/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui.legend;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.broad.igv.track.TrackType;
import org.broad.igv.ui.legend.HeatmapLegendPanel;
import org.broad.igv.ui.legend.LegendPanel;
import org.broad.igv.ui.legend.LohLegendPanel;
import org.broad.igv.ui.legend.MutationLegendPanel;
import org.broad.igv.ui.util.UIUtilities;
import org.jdesktop.layout.GroupLayout;

public class LegendDialog
extends JDialog {
    private JLabel jLabel1;
    private JLabel cnLabel;
    private JPanel copyNoCanvas;
    private JLabel legendLabel1;
    private JPanel methylationCanvas;
    private JPanel lohCanvas;
    private JLabel legendLabel2;
    private JLabel jLabel2;
    private JPanel expressionCanvas;
    private JPanel mutationCanvas;
    private JLabel legendLabel3;
    private JLabel legendLabel4;
    private JPanel rnaiPanel;
    private JButton resetToDefault;
    private JButton okButton;
    private JLabel jLabel3;

    public LegendDialog(Frame owner) {
        super(owner);
        this.initComponents();
    }

    public LegendDialog(Frame owner, boolean b2) {
        super(owner, b2);
    }

    private void okButtonActionPerformed(ActionEvent e2) {
        this.setVisible(false);
    }

    private void resetToDefaultActionPerformed(ActionEvent e2) {
        String message = "This will reset all heatmap preferences to their default values.\nAre you sure you want to continue?";
        boolean status = UIUtilities.showConfirmationDialog(this, message);
        if (status) {
            ((LegendPanel)this.copyNoCanvas).resetPreferencesToDefault();
            ((LegendPanel)this.expressionCanvas).resetPreferencesToDefault();
            ((LegendPanel)this.rnaiPanel).resetPreferencesToDefault();
            ((LegendPanel)this.lohCanvas).resetPreferencesToDefault();
            ((LegendPanel)this.methylationCanvas).resetPreferencesToDefault();
            ((LegendPanel)this.mutationCanvas).resetPreferencesToDefault();
        }
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.cnLabel = new JLabel();
        this.copyNoCanvas = new HeatmapLegendPanel(TrackType.COPY_NUMBER);
        this.legendLabel1 = new JLabel();
        this.methylationCanvas = new HeatmapLegendPanel(TrackType.DNA_METHYLATION);
        this.lohCanvas = new LohLegendPanel();
        this.legendLabel2 = new JLabel();
        this.jLabel2 = new JLabel();
        this.expressionCanvas = new HeatmapLegendPanel(TrackType.GENE_EXPRESSION);
        this.mutationCanvas = new MutationLegendPanel();
        this.legendLabel3 = new JLabel();
        this.legendLabel4 = new JLabel();
        this.rnaiPanel = new HeatmapLegendPanel(TrackType.RNAI);
        this.resetToDefault = new JButton();
        this.okButton = new JButton();
        this.jLabel3 = new JLabel();
        this.setDefaultCloseOperation(2);
        Container contentPane = this.getContentPane();
        contentPane.setLayout(null);
        this.jLabel1.setFont(new Font("Lucida Sans", 1, 18));
        this.jLabel1.setText("Legends");
        contentPane.add(this.jLabel1);
        this.jLabel1.setBounds(new Rectangle(new Point(392, 0), this.jLabel1.getPreferredSize()));
        this.cnLabel.setText("Copy Number");
        contentPane.add(this.cnLabel);
        this.cnLabel.setBounds(new Rectangle(new Point(10, 40), this.cnLabel.getPreferredSize()));
        this.copyNoCanvas.setBorder(null);
        GroupLayout copyNoCanvasLayout = new GroupLayout(this.copyNoCanvas);
        this.copyNoCanvas.setLayout(copyNoCanvasLayout);
        copyNoCanvasLayout.setHorizontalGroup(copyNoCanvasLayout.createParallelGroup().add(0, 588, Short.MAX_VALUE));
        copyNoCanvasLayout.setVerticalGroup(copyNoCanvasLayout.createParallelGroup().add(0, 60, Short.MAX_VALUE));
        contentPane.add(this.copyNoCanvas);
        this.copyNoCanvas.setBounds(120, 38, 590, 62);
        this.legendLabel1.setText("Expression");
        contentPane.add(this.legendLabel1);
        this.legendLabel1.setBounds(new Rectangle(new Point(10, 120), this.legendLabel1.getPreferredSize()));
        this.methylationCanvas.setMinimumSize(new Dimension(100, 100));
        this.methylationCanvas.setBorder(null);
        GroupLayout methylationCanvasLayout = new GroupLayout(this.methylationCanvas);
        this.methylationCanvas.setLayout(methylationCanvasLayout);
        methylationCanvasLayout.setHorizontalGroup(methylationCanvasLayout.createParallelGroup().add(0, 588, Short.MAX_VALUE));
        methylationCanvasLayout.setVerticalGroup(methylationCanvasLayout.createParallelGroup().add(0, 60, Short.MAX_VALUE));
        contentPane.add(this.methylationCanvas);
        this.methylationCanvas.setBounds(120, 272, 590, 62);
        this.lohCanvas.setBorder(null);
        GroupLayout lohCanvasLayout = new GroupLayout(this.lohCanvas);
        this.lohCanvas.setLayout(lohCanvasLayout);
        lohCanvasLayout.setHorizontalGroup(lohCanvasLayout.createParallelGroup().add(0, 588, Short.MAX_VALUE));
        lohCanvasLayout.setVerticalGroup(lohCanvasLayout.createParallelGroup().add(0, 60, Short.MAX_VALUE));
        contentPane.add(this.lohCanvas);
        this.lohCanvas.setBounds(120, 350, 590, 62);
        this.legendLabel2.setText("LOH");
        contentPane.add(this.legendLabel2);
        this.legendLabel2.setBounds(10, 375, 45, this.legendLabel2.getPreferredSize().height);
        this.jLabel2.setText("Methylation");
        contentPane.add(this.jLabel2);
        this.jLabel2.setBounds(new Rectangle(new Point(10, 285), this.jLabel2.getPreferredSize()));
        this.expressionCanvas.setBorder(null);
        GroupLayout expressionCanvasLayout = new GroupLayout(this.expressionCanvas);
        this.expressionCanvas.setLayout(expressionCanvasLayout);
        expressionCanvasLayout.setHorizontalGroup(expressionCanvasLayout.createParallelGroup().add(0, 588, Short.MAX_VALUE));
        expressionCanvasLayout.setVerticalGroup(expressionCanvasLayout.createParallelGroup().add(0, 60, Short.MAX_VALUE));
        contentPane.add(this.expressionCanvas);
        this.expressionCanvas.setBounds(120, 116, 590, 62);
        this.mutationCanvas.setBorder(null);
        GroupLayout mutationCanvasLayout = new GroupLayout(this.mutationCanvas);
        this.mutationCanvas.setLayout(mutationCanvasLayout);
        mutationCanvasLayout.setHorizontalGroup(mutationCanvasLayout.createParallelGroup().add(0, 588, Short.MAX_VALUE));
        mutationCanvasLayout.setVerticalGroup(mutationCanvasLayout.createParallelGroup().add(0, 60, Short.MAX_VALUE));
        contentPane.add(this.mutationCanvas);
        this.mutationCanvas.setBounds(120, 428, 590, 62);
        this.legendLabel3.setText("Mutation");
        contentPane.add(this.legendLabel3);
        this.legendLabel3.setBounds(new Rectangle(new Point(10, 455), this.legendLabel3.getPreferredSize()));
        this.legendLabel4.setText("RNAi");
        contentPane.add(this.legendLabel4);
        this.legendLabel4.setBounds(new Rectangle(new Point(10, 200), this.legendLabel4.getPreferredSize()));
        this.rnaiPanel.setBorder(null);
        GroupLayout rnaiPanelLayout = new GroupLayout(this.rnaiPanel);
        this.rnaiPanel.setLayout(rnaiPanelLayout);
        rnaiPanelLayout.setHorizontalGroup(rnaiPanelLayout.createParallelGroup().add(0, 588, Short.MAX_VALUE));
        rnaiPanelLayout.setVerticalGroup(rnaiPanelLayout.createParallelGroup().add(0, 60, Short.MAX_VALUE));
        contentPane.add(this.rnaiPanel);
        this.rnaiPanel.setBounds(120, 194, 590, 62);
        this.resetToDefault.setText("Reset to default");
        this.resetToDefault.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                LegendDialog.this.resetToDefaultActionPerformed(e2);
            }
        });
        contentPane.add(this.resetToDefault);
        this.resetToDefault.setBounds(new Rectangle(new Point(475, 575), this.resetToDefault.getPreferredSize()));
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                LegendDialog.this.okButtonActionPerformed(e2);
            }
        });
        contentPane.add(this.okButton);
        this.okButton.setBounds(new Rectangle(new Point(635, 575), this.okButton.getPreferredSize()));
        this.jLabel3.setText("<html>* click any item to bring up its editor");
        contentPane.add(this.jLabel3);
        this.jLabel3.setBounds(15, 550, 396, this.jLabel3.getPreferredSize().height);
        Dimension preferredSize = new Dimension();
        for (int i2 = 0; i2 < contentPane.getComponentCount(); ++i2) {
            Rectangle bounds = contentPane.getComponent(i2).getBounds();
            preferredSize.width = Math.max(bounds.x + bounds.width, preferredSize.width);
            preferredSize.height = Math.max(bounds.y + bounds.height, preferredSize.height);
        }
        Insets insets = contentPane.getInsets();
        preferredSize.width += insets.right;
        preferredSize.height += insets.bottom;
        contentPane.setMinimumSize(preferredSize);
        contentPane.setPreferredSize(preferredSize);
        this.setSize(755, 665);
        this.setLocationRelativeTo(this.getOwner());
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                LegendDialog dialog = new LegendDialog(new JFrame());
                dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e2) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }
}

