/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.hic.data;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.sf.samtools.util.SortingCollection;
import org.broad.igv.hic.data.ContactRecord;

public class ContactRecordCodec
implements SortingCollection.Codec<ContactRecord> {
    DataOutputStream os;
    DataInputStream is;

    @Override
    public void setOutputStream(OutputStream os) {
        this.os = new DataOutputStream(os);
    }

    @Override
    public void setInputStream(InputStream is) {
        this.is = new DataInputStream(is);
    }

    @Override
    public void encode(ContactRecord contactRecord) {
        try {
            this.os.writeInt(contactRecord.getBlockNumber());
            this.os.writeInt(contactRecord.getX());
            this.os.writeInt(contactRecord.getY());
            this.os.writeShort(contactRecord.getCounts());
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
    }

    @Override
    public ContactRecord decode() {
        try {
            int block = this.is.readInt();
            int bin1 = this.is.readInt();
            int bin2 = this.is.readInt();
            short counts = this.is.readShort();
            return new ContactRecord(block, bin1, bin2, counts);
        }
        catch (IOException e2) {
            e2.printStackTrace();
            throw new RuntimeException(e2);
        }
    }

    @Override
    public SortingCollection.Codec<ContactRecord> clone() {
        ContactRecordCodec newCodec = new ContactRecordCodec();
        newCodec.os = this.os;
        newCodec.is = this.is;
        return newCodec;
    }
}

