/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.util.stream;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import junit.framework.Assert;
import org.apache.log4j.Logger;
import org.broad.igv.util.UserPasswordInputImpl;
import org.broad.tribble.util.ftp.FTPClient;
import org.broad.tribble.util.ftp.FTPReply;
import org.broad.tribble.util.ftp.FTPUtils;

public class SeekableFTPStreamHelper {
    private static Logger log = Logger.getLogger(SeekableFTPStreamHelper.class);
    private long position = 0L;
    private String host;
    private String path;
    private String userInfo;
    FTPClient ftp = null;

    SeekableFTPStreamHelper(URL url) throws IOException {
        this.userInfo = url.getUserInfo();
        this.host = url.getHost();
        this.path = url.getPath();
        this.ftp = FTPUtils.connect(this.host, this.userInfo, new UserPasswordInputImpl());
    }

    public void seek(long position) {
        this.position = position;
    }

    public long position() {
        return this.position;
    }

    public boolean eof() throws IOException {
        return false;
    }

    public long length() {
        return 0L;
    }

    public long skip(long n2) throws IOException {
        long bytesToSkip = n2;
        this.position += bytesToSkip;
        this.ftp.setRestPosition(this.position);
        return bytesToSkip;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(byte[] buffer, int offset, int len) throws IOException {
        if (this.ftp == null) {
            this.ftp = FTPUtils.connect(this.host, this.userInfo, new UserPasswordInputImpl());
        }
        if (offset < 0 || len < 0 || offset + len > buffer.length) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        int n2 = 0;
        try {
            FTPReply reply = this.ftp.pasv();
            Assert.assertTrue(reply.isSuccess());
            if (this.position > 0L) {
                this.ftp.setRestPosition(this.position);
            }
            reply = this.ftp.retr(this.path);
            InputStream is = this.ftp.getDataStream();
            while (n2 < len) {
                int count = is.read(buffer, offset + n2, len - n2);
                if (count < 0) {
                    if (n2 != 0) break;
                    int n3 = -1;
                    return n3;
                }
                n2 += count;
            }
            this.position += (long)n2;
            int n4 = n2;
            return n4;
        }
        catch (EOFException e2) {
            if (n2 < 0) {
                int n5 = -1;
                return n5;
            }
            this.position += (long)n2;
            int n6 = n2;
            return n6;
        }
        finally {
            this.ftp.disconnect();
            this.ftp = null;
        }
    }

    private void reconnect() throws IOException {
        if (this.ftp != null) {
            this.ftp.disconnect();
        }
        this.ftp = FTPUtils.connect(this.host, this.userInfo, new UserPasswordInputImpl());
    }

    public void close() throws IOException {
        log.info("close");
        if (this.ftp != null) {
            this.ftp.disconnect();
            this.ftp = null;
        }
    }

    public int read() throws IOException {
        throw new UnsupportedOperationException("read() is not supported on SeekableHTTPStream.  Must read in blocks.");
    }
}

