/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.stat.descriptive.moment;

import java.io.Serializable;
import org.apache.commons.math.stat.descriptive.AbstractStorelessUnivariateStatistic;
import org.apache.commons.math.stat.descriptive.moment.SecondMoment;
import org.apache.commons.math.stat.descriptive.moment.Variance;

public class StandardDeviation
extends AbstractStorelessUnivariateStatistic
implements Serializable {
    private static final long serialVersionUID = 5728716329662425188L;
    private Variance variance = null;

    public StandardDeviation() {
        this.variance = new Variance();
    }

    public StandardDeviation(SecondMoment m2) {
        this.variance = new Variance(m2);
    }

    public StandardDeviation(boolean isBiasCorrected) {
        this.variance = new Variance(isBiasCorrected);
    }

    public StandardDeviation(boolean isBiasCorrected, SecondMoment m2) {
        this.variance = new Variance(isBiasCorrected, m2);
    }

    public void increment(double d2) {
        this.variance.increment(d2);
    }

    public long getN() {
        return this.variance.getN();
    }

    public double getResult() {
        return Math.sqrt(this.variance.getResult());
    }

    public void clear() {
        this.variance.clear();
    }

    public double evaluate(double[] values) {
        return Math.sqrt(this.variance.evaluate(values));
    }

    public double evaluate(double[] values, int begin, int length) {
        return Math.sqrt(this.variance.evaluate(values, begin, length));
    }

    public double evaluate(double[] values, double mean, int begin, int length) {
        return Math.sqrt(this.variance.evaluate(values, mean, begin, length));
    }

    public double evaluate(double[] values, double mean) {
        return Math.sqrt(this.variance.evaluate(values, mean));
    }

    public boolean isBiasCorrected() {
        return this.variance.isBiasCorrected();
    }

    public void setBiasCorrected(boolean isBiasCorrected) {
        this.variance.setBiasCorrected(isBiasCorrected);
    }
}

