/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui.action;

import java.util.ArrayList;
import org.apache.log4j.Logger;
import org.broad.igv.PreferenceManager;
import org.broad.igv.feature.Chromosome;
import org.broad.igv.feature.FeatureDB;
import org.broad.igv.feature.Locus;
import org.broad.igv.feature.NamedFeature;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.lists.GeneList;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.action.Command;
import org.broad.igv.ui.panel.FrameManager;
import org.broad.igv.ui.panel.ReferenceFrame;
import org.broad.igv.ui.util.MessageUtils;

public class SearchCommand
implements Command {
    private static Logger log = Logger.getLogger(SearchCommand.class);
    String searchString;
    ReferenceFrame referenceFrame;
    boolean recordHistory = true;
    Genome genome;

    public SearchCommand(ReferenceFrame referenceFrame, String searchString) {
        this.referenceFrame = referenceFrame;
        this.searchString = searchString.trim();
        this.genome = IGV.getInstance().getGenomeManager().getCurrentGenome();
    }

    public SearchCommand(ReferenceFrame referenceFrame, String searchString, boolean recordHistory) {
        this(referenceFrame, searchString);
        this.recordHistory = recordHistory;
    }

    @Override
    public void execute() {
        boolean success;
        block35: {
            if (log.isDebugEnabled()) {
                log.debug("Run search: " + this.searchString);
            }
            success = false;
            String[] tokens = this.searchString.split("\\s+");
            if (tokens.length >= 2) {
                String chr = this.genome.getChromosomeAlias(tokens[0].trim());
                try {
                    int start = Integer.parseInt(tokens[1].trim()) - 1;
                    int end = start + 1;
                    if (tokens.length > 2) {
                        end = Integer.parseInt(tokens[2].trim());
                    }
                    if (FrameManager.isGeneListMode()) {
                        IGV.getInstance().getSession().setCurrentGeneList(null);
                        IGV.getInstance().resetFrames();
                    }
                    if (this.recordHistory) {
                        IGV.getInstance().getSession().getHistory().push(this.searchString, this.referenceFrame.getZoom());
                    }
                    this.referenceFrame.jumpTo(chr, start, end);
                    success = true;
                }
                catch (NumberFormatException e2) {
                    ArrayList<String> loci = new ArrayList<String>(tokens.length);
                    for (String t : tokens) {
                        Locus l2 = new Locus(t);
                        if (l2.isValid()) {
                            loci.add(t);
                            continue;
                        }
                        if (FeatureDB.getFeature(t) == null) continue;
                        loci.add(t);
                    }
                    if (loci.size() <= 1) {
                        success = false;
                        break block35;
                    }
                    if (loci.size() != tokens.length) {
                        MessageUtils.showMessage("Not all portions of the search string are recognized as genes or loci.");
                    }
                    GeneList geneList = new GeneList("", loci, false);
                    IGV.getInstance().getSession().setCurrentGeneList(geneList);
                    IGV.getInstance().resetFrames();
                    success = true;
                }
            } else {
                NamedFeature feature;
                if (FrameManager.isGeneListMode()) {
                    IGV.getInstance().getSession().setCurrentGeneList(null);
                    IGV.getInstance().resetFrames();
                }
                if ((feature = FeatureDB.getFeature(this.searchString.toUpperCase().trim())) != null) {
                    int flankingRegion = PreferenceManager.getInstance().getAsInt("FLAKING_REGIONS");
                    int start = Math.max(0, feature.getStart() - flankingRegion);
                    int end = feature.getEnd() + flankingRegion;
                    if (this.recordHistory) {
                        IGV.getInstance().getSession().getHistory().push(this.searchString, this.referenceFrame.getZoom());
                    }
                    if (PreferenceManager.getInstance().getAsBoolean("SEARCH_ZOOM")) {
                        this.referenceFrame.jumpTo(feature.getChr(), start, end);
                    } else {
                        int center = (start + end) / 2;
                        this.referenceFrame.centerOnLocation(feature.getChr(), center);
                    }
                    if (log.isDebugEnabled()) {
                        log.debug("End search: " + this.searchString);
                    }
                    success = true;
                } else if (!this.searchString.contains("\"")) {
                    String chr = null;
                    int[] startEnd = null;
                    int colonIdx = this.searchString.lastIndexOf(":");
                    if (colonIdx > 0) {
                        chr = this.genome.getChromosomeAlias(this.searchString.substring(0, colonIdx));
                        String posString = this.searchString.substring(colonIdx).replace(":", "");
                        startEnd = this.getStartEnd(posString);
                        if (startEnd != null) {
                            if (this.recordHistory) {
                                IGV.getInstance().getSession().getHistory().push(this.searchString, this.referenceFrame.getZoom());
                            }
                            this.referenceFrame.jumpTo(chr, startEnd[0], startEnd[1]);
                            if (log.isDebugEnabled()) {
                                log.debug("End search: " + this.searchString);
                            }
                            success = true;
                        }
                    } else if (this.searchString.contains("-")) {
                        startEnd = this.getStartEnd(this.searchString);
                        if (startEnd != null) {
                            if (this.recordHistory) {
                                IGV.getInstance().getSession().getHistory().push(this.searchString, this.referenceFrame.getZoom());
                            }
                            this.referenceFrame.jumpTo(null, startEnd[0], startEnd[1]);
                            if (log.isDebugEnabled()) {
                                log.debug("End search: " + this.searchString);
                            }
                            success = true;
                        }
                    } else {
                        chr = this.genome.getChromosomeAlias(this.searchString);
                        Chromosome chromosome = this.genome.getChromosome(chr);
                        if (chromosome != null || this.searchString.equals("All")) {
                            if (this.recordHistory) {
                                IGV.getInstance().getSession().getHistory().push(chr, this.referenceFrame.getZoom());
                            }
                            this.referenceFrame.setChromosomeName(chr, true);
                            IGV.getInstance().repaintDataAndHeaderPanels();
                            IGV.getInstance().repaintStatusAndZoomSlider();
                            if (log.isDebugEnabled()) {
                                log.debug("End search: " + this.searchString);
                            }
                            success = true;
                        }
                    }
                }
            }
        }
        if (!success && !IGV.getInstance().scrollToTrack(this.searchString.replaceAll("\"", ""))) {
            this.showError("Cannot find feature or locus: " + this.searchString);
        }
        if (log.isDebugEnabled()) {
            log.debug("End search: " + this.searchString);
        }
    }

    private int[] getStartEnd(String posString) {
        try {
            String endString;
            String[] posTokens = posString.split("-");
            String startString = posTokens[0].replaceAll(",", "");
            int start = Math.max(0, Integer.parseInt(startString)) - 1;
            int end = start + 1;
            if (posTokens.length > 1) {
                endString = posTokens[1].replaceAll(",", "");
                end = Integer.parseInt(endString);
            }
            if (posTokens.length == 1 || end - start < 10) {
                int center = (start + end) / 2;
                start = center - 20;
                end = center + 20;
            } else {
                endString = posTokens[1].replaceAll(",", "");
                end = Integer.parseInt(endString);
            }
            return new int[]{Math.min(start, end), Math.max(start, end)};
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    private void showError(String message) {
        MessageUtils.showMessage(message);
    }
}

