/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui.action;

import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;
import org.broad.igv.PreferenceManager;
import org.broad.igv.session.Session;
import org.broad.igv.session.SessionWriter;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.WaitCursorManager;
import org.broad.igv.ui.action.MenuAction;
import org.broad.igv.ui.util.FileDialogUtils;

public class SaveSessionMenuAction
extends MenuAction {
    static Logger log = Logger.getLogger(SaveSessionMenuAction.class);
    IGV mainFrame;

    public SaveSessionMenuAction(String label, int mnemonic, IGV mainFrame) {
        super(label, null, mnemonic);
        this.mainFrame = mainFrame;
        this.setToolTipText("Save the current session");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent e2) {
        File sessionFile = null;
        String currentSessionFilePath = this.mainFrame.getSession().getPath();
        String initFile = currentSessionFilePath == null ? "igv_session.xml" : currentSessionFilePath;
        sessionFile = FileDialogUtils.chooseFile("Save Session", PreferenceManager.getInstance().getLastSessionDirectory(), new File(initFile), FileDialogUtils.SAVE);
        if (sessionFile == null) {
            this.mainFrame.resetStatusMessage();
            return;
        }
        String filePath = sessionFile.getAbsolutePath();
        if (!filePath.toLowerCase().endsWith(".xml")) {
            sessionFile = new File(filePath + ".xml");
        }
        this.mainFrame.setStatusBarMessage("Saving session to " + sessionFile.getAbsolutePath());
        File sf = sessionFile;
        WaitCursorManager.CursorToken token = WaitCursorManager.showWaitCursor();
        try {
            Session currentSession = this.mainFrame.getSession();
            currentSession.setPath(sf.getAbsolutePath());
            new SessionWriter().saveSession(currentSession, sf);
            PreferenceManager.getInstance().setLastSessionDirectory(sf.getParentFile());
        }
        catch (Exception e22) {
            SaveSessionMenuAction saveSessionMenuAction = this;
            JOptionPane.showMessageDialog(saveSessionMenuAction.mainFrame.getMainFrame(), "There was an error writing to " + sf.getName() + "(" + e22.getMessage() + ")");
            log.error("Failed to save session!", e22);
        }
        finally {
            WaitCursorManager.removeWaitCursor(token);
            this.mainFrame.resetStatusMessage();
        }
    }
}

