/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.dom.svg;

import org.apache.batik.parser.PathHandler;
import org.w3c.dom.svg.SVGPathSeg;
import org.w3c.dom.svg.SVGPathSegArcAbs;
import org.w3c.dom.svg.SVGPathSegArcRel;
import org.w3c.dom.svg.SVGPathSegCurvetoCubicAbs;
import org.w3c.dom.svg.SVGPathSegCurvetoCubicRel;
import org.w3c.dom.svg.SVGPathSegCurvetoCubicSmoothAbs;
import org.w3c.dom.svg.SVGPathSegCurvetoCubicSmoothRel;
import org.w3c.dom.svg.SVGPathSegCurvetoQuadraticAbs;
import org.w3c.dom.svg.SVGPathSegCurvetoQuadraticRel;
import org.w3c.dom.svg.SVGPathSegCurvetoQuadraticSmoothAbs;
import org.w3c.dom.svg.SVGPathSegCurvetoQuadraticSmoothRel;
import org.w3c.dom.svg.SVGPathSegLinetoAbs;
import org.w3c.dom.svg.SVGPathSegLinetoHorizontalAbs;
import org.w3c.dom.svg.SVGPathSegLinetoHorizontalRel;
import org.w3c.dom.svg.SVGPathSegLinetoRel;
import org.w3c.dom.svg.SVGPathSegLinetoVerticalAbs;
import org.w3c.dom.svg.SVGPathSegLinetoVerticalRel;
import org.w3c.dom.svg.SVGPathSegList;
import org.w3c.dom.svg.SVGPathSegMovetoAbs;
import org.w3c.dom.svg.SVGPathSegMovetoRel;

public abstract class SVGAnimatedPathDataSupport {
    public static void handlePathSegList(SVGPathSegList p2, PathHandler h2) {
        int n2 = p2.getNumberOfItems();
        h2.startPath();
        int i2 = 0;
        while (i2 < n2) {
            SVGPathSeg seg = p2.getItem(i2);
            switch (seg.getPathSegType()) {
                case 1: {
                    h2.closePath();
                    break;
                }
                case 2: {
                    SVGPathSeg s = (SVGPathSegMovetoAbs)seg;
                    h2.movetoAbs(s.getX(), s.getY());
                    break;
                }
                case 3: {
                    SVGPathSeg s = (SVGPathSegMovetoRel)seg;
                    h2.movetoRel(s.getX(), s.getY());
                    break;
                }
                case 4: {
                    SVGPathSeg s = (SVGPathSegLinetoAbs)seg;
                    h2.linetoAbs(s.getX(), s.getY());
                    break;
                }
                case 5: {
                    SVGPathSeg s = (SVGPathSegLinetoRel)seg;
                    h2.linetoRel(s.getX(), s.getY());
                    break;
                }
                case 6: {
                    SVGPathSeg s = (SVGPathSegCurvetoCubicAbs)seg;
                    h2.curvetoCubicAbs(s.getX1(), s.getY1(), s.getX2(), s.getY2(), s.getX(), s.getY());
                    break;
                }
                case 7: {
                    SVGPathSeg s = (SVGPathSegCurvetoCubicRel)seg;
                    h2.curvetoCubicRel(s.getX1(), s.getY1(), s.getX2(), s.getY2(), s.getX(), s.getY());
                    break;
                }
                case 8: {
                    SVGPathSeg s = (SVGPathSegCurvetoQuadraticAbs)seg;
                    h2.curvetoQuadraticAbs(s.getX1(), s.getY1(), s.getX(), s.getY());
                    break;
                }
                case 9: {
                    SVGPathSeg s = (SVGPathSegCurvetoQuadraticRel)seg;
                    h2.curvetoQuadraticRel(s.getX1(), s.getY1(), s.getX(), s.getY());
                    break;
                }
                case 10: {
                    SVGPathSeg s = (SVGPathSegArcAbs)seg;
                    h2.arcAbs(s.getR1(), s.getR2(), s.getAngle(), s.getLargeArcFlag(), s.getSweepFlag(), s.getX(), s.getY());
                    break;
                }
                case 11: {
                    SVGPathSeg s = (SVGPathSegArcRel)seg;
                    h2.arcRel(s.getR1(), s.getR2(), s.getAngle(), s.getLargeArcFlag(), s.getSweepFlag(), s.getX(), s.getY());
                    break;
                }
                case 12: {
                    SVGPathSeg s = (SVGPathSegLinetoHorizontalAbs)seg;
                    h2.linetoHorizontalAbs(s.getX());
                    break;
                }
                case 13: {
                    SVGPathSeg s = (SVGPathSegLinetoHorizontalRel)seg;
                    h2.linetoHorizontalRel(s.getX());
                    break;
                }
                case 14: {
                    SVGPathSeg s = (SVGPathSegLinetoVerticalAbs)seg;
                    h2.linetoVerticalAbs(s.getY());
                    break;
                }
                case 15: {
                    SVGPathSeg s = (SVGPathSegLinetoVerticalRel)seg;
                    h2.linetoVerticalRel(s.getY());
                    break;
                }
                case 16: {
                    SVGPathSeg s = (SVGPathSegCurvetoCubicSmoothAbs)seg;
                    h2.curvetoCubicSmoothAbs(s.getX2(), s.getY2(), s.getX(), s.getY());
                    break;
                }
                case 17: {
                    SVGPathSeg s = (SVGPathSegCurvetoCubicSmoothRel)seg;
                    h2.curvetoCubicSmoothRel(s.getX2(), s.getY2(), s.getX(), s.getY());
                    break;
                }
                case 18: {
                    SVGPathSeg s = (SVGPathSegCurvetoQuadraticSmoothAbs)seg;
                    h2.curvetoQuadraticSmoothAbs(s.getX(), s.getY());
                    break;
                }
                case 19: {
                    SVGPathSeg s = (SVGPathSegCurvetoQuadraticSmoothRel)seg;
                    h2.curvetoQuadraticSmoothRel(s.getX(), s.getY());
                    break;
                }
            }
            ++i2;
        }
        h2.endPath();
    }
}

