/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.shorts;

import it.unimi.dsi.fastutil.Arrays;
import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.ints.IntArrays;
import it.unimi.dsi.fastutil.shorts.ShortComparator;
import java.io.Serializable;
import java.util.Random;

public class ShortArrays {
    public static final long ONEOVERPHI = 106039L;
    public static final short[] EMPTY_ARRAY = new short[0];
    private static final int SMALL = 7;
    private static final int MEDIUM = 50;
    private static final int DIGIT_BITS = 8;
    private static final int DIGIT_MASK = 255;
    private static final int DIGITS_PER_ELEMENT = 2;
    public static final Hash.Strategy HASH_STRATEGY = new ArrayHashStrategy();

    private ShortArrays() {
    }

    public static short[] ensureCapacity(short[] array, int length) {
        if (length > array.length) {
            short[] t = new short[length];
            System.arraycopy(array, 0, t, 0, array.length);
            return t;
        }
        return array;
    }

    public static short[] ensureCapacity(short[] array, int length, int preserve) {
        if (length > array.length) {
            short[] t = new short[length];
            System.arraycopy(array, 0, t, 0, preserve);
            return t;
        }
        return array;
    }

    public static short[] grow(short[] array, int length) {
        if (length > array.length) {
            int newLength = (int)Math.min(Math.max(106039L * (long)array.length >>> 16, (long)length), Integer.MAX_VALUE);
            short[] t = new short[newLength];
            System.arraycopy(array, 0, t, 0, array.length);
            return t;
        }
        return array;
    }

    public static short[] grow(short[] array, int length, int preserve) {
        if (length > array.length) {
            int newLength = (int)Math.min(Math.max(106039L * (long)array.length >>> 16, (long)length), Integer.MAX_VALUE);
            short[] t = new short[newLength];
            System.arraycopy(array, 0, t, 0, preserve);
            return t;
        }
        return array;
    }

    public static short[] trim(short[] array, int length) {
        if (length >= array.length) {
            return array;
        }
        short[] t = length == 0 ? EMPTY_ARRAY : new short[length];
        System.arraycopy(array, 0, t, 0, length);
        return t;
    }

    public static short[] setLength(short[] array, int length) {
        if (length == array.length) {
            return array;
        }
        if (length < array.length) {
            return ShortArrays.trim(array, length);
        }
        return ShortArrays.ensureCapacity(array, length);
    }

    public static short[] copy(short[] array, int offset, int length) {
        ShortArrays.ensureOffsetLength(array, offset, length);
        short[] a2 = length == 0 ? EMPTY_ARRAY : new short[length];
        System.arraycopy(array, offset, a2, 0, length);
        return a2;
    }

    public static short[] copy(short[] array) {
        return (short[])array.clone();
    }

    public static void fill(short[] array, short value) {
        int i2 = array.length;
        while (i2-- != 0) {
            array[i2] = value;
        }
    }

    public static void fill(short[] array, int from, int to, short value) {
        ShortArrays.ensureFromTo(array, from, to);
        if (from == 0) {
            while (to-- != 0) {
                array[to] = value;
            }
        } else {
            for (int i2 = from; i2 < to; ++i2) {
                array[i2] = value;
            }
        }
    }

    public static boolean equals(short[] a1, short[] a2) {
        int i2 = a1.length;
        if (i2 != a2.length) {
            return false;
        }
        while (i2-- != 0) {
            if (a1[i2] == a2[i2]) continue;
            return false;
        }
        return true;
    }

    public static void ensureFromTo(short[] a2, int from, int to) {
        Arrays.ensureFromTo(a2.length, from, to);
    }

    public static void ensureOffsetLength(short[] a2, int offset, int length) {
        Arrays.ensureOffsetLength(a2.length, offset, length);
    }

    private static void swap(short[] x, int a2, int b2) {
        short t = x[a2];
        x[a2] = x[b2];
        x[b2] = t;
    }

    private static void vecSwap(short[] x, int a2, int b2, int n2) {
        int i2 = 0;
        while (i2 < n2) {
            ShortArrays.swap(x, a2, b2);
            ++i2;
            ++a2;
            ++b2;
        }
    }

    private static int med3(short[] x, int a2, int b2, int c2, ShortComparator comp) {
        int ab = comp.compare(x[a2], x[b2]);
        int ac = comp.compare(x[a2], x[c2]);
        int bc = comp.compare(x[b2], x[c2]);
        return ab < 0 ? (bc < 0 ? b2 : (ac < 0 ? c2 : a2)) : (bc > 0 ? b2 : (ac > 0 ? c2 : a2));
    }

    private static void selectionSort(short[] a2, int from, int to, ShortComparator comp) {
        for (int i2 = from; i2 < to - 1; ++i2) {
            int m2 = i2;
            for (int j2 = i2 + 1; j2 < to; ++j2) {
                if (comp.compare(a2[j2], a2[m2]) >= 0) continue;
                m2 = j2;
            }
            if (m2 == i2) continue;
            short u = a2[i2];
            a2[i2] = a2[m2];
            a2[m2] = u;
        }
    }

    private static void insertionSort(short[] a2, int from, int to, ShortComparator comp) {
        int i2 = from;
        while (++i2 < to) {
            short t = a2[i2];
            int j2 = i2;
            short u = a2[j2 - 1];
            while (comp.compare(t, u) < 0) {
                a2[j2] = u;
                if (from == j2 - 1) {
                    --j2;
                    break;
                }
                u = a2[--j2 - 1];
            }
            a2[j2] = t;
        }
    }

    private static void selectionSort(short[] a2, int from, int to) {
        for (int i2 = from; i2 < to - 1; ++i2) {
            int m2 = i2;
            for (int j2 = i2 + 1; j2 < to; ++j2) {
                if (a2[j2] >= a2[m2]) continue;
                m2 = j2;
            }
            if (m2 == i2) continue;
            short u = a2[i2];
            a2[i2] = a2[m2];
            a2[m2] = u;
        }
    }

    private static void insertionSort(short[] a2, int from, int to) {
        int i2 = from;
        while (++i2 < to) {
            short t = a2[i2];
            int j2 = i2;
            short u = a2[j2 - 1];
            while (t < u) {
                a2[j2] = u;
                if (from == j2 - 1) {
                    --j2;
                    break;
                }
                u = a2[--j2 - 1];
            }
            a2[j2] = t;
        }
    }

    public static void quickSort(short[] x, int from, int to, ShortComparator comp) {
        int c2;
        int a2;
        int len = to - from;
        if (len < 7) {
            ShortArrays.selectionSort(x, from, to, comp);
            return;
        }
        int m2 = from + len / 2;
        if (len > 7) {
            int l2 = from;
            int n2 = to - 1;
            if (len > 50) {
                int s = len / 8;
                l2 = ShortArrays.med3(x, l2, l2 + s, l2 + 2 * s, comp);
                m2 = ShortArrays.med3(x, m2 - s, m2, m2 + s, comp);
                n2 = ShortArrays.med3(x, n2 - 2 * s, n2 - s, n2, comp);
            }
            m2 = ShortArrays.med3(x, l2, m2, n2, comp);
        }
        short v = x[m2];
        int b2 = a2 = from;
        int d2 = c2 = to - 1;
        while (true) {
            int comparison;
            if (b2 <= c2 && (comparison = comp.compare(x[b2], v)) <= 0) {
                if (comparison == 0) {
                    ShortArrays.swap(x, a2++, b2);
                }
                ++b2;
                continue;
            }
            while (c2 >= b2 && (comparison = comp.compare(x[c2], v)) >= 0) {
                if (comparison == 0) {
                    ShortArrays.swap(x, c2, d2--);
                }
                --c2;
            }
            if (b2 > c2) break;
            ShortArrays.swap(x, b2++, c2--);
        }
        int n3 = to;
        int s = Math.min(a2 - from, b2 - a2);
        ShortArrays.vecSwap(x, from, b2 - s, s);
        s = Math.min(d2 - c2, n3 - d2 - 1);
        ShortArrays.vecSwap(x, b2, n3 - s, s);
        s = b2 - a2;
        if (s > 1) {
            ShortArrays.quickSort(x, from, from + s, comp);
        }
        if ((s = d2 - c2) > 1) {
            ShortArrays.quickSort(x, n3 - s, n3, comp);
        }
    }

    public static void quickSort(short[] x, ShortComparator comp) {
        ShortArrays.quickSort(x, 0, x.length, comp);
    }

    private static int med3(short[] x, int a2, int b2, int c2) {
        int bc;
        int ac;
        int ab;
        int n2 = x[a2] < x[b2] ? -1 : (ab = x[a2] == x[b2] ? 0 : 1);
        int n3 = x[a2] < x[c2] ? -1 : (ac = x[a2] == x[c2] ? 0 : 1);
        int n4 = x[b2] < x[c2] ? -1 : (bc = x[b2] == x[c2] ? 0 : 1);
        return ab < 0 ? (bc < 0 ? b2 : (ac < 0 ? c2 : a2)) : (bc > 0 ? b2 : (ac > 0 ? c2 : a2));
    }

    public static void quickSort(short[] x, int from, int to) {
        int c2;
        int a2;
        int len = to - from;
        if (len < 7) {
            ShortArrays.selectionSort(x, from, to);
            return;
        }
        int m2 = from + len / 2;
        if (len > 7) {
            int l2 = from;
            int n2 = to - 1;
            if (len > 50) {
                int s = len / 8;
                l2 = ShortArrays.med3(x, l2, l2 + s, l2 + 2 * s);
                m2 = ShortArrays.med3(x, m2 - s, m2, m2 + s);
                n2 = ShortArrays.med3(x, n2 - 2 * s, n2 - s, n2);
            }
            m2 = ShortArrays.med3(x, l2, m2, n2);
        }
        short v = x[m2];
        int b2 = a2 = from;
        int d2 = c2 = to - 1;
        while (true) {
            int comparison;
            if (b2 <= c2 && (x[b2] < v ? -1 : (comparison = x[b2] == v ? 0 : 1)) <= 0) {
                if (comparison == 0) {
                    ShortArrays.swap(x, a2++, b2);
                }
                ++b2;
                continue;
            }
            while (c2 >= b2 && (x[c2] < v ? -1 : (comparison = x[c2] == v ? 0 : 1)) >= 0) {
                if (comparison == 0) {
                    ShortArrays.swap(x, c2, d2--);
                }
                --c2;
            }
            if (b2 > c2) break;
            ShortArrays.swap(x, b2++, c2--);
        }
        int n3 = to;
        int s = Math.min(a2 - from, b2 - a2);
        ShortArrays.vecSwap(x, from, b2 - s, s);
        s = Math.min(d2 - c2, n3 - d2 - 1);
        ShortArrays.vecSwap(x, b2, n3 - s, s);
        s = b2 - a2;
        if (s > 1) {
            ShortArrays.quickSort(x, from, from + s);
        }
        if ((s = d2 - c2) > 1) {
            ShortArrays.quickSort(x, n3 - s, n3);
        }
    }

    public static void quickSort(short[] x) {
        ShortArrays.quickSort(x, 0, x.length);
    }

    public static void mergeSort(short[] a2, int from, int to, short[] supp) {
        int len = to - from;
        if (len < 7) {
            ShortArrays.insertionSort(a2, from, to);
            return;
        }
        int mid = from + to >>> 1;
        ShortArrays.mergeSort(supp, from, mid, a2);
        ShortArrays.mergeSort(supp, mid, to, a2);
        if (supp[mid - 1] <= supp[mid]) {
            System.arraycopy(supp, from, a2, from, len);
            return;
        }
        int p2 = from;
        int q = mid;
        for (int i2 = from; i2 < to; ++i2) {
            a2[i2] = q >= to || p2 < mid && supp[p2] <= supp[q] ? supp[p2++] : supp[q++];
        }
    }

    public static void mergeSort(short[] a2, int from, int to) {
        ShortArrays.mergeSort(a2, from, to, (short[])a2.clone());
    }

    public static void mergeSort(short[] a2) {
        ShortArrays.mergeSort(a2, 0, a2.length);
    }

    public static void mergeSort(short[] a2, int from, int to, ShortComparator comp, short[] supp) {
        int len = to - from;
        if (len < 7) {
            ShortArrays.insertionSort(a2, from, to, comp);
            return;
        }
        int mid = from + to >>> 1;
        ShortArrays.mergeSort(supp, from, mid, comp, a2);
        ShortArrays.mergeSort(supp, mid, to, comp, a2);
        if (comp.compare(supp[mid - 1], supp[mid]) <= 0) {
            System.arraycopy(supp, from, a2, from, len);
            return;
        }
        int p2 = from;
        int q = mid;
        for (int i2 = from; i2 < to; ++i2) {
            a2[i2] = q >= to || p2 < mid && comp.compare(supp[p2], supp[q]) <= 0 ? supp[p2++] : supp[q++];
        }
    }

    public static void mergeSort(short[] a2, int from, int to, ShortComparator comp) {
        ShortArrays.mergeSort(a2, from, to, comp, (short[])a2.clone());
    }

    public static void mergeSort(short[] a2, ShortComparator comp) {
        ShortArrays.mergeSort(a2, 0, a2.length, comp);
    }

    public static int binarySearch(short[] a2, int from, int to, short key) {
        while (from <= to) {
            int mid = from + to >>> 1;
            short midVal = a2[mid];
            if (midVal < key) {
                from = mid + 1;
                continue;
            }
            if (midVal > key) {
                to = mid - 1;
                continue;
            }
            return mid;
        }
        return -(from + 1);
    }

    public static int binarySearch(short[] a2, short key) {
        return ShortArrays.binarySearch(a2, 0, a2.length, key);
    }

    public static int binarySearch(short[] a2, int from, int to, short key, ShortComparator c2) {
        while (from <= to) {
            int mid = from + to >>> 1;
            short midVal = a2[mid];
            int cmp = c2.compare(midVal, key);
            if (cmp < 0) {
                from = mid + 1;
                continue;
            }
            if (cmp > 0) {
                to = mid - 1;
                continue;
            }
            return mid;
        }
        return -(from + 1);
    }

    public static int binarySearch(short[] a2, short key, ShortComparator c2) {
        return ShortArrays.binarySearch(a2, 0, a2.length, key, c2);
    }

    public static void radixSort(short[] a2) {
        ShortArrays.radixSort(a2, 0, a2.length);
    }

    public static void radixSort(short[] a2, int from, int to) {
        boolean maxLevel = true;
        int stackSize = 256;
        int[] offsetStack = new int[256];
        int offsetPos = 0;
        int[] lengthStack = new int[256];
        int lengthPos = 0;
        int[] levelStack = new int[256];
        int levelPos = 0;
        offsetStack[offsetPos++] = from;
        lengthStack[lengthPos++] = to - from;
        levelStack[levelPos++] = 0;
        int[] count = new int[256];
        int[] pos = new int[256];
        byte[] digit = new byte[a2.length];
        while (offsetPos > 0) {
            int level;
            int signMask;
            int first = offsetStack[--offsetPos];
            int length = lengthStack[--lengthPos];
            int n2 = signMask = (level = levelStack[--levelPos]) % 2 == 0 ? 128 : 0;
            if (length < 50) {
                ShortArrays.selectionSort(a2, first, first + length);
                continue;
            }
            int shift = (1 - level % 2) * 8;
            int i2 = length;
            while (i2-- != 0) {
                digit[first + i2] = (byte)(a2[first + i2] >>> shift & 0xFF ^ signMask);
            }
            i2 = length;
            while (i2-- != 0) {
                int n3 = digit[first + i2] & 0xFF;
                count[n3] = count[n3] + 1;
            }
            int lastUsed = -1;
            int p2 = first;
            for (int i3 = 0; i3 < 256; ++i3) {
                if (count[i3] != 0) {
                    lastUsed = i3;
                    if (level < 1 && count[i3] > 1) {
                        offsetStack[offsetPos++] = p2;
                        lengthStack[lengthPos++] = count[i3];
                        levelStack[levelPos++] = level + 1;
                    }
                }
                pos[i3] = p2 += count[i3];
            }
            int end = first + length - count[lastUsed];
            count[lastUsed] = 0;
            int c2 = -1;
            for (int i4 = first; i4 < end; i4 += count[c2]) {
                short t = a2[i4];
                c2 = digit[i4] & 0xFF;
                while (true) {
                    int n4 = c2;
                    int n5 = pos[n4] - 1;
                    pos[n4] = n5;
                    int d2 = n5;
                    if (n5 <= i4) break;
                    short z = t;
                    int zz = c2;
                    t = a2[d2];
                    c2 = digit[d2] & 0xFF;
                    a2[d2] = z;
                    digit[d2] = (byte)zz;
                }
                a2[i4] = t;
                count[c2] = 0;
            }
        }
    }

    private static void insertionSortIndirect(int[] perm, short[] a2, int from, int to) {
        int i2 = from;
        while (++i2 < to) {
            int t = perm[i2];
            int j2 = i2;
            int u = perm[j2 - 1];
            while (a2[t] < a2[u]) {
                perm[j2] = u;
                if (from == j2 - 1) {
                    --j2;
                    break;
                }
                u = perm[--j2 - 1];
            }
            perm[j2] = t;
        }
    }

    public static void radixSortIndirect(int[] perm, short[] a2, boolean stable) {
        ShortArrays.radixSortIndirect(perm, a2, 0, perm.length, stable);
    }

    public static void radixSortIndirect(int[] perm, short[] a2, int from, int to, boolean stable) {
        boolean maxLevel = true;
        int stackSize = 256;
        int[] offsetStack = new int[256];
        int offsetPos = 0;
        int[] lengthStack = new int[256];
        int lengthPos = 0;
        int[] levelStack = new int[256];
        int levelPos = 0;
        offsetStack[offsetPos++] = from;
        lengthStack[lengthPos++] = to - from;
        levelStack[levelPos++] = 0;
        int[] count = new int[256];
        int[] pos = stable ? null : new int[256];
        int[] support = stable ? new int[perm.length] : null;
        byte[] digit = new byte[perm.length];
        while (offsetPos > 0) {
            int i2;
            int level;
            int signMask;
            int first = offsetStack[--offsetPos];
            int length = lengthStack[--lengthPos];
            int n2 = signMask = (level = levelStack[--levelPos]) % 2 == 0 ? 128 : 0;
            if (length < 50) {
                ShortArrays.insertionSortIndirect(perm, a2, first, first + length);
                continue;
            }
            int shift = (1 - level % 2) * 8;
            int i3 = length;
            while (i3-- != 0) {
                digit[i3] = (byte)(a2[perm[first + i3]] >>> shift & 0xFF ^ signMask);
            }
            i3 = length;
            while (i3-- != 0) {
                int n3 = digit[i3] & 0xFF;
                count[n3] = count[n3] + 1;
            }
            int lastUsed = -1;
            int p2 = 0;
            for (i2 = 0; i2 < 256; ++i2) {
                if (count[i2] != 0) {
                    lastUsed = i2;
                    if (level < 1 && count[i2] > 1) {
                        offsetStack[offsetPos++] = p2 + first;
                        lengthStack[lengthPos++] = count[i2];
                        levelStack[levelPos++] = level + 1;
                    }
                }
                if (stable) {
                    count[i2] = p2 += count[i2];
                    continue;
                }
                pos[i2] = p2 += count[i2];
            }
            if (stable) {
                i2 = length;
                while (i2-- != 0) {
                    int n4 = digit[i2] & 0xFF;
                    int n5 = count[n4] - 1;
                    count[n4] = n5;
                    support[n5] = perm[first + i2];
                }
                System.arraycopy(support, 0, perm, first, length);
                IntArrays.fill(count, 0);
                continue;
            }
            int end = length - count[lastUsed];
            count[lastUsed] = 0;
            int c2 = -1;
            for (int i4 = 0; i4 < end; i4 += count[c2]) {
                int t = perm[i4 + first];
                c2 = digit[i4] & 0xFF;
                while (true) {
                    int n6 = c2;
                    int n7 = pos[n6] - 1;
                    pos[n6] = n7;
                    int d2 = n7;
                    if (n7 <= i4) break;
                    int z = t;
                    int zz = c2;
                    t = perm[d2 + first];
                    c2 = digit[d2] & 0xFF;
                    perm[d2 + first] = z;
                    digit[d2] = (byte)zz;
                }
                perm[i4 + first] = t;
                count[c2] = 0;
            }
        }
    }

    private static void selectionSort(short[] a2, short[] b2, int from, int to) {
        for (int i2 = from; i2 < to - 1; ++i2) {
            int m2 = i2;
            for (int j2 = i2 + 1; j2 < to; ++j2) {
                if (a2[j2] >= a2[m2] && (a2[j2] != a2[m2] || b2[j2] >= b2[m2])) continue;
                m2 = j2;
            }
            if (m2 == i2) continue;
            short t = a2[i2];
            a2[i2] = a2[m2];
            a2[m2] = t;
            t = b2[i2];
            b2[i2] = b2[m2];
            b2[m2] = t;
        }
    }

    public static void radixSort(short[] a2, short[] b2) {
        ShortArrays.radixSort(a2, b2, 0, a2.length);
    }

    public static void radixSort(short[] a2, short[] b2, int from, int to) {
        int layers = 2;
        if (a2.length != b2.length) {
            throw new IllegalArgumentException("Array size mismatch.");
        }
        int maxLevel = 3;
        int stackSize = 766;
        int[] offsetStack = new int[766];
        int offsetPos = 0;
        int[] lengthStack = new int[766];
        int lengthPos = 0;
        int[] levelStack = new int[766];
        int levelPos = 0;
        offsetStack[offsetPos++] = from;
        lengthStack[lengthPos++] = to - from;
        levelStack[levelPos++] = 0;
        int[] count = new int[256];
        int[] pos = new int[256];
        byte[] digit = new byte[a2.length];
        while (offsetPos > 0) {
            int level;
            int signMask;
            int first = offsetStack[--offsetPos];
            int length = lengthStack[--lengthPos];
            int n2 = signMask = (level = levelStack[--levelPos]) % 2 == 0 ? 128 : 0;
            if (length < 50) {
                ShortArrays.selectionSort(a2, b2, first, first + length);
                continue;
            }
            short[] k2 = level < 2 ? a2 : b2;
            int shift = (1 - level % 2) * 8;
            int i2 = length;
            while (i2-- != 0) {
                digit[first + i2] = (byte)(k2[first + i2] >>> shift & 0xFF ^ signMask);
            }
            i2 = length;
            while (i2-- != 0) {
                int n3 = digit[first + i2] & 0xFF;
                count[n3] = count[n3] + 1;
            }
            int lastUsed = -1;
            int p2 = first;
            for (int i3 = 0; i3 < 256; ++i3) {
                if (count[i3] != 0) {
                    lastUsed = i3;
                    if (level < 3 && count[i3] > 1) {
                        offsetStack[offsetPos++] = p2;
                        lengthStack[lengthPos++] = count[i3];
                        levelStack[levelPos++] = level + 1;
                    }
                }
                pos[i3] = p2 += count[i3];
            }
            int end = first + length - count[lastUsed];
            count[lastUsed] = 0;
            int c2 = -1;
            for (int i4 = first; i4 < end; i4 += count[c2]) {
                short t = a2[i4];
                short u = b2[i4];
                c2 = digit[i4] & 0xFF;
                while (true) {
                    int n4 = c2;
                    int n5 = pos[n4] - 1;
                    pos[n4] = n5;
                    int d2 = n5;
                    if (n5 <= i4) break;
                    short z = t;
                    int zz = c2;
                    t = a2[d2];
                    a2[d2] = z;
                    z = u;
                    u = b2[d2];
                    b2[d2] = z;
                    c2 = digit[d2] & 0xFF;
                    digit[d2] = (byte)zz;
                }
                a2[i4] = t;
                b2[i4] = u;
                count[c2] = 0;
            }
        }
    }

    private static void selectionSort(short[][] a2, int from, int to, int level) {
        int layers = a2.length;
        int firstLayer = level / 2;
        for (int i2 = from; i2 < to - 1; ++i2) {
            int m2 = i2;
            block1: for (int j2 = i2 + 1; j2 < to; ++j2) {
                for (int p2 = firstLayer; p2 < layers; ++p2) {
                    if (a2[p2][j2] < a2[p2][m2]) {
                        m2 = j2;
                        continue block1;
                    }
                    if (a2[p2][j2] > a2[p2][m2]) continue block1;
                }
            }
            if (m2 == i2) continue;
            int p3 = layers;
            while (p3-- != 0) {
                short u = a2[p3][i2];
                a2[p3][i2] = a2[p3][m2];
                a2[p3][m2] = u;
            }
        }
    }

    public static void radixSort(short[][] a2) {
        ShortArrays.radixSort(a2, 0, a2[0].length);
    }

    public static void radixSort(short[][] a2, int from, int to) {
        int layers = a2.length;
        int maxLevel = 2 * layers - 1;
        int p2 = layers;
        int l2 = a2[0].length;
        while (p2-- != 0) {
            if (a2[p2].length == l2) continue;
            throw new IllegalArgumentException("The array of index " + p2 + " has not the same length of the array of index 0.");
        }
        int stackSize = 255 * (layers * 2 - 1) + 1;
        int[] offsetStack = new int[stackSize];
        int offsetPos = 0;
        int[] lengthStack = new int[stackSize];
        int lengthPos = 0;
        int[] levelStack = new int[stackSize];
        int levelPos = 0;
        offsetStack[offsetPos++] = from;
        lengthStack[lengthPos++] = to - from;
        levelStack[levelPos++] = 0;
        int[] count = new int[256];
        int[] pos = new int[256];
        byte[] digit = new byte[a2[0].length];
        short[] t = new short[layers];
        while (offsetPos > 0) {
            int level;
            int signMask;
            int first = offsetStack[--offsetPos];
            int length = lengthStack[--lengthPos];
            int n2 = signMask = (level = levelStack[--levelPos]) % 2 == 0 ? 128 : 0;
            if (length < 50) {
                ShortArrays.selectionSort(a2, first, first + length, level);
                continue;
            }
            short[] k2 = a2[level / 2];
            int shift = (1 - level % 2) * 8;
            int i2 = length;
            while (i2-- != 0) {
                digit[first + i2] = (byte)(k2[first + i2] >>> shift & 0xFF ^ signMask);
            }
            i2 = length;
            while (i2-- != 0) {
                int n3 = digit[first + i2] & 0xFF;
                count[n3] = count[n3] + 1;
            }
            int lastUsed = -1;
            int p3 = first;
            for (int i3 = 0; i3 < 256; ++i3) {
                if (count[i3] != 0) {
                    lastUsed = i3;
                    if (level < maxLevel && count[i3] > 1) {
                        offsetStack[offsetPos++] = p3;
                        lengthStack[lengthPos++] = count[i3];
                        levelStack[levelPos++] = level + 1;
                    }
                }
                pos[i3] = p3 += count[i3];
            }
            int end = first + length - count[lastUsed];
            count[lastUsed] = 0;
            int c2 = -1;
            for (int i4 = first; i4 < end; i4 += count[c2]) {
                int p4 = layers;
                while (p4-- != 0) {
                    t[p4] = a2[p4][i4];
                }
                c2 = digit[i4] & 0xFF;
                while (true) {
                    int n4 = c2;
                    int n5 = pos[n4] - 1;
                    pos[n4] = n5;
                    int d2 = n5;
                    if (n5 <= i4) break;
                    p4 = layers;
                    while (p4-- != 0) {
                        short u = t[p4];
                        t[p4] = a2[p4][d2];
                        a2[p4][d2] = u;
                    }
                    int zz = c2;
                    c2 = digit[d2] & 0xFF;
                    digit[d2] = (byte)zz;
                }
                p4 = layers;
                while (p4-- != 0) {
                    a2[p4][i4] = t[p4];
                }
                count[c2] = 0;
            }
        }
    }

    public static short[] shuffle(short[] a2, int from, int to, Random random) {
        int i2 = to - from;
        while (i2-- != 0) {
            int p2 = random.nextInt(i2 + 1);
            short t = a2[from + i2];
            a2[from + i2] = a2[from + p2];
            a2[from + p2] = t;
        }
        return a2;
    }

    public static short[] shuffle(short[] a2, Random random) {
        int i2 = a2.length;
        while (i2-- != 0) {
            int p2 = random.nextInt(i2 + 1);
            short t = a2[i2];
            a2[i2] = a2[p2];
            a2[p2] = t;
        }
        return a2;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ArrayHashStrategy
    implements Hash.Strategy<short[]>,
    Serializable {
        public static final long serialVersionUID = -7046029254386353129L;

        private ArrayHashStrategy() {
        }

        @Override
        public int hashCode(short[] o2) {
            return java.util.Arrays.hashCode(o2);
        }

        @Override
        public boolean equals(short[] a2, short[] b2) {
            return ShortArrays.equals(a2, b2);
        }
    }
}

