/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.ints;

import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.HashCommon;
import it.unimi.dsi.fastutil.booleans.BooleanArrays;
import it.unimi.dsi.fastutil.ints.AbstractInt2ObjectMap;
import it.unimi.dsi.fastutil.ints.AbstractIntSet;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.objects.AbstractObjectCollection;
import it.unimi.dsi.fastutil.objects.AbstractObjectSet;
import it.unimi.dsi.fastutil.objects.ObjectArrays;
import it.unimi.dsi.fastutil.objects.ObjectCollection;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Map;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Int2ObjectOpenHashMap<V>
extends AbstractInt2ObjectMap<V>
implements Serializable,
Cloneable,
Hash {
    public static final long serialVersionUID = 0L;
    private static final boolean ASSERTS = false;
    protected transient int[] key;
    protected transient V[] value;
    protected transient boolean[] used;
    protected final float f;
    protected transient int n;
    protected transient int maxFill;
    protected transient int mask;
    protected int size;
    protected volatile transient Int2ObjectMap.FastEntrySet<V> entries;
    protected volatile transient IntSet keys;
    protected volatile transient ObjectCollection<V> values;

    public Int2ObjectOpenHashMap(int expected, float f2) {
        if (f2 <= 0.0f || f2 > 1.0f) {
            throw new IllegalArgumentException("Load factor must be greater than 0 and smaller than or equal to 1");
        }
        if (expected < 0) {
            throw new IllegalArgumentException("The expected number of elements must be nonnegative");
        }
        this.f = f2;
        this.n = HashCommon.arraySize(expected, f2);
        this.mask = this.n - 1;
        this.maxFill = HashCommon.maxFill(this.n, f2);
        this.key = new int[this.n];
        this.value = new Object[this.n];
        this.used = new boolean[this.n];
    }

    public Int2ObjectOpenHashMap(int expected) {
        this(expected, 0.75f);
    }

    public Int2ObjectOpenHashMap() {
        this(16, 0.75f);
    }

    public Int2ObjectOpenHashMap(Map<? extends Integer, ? extends V> m2, float f2) {
        this(m2.size(), f2);
        this.putAll(m2);
    }

    public Int2ObjectOpenHashMap(Map<? extends Integer, ? extends V> m2) {
        this(m2, 0.75f);
    }

    public Int2ObjectOpenHashMap(Int2ObjectMap<V> m2, float f2) {
        this(m2.size(), f2);
        this.putAll(m2);
    }

    public Int2ObjectOpenHashMap(Int2ObjectMap<V> m2) {
        this(m2, 0.75f);
    }

    public Int2ObjectOpenHashMap(int[] k2, V[] v, float f2) {
        this(k2.length, f2);
        if (k2.length != v.length) {
            throw new IllegalArgumentException("The key array and the value array have different lengths (" + k2.length + " and " + v.length + ")");
        }
        for (int i2 = 0; i2 < k2.length; ++i2) {
            this.put(k2[i2], v[i2]);
        }
    }

    public Int2ObjectOpenHashMap(int[] k2, V[] v) {
        this(k2, v, 0.75f);
    }

    @Override
    public V put(int k2, V v) {
        int pos = HashCommon.murmurHash3(k2) & this.mask;
        while (this.used[pos]) {
            if (k2 == this.key[pos]) {
                V oldValue = this.value[pos];
                this.value[pos] = v;
                return oldValue;
            }
            pos = pos + 1 & this.mask;
        }
        this.used[pos] = true;
        this.key[pos] = k2;
        this.value[pos] = v;
        if (++this.size >= this.maxFill) {
            this.rehash(HashCommon.arraySize(this.size + 1, this.f));
        }
        return (V)this.defRetValue;
    }

    @Override
    public V put(Integer ok, V ov) {
        V v = ov;
        int k2 = ok;
        int pos = HashCommon.murmurHash3(k2) & this.mask;
        while (this.used[pos]) {
            if (k2 == this.key[pos]) {
                V oldValue = this.value[pos];
                this.value[pos] = v;
                return oldValue;
            }
            pos = pos + 1 & this.mask;
        }
        this.used[pos] = true;
        this.key[pos] = k2;
        this.value[pos] = v;
        if (++this.size >= this.maxFill) {
            this.rehash(HashCommon.arraySize(this.size + 1, this.f));
        }
        return (V)this.defRetValue;
    }

    protected final void shiftKeys(int pos) {
        while (true) {
            int last = pos;
            pos = last + 1 & this.mask;
            while (this.used[pos]) {
                int slot = HashCommon.murmurHash3(this.key[pos]) & this.mask;
                if (last <= pos ? last >= slot || slot > pos : last >= slot && slot > pos) break;
                pos = pos + 1 & this.mask;
            }
            if (!this.used[pos]) break;
            this.key[last] = this.key[pos];
            this.value[last] = this.value[pos];
        }
        this.used[last] = false;
        this.value[last] = null;
    }

    @Override
    public V remove(int k2) {
        int pos = HashCommon.murmurHash3(k2) & this.mask;
        while (this.used[pos]) {
            if (k2 == this.key[pos]) {
                --this.size;
                V v = this.value[pos];
                this.shiftKeys(pos);
                return v;
            }
            pos = pos + 1 & this.mask;
        }
        return (V)this.defRetValue;
    }

    @Override
    public V remove(Object ok) {
        int k2 = (Integer)ok;
        int pos = HashCommon.murmurHash3(k2) & this.mask;
        while (this.used[pos]) {
            if (k2 == this.key[pos]) {
                --this.size;
                V v = this.value[pos];
                this.shiftKeys(pos);
                return v;
            }
            pos = pos + 1 & this.mask;
        }
        return (V)this.defRetValue;
    }

    public V get(Integer ok) {
        int k2 = ok;
        int pos = HashCommon.murmurHash3(k2) & this.mask;
        while (this.used[pos]) {
            if (k2 == this.key[pos]) {
                return this.value[pos];
            }
            pos = pos + 1 & this.mask;
        }
        return (V)this.defRetValue;
    }

    @Override
    public V get(int k2) {
        int pos = HashCommon.murmurHash3(k2) & this.mask;
        while (this.used[pos]) {
            if (k2 == this.key[pos]) {
                return this.value[pos];
            }
            pos = pos + 1 & this.mask;
        }
        return (V)this.defRetValue;
    }

    @Override
    public boolean containsKey(int k2) {
        int pos = HashCommon.murmurHash3(k2) & this.mask;
        while (this.used[pos]) {
            if (k2 == this.key[pos]) {
                return true;
            }
            pos = pos + 1 & this.mask;
        }
        return false;
    }

    @Override
    public boolean containsValue(Object v) {
        V[] value = this.value;
        boolean[] used = this.used;
        int i2 = this.n;
        while (i2-- != 0) {
            if (!used[i2] || !(value[i2] == null ? v == null : value[i2].equals(v))) continue;
            return true;
        }
        return false;
    }

    @Override
    public void clear() {
        if (this.size == 0) {
            return;
        }
        this.size = 0;
        BooleanArrays.fill(this.used, false);
        ObjectArrays.fill(this.value, null);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Deprecated
    public void growthFactor(int growthFactor) {
    }

    @Deprecated
    public int growthFactor() {
        return 16;
    }

    public Int2ObjectMap.FastEntrySet<V> int2ObjectEntrySet() {
        if (this.entries == null) {
            this.entries = new MapEntrySet();
        }
        return this.entries;
    }

    @Override
    public IntSet keySet() {
        if (this.keys == null) {
            this.keys = new KeySet();
        }
        return this.keys;
    }

    @Override
    public ObjectCollection<V> values() {
        if (this.values == null) {
            this.values = new AbstractObjectCollection<V>(){

                @Override
                public ObjectIterator<V> iterator() {
                    return new ValueIterator();
                }

                @Override
                public int size() {
                    return Int2ObjectOpenHashMap.this.size;
                }

                @Override
                public boolean contains(Object v) {
                    return Int2ObjectOpenHashMap.this.containsValue(v);
                }

                @Override
                public void clear() {
                    Int2ObjectOpenHashMap.this.clear();
                }
            };
        }
        return this.values;
    }

    @Deprecated
    public boolean rehash() {
        return true;
    }

    public boolean trim() {
        int l2 = HashCommon.arraySize(this.size, this.f);
        if (l2 >= this.n) {
            return true;
        }
        try {
            this.rehash(l2);
        }
        catch (OutOfMemoryError cantDoIt) {
            return false;
        }
        return true;
    }

    public boolean trim(int n2) {
        int l2 = HashCommon.nextPowerOfTwo((int)Math.ceil((float)n2 / this.f));
        if (this.n <= l2) {
            return true;
        }
        try {
            this.rehash(l2);
        }
        catch (OutOfMemoryError cantDoIt) {
            return false;
        }
        return true;
    }

    protected void rehash(int newN) {
        int i2 = 0;
        boolean[] used = this.used;
        int[] key = this.key;
        V[] value = this.value;
        int newMask = newN - 1;
        int[] newKey = new int[newN];
        Object[] newValue = new Object[newN];
        boolean[] newUsed = new boolean[newN];
        int j2 = this.size;
        while (j2-- != 0) {
            while (!used[i2]) {
                ++i2;
            }
            int k2 = key[i2];
            int pos = HashCommon.murmurHash3(k2) & newMask;
            while (newUsed[pos]) {
                pos = pos + 1 & newMask;
            }
            newUsed[pos] = true;
            newKey[pos] = k2;
            newValue[pos] = value[i2];
            ++i2;
        }
        this.n = newN;
        this.mask = newMask;
        this.maxFill = HashCommon.maxFill(this.n, this.f);
        this.key = newKey;
        this.value = newValue;
        this.used = newUsed;
    }

    public Int2ObjectOpenHashMap<V> clone() {
        Int2ObjectOpenHashMap c2;
        try {
            c2 = (Int2ObjectOpenHashMap)super.clone();
        }
        catch (CloneNotSupportedException cantHappen) {
            throw new InternalError();
        }
        c2.keys = null;
        c2.values = null;
        c2.entries = null;
        c2.key = (int[])this.key.clone();
        c2.value = (Object[])this.value.clone();
        c2.used = (boolean[])this.used.clone();
        return c2;
    }

    @Override
    public int hashCode() {
        int h2 = 0;
        int j2 = this.size;
        int i2 = 0;
        int t = 0;
        while (j2-- != 0) {
            while (!this.used[i2]) {
                ++i2;
            }
            t = this.key[i2];
            if (this != this.value[i2]) {
                t ^= this.value[i2] == null ? 0 : this.value[i2].hashCode();
            }
            h2 += t;
            ++i2;
        }
        return h2;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        int[] key = this.key;
        V[] value = this.value;
        MapIterator i2 = new MapIterator();
        s.defaultWriteObject();
        int j2 = this.size;
        while (j2-- != 0) {
            int e2 = i2.nextEntry();
            s.writeInt(key[e2]);
            s.writeObject(value[e2]);
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.n = HashCommon.arraySize(this.size, this.f);
        this.maxFill = HashCommon.maxFill(this.n, this.f);
        this.mask = this.n - 1;
        this.key = new int[this.n];
        int[] key = this.key;
        this.value = new Object[this.n];
        Object[] value = this.value;
        this.used = new boolean[this.n];
        boolean[] used = this.used;
        int i2 = this.size;
        int pos = 0;
        while (i2-- != 0) {
            int k2 = s.readInt();
            Object v = s.readObject();
            pos = HashCommon.murmurHash3(k2) & this.mask;
            while (used[pos]) {
                pos = pos + 1 & this.mask;
            }
            used[pos] = true;
            key[pos] = k2;
            value[pos] = v;
        }
    }

    private void checkTable() {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class ValueIterator
    extends MapIterator
    implements ObjectIterator<V> {
        @Override
        public V next() {
            return Int2ObjectOpenHashMap.this.value[this.nextEntry()];
        }
    }

    private final class KeySet
    extends AbstractIntSet {
        private KeySet() {
        }

        public IntIterator iterator() {
            return new KeyIterator();
        }

        public int size() {
            return Int2ObjectOpenHashMap.this.size;
        }

        public boolean contains(int k2) {
            return Int2ObjectOpenHashMap.this.containsKey(k2);
        }

        public boolean remove(int k2) {
            int oldSize = Int2ObjectOpenHashMap.this.size;
            Int2ObjectOpenHashMap.this.remove(k2);
            return Int2ObjectOpenHashMap.this.size != oldSize;
        }

        public void clear() {
            Int2ObjectOpenHashMap.this.clear();
        }
    }

    private final class KeyIterator
    extends MapIterator
    implements IntIterator {
        public int nextInt() {
            return Int2ObjectOpenHashMap.this.key[this.nextEntry()];
        }

        public Integer next() {
            return Int2ObjectOpenHashMap.this.key[this.nextEntry()];
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class MapEntrySet
    extends AbstractObjectSet<Int2ObjectMap.Entry<V>>
    implements Int2ObjectMap.FastEntrySet<V> {
        private MapEntrySet() {
        }

        @Override
        public ObjectIterator<Int2ObjectMap.Entry<V>> iterator() {
            return new EntryIterator();
        }

        @Override
        public ObjectIterator<Int2ObjectMap.Entry<V>> fastIterator() {
            return new FastEntryIterator();
        }

        @Override
        public boolean contains(Object o2) {
            if (!(o2 instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e2 = (Map.Entry)o2;
            int k2 = (Integer)e2.getKey();
            int pos = HashCommon.murmurHash3(k2) & Int2ObjectOpenHashMap.this.mask;
            while (Int2ObjectOpenHashMap.this.used[pos]) {
                if (k2 == Int2ObjectOpenHashMap.this.key[pos]) {
                    return Int2ObjectOpenHashMap.this.value[pos] == null ? e2.getValue() == null : Int2ObjectOpenHashMap.this.value[pos].equals(e2.getValue());
                }
                pos = pos + 1 & Int2ObjectOpenHashMap.this.mask;
            }
            return false;
        }

        @Override
        public boolean remove(Object o2) {
            if (!(o2 instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e2 = (Map.Entry)o2;
            int k2 = (Integer)e2.getKey();
            int pos = HashCommon.murmurHash3(k2) & Int2ObjectOpenHashMap.this.mask;
            while (Int2ObjectOpenHashMap.this.used[pos]) {
                if (k2 == Int2ObjectOpenHashMap.this.key[pos]) {
                    Int2ObjectOpenHashMap.this.remove(e2.getKey());
                    return true;
                }
                pos = pos + 1 & Int2ObjectOpenHashMap.this.mask;
            }
            return false;
        }

        @Override
        public int size() {
            return Int2ObjectOpenHashMap.this.size;
        }

        @Override
        public void clear() {
            Int2ObjectOpenHashMap.this.clear();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class FastEntryIterator
    extends MapIterator
    implements ObjectIterator<Int2ObjectMap.Entry<V>> {
        final AbstractInt2ObjectMap.BasicEntry<V> entry;

        private FastEntryIterator() {
            this.entry = new AbstractInt2ObjectMap.BasicEntry<Object>(0, null);
        }

        @Override
        public AbstractInt2ObjectMap.BasicEntry<V> next() {
            int e2 = this.nextEntry();
            this.entry.key = Int2ObjectOpenHashMap.this.key[e2];
            this.entry.value = Int2ObjectOpenHashMap.this.value[e2];
            return this.entry;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EntryIterator
    extends MapIterator
    implements ObjectIterator<Int2ObjectMap.Entry<V>> {
        private EntryIterator() {
        }

        @Override
        public Int2ObjectMap.Entry<V> next() {
            return new MapEntry(this.nextEntry());
        }
    }

    private class MapIterator {
        int pos;
        int last;
        int c;

        private MapIterator() {
            this.pos = Int2ObjectOpenHashMap.this.n;
            this.last = -1;
            this.c = Int2ObjectOpenHashMap.this.size;
            boolean[] used = Int2ObjectOpenHashMap.this.used;
            if (this.c != 0) {
                while (!used[--this.pos]) {
                }
            }
        }

        public boolean hasNext() {
            return this.c != 0;
        }

        public int nextEntry() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.last = this.pos;
            if (--this.c != 0) {
                boolean[] used = Int2ObjectOpenHashMap.this.used;
                while (!used[this.pos = this.pos - 1 & Int2ObjectOpenHashMap.this.mask]) {
                }
            }
            return this.last;
        }

        public void remove() {
            if (this.last == -1) {
                throw new IllegalStateException();
            }
            --Int2ObjectOpenHashMap.this.size;
            Int2ObjectOpenHashMap.this.shiftKeys(this.last);
            this.last = -1;
        }

        public int skip(int n2) {
            int i2 = n2;
            while (i2-- != 0 && this.hasNext()) {
                this.nextEntry();
            }
            return n2 - i2 - 1;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class MapEntry
    implements Int2ObjectMap.Entry<V>,
    Map.Entry<Integer, V> {
        private int index;

        MapEntry(int index) {
            this.index = index;
        }

        @Override
        public Integer getKey() {
            return Int2ObjectOpenHashMap.this.key[this.index];
        }

        @Override
        public int getIntKey() {
            return Int2ObjectOpenHashMap.this.key[this.index];
        }

        @Override
        public V getValue() {
            return Int2ObjectOpenHashMap.this.value[this.index];
        }

        @Override
        public V setValue(V v) {
            Object oldValue = Int2ObjectOpenHashMap.this.value[this.index];
            Int2ObjectOpenHashMap.this.value[this.index] = v;
            return oldValue;
        }

        @Override
        public boolean equals(Object o2) {
            if (!(o2 instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e2 = (Map.Entry)o2;
            return Int2ObjectOpenHashMap.this.key[this.index] == (Integer)e2.getKey() && (Int2ObjectOpenHashMap.this.value[this.index] == null ? e2.getValue() == null : Int2ObjectOpenHashMap.this.value[this.index].equals(e2.getValue()));
        }

        @Override
        public int hashCode() {
            return Int2ObjectOpenHashMap.this.key[this.index] ^ (Int2ObjectOpenHashMap.this.value[this.index] == null ? 0 : Int2ObjectOpenHashMap.this.value[this.index].hashCode());
        }

        public String toString() {
            return Int2ObjectOpenHashMap.this.key[this.index] + "=>" + Int2ObjectOpenHashMap.this.value[this.index];
        }
    }
}

