/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.prefs.Preferences;
import java.util.regex.Pattern;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileSystemView;
import org.apache.log4j.Logger;
import org.broad.igv.exceptions.DataLoadException;

public class Globals {
    private static Logger log = Logger.getLogger(Globals.class);
    public static final String CHR_ALL = "All";
    public static boolean headless = false;
    public static boolean suppressMessages = false;
    private static boolean batch = false;
    public static final String SESSION_FILE_EXTENSION = ".xml";
    public static final String GENOME_FILE_EXTENSION = ".genome";
    public static final String ZIP_EXTENSION = ".zip";
    public static final String FASTA_GZIP_FILE_EXTENSION = ".gz";
    public static final String GENOME_ARCHIVE_PROPERTY_FILE_NAME = "property.txt";
    public static final String GENOME_ARCHIVE_ID_KEY = "id";
    public static final String GENOME_ARCHIVE_NAME_KEY = "name";
    public static final String GENOME_ARCHIVE_VERSION_KEY = "version";
    public static final String GENOME_ORDERED_KEY = "ordered";
    public static final String GENOME_GENETRACK_NAME = "geneTrackName";
    public static final String GENOME_URL_KEY = "url";
    public static final String GENOME_ARCHIVE_CYTOBAND_FILE_KEY = "cytobandFile";
    public static final String GENOME_ARCHIVE_GENE_FILE_KEY = "geneFile";
    public static final String GENOME_ARCHIVE_SEQUENCE_FILE_LOCATION_KEY = "sequenceLocation";
    public static final Pattern commaPattern = Pattern.compile(",");
    public static final Pattern tabPattern = Pattern.compile("\t");
    public static final Pattern colonPattern = Pattern.compile(":");
    public static final Pattern dashPattern = Pattern.compile("-");
    public static final Pattern equalPattern = Pattern.compile("=");
    public static List emptyList = new ArrayList();
    public static String VERSION;
    public static String BUILD;
    public static String TIMESTAMP;
    public static final String NO_FEATURES_FOUND_WARNING = "No features were found in this file with chromosomes mapped to the current genome";
    public static double log2;
    public static final boolean IS_WINDOWS;
    public static final boolean IS_MAC;
    public static final boolean IS_LINUX;
    public static final String GENOME_CACHE_FOLDER_NAME = "genomes";
    private static File DEFAULT_USER_DIRECTORY;
    private static File DEFAULT_IGV_DIRECTORY;
    private static File GENOME_CACHE_DIRECTORY;
    private static File IGV_TEMP_DIRECTORY;
    private static File GENE_LIST_DIRECTORY;
    private static final String GENE_LIST_FOLDER_NAME = "lists";
    public static final String IGV_DIR_USERPREF = "igvDir";
    public static final String GENOME_CHR_ALIAS_FILE_KEY = "chrAliasFile";
    public static final String DEFAULT_GENOME = "hg18";

    public static void setHeadless(boolean bool) {
        headless = bool;
    }

    public static boolean isHeadless() {
        return headless;
    }

    public static void setSuppressMessages(boolean bool) {
        suppressMessages = bool;
    }

    public static boolean isSuppressMessages() {
        return suppressMessages;
    }

    public static String applicationString() {
        return "IGV Version " + VERSION + " (" + BUILD + ")" + TIMESTAMP;
    }

    public static String versionString() {
        return "<html>Version " + VERSION + " (" + BUILD + ")<br>" + TIMESTAMP;
    }

    public static synchronized File getUserDirectory() {
        if (DEFAULT_USER_DIRECTORY == null) {
            DEFAULT_USER_DIRECTORY = FileSystemView.getFileSystemView().getDefaultDirectory();
        }
        return DEFAULT_USER_DIRECTORY;
    }

    public static File getIgvDirectory() {
        if (System.getProperty("os.name").equals("Windows XP")) {
            try {
                Runtime.getRuntime().exec("attrib -r \"" + Globals.getUserDirectory().getAbsolutePath() + "\"");
            }
            catch (IOException e2) {
                // empty catch block
            }
        }
        if (DEFAULT_IGV_DIRECTORY == null) {
            try {
                Preferences prefs = Preferences.userNodeForPackage(Globals.class);
                String userDir = prefs.get(IGV_DIR_USERPREF, null);
                if (userDir != null && !(DEFAULT_IGV_DIRECTORY = new File(userDir)).exists()) {
                    DEFAULT_IGV_DIRECTORY = null;
                    prefs.remove(IGV_DIR_USERPREF);
                }
            }
            catch (Exception e3) {
                Preferences prefs = Preferences.userNodeForPackage(Globals.class);
                prefs.remove(IGV_DIR_USERPREF);
                System.err.println("Error creating user directory");
                e3.printStackTrace();
            }
            if (DEFAULT_IGV_DIRECTORY == null) {
                String userHomeString = System.getProperty("user.home");
                File rootDir = new File(userHomeString);
                if (!rootDir.exists() || !Globals.canWrite(rootDir)) {
                    rootDir = Globals.getUserDirectory();
                }
                DEFAULT_IGV_DIRECTORY = IS_MAC ? new File(rootDir, ".igv") : new File(rootDir, "igv");
            }
            if (!DEFAULT_IGV_DIRECTORY.exists()) {
                try {
                    boolean wasSuccessful = DEFAULT_IGV_DIRECTORY.mkdir();
                    if (!wasSuccessful) {
                        log.error("Failed to create user directory!");
                    }
                }
                catch (Exception e4) {
                    log.error("Error creating user directory", e4);
                }
            }
            if (!(DEFAULT_IGV_DIRECTORY.exists() && DEFAULT_IGV_DIRECTORY.canRead() && Globals.canWrite(DEFAULT_IGV_DIRECTORY))) {
                if (Globals.isHeadless() || Globals.isSuppressMessages()) {
                    System.err.println("Cannot write to igv directory: " + DEFAULT_IGV_DIRECTORY.getAbsolutePath());
                    DEFAULT_IGV_DIRECTORY = new File(".").getParentFile();
                } else {
                    int option = JOptionPane.showConfirmDialog(null, "<html>The default IGV directory (" + DEFAULT_IGV_DIRECTORY + ") " + "cannot be accessed.  Click Yes to choose a new folder or No to exit.<br>" + "This folder will be used to store user preferences and cached genomes.", "IGV Directory Error", 0);
                    if (option == 0) {
                        JFileChooser fc = new JFileChooser();
                        fc.setFileSelectionMode(1);
                        int retValue = fc.showOpenDialog(null);
                        if (retValue == 0) {
                            DEFAULT_IGV_DIRECTORY = fc.getSelectedFile();
                            Preferences prefs = Preferences.userNodeForPackage(Globals.class);
                            prefs.put(IGV_DIR_USERPREF, DEFAULT_IGV_DIRECTORY.getAbsolutePath());
                        }
                    }
                }
            }
            if (!DEFAULT_IGV_DIRECTORY.canRead()) {
                throw new DataLoadException("Cannot read from user directory", DEFAULT_IGV_DIRECTORY.getAbsolutePath());
            }
            if (!Globals.canWrite(DEFAULT_IGV_DIRECTORY)) {
                throw new DataLoadException("Cannot write to user directory", DEFAULT_IGV_DIRECTORY.getAbsolutePath());
            }
        }
        return DEFAULT_IGV_DIRECTORY;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean canWrite(File directory) {
        if (IS_WINDOWS) {
            File testFile = null;
            try {
                testFile = new File(directory, "igv332415dsfjdsklt.testfile");
                if (testFile.exists()) {
                    testFile.delete();
                }
                testFile.deleteOnExit();
                testFile.createNewFile();
                boolean bl = testFile.exists();
                return bl;
            }
            catch (IOException e2) {
                boolean bl = false;
                return bl;
            }
            finally {
                if (testFile.exists()) {
                    testFile.delete();
                }
            }
        }
        return directory.canWrite();
    }

    public static File getGenomeCacheDirectory() {
        if (GENOME_CACHE_DIRECTORY == null) {
            GENOME_CACHE_DIRECTORY = new File(Globals.getIgvDirectory(), GENOME_CACHE_FOLDER_NAME);
            if (!GENOME_CACHE_DIRECTORY.exists()) {
                GENOME_CACHE_DIRECTORY.mkdir();
            }
            if (!GENOME_CACHE_DIRECTORY.canRead()) {
                throw new DataLoadException("Cannot read from user directory", GENOME_CACHE_DIRECTORY.getAbsolutePath());
            }
            if (!GENOME_CACHE_DIRECTORY.canWrite()) {
                throw new DataLoadException("Cannot write to user directory", GENOME_CACHE_DIRECTORY.getAbsolutePath());
            }
        }
        return GENOME_CACHE_DIRECTORY;
    }

    public static File getGeneListDirectory() {
        if (GENE_LIST_DIRECTORY == null) {
            GENE_LIST_DIRECTORY = new File(Globals.getIgvDirectory(), GENE_LIST_FOLDER_NAME);
            if (!GENE_LIST_DIRECTORY.exists()) {
                GENE_LIST_DIRECTORY.mkdir();
            }
            if (!GENE_LIST_DIRECTORY.canRead()) {
                throw new DataLoadException("Cannot read from user directory", GENE_LIST_DIRECTORY.getAbsolutePath());
            }
            if (!GENE_LIST_DIRECTORY.canWrite()) {
                throw new DataLoadException("Cannot write to user directory", GENE_LIST_DIRECTORY.getAbsolutePath());
            }
        }
        return GENE_LIST_DIRECTORY;
    }

    public static boolean isBatch() {
        return batch;
    }

    public static void setBatch(boolean batch) {
        Globals.batch = batch;
    }

    static {
        log2 = Math.log(2.0);
        IS_WINDOWS = System.getProperty("os.name").toLowerCase().startsWith("windows");
        IS_MAC = System.getProperty("os.name").toLowerCase().startsWith("mac");
        IS_LINUX = System.getProperty("os.name").toLowerCase().startsWith("linux");
        Properties properties = new Properties();
        try {
            properties.load(Globals.class.getResourceAsStream("/resources/about.properties"));
        }
        catch (IOException e2) {
            log.error("*** Error retrieving version and build information! ***", e2);
        }
        VERSION = properties.getProperty(GENOME_ARCHIVE_VERSION_KEY, "???");
        BUILD = properties.getProperty("build", "???");
        TIMESTAMP = properties.getProperty("timestamp", "???");
    }
}

