/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.med.icb.goby.alignments;

import com.google.protobuf.CodedInputStream;
import edu.cornell.med.icb.goby.alignments.AlignmentReaderImpl;
import edu.cornell.med.icb.goby.alignments.Alignments;
import edu.cornell.med.icb.util.VersionUtils;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.logging.ProgressLogger;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class UpgradeTo1_9_6 {
    private boolean verbose;
    private static final Logger LOG = Logger.getLogger(AlignmentReaderImpl.class);

    public void upgrade(String basename, AlignmentReaderImpl reader) throws IOException {
        if (!"1.9.5-".equals(reader.getGobyVersion())) {
            return;
        }
        GZIPInputStream indexStream = new GZIPInputStream(new FileInputStream(basename + ".index"));
        CodedInputStream codedInput = CodedInputStream.newInstance(indexStream);
        codedInput.setSizeLimit(Integer.MAX_VALUE);
        Alignments.AlignmentIndex index = Alignments.AlignmentIndex.parseFrom(codedInput);
        LongArrayList indexOffsets = new LongArrayList();
        LongArrayList upgradedOffsets = new LongArrayList();
        LongArrayList indexAbsolutePositions = new LongArrayList();
        LongArrayList upgradedIndexAbsolutePositions = new LongArrayList();
        for (long offset : index.getOffsetsList()) {
            indexOffsets.add(offset);
        }
        for (long absolutePosition : index.getAbsolutePositionsList()) {
            indexAbsolutePositions.add(absolutePosition);
        }
        indexAbsolutePositions.trim();
        indexOffsets.trim();
        int[] targetLengths = reader.getTargetLength();
        long[] targetPositionOffsets = new long[targetLengths.length];
        targetPositionOffsets[0] = 0L;
        for (int targetIndex = 1; targetIndex < targetLengths.length; ++targetIndex) {
            targetPositionOffsets[targetIndex] = (long)targetLengths[targetIndex - 1] + targetPositionOffsets[targetIndex - 1];
        }
        long previousAbsolutePosition = -1L;
        ProgressLogger progress = new ProgressLogger(LOG);
        progress.expectedUpdates = indexOffsets.size();
        progress.priority = Level.INFO;
        progress.start();
        Alignments.AlignmentEntry entry = reader.next();
        previousAbsolutePosition = this.pushEntryToIndex(upgradedOffsets, upgradedIndexAbsolutePositions, targetPositionOffsets, previousAbsolutePosition, 0L, entry);
        Iterator i$ = indexOffsets.iterator();
        while (i$.hasNext()) {
            long indexOffset = (Long)i$.next();
            entry = this.fetchFirstEntry(reader, indexOffset);
            previousAbsolutePosition = this.pushEntryToIndex(upgradedOffsets, upgradedIndexAbsolutePositions, targetPositionOffsets, previousAbsolutePosition, indexOffset, entry);
            progress.lightUpdate();
        }
        progress.stop();
        this.writeIndex(basename, upgradedOffsets, upgradedIndexAbsolutePositions);
        this.upgradeHeaderVersion(basename);
        if (this.verbose) {
            System.out.printf("alignment %s upgraded successfully.%n", basename);
        }
    }

    private long pushEntryToIndex(LongArrayList upgradedOffsets, LongArrayList upgradedIndexAbsolutePositions, long[] targetPositionOffsets, long previousAbsolutePosition, long indexOffset, Alignments.AlignmentEntry entry) {
        if (entry == null) {
            if (this.verbose) {
                System.err.println("Error: Cannot obtain entry at start of chunk for indexOffset: " + indexOffset);
                System.exit(10);
            }
        } else {
            int position;
            int targetIndex = entry.getTargetIndex();
            long newAbsolutePosition = targetPositionOffsets[targetIndex] + (long)(position = entry.getPosition());
            if (newAbsolutePosition > previousAbsolutePosition) {
                upgradedOffsets.add(indexOffset);
                upgradedIndexAbsolutePositions.add(newAbsolutePosition);
                previousAbsolutePosition = newAbsolutePosition;
            }
        }
        return previousAbsolutePosition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void upgradeHeaderVersion(String basename) throws IOException {
        InputStream headerStream;
        try {
            headerStream = new GZIPInputStream(new FileInputStream(basename + ".header"));
        }
        catch (IOException e2) {
            LOG.trace("falling back to legacy 1.4- uncompressed header.");
            headerStream = new FileInputStream(basename + ".header");
        }
        CodedInputStream codedInput = CodedInputStream.newInstance(headerStream);
        codedInput.setSizeLimit(Integer.MAX_VALUE);
        Alignments.AlignmentHeader header = Alignments.AlignmentHeader.parseFrom(codedInput);
        Alignments.AlignmentHeader.Builder upgradedHeader = Alignments.AlignmentHeader.newBuilder(header);
        upgradedHeader.setVersion(VersionUtils.getImplementationVersion(UpgradeTo1_9_6.class));
        FileUtils.moveFile(new File(basename + ".header"), new File(basename + ".header.bak"));
        GZIPOutputStream headerOutput = new GZIPOutputStream(new FileOutputStream(basename + ".header"));
        try {
            upgradedHeader.build().writeTo(headerOutput);
        }
        finally {
            headerOutput.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeIndex(String basename, LongArrayList indexOffsets, LongArrayList indexAbsolutePositions) throws IOException {
        DeflaterOutputStream indexOutput = null;
        try {
            FileUtils.moveFile(new File(basename + ".index"), new File(basename + ".index.bak"));
            indexOutput = new GZIPOutputStream(new FileOutputStream(basename + ".index"));
            Alignments.AlignmentIndex.Builder indexBuilder = Alignments.AlignmentIndex.newBuilder();
            assert (indexOffsets.size() == indexAbsolutePositions.size()) : "index sizes must be consistent.";
            indexBuilder.addAllOffsets(indexOffsets);
            indexBuilder.addAllAbsolutePositions(indexAbsolutePositions);
            indexBuilder.build().writeTo(indexOutput);
        }
        finally {
            if (indexOutput != null) {
                indexOutput.close();
            }
        }
    }

    private Alignments.AlignmentEntry fetchFirstEntry(AlignmentReaderImpl reader, long indexOffset) throws IOException {
        reader.seek(indexOffset);
        if (reader.hasNext()) {
            return reader.next();
        }
        return null;
    }

    public void setSilent(boolean silent) {
        this.verbose = !silent;
    }
}

