/*
 * Decompiled with CFR 0.152.
 */
package org.broad.tribble.annotation;

import org.broad.tribble.annotation.DiploidGenotypeException;

public enum DiploidGenotype {
    AA,
    AC,
    AG,
    AT,
    CC,
    CG,
    CT,
    GG,
    GT,
    TT;


    public static DiploidGenotype toDiploidGenotype(String genotype) {
        if (genotype.length() != 2) {
            throw new DiploidGenotypeException("Genotype string for conversion should be of length 2, we were passed = " + genotype);
        }
        genotype = genotype.toUpperCase();
        for (DiploidGenotype g2 : DiploidGenotype.values()) {
            if (!g2.toString().equals(genotype)) continue;
            return g2;
        }
        throw new DiploidGenotypeException("Unable to find genotype matching " + genotype);
    }

    public boolean isHet() {
        return this.toString().toCharArray()[0] != this.toString().toCharArray()[1];
    }

    public boolean containsBase(char base) {
        return this.toString().charAt(0) == base || this.toString().charAt(1) == base;
    }
}

