/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.util.stream;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.log4j.Logger;
import org.broad.igv.util.HttpUtils;
import org.broad.tribble.util.SeekableStream;

public class SeekableServiceStream
extends SeekableStream {
    static Logger log = Logger.getLogger(SeekableServiceStream.class);
    private static final String WEBSERVICE_URL = "http://www.broadinstitute.org/webservices/igv";
    private static final String IGV_DATA_HOST = "www.broadinstitute.org";
    private static final String DATA_PATH = "/xchip/igv/data/public";
    private static final String DATA_HTTP_PATH = "/igvdata";
    private long position = 0L;
    private long contentLength = Long.MAX_VALUE;
    private String dataPath;

    public SeekableServiceStream(String path) {
        try {
            URL url = new URL(path);
            this.dataPath = url.getPath().replaceFirst(DATA_HTTP_PATH, DATA_PATH);
        }
        catch (MalformedURLException e2) {
            log.error("Error instantiating SeekableServiceStream", e2);
        }
    }

    @Override
    public long length() {
        return this.contentLength;
    }

    @Override
    public boolean eof() throws IOException {
        return this.position >= this.contentLength;
    }

    @Override
    public void seek(long position) {
        this.position = position;
    }

    @Override
    public long position() {
        return this.position;
    }

    @Override
    public long skip(long n2) throws IOException {
        this.position += n2;
        return n2;
    }

    @Override
    public int read(byte[] buffer, int offset, int length) throws IOException {
        int n2;
        if (offset < 0 || length < 0 || offset + length > buffer.length) {
            throw new IndexOutOfBoundsException();
        }
        InputStream is = null;
        URL url = new URL("http://www.broadinstitute.org/webservices/igv?method=getRange&file=" + this.dataPath + "&position=" + this.position + "&length=" + length);
        try {
            int count;
            is = HttpUtils.getInstance().openConnectionStream(url);
            for (n2 = 0; n2 < length; n2 += count) {
                count = is.read(buffer, offset + n2, length - n2);
                if (count >= 0) continue;
                int n3 = n2;
                return n3;
            }
            this.position += (long)n2;
            count = n2;
            return count;
        }
        catch (IOException e2) {
            if (e2.getMessage().contains("416") || e2 instanceof EOFException) {
                int n4 = n2;
                return n4;
            }
            throw e2;
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
    }

    @Override
    public void close() throws IOException {
    }

    public byte[] readBytes(long position, int nBytes) throws IOException {
        this.position = position;
        byte[] buffer = new byte[nBytes];
        this.read(buffer, 0, nBytes);
        return buffer;
    }

    @Override
    public int read() throws IOException {
        throw new UnsupportedOperationException("read() is not supported on SeekableServiceStream.  Must read in blocks.");
    }
}

