/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.sam;

import java.util.Arrays;

public class AlignmentBlock {
    private int start;
    private byte[] bases;
    public byte[] qualities;
    private boolean softClipped = false;

    public AlignmentBlock(int start, byte[] bases, byte[] qualities) {
        this.start = start;
        this.bases = bases;
        if (qualities == null || qualities.length < bases.length) {
            this.qualities = new byte[bases.length];
            Arrays.fill(qualities, (byte)126);
        } else {
            this.qualities = qualities;
        }
    }

    public boolean contains(int position) {
        int offset = position - this.start;
        return offset >= 0 && offset < this.bases.length;
    }

    public byte[] getBases() {
        return this.bases;
    }

    public int getStart() {
        return this.start;
    }

    public byte getQuality(int offset) {
        return this.qualities[offset];
    }

    public byte[] getQualities() {
        return this.qualities;
    }

    public int getEnd() {
        return this.start + this.bases.length;
    }

    public boolean isSoftClipped() {
        return this.softClipped;
    }

    public void setSoftClipped(boolean softClipped) {
        this.softClipped = softClipped;
    }
}

