/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.maf;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.broad.igv.maf.MAFTile;
import org.broad.igv.renderer.GraphicUtils;
import org.broad.igv.track.RenderContext;
import org.broad.igv.track.Track;
import org.broad.igv.ui.FontManager;

public class MAFRenderer {
    static Map<Character, Color> nucleotideColors = new HashMap<Character, Color>();

    public void renderGaps(List<MAFTile.Gap> gaps, RenderContext context, Rectangle rect) {
        double origin = context.getOrigin();
        double locScale = context.getScale();
        if (locScale > 1.0) {
            return;
        }
        for (MAFTile.Gap gap : gaps) {
            int pixelPosition = (int)(((double)gap.getPosition() - origin) / locScale);
            Graphics2D g2 = context.getGraphic2DForColor(Color.BLACK);
            g2.drawLine(pixelPosition, rect.y + rect.height - 5, pixelPosition, rect.y + rect.height);
            Rectangle textRect = new Rectangle(rect);
            textRect.x = pixelPosition - 6;
            textRect.width = 12;
            textRect.height = rect.height - 7;
            GraphicUtils.drawCenteredText(String.valueOf(gap.getCount()), textRect, g2);
        }
    }

    public void renderAligment(MAFTile.MASequence alignedSequence, MAFTile.MASequence reference, List<MAFTile.Gap> gaps, RenderContext context, Rectangle trackRectangle, Track track) {
        double origin = context.getOrigin();
        double locScale = context.getScale();
        if (locScale > 1.0) {
            return;
        }
        double pixelStart = ((double)alignedSequence.getStart() - origin) / locScale;
        double pixelEnd = ((double)alignedSequence.getEnd() - origin) / locScale;
        if (pixelEnd >= trackRectangle.getX() && pixelStart <= trackRectangle.getMaxX()) {
            int w = Math.max(1, (int)(pixelEnd - pixelStart));
            int h2 = (int)Math.max(1.0, trackRectangle.getHeight() - 2.0);
            int y = (int)(trackRectangle.getY() + (trackRectangle.getHeight() - (double)h2) / 2.0);
            Rectangle block = new Rectangle((int)pixelStart, y, w, h2);
            if (locScale < 1.0) {
                this.drawBases(context, block, alignedSequence, reference, gaps);
            }
        }
    }

    private void drawBases(RenderContext context, Rectangle rect, MAFTile.MASequence alignment, MAFTile.MASequence ref, List<MAFTile.Gap> gaps) {
        double locScale = context.getScale();
        double origin = context.getOrigin();
        int pY = (int)rect.getY();
        int dY = (int)rect.getHeight();
        int dX = (int)(1.0 / locScale);
        Graphics2D g2 = (Graphics2D)context.getGraphics().create();
        if (dX >= 8) {
            Font f2 = FontManager.getFont(1, Math.min(dX, 12));
            g2.setFont(f2);
        }
        int windowStart = (int)origin - 1;
        int windowEnd = (int)context.getEndLocation() + 1;
        int start = Math.max(windowStart, alignment.getStart());
        int end = Math.min(windowEnd, alignment.getEnd());
        for (int loc = start; loc < end; ++loc) {
            int pX0 = (int)(((double)loc - origin) / locScale);
            int c2 = alignment.getGapAdjustedBase(loc);
            char refBase = ref.getGapAdjustedBase(loc);
            if (c2 == 0 || refBase == '\u0000') continue;
            boolean misMatch = Character.toUpperCase((char)c2) != Character.toUpperCase(refBase);
            int charToDraw = misMatch || ref == alignment ? c2 : 46;
            Color color = nucleotideColors.get(Character.valueOf((char)charToDraw));
            if (dX >= 8 && dY >= 12 || charToDraw == 46) {
                if (charToDraw == 46) {
                    color = Color.LIGHT_GRAY;
                } else if (color == null) {
                    color = Color.black;
                }
                g2.setColor(color);
                this.drawCenteredText(g2, new char[]{charToDraw}, pX0, pY + 2, dX, dY - 2);
                continue;
            }
            if (color == null) continue;
            g2.setColor(color);
            g2.fillRect(pX0, pY, dX - 1, dY);
        }
        if (gaps != null) {
            Graphics2D gapG = context.getGraphic2DForColor(Color.black);
            block1: for (MAFTile.Gap gap : gaps) {
                for (int idx = gap.startIdx; idx < gap.endIdx; ++idx) {
                    if (alignment.bases.charAt(idx) == '-') continue;
                    int pX0 = (int)(((double)gap.getPosition() - origin) / locScale);
                    gapG.drawLine(pX0, pY, pX0, pY + dY);
                    continue block1;
                }
            }
        }
    }

    private void drawCenteredText(Graphics2D g2, char[] chars, int x, int y, int w, int h2) {
        FontMetrics fm = g2.getFontMetrics();
        int msg_width = fm.charsWidth(chars, 0, 1);
        int ascent = fm.getMaxAscent();
        int descent = fm.getMaxDescent();
        int msgX = x + w / 2 - msg_width / 2;
        int msgY = y + h2 / 2 - descent / 2 + ascent / 2;
        g2.drawChars(chars, 0, 1, msgX, msgY);
    }

    static {
        nucleotideColors.put(Character.valueOf('A'), Color.GREEN);
        nucleotideColors.put(Character.valueOf('a'), Color.GREEN);
        nucleotideColors.put(Character.valueOf('C'), Color.BLUE);
        nucleotideColors.put(Character.valueOf('c'), Color.BLUE);
        nucleotideColors.put(Character.valueOf('T'), Color.RED);
        nucleotideColors.put(Character.valueOf('t'), Color.RED);
        nucleotideColors.put(Character.valueOf('G'), new Color(242, 182, 65));
        nucleotideColors.put(Character.valueOf('g'), new Color(242, 182, 65));
        nucleotideColors.put(Character.valueOf('N'), Color.gray);
        nucleotideColors.put(Character.valueOf('n'), Color.gray);
    }
}

