/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.hic.data;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.broad.igv.hic.data.Chromosome;
import org.broad.igv.hic.data.DatasetReader;
import org.broad.igv.hic.data.Matrix;

public class Dataset {
    private boolean caching = true;
    public Chromosome[] chromosomes;
    Map<String, Matrix> matrices = new HashMap<String, Matrix>(625);
    private DatasetReader reader;

    public Dataset(DatasetReader reader) {
        this.reader = reader;
        this.readChromosomes();
    }

    public void readChromosomes() {
    }

    public Matrix getMatrix(Chromosome chr1, Chromosome chr2) {
        int t2;
        int t1 = Math.min(chr1.getIndex(), chr2.getIndex());
        String key = Matrix.generateKey(t1, t2 = Math.max(chr1.getIndex(), chr2.getIndex()));
        Matrix m2 = this.matrices.get(key);
        if (m2 == null && this.reader != null) {
            try {
                m2 = this.reader.readMatrix(key);
                if (this.caching) {
                    this.matrices.put(key, m2);
                }
            }
            catch (IOException e2) {
                e2.printStackTrace();
            }
        }
        return m2;
    }

    public boolean isCaching() {
        return this.caching;
    }

    public void setCaching(boolean caching) {
        this.caching = caching;
    }

    public Chromosome[] getChromosomes() {
        return this.chromosomes;
    }

    public void setChromosomes(Chromosome[] chromosomes) {
        this.chromosomes = chromosomes;
    }
}

