/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.dom.util;

import org.apache.batik.util.XMLConstants;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class XMLSupport
implements XMLConstants {
    private XMLSupport() {
    }

    public static String getXMLLang(Element elt) {
        Attr attr = elt.getAttributeNodeNS("http://www.w3.org/XML/1998/namespace", "lang");
        if (attr != null) {
            return attr.getNodeValue();
        }
        Node n2 = elt.getParentNode();
        while (n2 != null) {
            if (n2.getNodeType() == 1 && (attr = ((Element)n2).getAttributeNodeNS("http://www.w3.org/XML/1998/namespace", "lang")) != null) {
                return attr.getNodeValue();
            }
            n2 = n2.getParentNode();
        }
        return "en";
    }

    public static String getXMLSpace(Element elt) {
        Attr attr = elt.getAttributeNodeNS("http://www.w3.org/XML/1998/namespace", "space");
        if (attr != null) {
            return attr.getNodeValue();
        }
        Node n2 = elt.getParentNode();
        while (n2 != null) {
            if (n2.getNodeType() == 1 && (attr = ((Element)n2).getAttributeNodeNS("http://www.w3.org/XML/1998/namespace", "space")) != null) {
                return attr.getNodeValue();
            }
            n2 = n2.getParentNode();
        }
        return "default";
    }

    public static String defaultXMLSpace(String data) {
        int nChars = data.length();
        StringBuffer result = new StringBuffer(nChars);
        boolean space = false;
        int i2 = 0;
        while (i2 < nChars) {
            char c2 = data.charAt(i2);
            switch (c2) {
                case '\n': 
                case '\r': {
                    space = false;
                    break;
                }
                case '\t': 
                case ' ': {
                    if (space) break;
                    result.append(' ');
                    space = true;
                    break;
                }
                default: {
                    result.append(c2);
                    space = false;
                }
            }
            ++i2;
        }
        return result.toString().trim();
    }

    public static String preserveXMLSpace(String data) {
        int nChars = data.length();
        StringBuffer result = new StringBuffer(nChars);
        int i2 = 0;
        while (i2 < data.length()) {
            char c2 = data.charAt(i2);
            switch (c2) {
                case '\t': 
                case '\n': 
                case '\r': {
                    result.append(' ');
                    break;
                }
                default: {
                    result.append(c2);
                }
            }
            ++i2;
        }
        return result.toString();
    }
}

