/*
 * Decompiled with CFR 0.152.
 */
package com.martiansoftware.jsap;

import com.martiansoftware.jsap.Defaults;
import com.martiansoftware.jsap.Flagged;
import com.martiansoftware.jsap.FlaggedOption;
import com.martiansoftware.jsap.IDMap;
import com.martiansoftware.jsap.IllegalMultipleDeclarationException;
import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.JSAPException;
import com.martiansoftware.jsap.JSAPResult;
import com.martiansoftware.jsap.Option;
import com.martiansoftware.jsap.Parameter;
import com.martiansoftware.jsap.ParseException;
import com.martiansoftware.jsap.QualifiedSwitch;
import com.martiansoftware.jsap.RequiredParameterMissingException;
import com.martiansoftware.jsap.Switch;
import com.martiansoftware.jsap.SyntaxException;
import com.martiansoftware.jsap.UnflaggedOption;
import com.martiansoftware.jsap.UnknownFlagException;
import java.util.Iterator;

class Parser {
    private JSAP config = null;
    private Iterator unflaggedOptions = null;
    private UnflaggedOption curUnflaggedOption = null;
    private String[] args = null;
    private boolean parsed = false;
    private JSAPResult result = null;

    public Parser(JSAP jSAP, String[] stringArray) {
        this.config = jSAP;
        this.args = stringArray;
        this.parsed = false;
        this.result = new JSAPResult();
        this.unflaggedOptions = jSAP.getUnflaggedOptionsIterator();
        this.advanceUnflaggedOption();
    }

    private void advanceUnflaggedOption() {
        this.curUnflaggedOption = this.unflaggedOptions.hasNext() ? (UnflaggedOption)this.unflaggedOptions.next() : null;
    }

    private void processParameter(Parameter parameter, String string) {
        if (this.result.getObject(parameter.getID()) != null && (parameter instanceof FlaggedOption && !((FlaggedOption)parameter).allowMultipleDeclarations() || parameter instanceof Switch || parameter instanceof QualifiedSwitch || parameter instanceof UnflaggedOption && !((UnflaggedOption)parameter).isGreedy())) {
            this.result.addException(parameter.getID(), new IllegalMultipleDeclarationException(parameter.getID()));
        }
        if (parameter instanceof QualifiedSwitch) {
            this.result.registerQualifiedSwitch(parameter.getID(), true);
        }
        try {
            this.result.add(parameter.getID(), parameter.parse(string));
        }
        catch (ParseException parseException) {
            this.result.addException(parameter.getID(), parseException);
        }
    }

    private int parseArg(String[] stringArray, int n2) {
        if (stringArray[n2].startsWith("--") && !stringArray[n2].equals("--")) {
            return this.parseLongForm(stringArray, n2);
        }
        if (stringArray[n2].startsWith("-") && !stringArray[n2].equals("-") && !stringArray[n2].equals("--")) {
            return this.parseShortForm(stringArray, n2);
        }
        return this.parseUnflaggedOption(stringArray, n2);
    }

    private void processDefaults() {
        Defaults defaults = this.config.getDefaults(this.result);
        Iterator iterator = defaults.idIterator();
        while (iterator.hasNext()) {
            String[] stringArray;
            String string = (String)iterator.next();
            if (this.result.getObject(string) != null || (stringArray = defaults.getDefault(string)) == null) continue;
            int n2 = stringArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                this.processParameter(this.config.getByID(string), stringArray[i2]);
            }
        }
    }

    private void enforceRequirements() {
        IDMap iDMap = this.config.getIDMap();
        Iterator iterator = iDMap.idIterator();
        while (iterator.hasNext()) {
            Option option;
            String string = (String)iterator.next();
            Parameter parameter = this.config.getByID(string);
            if (!(parameter instanceof Option) || !(option = (Option)parameter).required() || this.result.getObject(string) != null || this.result.getException(string) != null) continue;
            this.result.addException(option.getID(), new RequiredParameterMissingException(string));
        }
    }

    public JSAPResult parse() {
        if (this.parsed) {
            this.result.addException(null, new JSAPException("This Parser has already run."));
        } else {
            this.result.setValuesFromUser(true);
            this.preregisterQualifiedSwitches();
            int n2 = this.args.length;
            int n3 = 0;
            while (n3 < n2) {
                n3 = this.parseArg(this.args, n3);
            }
            this.result.setValuesFromUser(false);
            this.processDefaults();
            this.enforceRequirements();
            this.parsed = true;
        }
        return this.result;
    }

    private void preregisterQualifiedSwitches() {
        Iterator iterator = this.config.getIDMap().idIterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Parameter parameter = this.config.getByID(string);
            if (!(parameter instanceof QualifiedSwitch)) continue;
            this.result.registerQualifiedSwitch(string, false);
        }
    }

    private int parseLongForm(String[] stringArray, int n2) {
        int n3 = stringArray[n2].indexOf(61);
        int n4 = stringArray[n2].indexOf(58);
        String string = null;
        String string2 = null;
        String string3 = null;
        if (n3 == -1 && n4 == -1) {
            string = stringArray[n2].substring(2);
        }
        if (n3 != -1) {
            string = stringArray[n2].substring(2, n3);
            string2 = stringArray[n2].substring(n3 + 1);
        }
        if (n3 == -1 && n4 != -1) {
            string = stringArray[n2].substring(2, n4);
            string3 = stringArray[n2].substring(n4);
        }
        ++n2;
        Flagged flagged = this.config.getByLongFlag(string);
        Parameter parameter = (Parameter)((Object)flagged);
        if (flagged == null) {
            this.result.addException(null, new UnknownFlagException(string));
        } else if (flagged instanceof Switch) {
            if (n3 != -1) {
                this.result.addException(parameter.getID(), new SyntaxException("Switch \"" + string + "\" does not take any parameters."));
            } else {
                this.processParameter(parameter, null);
            }
        } else if (parameter instanceof QualifiedSwitch) {
            Object var10_10 = null;
            if (n4 == -1) {
                this.processParameter(parameter, null);
            } else {
                this.processParameter(parameter, stringArray[n2 - 1].substring(n4 + 1));
            }
        } else if (n3 == -1) {
            if (n2 >= stringArray.length) {
                this.result.addException(parameter.getID(), new SyntaxException("No value specified for option \"" + string + "\""));
            } else {
                string2 = stringArray[n2];
                ++n2;
                this.processParameter(parameter, string2);
            }
        } else {
            this.processParameter(parameter, string2);
        }
        return n2;
    }

    private int parseShortForm(String[] stringArray, int n2) {
        Character c2 = null;
        int n3 = stringArray[n2].indexOf(61);
        int n4 = stringArray[n2].length();
        if (n3 != -1) {
            n4 = n3;
        }
        for (int i2 = 1; i2 < n4; ++i2) {
            c2 = new Character(stringArray[n2].charAt(i2));
            Flagged flagged = this.config.getByShortFlag(c2);
            Parameter parameter = (Parameter)((Object)flagged);
            if (flagged == null) {
                this.result.addException(null, new UnknownFlagException(c2));
                continue;
            }
            if (flagged instanceof Switch) {
                if (i2 == n3 - 1) {
                    this.result.addException(parameter.getID(), new SyntaxException("Switch \"" + c2 + "\" does not take any parameters."));
                    continue;
                }
                this.processParameter(parameter, null);
                continue;
            }
            if (flagged instanceof QualifiedSwitch) {
                if (stringArray[n2].length() > i2 + 1 && stringArray[n2].charAt(i2 + 1) == ':') {
                    this.processParameter(parameter, stringArray[n2].substring(i2 + 2));
                    break;
                }
                this.processParameter(parameter, null);
                continue;
            }
            String string = null;
            if (n3 != -1) {
                string = stringArray[n2].substring(n3 + 1);
                this.processParameter(parameter, string);
                continue;
            }
            if (i2 < n4 - 1) {
                string = stringArray[n2].substring(i2 + 1, n4);
                this.processParameter(parameter, string);
                break;
            }
            if (++n2 >= stringArray.length) {
                this.result.addException(parameter.getID(), new SyntaxException("No value specified for option \"" + c2 + "\"."));
                continue;
            }
            string = stringArray[n2];
            this.processParameter(parameter, string);
        }
        return ++n2;
    }

    private int parseUnflaggedOption(String[] stringArray, int n2) {
        if (this.curUnflaggedOption != null) {
            this.processParameter(this.curUnflaggedOption, stringArray[n2]);
            if (!this.curUnflaggedOption.isGreedy()) {
                this.advanceUnflaggedOption();
            }
        } else {
            this.result.addException(null, new JSAPException("Unexpected argument: " + stringArray[n2]));
        }
        return n2 + 1;
    }
}

