/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.swing.JideScrollPane;
import com.jidesoft.swing.JideScrollPaneConstants;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.ScrollPaneLayout;
import javax.swing.Scrollable;
import javax.swing.border.Border;

public class JideScrollPaneLayout
extends ScrollPaneLayout
implements JideScrollPaneConstants {
    protected JViewport _rowFoot;
    protected JViewport _colFoot;
    protected Component _hLeft;
    protected Component _hRight;
    protected Component _vTop;
    protected Component _vBottom;

    public void syncWithScrollPane(JScrollPane jScrollPane) {
        super.syncWithScrollPane(jScrollPane);
        if (jScrollPane instanceof JideScrollPane) {
            this._rowFoot = ((JideScrollPane)jScrollPane).getRowFooter();
            this._colFoot = ((JideScrollPane)jScrollPane).getColumnFooter();
            this._hLeft = ((JideScrollPane)jScrollPane).getScrollBarCorner("HORIZONTAL_LEFT");
            this._hRight = ((JideScrollPane)jScrollPane).getScrollBarCorner("HORIZONTAL_RIGHT");
            this._vTop = ((JideScrollPane)jScrollPane).getScrollBarCorner("VERTICAL_TOP");
            this._vBottom = ((JideScrollPane)jScrollPane).getScrollBarCorner("VERTICAL_BOTTOM");
        }
    }

    protected boolean isHsbCoversWholeWidth(JScrollPane jScrollPane) {
        if (jScrollPane instanceof JideScrollPane) {
            return ((JideScrollPane)jScrollPane).isHorizontalScrollBarCoversWholeWidth();
        }
        return false;
    }

    protected boolean isVsbCoversWholeHeight(JScrollPane jScrollPane) {
        if (jScrollPane instanceof JideScrollPane) {
            return ((JideScrollPane)jScrollPane).isVerticalScrollBarCoversWholeHeight();
        }
        return false;
    }

    protected boolean isColumnHeadersHeightUnified(JScrollPane jScrollPane) {
        if (jScrollPane instanceof JideScrollPane) {
            return ((JideScrollPane)jScrollPane).isColumnHeadersHeightUnified();
        }
        return false;
    }

    protected boolean isColumnFootersHeightUnified(JScrollPane jScrollPane) {
        if (jScrollPane instanceof JideScrollPane) {
            return ((JideScrollPane)jScrollPane).isColumnFootersHeightUnified();
        }
        return false;
    }

    public void addLayoutComponent(String string, Component component) {
        if (string.equals("ROW_FOOTER")) {
            this._rowFoot = (JViewport)this.addSingletonComponent(this._rowFoot, component);
        } else if (string.equals("COLUMN_FOOTER")) {
            this._colFoot = (JViewport)this.addSingletonComponent(this._colFoot, component);
        } else if (string.equals("HORIZONTAL_LEFT")) {
            this._hLeft = this.addSingletonComponent(this._hLeft, component);
        } else if (string.equals("HORIZONTAL_RIGHT")) {
            this._hRight = this.addSingletonComponent(this._hRight, component);
        } else if (string.equals("VERTICAL_TOP")) {
            this._vTop = this.addSingletonComponent(this._vTop, component);
        } else if (string.equals("VERTICAL_BOTTOM")) {
            this._vBottom = this.addSingletonComponent(this._vBottom, component);
        } else {
            super.addLayoutComponent(string, component);
        }
    }

    public void removeLayoutComponent(Component component) {
        if (component == this._rowFoot) {
            this._rowFoot = null;
        } else if (component == this._colFoot) {
            this._colFoot = null;
        } else if (component == this._hLeft) {
            this._hLeft = null;
        } else if (component == this._hRight) {
            this._hRight = null;
        } else if (component == this._vTop) {
            this._vTop = null;
        } else if (component == this._vBottom) {
            this._vBottom = null;
        } else {
            super.removeLayoutComponent(component);
        }
    }

    public JViewport getRowFooter() {
        return this._rowFoot;
    }

    public JViewport getColumnFooter() {
        return this._colFoot;
    }

    public Component getScrollBarCorner(String string) {
        if (string.equals("HORIZONTAL_LEFT")) {
            return this._hLeft;
        }
        if (string.equals("HORIZONTAL_RIGHT")) {
            return this._hRight;
        }
        if (string.equals("VERTICAL_BOTTOM")) {
            return this._vBottom;
        }
        if (string.equals("VERTICAL_TOP")) {
            return this._vTop;
        }
        return super.getCorner(string);
    }

    public Dimension preferredLayoutSize(Container container) {
        boolean bl;
        Border border;
        JScrollPane jScrollPane = (JScrollPane)container;
        this.vsbPolicy = jScrollPane.getVerticalScrollBarPolicy();
        this.hsbPolicy = jScrollPane.getHorizontalScrollBarPolicy();
        Insets insets = container.getInsets();
        int n2 = insets.left + insets.right;
        int n3 = insets.top + insets.bottom;
        Dimension dimension = null;
        Dimension dimension2 = null;
        Component component = null;
        if (this.viewport != null) {
            dimension = this.viewport.getPreferredSize();
            dimension2 = this.viewport.getViewSize();
            component = this.viewport.getView();
        }
        if (dimension != null) {
            n2 += dimension.width;
            n3 += dimension.height;
        }
        if ((border = jScrollPane.getViewportBorder()) != null) {
            Insets insets2 = border.getBorderInsets(container);
            n2 += insets2.left + insets2.right;
            n3 += insets2.top + insets2.bottom;
        }
        int n4 = 0;
        if (this.rowHead != null && this.rowHead.isVisible()) {
            n4 = this.rowHead.getPreferredSize().width;
        }
        if (this.upperLeft != null && this.upperLeft.isVisible()) {
            n4 = Math.max(n4, this.upperLeft.getPreferredSize().width);
        }
        if (this.lowerLeft != null && this.lowerLeft.isVisible()) {
            n4 = Math.max(n4, this.lowerLeft.getPreferredSize().width);
        }
        n2 += n4;
        int n5 = this.getUpperHeight();
        n3 += n5;
        if (this._rowFoot != null && this._rowFoot.isVisible()) {
            n2 += this._rowFoot.getPreferredSize().width;
        }
        int n6 = this.getLowerHeight();
        n3 += n6;
        if (this.vsb != null && this.vsbPolicy != 21) {
            if (this.vsbPolicy == 22) {
                n2 += this.vsb.getPreferredSize().width;
            } else if (dimension2 != null && dimension != null) {
                bl = true;
                if (component instanceof Scrollable) {
                    boolean bl2 = bl = !((Scrollable)((Object)component)).getScrollableTracksViewportHeight();
                }
                if (bl && dimension2.height > dimension.height) {
                    n2 += this.vsb.getPreferredSize().width;
                }
            }
        }
        if (this.hsb != null && this.hsbPolicy != 31) {
            if (this.hsbPolicy == 32) {
                n3 += this.hsb.getPreferredSize().height;
            } else if (dimension2 != null && dimension != null) {
                bl = true;
                if (component instanceof Scrollable) {
                    boolean bl3 = bl = !((Scrollable)((Object)component)).getScrollableTracksViewportWidth();
                }
                if (bl && dimension2.width > dimension.width) {
                    n3 += this.hsb.getPreferredSize().height;
                }
            }
        }
        return new Dimension(n2, n3);
    }

    private int getUpperHeight() {
        int n2 = 0;
        if (this.upperLeft != null && this.upperLeft.isVisible()) {
            n2 = this.upperLeft.getPreferredSize().height;
        }
        if (this.upperRight != null && this.upperRight.isVisible()) {
            n2 = Math.max(this.upperRight.getPreferredSize().height, n2);
        }
        if (this.colHead != null && this.colHead.isVisible()) {
            n2 = Math.max(this.colHead.getPreferredSize().height, n2);
        }
        return n2;
    }

    private int getLowerHeight() {
        int n2 = 0;
        if (this.lowerLeft != null && this.lowerLeft.isVisible()) {
            n2 = this.lowerLeft.getPreferredSize().height;
        }
        if (this.lowerRight != null && this.lowerRight.isVisible()) {
            n2 = Math.max(this.lowerRight.getPreferredSize().height, n2);
        }
        if (this._colFoot != null && this._colFoot.isVisible()) {
            n2 = Math.max(this._colFoot.getPreferredSize().height, n2);
        }
        return n2;
    }

    public Dimension minimumLayoutSize(Container container) {
        Dimension dimension;
        Object object;
        JScrollPane jScrollPane = (JScrollPane)container;
        this.vsbPolicy = jScrollPane.getVerticalScrollBarPolicy();
        this.hsbPolicy = jScrollPane.getHorizontalScrollBarPolicy();
        Insets insets = container.getInsets();
        int n2 = insets.left + insets.right;
        int n3 = insets.top + insets.bottom;
        if (this.viewport != null) {
            object = this.viewport.getMinimumSize();
            n2 += ((Dimension)object).width;
            n3 += ((Dimension)object).height;
        }
        if ((object = jScrollPane.getViewportBorder()) != null) {
            Insets insets2 = object.getBorderInsets(container);
            n2 += insets2.left + insets2.right;
            n3 += insets2.top + insets2.bottom;
        }
        int n4 = 0;
        if (this.rowHead != null && this.rowHead.isVisible()) {
            Dimension dimension2 = this.rowHead.getMinimumSize();
            n4 = dimension2.width;
            n3 = Math.max(n3, dimension2.height);
        }
        if (this.upperLeft != null && this.upperLeft.isVisible()) {
            n4 = Math.max(n4, this.upperLeft.getMinimumSize().width);
        }
        if (this.lowerLeft != null && this.lowerLeft.isVisible()) {
            n4 = Math.max(n4, this.lowerLeft.getMinimumSize().width);
        }
        n2 += n4;
        int n5 = 0;
        if (this.upperLeft != null && this.upperLeft.isVisible()) {
            n5 = this.upperLeft.getMinimumSize().height;
        }
        if (this.upperRight != null && this.upperRight.isVisible()) {
            n5 = Math.max(this.upperRight.getMinimumSize().height, n5);
        }
        if (this.colHead != null && this.colHead.isVisible()) {
            Dimension dimension3 = this.colHead.getMinimumSize();
            n2 = Math.max(n2, dimension3.width);
            n5 = Math.max(dimension3.height, n5);
        }
        n3 += n5;
        int n6 = 0;
        if (this.lowerLeft != null && this.lowerLeft.isVisible()) {
            n6 = this.lowerLeft.getMinimumSize().height;
        }
        if (this.lowerRight != null && this.lowerRight.isVisible()) {
            n6 = Math.max(this.lowerRight.getMinimumSize().height, n6);
        }
        if (this._colFoot != null && this._colFoot.isVisible()) {
            dimension = this._colFoot.getMinimumSize();
            n2 = Math.max(n2, dimension.width);
            n6 = Math.max(dimension.height, n6);
        }
        n3 += n6;
        if (this._rowFoot != null && this._rowFoot.isVisible()) {
            dimension = this._rowFoot.getMinimumSize();
            n2 = Math.max(n2, dimension.width);
            n3 += dimension.height;
        }
        if (this.vsb != null && this.vsbPolicy != 21) {
            dimension = this.vsb.getMinimumSize();
            n2 += dimension.width;
            n3 = Math.max(n3, dimension.height);
        }
        if (this.hsb != null && this.hsbPolicy != 31) {
            dimension = this.hsb.getMinimumSize();
            n2 = Math.max(n2, dimension.width);
            n3 += dimension.height;
        }
        return new Dimension(n2, n3);
    }

    public void layoutContainer(Container container) {
        Dimension dimension;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        Scrollable scrollable;
        boolean bl;
        Insets insets;
        Border border;
        JScrollPane jScrollPane = (JScrollPane)container;
        this.vsbPolicy = jScrollPane.getVerticalScrollBarPolicy();
        this.hsbPolicy = jScrollPane.getHorizontalScrollBarPolicy();
        Rectangle rectangle = jScrollPane.getBounds();
        rectangle.y = 0;
        rectangle.x = 0;
        Insets insets2 = container.getInsets();
        rectangle.x = insets2.left;
        rectangle.y = insets2.top;
        rectangle.width -= insets2.left + insets2.right;
        rectangle.height -= insets2.top + insets2.bottom;
        Rectangle rectangle2 = new Rectangle(0, rectangle.y, 0, 0);
        int n7 = this.getUpperHeight();
        if (this.colHead != null && this.colHead.isVisible()) {
            int n8;
            rectangle2.height = n8 = Math.min(rectangle.height, n7);
            rectangle.y += n8;
            rectangle.height -= n8;
        }
        Rectangle rectangle3 = new Rectangle(0, 0, 0, 0);
        if (this.rowHead != null && this.rowHead.isVisible()) {
            int n9 = this.rowHead.getPreferredSize().width;
            if (this.upperLeft != null && this.upperLeft.isVisible()) {
                n9 = Math.max(n9, this.upperLeft.getPreferredSize().width);
            }
            if (this.lowerLeft != null && this.lowerLeft.isVisible()) {
                n9 = Math.max(n9, this.lowerLeft.getPreferredSize().width);
            }
            rectangle3.width = n9;
            rectangle.width -= n9;
            rectangle3.x = rectangle.x;
            rectangle.x += n9;
        }
        if ((border = jScrollPane.getViewportBorder()) != null) {
            insets = border.getBorderInsets(container);
            rectangle.x += insets.left;
            rectangle.y += insets.top;
            rectangle.width -= insets.left + insets.right;
            rectangle.height -= insets.top + insets.bottom;
        } else {
            insets = new Insets(0, 0, 0, 0);
        }
        Rectangle rectangle4 = new Rectangle(0, 0, 0, 0);
        if (this._rowFoot != null && this._rowFoot.isVisible()) {
            int n10 = this._rowFoot.getPreferredSize().width;
            if (this.upperRight != null && this.upperRight.isVisible()) {
                n10 = Math.max(n10, this.upperRight.getPreferredSize().width);
            }
            if (this.lowerRight != null && this.lowerRight.isVisible()) {
                n10 = Math.max(n10, this.lowerRight.getPreferredSize().width);
            }
            rectangle4.width = n10;
            rectangle.width -= n10;
            rectangle4.x = rectangle.x + rectangle.width;
        }
        Rectangle rectangle5 = new Rectangle(0, rectangle.y, 0, 0);
        int n11 = this.getLowerHeight();
        if (this._colFoot != null && this._colFoot.isVisible()) {
            int n12;
            rectangle5.height = n12 = Math.min(rectangle.height, n11);
            rectangle.height -= n12;
            rectangle5.y = rectangle.y + rectangle.height;
        }
        Component component = this.viewport != null ? this.viewport.getView() : null;
        Dimension dimension2 = component != null ? component.getPreferredSize() : new Dimension(0, 0);
        Dimension dimension3 = this.viewport != null ? this.viewport.toViewCoordinates(rectangle.getSize()) : new Dimension(0, 0);
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = bl = rectangle.width < 0 || rectangle.height < 0;
        if (!bl && component instanceof Scrollable) {
            scrollable = (Scrollable)((Object)component);
            bl2 = scrollable.getScrollableTracksViewportWidth();
            bl3 = scrollable.getScrollableTracksViewportHeight();
        } else {
            scrollable = null;
        }
        Rectangle rectangle6 = new Rectangle(0, this.isVsbCoversWholeHeight(jScrollPane) ? insets2.top : rectangle.y - insets.top, 0, 0);
        if (this.vsbPolicy == 22) {
            n6 = 1;
        } else if (this.vsbPolicy == 21) {
            n6 = 0;
        } else if (bl) {
            n6 = 0;
        } else {
            int n13 = n6 = !bl3 && (dimension2.height > dimension3.height || this.rowHead != null && this.rowHead.getView() != null && this.rowHead.getView().getPreferredSize().height > dimension3.height) ? 1 : 0;
        }
        if (this.vsb != null && n6 != 0) {
            this.adjustForVSB(true, rectangle, rectangle6, insets, true);
            dimension3 = this.viewport.toViewCoordinates(rectangle.getSize());
        }
        Rectangle rectangle7 = new Rectangle(this.isHsbCoversWholeWidth(jScrollPane) ? insets2.left : rectangle.x - insets.left, 0, 0, 0);
        if (this.hsbPolicy == 32) {
            n5 = 1;
        } else if (this.hsbPolicy == 31) {
            n5 = 0;
        } else if (bl) {
            n5 = 0;
        } else {
            int n14 = n5 = !bl2 && (dimension2.width > dimension3.width || this.colHead != null && this.colHead.getView() != null && this.colHead.getView().getPreferredSize().width > dimension3.width) ? 1 : 0;
        }
        if (this.hsb != null && n5 != 0) {
            this.adjustForHSB(true, rectangle, rectangle7, insets);
            if (this.vsb != null && n6 == 0 && this.vsbPolicy != 21) {
                dimension3 = this.viewport.toViewCoordinates(rectangle.getSize());
                int n15 = n6 = dimension2.height > dimension3.height ? 1 : 0;
                if (n6 != 0) {
                    this.adjustForVSB(true, rectangle, rectangle6, insets, true);
                }
            }
        }
        boolean bl5 = jScrollPane.getComponentOrientation().isLeftToRight();
        if (this.viewport != null) {
            this.viewport.setBounds(this.adjustBounds(container, rectangle, bl5));
            if (scrollable != null) {
                dimension3 = this.viewport.toViewCoordinates(rectangle.getSize());
                n4 = n5;
                n3 = n6;
                bl2 = scrollable.getScrollableTracksViewportWidth();
                bl3 = scrollable.getScrollableTracksViewportHeight();
                if (this.vsb != null && this.vsbPolicy == 20) {
                    int n16 = n2 = !bl3 && (dimension2.height > dimension3.height || this.rowHead != null && this.rowHead.getView() != null && this.rowHead.getView().getPreferredSize().height > dimension3.height) ? 1 : 0;
                    if (n2 != n6) {
                        n6 = n2;
                        this.adjustForVSB(n6 != 0, rectangle, rectangle6, insets, true);
                        dimension3 = this.viewport.toViewCoordinates(rectangle.getSize());
                    }
                }
                if (this.hsb != null && this.hsbPolicy == 30) {
                    int n17 = n2 = !bl2 && (dimension2.width > dimension3.width || this.colHead != null && this.colHead.getView() != null && this.colHead.getView().getPreferredSize().width > dimension3.width) ? 1 : 0;
                    if (n2 != n5) {
                        n5 = n2;
                        this.adjustForHSB(n5 != 0, rectangle, rectangle7, insets);
                        if (this.vsb != null && n6 == 0 && this.vsbPolicy != 21) {
                            dimension3 = this.viewport.toViewCoordinates(rectangle.getSize());
                            int n18 = n6 = dimension2.height > dimension3.height ? 1 : 0;
                            if (n6 != 0) {
                                this.adjustForVSB(true, rectangle, rectangle6, insets, true);
                            }
                        }
                        if (this._rowFoot != null && this._rowFoot.isVisible()) {
                            rectangle6.x += rectangle4.width;
                        }
                    }
                }
                if (n4 != n5 || n3 != n6) {
                    this.viewport.setBounds(this.adjustBounds(container, rectangle, bl5));
                }
            }
        }
        rectangle6.height = this.isVsbCoversWholeHeight(jScrollPane) ? jScrollPane.getHeight() - insets2.bottom - insets2.top : rectangle.height + insets.top + insets.bottom;
        rectangle7.width = this.isHsbCoversWholeWidth(jScrollPane) ? jScrollPane.getWidth() - rectangle6.width - insets2.left - insets2.right : rectangle.width + insets.left + insets.right;
        rectangle3.height = rectangle.height + insets.top + insets.bottom;
        rectangle3.y = rectangle.y - insets.top;
        rectangle2.width = rectangle.width + insets.left + insets.right;
        rectangle2.x = rectangle.x - insets.left;
        rectangle5.x = rectangle.x;
        rectangle5.y = rectangle3.y + rectangle3.height;
        rectangle5.width = rectangle.width;
        rectangle4.x = rectangle.x + rectangle.width;
        rectangle4.y = rectangle.y;
        rectangle4.height = rectangle.height;
        rectangle6.x += rectangle4.width;
        rectangle7.y += rectangle5.height;
        if (this.rowHead != null) {
            this.rowHead.setBounds(this.adjustBounds(container, rectangle3, bl5));
        }
        if (this._rowFoot != null) {
            this._rowFoot.setBounds(this.adjustBounds(container, rectangle4, bl5));
        }
        int n19 = this.isColumnHeadersHeightUnified(jScrollPane) ? Math.max(rectangle2.height, Math.max(this.upperLeft == null ? 0 : this.upperLeft.getPreferredSize().height, this.upperRight == null ? 0 : this.upperRight.getPreferredSize().height)) : (n4 = 0);
        int n20 = this.isColumnFootersHeightUnified(jScrollPane) ? Math.max(rectangle5.height, Math.max(this.lowerLeft == null ? 0 : this.lowerLeft.getPreferredSize().height, this.lowerRight == null ? 0 : this.lowerRight.getPreferredSize().height)) : (n3 = 0);
        if (this.colHead != null) {
            n2 = this.isColumnHeadersHeightUnified(jScrollPane) ? n4 : Math.min(rectangle2.height, this.colHead.getPreferredSize().height);
            this.colHead.setBounds(this.adjustBounds(container, new Rectangle(rectangle2.x, rectangle2.y + rectangle2.height - n2, rectangle2.width, n2), bl5));
        }
        if (this._colFoot != null) {
            n2 = this.isColumnFootersHeightUnified(jScrollPane) ? n3 : Math.min(rectangle5.height, this._colFoot.getPreferredSize().height);
            this._colFoot.setBounds(this.adjustBounds(container, new Rectangle(rectangle5.x, rectangle5.y, rectangle5.width, n2), bl5));
        } else if (this.isColumnFootersHeightUnified(jScrollPane)) {
            n3 = rectangle7.height;
        }
        if (this.vsb != null) {
            if (n6 != 0) {
                this.vsb.setVisible(true);
                if (this._vTop == null && this._vBottom == null) {
                    this.vsb.setBounds(this.adjustBounds(container, rectangle6, bl5));
                } else {
                    Rectangle rectangle8 = new Rectangle(rectangle6);
                    if (this._vTop != null) {
                        dimension = this._vTop.getPreferredSize();
                        rectangle8.y += dimension.height;
                        rectangle8.height -= dimension.height;
                        this._vTop.setVisible(true);
                        this._vTop.setBounds(this.adjustBounds(container, new Rectangle(rectangle6.x, rectangle6.y, rectangle6.width, dimension.height), bl5));
                    }
                    if (this._vBottom != null) {
                        dimension = this._vBottom.getPreferredSize();
                        rectangle8.height -= dimension.height;
                        this._vBottom.setVisible(true);
                        this._vBottom.setBounds(this.adjustBounds(container, new Rectangle(rectangle6.x, rectangle6.y + rectangle6.height - dimension.height, rectangle6.width, dimension.height), bl5));
                    }
                    this.vsb.setBounds(this.adjustBounds(container, rectangle8, bl5));
                }
            } else {
                if (dimension2.height > dimension3.height) {
                    this.vsb.setVisible(true);
                    this.vsb.setBounds(this.adjustBounds(container, new Rectangle(rectangle6.x, rectangle6.y, 0, rectangle6.height), bl5));
                } else {
                    this.vsb.setVisible(false);
                }
                if (this._vTop != null) {
                    this._vTop.setVisible(false);
                }
                if (this._vBottom != null) {
                    this._vBottom.setVisible(false);
                }
            }
        }
        if (this.hsb != null) {
            if (n5 != 0) {
                this.hsb.setVisible(true);
                if (this._hLeft == null && this._hRight == null) {
                    this.hsb.setBounds(this.adjustBounds(container, rectangle7, bl5));
                } else {
                    Rectangle rectangle9 = new Rectangle(rectangle7);
                    if (this._hLeft != null) {
                        dimension = this._hLeft.getPreferredSize();
                        rectangle9.x += dimension.width;
                        rectangle9.width -= dimension.width;
                        this._hLeft.setVisible(true);
                        this._hLeft.setBounds(this.adjustBounds(container, new Rectangle(rectangle7.x, rectangle7.y, dimension.width, rectangle7.height), bl5));
                        this._hLeft.doLayout();
                    }
                    if (this._hRight != null) {
                        dimension = this._hRight.getPreferredSize();
                        rectangle9.width -= dimension.width;
                        this._hRight.setVisible(true);
                        this._hRight.setBounds(this.adjustBounds(container, new Rectangle(rectangle7.x + rectangle7.width - dimension.width, rectangle7.y, dimension.width, rectangle7.height), bl5));
                    }
                    this.hsb.setBounds(this.adjustBounds(container, rectangle9, bl5));
                }
            } else {
                if (dimension2.width > dimension3.width) {
                    this.hsb.setVisible(true);
                    this.hsb.setBounds(this.adjustBounds(container, new Rectangle(rectangle7.x, rectangle7.y, rectangle7.width, 0), bl5));
                } else {
                    this.hsb.setVisible(false);
                }
                if (this._hLeft != null) {
                    this._hLeft.setVisible(false);
                }
                if (this._hRight != null) {
                    this._hRight.setVisible(false);
                }
            }
        }
        if (this.lowerLeft != null && this.lowerLeft.isVisible()) {
            int n21 = this.isColumnFootersHeightUnified(jScrollPane) ? n3 : Math.min(this.lowerLeft.getPreferredSize().height, rectangle5.height);
            this.lowerLeft.setBounds(this.adjustBounds(container, new Rectangle(rectangle3.x, rectangle5.y != 0 ? rectangle5.y : rectangle7.y, rectangle3.width, n21), bl5));
        }
        if (this.lowerRight != null && this.lowerRight.isVisible()) {
            int n22 = this.isColumnFootersHeightUnified(jScrollPane) ? n3 : Math.min(this.lowerRight.getPreferredSize().height, rectangle5.height);
            this.lowerRight.setBounds(this.adjustBounds(container, new Rectangle(rectangle4.x, rectangle5.y != 0 ? rectangle5.y : rectangle7.y, rectangle4.width + (this.isVsbCoversWholeHeight(jScrollPane) ? 0 : rectangle6.width), n22), bl5));
        }
        if (this.upperLeft != null && this.upperLeft.isVisible()) {
            int n23 = this.isColumnHeadersHeightUnified(jScrollPane) ? n4 : Math.min(this.upperLeft.getPreferredSize().height, rectangle2.height);
            this.upperLeft.setBounds(this.adjustBounds(container, new Rectangle(rectangle3.x, rectangle2.y + rectangle2.height - n23, rectangle3.width, n23), bl5));
        }
        if (this.upperRight != null && this.upperRight.isVisible()) {
            int n24 = this.isColumnHeadersHeightUnified(jScrollPane) ? n4 : Math.min(this.upperRight.getPreferredSize().height, rectangle2.height);
            this.upperRight.setBounds(this.adjustBounds(container, new Rectangle(rectangle4.x, rectangle2.y + rectangle2.height - n24, rectangle4.width + (this.isVsbCoversWholeHeight(jScrollPane) ? 0 : rectangle6.width), n24), bl5));
        }
    }

    private Rectangle adjustBounds(Container container, Rectangle rectangle, boolean bl) {
        if (bl) {
            return rectangle;
        }
        Rectangle rectangle2 = new Rectangle(rectangle);
        int n2 = container.getWidth();
        rectangle2.x = n2 - (rectangle.x + rectangle.width);
        return rectangle2;
    }

    private void adjustForVSB(boolean bl, Rectangle rectangle, Rectangle rectangle2, Insets insets, boolean bl2) {
        int n2 = rectangle2.width;
        if (bl) {
            int n3 = Math.max(0, this.vsb.getPreferredSize().width);
            rectangle.width -= n3;
            rectangle2.width = n3;
            if (bl2) {
                rectangle2.x = rectangle.x + rectangle.width + insets.right;
            } else {
                rectangle2.x = rectangle.x - insets.left;
                rectangle.x += n3;
            }
        } else {
            rectangle.width += n2;
        }
    }

    private void adjustForHSB(boolean bl, Rectangle rectangle, Rectangle rectangle2, Insets insets) {
        int n2 = rectangle2.height;
        if (bl) {
            int n3 = Math.max(0, this.hsb.getPreferredSize().height);
            rectangle.height -= n3;
            rectangle2.y = rectangle.y + rectangle.height + insets.bottom;
            rectangle2.height = n3;
        } else {
            rectangle.height += n2;
        }
    }

    static class UIResource
    extends JideScrollPaneLayout
    implements javax.swing.plaf.UIResource {
        UIResource() {
        }
    }
}

