/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.plaf.basic;

import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.swing.StyleRange;
import com.jidesoft.swing.StyledLabel;
import com.sun.java.swing.plaf.windows.WindowsLookAndFeel;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.SwingConstants;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicLabelUI;
import javax.swing.text.View;

public class BasicStyledLabelUI
extends BasicLabelUI
implements SwingConstants {
    public static Comparator<StyleRange> _comparator;
    protected static BasicStyledLabelUI styledLabelUI;
    private List<StyledText> _styledTexts;

    public static ComponentUI createUI(JComponent jComponent) {
        return styledLabelUI;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        super.propertyChange(propertyChangeEvent);
        if ("styleRange".equals(propertyChangeEvent.getPropertyName())) {
            this._styledTexts = null;
            if (propertyChangeEvent.getSource() instanceof StyledLabel) {
                ((StyledLabel)propertyChangeEvent.getSource()).revalidate();
                ((StyledLabel)propertyChangeEvent.getSource()).repaint();
            }
        } else if ("ignoreColorSettings".equals(propertyChangeEvent.getPropertyName()) && propertyChangeEvent.getSource() instanceof StyledLabel) {
            ((StyledLabel)propertyChangeEvent.getSource()).repaint();
        }
    }

    protected void paintEnabledText(JLabel jLabel, Graphics graphics, String string, int n2, int n3) {
        View view;
        View view2 = view = jLabel != null ? (View)jLabel.getClientProperty("html") : null;
        if (view != null) {
            super.paintEnabledText(jLabel, graphics, string, n2, n3);
        } else {
            this.paintStyledText((StyledLabel)jLabel, graphics, n2, n3);
        }
    }

    protected void paintDisabledText(JLabel jLabel, Graphics graphics, String string, int n2, int n3) {
        View view;
        View view2 = view = jLabel != null ? (View)jLabel.getClientProperty("html") : null;
        if (view != null) {
            super.paintDisabledText(jLabel, graphics, string, n2, n3);
        } else {
            this.paintStyledText((StyledLabel)jLabel, graphics, n2, n3);
        }
    }

    protected void buildStyledText(StyledLabel styledLabel) {
        if (this._styledTexts == null) {
            this._styledTexts = new ArrayList<StyledText>();
        } else {
            this._styledTexts.clear();
        }
        StyleRange[] styleRangeArray = styledLabel.getStyleRanges();
        if (_comparator == null) {
            _comparator = new Comparator<StyleRange>(){

                @Override
                public int compare(StyleRange styleRange, StyleRange styleRange2) {
                    if (styleRange.getStart() < styleRange2.getStart()) {
                        return -1;
                    }
                    if (styleRange.getStart() > styleRange2.getStart()) {
                        return 1;
                    }
                    return 0;
                }
            };
        }
        Arrays.sort(styleRangeArray, _comparator);
        String string = styledLabel.getText();
        if (string != null && string.length() > 0) {
            int n2 = 0;
            for (StyleRange styleRange : styleRangeArray) {
                if (styleRange.getStart() > n2) {
                    this._styledTexts.add(new StyledText(string.substring(n2, styleRange.getStart())));
                    n2 = styleRange.getStart();
                }
                if (styleRange.getStart() == n2) {
                    if (styleRange.getLength() == -1) {
                        this._styledTexts.add(new StyledText(string.substring(n2), styleRange));
                        n2 = string.length();
                        continue;
                    }
                    this._styledTexts.add(new StyledText(string.substring(n2, n2 + styleRange.getLength()), styleRange));
                    n2 += styleRange.getLength();
                    continue;
                }
                if (styleRange.getStart() >= n2) continue;
            }
            if (n2 < string.length()) {
                this._styledTexts.add(new StyledText(string.substring(n2, string.length())));
            }
        }
    }

    protected String layoutCL(JLabel jLabel, FontMetrics fontMetrics, String string, Icon icon, Rectangle rectangle, Rectangle rectangle2, Rectangle rectangle3) {
        Dimension dimension = this.getPreferredSize((StyledLabel)jLabel);
        rectangle3.width = dimension.width;
        rectangle3.height = dimension.height;
        return BasicStyledLabelUI.layoutCompoundLabel(jLabel, fontMetrics, string, icon, jLabel.getVerticalAlignment(), jLabel.getHorizontalAlignment(), jLabel.getVerticalTextPosition(), jLabel.getHorizontalTextPosition(), rectangle, rectangle2, rectangle3, jLabel.getIconTextGap());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Dimension getPreferredSize(StyledLabel styledLabel) {
        this.buildStyledText(styledLabel);
        int n2 = 0;
        Font font = this.getFont(styledLabel);
        FontMetrics fontMetrics = styledLabel.getFontMetrics(font);
        int n3 = 0;
        int n4 = font.getSize();
        List<StyledText> list = this._styledTexts;
        synchronized (list) {
            StyledText[] styledTextArray = this._styledTexts.toArray(new StyledText[this._styledTexts.size()]);
            for (int i2 = styledTextArray.length - 1; i2 >= 0; --i2) {
                FontMetrics fontMetrics2;
                StyledText styledText = styledTextArray[i2];
                StyleRange styleRange = styledText.styleRange;
                float f2 = styleRange != null && (styleRange.isSuperscript() || styleRange.isSubscript()) ? (float)Math.round((float)n4 / styleRange.getFontShrinkRatio()) : (float)n4;
                font = this.getFont(styledLabel);
                if (styleRange != null && (styleRange.getFontStyle() != -1 && font.getStyle() != styleRange.getFontStyle() || (float)font.getSize() != f2)) {
                    font = font.deriveFont(styleRange.getFontStyle() == -1 ? font.getStyle() : styleRange.getFontStyle(), f2);
                    fontMetrics2 = styledLabel.getFontMetrics(font);
                    n2 += fontMetrics2.stringWidth(styledText.text);
                } else {
                    fontMetrics2 = fontMetrics;
                    n2 += fontMetrics.stringWidth(styledText.text);
                }
                if (styleRange == null) continue;
                if (styleRange.isUnderlined() && n3 < 2) {
                    n3 = 2;
                }
                if (styleRange.isDotted() && n3 < 3) {
                    n3 = 3;
                }
                if (!styleRange.isWaved() || n3 >= 4) continue;
                n3 = 4;
            }
        }
        int n5 = fontMetrics.getHeight();
        return new Dimension(n2, n5 + n3);
    }

    protected Font getFont(StyledLabel styledLabel) {
        Font font = styledLabel.getFont();
        if (font == null) {
            font = UIDefaultsLookup.getFont("Label.font");
        }
        return font;
    }

    protected void paintStyledText(StyledLabel styledLabel, Graphics graphics, int n2, int n3) {
        int n4 = n2 < styledLabel.getInsets().left ? styledLabel.getInsets().left : n2;
        int n5 = styledLabel.getDisplayedMnemonicIndex();
        if (UIManager.getLookAndFeel() instanceof WindowsLookAndFeel && WindowsLookAndFeel.isMnemonicHidden()) {
            n5 = -1;
        }
        this.buildStyledText(styledLabel);
        Color color = graphics.getColor();
        int n6 = 0;
        boolean bl = false;
        int n7 = 0;
        Font font = this.getFont(styledLabel);
        FontMetrics fontMetrics = styledLabel.getFontMetrics(font);
        int n8 = font.getSize();
        for (StyledText styledText : this._styledTexts) {
            Color color2;
            FontMetrics fontMetrics2;
            StyleRange styleRange = styledText.styleRange;
            if (styledText.text.length() > n5 - n6) {
                bl = true;
                n7 = n5 - n6;
            }
            n6 += styledText.text.length();
            int n9 = n3;
            float f2 = styleRange != null && (styleRange.isSuperscript() || styleRange.isSubscript()) ? (float)Math.round((float)n8 / styleRange.getFontShrinkRatio()) : (float)n8;
            font = this.getFont(styledLabel);
            if (styleRange != null && (styleRange.getFontStyle() != -1 && font.getStyle() != styleRange.getFontStyle() || (float)font.getSize() != f2)) {
                font = font.deriveFont(styleRange.getFontStyle() == -1 ? font.getStyle() : styleRange.getFontStyle(), f2);
                fontMetrics2 = styledLabel.getFontMetrics(font);
            } else {
                fontMetrics2 = fontMetrics;
            }
            graphics.setFont(font);
            String string = styledText.text;
            int n10 = fontMetrics2.stringWidth(string);
            boolean bl2 = false;
            int n11 = styledLabel.getWidth() - n4;
            if (n11 < n10) {
                string = SwingUtilities.layoutCompoundLabel(styledLabel, fontMetrics2, string, null, styledLabel.getVerticalAlignment(), styledLabel.getHorizontalAlignment(), styledLabel.getVerticalTextPosition(), styledLabel.getHorizontalTextPosition(), new Rectangle(n4, n9, n11, styledLabel.getHeight()), new Rectangle(), new Rectangle(), 0);
                n10 = fontMetrics2.stringWidth(string);
                bl2 = true;
            }
            if (styleRange != null && styleRange.isSuperscript()) {
                n9 -= fontMetrics.getHeight() - fontMetrics2.getHeight();
            }
            if (styleRange != null && styleRange.getBackgroundColor() != null) {
                graphics.setColor(styleRange.getBackgroundColor());
                graphics.fillRect(n4, n9 - fontMetrics2.getHeight(), n10, fontMetrics2.getHeight() + 4);
            }
            Color color3 = color2 = styleRange != null && !styledLabel.isIgnoreColorSettings() && styleRange.getFontColor() != null ? styleRange.getFontColor() : styledLabel.getForeground();
            if (!styledLabel.isEnabled()) {
                color2 = UIDefaultsLookup.getColor("Label.disabledForeground");
            }
            graphics.setColor(color2);
            if (bl) {
                JideSwingUtilities.drawStringUnderlineCharAt(styledLabel, graphics, string, n7, n4, n9);
            } else {
                JideSwingUtilities.drawString(styledLabel, graphics, string, n4, n9);
            }
            if (styleRange != null) {
                int n12;
                int n13;
                Stroke stroke = ((Graphics2D)graphics).getStroke();
                if (styleRange.getLineStroke() != null) {
                    ((Graphics2D)graphics).setStroke(styleRange.getLineStroke());
                }
                if (!styledLabel.isIgnoreColorSettings() && styleRange.getLineColor() != null) {
                    graphics.setColor(styleRange.getLineColor());
                }
                if (styleRange.isStrikethrough()) {
                    n13 = n9 + (fontMetrics2.getDescent() - fontMetrics2.getAscent()) / 2;
                    graphics.drawLine(n4, n13, n4 + n10 - 1, n13);
                }
                if (styleRange.isDoublestrikethrough()) {
                    n13 = n9 + (fontMetrics2.getDescent() - fontMetrics2.getAscent()) / 2;
                    graphics.drawLine(n4, n13 - 1, n4 + n10 - 1, n13 - 1);
                    graphics.drawLine(n4, n13 + 1, n4 + n10 - 1, n13 + 1);
                }
                if (styleRange.isUnderlined()) {
                    n13 = n9 + 1;
                    graphics.drawLine(n4, n13, n4 + n10 - 1, n13);
                }
                if (styleRange.isDotted()) {
                    n13 = n9 + 1;
                    for (n12 = n4; n12 < n4 + n10; n12 += 4) {
                        graphics.drawRect(n12, n13, 1, 1);
                    }
                }
                if (styleRange.isWaved()) {
                    n13 = n9 + 1;
                    for (n12 = n4; n12 < n4 + n10; n12 += 4) {
                        if (n12 + 2 <= n4 + n10 - 1) {
                            graphics.drawLine(n12, n13 + 2, n12 + 2, n13);
                        }
                        if (n12 + 4 > n4 + n10 - 1) continue;
                        graphics.drawLine(n12 + 3, n13 + 1, n12 + 4, n13 + 2);
                    }
                }
                if (styleRange.getLineStroke() != null) {
                    ((Graphics2D)graphics).setStroke(stroke);
                }
            }
            if (bl2) break;
            n4 += n10;
        }
        graphics.setColor(color);
    }

    public static String layoutCompoundLabel(JComponent jComponent, FontMetrics fontMetrics, String string, Icon icon, int n2, int n3, int n4, int n5, Rectangle rectangle, Rectangle rectangle2, Rectangle rectangle3, int n6) {
        boolean bl = true;
        int n7 = n3;
        int n8 = n5;
        if (jComponent != null && !jComponent.getComponentOrientation().isLeftToRight()) {
            bl = false;
        }
        switch (n3) {
            case 10: {
                n7 = bl ? 2 : 4;
                break;
            }
            case 11: {
                n7 = bl ? 4 : 2;
            }
        }
        switch (n5) {
            case 10: {
                n8 = bl ? 2 : 4;
                break;
            }
            case 11: {
                n8 = bl ? 4 : 2;
            }
        }
        return BasicStyledLabelUI.layoutCompoundLabelImpl(jComponent, fontMetrics, string, icon, n2, n7, n4, n8, rectangle, rectangle2, rectangle3, n6);
    }

    public static String layoutCompoundLabel(FontMetrics fontMetrics, String string, Icon icon, int n2, int n3, int n4, int n5, Rectangle rectangle, Rectangle rectangle2, Rectangle rectangle3, int n6) {
        return BasicStyledLabelUI.layoutCompoundLabelImpl(null, fontMetrics, string, icon, n2, n3, n4, n5, rectangle, rectangle2, rectangle3, n6);
    }

    private static String layoutCompoundLabelImpl(JComponent jComponent, FontMetrics fontMetrics, String string, Icon icon, int n2, int n3, int n4, int n5, Rectangle rectangle, Rectangle rectangle2, Rectangle rectangle3, int n6) {
        int n7;
        int n8;
        if (icon != null) {
            rectangle2.width = icon.getIconWidth();
            rectangle2.height = icon.getIconHeight();
        } else {
            rectangle2.height = 0;
            rectangle2.width = 0;
        }
        boolean bl = string == null || string.equals("");
        int n9 = 0;
        View view = null;
        if (bl) {
            rectangle3.height = 0;
            rectangle3.width = 0;
            string = "";
            n8 = 0;
        } else {
            n8 = icon == null ? 0 : n6;
            n7 = n5 == 0 ? rectangle.width : rectangle.width - (rectangle2.width + n8);
            View view2 = view = jComponent != null ? (View)jComponent.getClientProperty("html") : null;
            if (view != null) {
                rectangle3.width = Math.min(n7, (int)view.getPreferredSpan(0));
                rectangle3.height = (int)view.getPreferredSpan(1);
            }
        }
        rectangle3.y = n4 == 1 ? (n5 != 0 ? 0 : -(rectangle3.height + n8)) : (n4 == 0 ? rectangle2.height / 2 - rectangle3.height / 2 : (n5 != 0 ? rectangle2.height - rectangle3.height : rectangle2.height + n8));
        rectangle3.x = n5 == 2 ? -(rectangle3.width + n8) : (n5 == 0 ? rectangle2.width / 2 - rectangle3.width / 2 : rectangle2.width + n8);
        n7 = Math.min(rectangle2.x, rectangle3.x);
        int n10 = Math.max(rectangle2.x + rectangle2.width, rectangle3.x + rectangle3.width) - n7;
        int n11 = Math.min(rectangle2.y, rectangle3.y);
        int n12 = Math.max(rectangle2.y + rectangle2.height, rectangle3.y + rectangle3.height) - n11;
        int n13 = n2 == 1 ? rectangle.y - n11 : (n2 == 0 ? rectangle.y + rectangle.height / 2 - (n11 + n12 / 2) : rectangle.y + rectangle.height - (n11 + n12));
        int n14 = n3 == 2 ? rectangle.x - n7 : (n3 == 4 ? rectangle.x + rectangle.width - (n7 + n10) : rectangle.x + rectangle.width / 2 - (n7 + n10 / 2));
        rectangle3.x += n14;
        rectangle3.y += n13;
        rectangle2.x += n14;
        rectangle2.y += n13;
        if (n9 < 0) {
            rectangle3.x -= n9;
        }
        return string;
    }

    static {
        styledLabelUI = new BasicStyledLabelUI();
    }

    class StyledText {
        StyleRange styleRange;
        String text;

        public StyledText(String string) {
            this.text = string;
        }

        public StyledText(String string, StyleRange styleRange) {
            this.text = string;
            this.styleRange = styleRange;
        }
    }
}

