/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.hic.tools;

import java.io.BufferedReader;
import java.io.IOException;
import org.broad.igv.hic.tools.AlignmentPair;
import org.broad.igv.hic.tools.PairIterator;
import org.broad.tribble.util.ParsingUtils;

public class AsciiPairIterator
implements PairIterator {
    AlignmentPair nextPair = null;
    BufferedReader reader;

    public AsciiPairIterator(String path) throws IOException {
        this.reader = ParsingUtils.openBufferedReader(path);
        this.advance();
    }

    private void advance() {
        try {
            String nextLine;
            while ((nextLine = this.reader.readLine()) != null) {
                String[] tokens = nextLine.split("\\s+");
                int nTokens = tokens.length;
                if (nTokens > 9) continue;
                String chrom1 = tokens[1];
                String chrom2 = tokens[5];
                int pos1 = Integer.parseInt(tokens[2]);
                int pos2 = Integer.parseInt(tokens[6]);
                this.nextPair = new AlignmentPair(chrom1, pos1, chrom2, pos2);
                return;
            }
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
        this.nextPair = null;
    }

    @Override
    public boolean hasNext() {
        return this.nextPair != null;
    }

    @Override
    public AlignmentPair next() {
        AlignmentPair p2 = this.nextPair;
        this.advance();
        return p2;
    }

    @Override
    public void remove() {
    }

    @Override
    public void close() {
        try {
            this.reader.close();
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
    }
}

