/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.hic;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.io.Serializable;
import java.text.DecimalFormat;
import javax.swing.JPanel;
import org.apache.log4j.Logger;
import org.broad.igv.hic.Context;
import org.broad.igv.hic.MainWindow;
import org.broad.igv.hic.data.Chromosome;
import org.broad.igv.ui.FontManager;

public class HiCRulerPanel
extends JPanel
implements Serializable {
    private static Logger log = Logger.getLogger(HiCRulerPanel.class);
    private MainWindow mainWindow;
    private Orientation orientation;
    private Font tickFont = FontManager.getFont(1, 9);
    private Font spanFont = FontManager.getFont(1, 12);
    Context frame;

    public HiCRulerPanel() {
    }

    public HiCRulerPanel(MainWindow mainWindow) {
        this.mainWindow = mainWindow;
    }

    public void setFrame(Context frame, Orientation orientation) {
        this.frame = frame;
        this.orientation = orientation;
    }

    @Override
    protected void paintComponent(Graphics g2) {
        super.paintComponent(g2);
        Graphics2D g2D = (Graphics2D)g2;
        if (this.frame == null) {
            return;
        }
        g2.setColor(Color.black);
        AffineTransform t = g2D.getTransform();
        if (this.orientation == Orientation.VERTICAL) {
            AffineTransform rotateTransform = new AffineTransform();
            rotateTransform.quadrantRotate(-1);
            g2D.transform(rotateTransform);
        }
        this.drawTicks(g2D);
        this.drawChr(g2D);
        g2D.setTransform(t);
    }

    private void drawChr(Graphics g2) {
        int w = this.isHorizontal() ? this.getWidth() : this.getHeight();
        int h2 = this.isHorizontal() ? this.getHeight() : this.getWidth();
        g2.setFont(this.spanFont);
        Chromosome chromosome = this.frame.getChromosome();
        if (chromosome != null && !chromosome.getName().equals("All")) {
            String rangeString = chromosome.getName();
            int strWidth = g2.getFontMetrics().stringWidth(rangeString);
            int strPosition = (w - strWidth) / 2;
            if (!this.isHorizontal()) {
                strPosition = -strPosition;
            }
            int vPos = h2 - 35;
            g2.drawString(rangeString, strPosition, vPos);
        }
    }

    private boolean isHorizontal() {
        return this.orientation == Orientation.HORIZONTAL;
    }

    private void drawTicks(Graphics g2) {
        int h2;
        int w = this.isHorizontal() ? this.getWidth() : this.getHeight();
        int n2 = h2 = this.isHorizontal() ? this.getHeight() : this.getWidth();
        if (w < 50 || this.frame.getScale() == 0.0) {
            return;
        }
        g2.setFont(this.tickFont);
        Chromosome chromosome = this.frame.getChromosome();
        if (chromosome == null) {
            return;
        }
        if (chromosome.getName().equals("All")) {
            int x1 = 0;
            Chromosome[] chromosomes = this.mainWindow.getChromosomes();
            int genomeCoord = 0;
            for (int i2 = 1; i2 < chromosomes.length; ++i2) {
                Chromosome c2 = chromosomes[i2];
                int x2 = this.frame.getScreenPosition(genomeCoord += c2.getSize() / 1000);
                int x = (x1 + x2) / 2;
                int strWidth = g2.getFontMetrics().stringWidth(c2.getName());
                int strPosition = this.isHorizontal() ? x - strWidth / 2 : -x - strWidth / 2;
                g2.drawString(c2.getName(), strPosition, h2 - 15);
                int xpos = this.orientation == Orientation.HORIZONTAL ? x2 : -x2;
                g2.drawLine(xpos, h2 - 10, xpos, h2 - 2);
                x1 = x2;
            }
        } else {
            int range = (int)((double)w * this.frame.getScale());
            TickSpacing ts = HiCRulerPanel.findSpacing(range, false);
            double spacing = ts.getMajorTick();
            int maxX = this.frame.getChromosome().getSize();
            int nTick = (int)((double)this.frame.getOrigin() / spacing) - 1;
            int l2 = (int)((double)nTick * spacing);
            int x = this.frame.getScreenPosition(l2);
            while (l2 < maxX && x < w) {
                int strPosition;
                l2 = (int)((double)nTick * spacing);
                x = this.frame.getScreenPosition(l2);
                String chrPosition = HiCRulerPanel.formatNumber((double)l2 / (double)ts.getUnitMultiplier()) + " " + ts.getMajorUnit();
                int strWidth = g2.getFontMetrics().stringWidth(chrPosition);
                int n3 = strPosition = this.isHorizontal() ? x - strWidth / 2 : -x - strWidth / 2;
                if (nTick % 2 == 0) {
                    g2.drawString(chrPosition, strPosition, h2 - 15);
                }
                int xpos = this.orientation == Orientation.HORIZONTAL ? x : -x;
                g2.drawLine(xpos, h2 - 10, xpos, h2 - 2);
                ++nTick;
            }
        }
    }

    public static String formatNumber(double position) {
        DecimalFormat formatter = new DecimalFormat();
        return formatter.format((int)position);
    }

    public static TickSpacing findSpacing(long maxValue, boolean scaleInKB) {
        if (maxValue < 10L) {
            System.out.println("max value = " + maxValue);
            return new TickSpacing(1.0, "bp", 1);
        }
        int nZeroes = (int)Math.log10(maxValue);
        String majorUnit = scaleInKB ? "kb" : "bp";
        int unitMultiplier = 1;
        if (nZeroes > 9) {
            majorUnit = scaleInKB ? "tb" : "gb";
            unitMultiplier = 1000000000;
        }
        if (nZeroes > 6) {
            majorUnit = scaleInKB ? "gb" : "mb";
            unitMultiplier = 1000000;
        } else if (nZeroes > 3) {
            majorUnit = scaleInKB ? "mb" : "kb";
            unitMultiplier = 1000;
        }
        double nMajorTicks = (double)maxValue / Math.pow(10.0, nZeroes - 1);
        if (nMajorTicks < 25.0) {
            return new TickSpacing(Math.pow(10.0, nZeroes - 1), majorUnit, unitMultiplier);
        }
        return new TickSpacing(Math.pow(10.0, nZeroes) / 2.0, majorUnit, unitMultiplier);
    }

    class ClickLink {
        Rectangle region;
        String value;
        String tooltipText;

        ClickLink(Rectangle region, String value, String tooltipText) {
            this.region = region;
            this.value = value;
            this.tooltipText = tooltipText;
        }
    }

    public static class TickSpacing {
        private double majorTick;
        private double minorTick;
        private String majorUnit = "";
        private int unitMultiplier = 1;

        TickSpacing(double majorTick, String majorUnit, int unitMultiplier) {
            this.majorTick = majorTick;
            this.minorTick = majorTick / 10.0;
            this.majorUnit = majorUnit;
            this.unitMultiplier = unitMultiplier;
        }

        public double getMajorTick() {
            return this.majorTick;
        }

        public double getMinorTick() {
            return this.minorTick;
        }

        public String getMajorUnit() {
            return this.majorUnit;
        }

        public void setMajorUnit(String majorUnit) {
            this.majorUnit = majorUnit;
        }

        public int getUnitMultiplier() {
            return this.unitMultiplier;
        }

        public void setUnitMultiplier(int unitMultiplier) {
            this.unitMultiplier = unitMultiplier;
        }
    }

    static enum Orientation {
        HORIZONTAL,
        VERTICAL;

    }
}

