/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.fraction;

import java.math.BigInteger;
import org.apache.commons.math.ConvergenceException;
import org.apache.commons.math.util.MathUtils;

public class Fraction
extends Number
implements Comparable {
    public static final Fraction ONE = new Fraction(1, 1);
    public static final Fraction ZERO = new Fraction(0, 1);
    private static final long serialVersionUID = 65382027393090L;
    private int denominator;
    private int numerator;

    public Fraction(double value) throws ConvergenceException {
        this(value, 1.0E-5, 100);
    }

    public Fraction(double value, double epsilon, int maxIterations) throws ConvergenceException {
        double r0 = value;
        int a0 = (int)Math.floor(r0);
        if (Math.abs((double)a0 - value) < epsilon) {
            this.numerator = a0;
            this.denominator = 1;
            return;
        }
        int p0 = 1;
        int q0 = 0;
        int p1 = a0;
        int q1 = 1;
        int p2 = 0;
        int q2 = 1;
        int n2 = 0;
        boolean stop = false;
        do {
            ++n2;
            double r1 = 1.0 / (r0 - (double)a0);
            int a1 = (int)Math.floor(r1);
            p2 = a1 * p1 + p0;
            q2 = a1 * q1 + q0;
            double convergent = (double)p2 / (double)q2;
            if (n2 < maxIterations && Math.abs(convergent - value) > epsilon) {
                p0 = p1;
                p1 = p2;
                q0 = q1;
                q1 = q2;
                a0 = a1;
                r0 = r1;
                continue;
            }
            stop = true;
        } while (!stop);
        if (n2 >= maxIterations) {
            throw new ConvergenceException("Unable to convert double to fraction");
        }
        this.numerator = p2;
        this.denominator = q2;
        this.reduce();
    }

    public Fraction(int num, int den) {
        if (den == 0) {
            throw new ArithmeticException("The denominator must not be zero");
        }
        if (den < 0) {
            if (num == Integer.MIN_VALUE || den == Integer.MIN_VALUE) {
                throw new ArithmeticException("overflow: can't negate");
            }
            num = -num;
            den = -den;
        }
        this.numerator = num;
        this.denominator = den;
        this.reduce();
    }

    public Fraction abs() {
        Fraction ret = this.numerator >= 0 ? this : this.negate();
        return ret;
    }

    public int compareTo(Object object) {
        int ret = 0;
        if (this != object) {
            double second;
            Fraction other = (Fraction)object;
            double first = this.doubleValue();
            if (first < (second = other.doubleValue())) {
                ret = -1;
            } else if (first > second) {
                ret = 1;
            }
        }
        return ret;
    }

    public double doubleValue() {
        return (double)this.numerator / (double)this.denominator;
    }

    public boolean equals(Object other) {
        boolean ret;
        if (this == other) {
            ret = true;
        } else if (other == null) {
            ret = false;
        } else {
            try {
                Fraction rhs = (Fraction)other;
                ret = this.numerator == rhs.numerator && this.denominator == rhs.denominator;
            }
            catch (ClassCastException ex) {
                ret = false;
            }
        }
        return ret;
    }

    public float floatValue() {
        return (float)this.doubleValue();
    }

    public int getDenominator() {
        return this.denominator;
    }

    public int getNumerator() {
        return this.numerator;
    }

    public int hashCode() {
        return 37 * (629 + this.getNumerator()) + this.getDenominator();
    }

    public int intValue() {
        return (int)this.doubleValue();
    }

    public long longValue() {
        return (long)this.doubleValue();
    }

    public Fraction negate() {
        if (this.numerator == Integer.MIN_VALUE) {
            throw new ArithmeticException("overflow: too large to negate");
        }
        return new Fraction(-this.numerator, this.denominator);
    }

    public Fraction reciprocal() {
        return new Fraction(this.denominator, this.numerator);
    }

    public Fraction add(Fraction fraction) {
        return this.addSub(fraction, true);
    }

    public Fraction subtract(Fraction fraction) {
        return this.addSub(fraction, false);
    }

    private Fraction addSub(Fraction fraction, boolean isAdd) {
        int tmodd1;
        int d2;
        if (fraction == null) {
            throw new IllegalArgumentException("The fraction must not be null");
        }
        if (this.numerator == 0) {
            return isAdd ? fraction : fraction.negate();
        }
        if (fraction.numerator == 0) {
            return this;
        }
        int d1 = MathUtils.gcd(this.denominator, fraction.denominator);
        if (d1 == 1) {
            int uvp = MathUtils.mulAndCheck(this.numerator, fraction.denominator);
            int upv = MathUtils.mulAndCheck(fraction.numerator, this.denominator);
            return new Fraction(isAdd ? MathUtils.addAndCheck(uvp, upv) : MathUtils.subAndCheck(uvp, upv), MathUtils.mulAndCheck(this.denominator, fraction.denominator));
        }
        BigInteger uvp = BigInteger.valueOf(this.numerator).multiply(BigInteger.valueOf(fraction.denominator / d1));
        BigInteger upv = BigInteger.valueOf(fraction.numerator).multiply(BigInteger.valueOf(this.denominator / d1));
        BigInteger t = isAdd ? uvp.add(upv) : uvp.subtract(upv);
        BigInteger w = t.divide(BigInteger.valueOf(d2 = (tmodd1 = t.mod(BigInteger.valueOf(d1)).intValue()) == 0 ? d1 : MathUtils.gcd(tmodd1, d1)));
        if (w.bitLength() > 31) {
            throw new ArithmeticException("overflow: numerator too large after multiply");
        }
        return new Fraction(w.intValue(), MathUtils.mulAndCheck(this.denominator / d1, fraction.denominator / d2));
    }

    public Fraction multiply(Fraction fraction) {
        if (fraction == null) {
            throw new IllegalArgumentException("The fraction must not be null");
        }
        if (this.numerator == 0 || fraction.numerator == 0) {
            return ZERO;
        }
        int d1 = MathUtils.gcd(this.numerator, fraction.denominator);
        int d2 = MathUtils.gcd(fraction.numerator, this.denominator);
        return Fraction.getReducedFraction(MathUtils.mulAndCheck(this.numerator / d1, fraction.numerator / d2), MathUtils.mulAndCheck(this.denominator / d2, fraction.denominator / d1));
    }

    public Fraction divide(Fraction fraction) {
        if (fraction == null) {
            throw new IllegalArgumentException("The fraction must not be null");
        }
        if (fraction.numerator == 0) {
            throw new ArithmeticException("The fraction to divide by must not be zero");
        }
        return this.multiply(fraction.reciprocal());
    }

    public static Fraction getReducedFraction(int numerator, int denominator) {
        if (denominator == 0) {
            throw new ArithmeticException("The denominator must not be zero");
        }
        if (numerator == 0) {
            return ZERO;
        }
        if (denominator == Integer.MIN_VALUE && (numerator & 1) == 0) {
            numerator /= 2;
            denominator /= 2;
        }
        if (denominator < 0) {
            if (numerator == Integer.MIN_VALUE || denominator == Integer.MIN_VALUE) {
                throw new ArithmeticException("overflow: can't negate");
            }
            numerator = -numerator;
            denominator = -denominator;
        }
        int gcd = MathUtils.gcd(numerator, denominator);
        return new Fraction(numerator /= gcd, denominator /= gcd);
    }

    private void reduce() {
        int d2 = MathUtils.gcd(this.numerator, this.denominator);
        if (d2 > 1) {
            this.numerator /= d2;
            this.denominator /= d2;
        }
        if (this.denominator < 0) {
            this.numerator *= -1;
            this.denominator *= -1;
        }
    }
}

