/*
 * Decompiled with CFR 0.152.
 */
package org.broad.tribble.source.query;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.broad.tribble.Tribble;
import org.broad.tribble.index.Block;
import org.broad.tribble.index.Index;
import org.broad.tribble.index.IndexFactory;
import org.broad.tribble.readers.AsciiLineReader;
import org.broad.tribble.readers.LineReader;
import org.broad.tribble.source.BasicFeatureSource;
import org.broad.tribble.source.query.QuerySource;
import org.broad.tribble.util.SeekableStream;
import org.broad.tribble.util.SeekableStreamFactory;

public class AsciiQuerySource
implements QuerySource {
    private static Logger log = Logger.getLogger(BasicFeatureSource.class);
    protected SeekableStream seekableStream;
    protected Index index;

    public AsciiQuerySource(String featureFile, String indexFile) throws IOException {
        this.seekableStream = SeekableStreamFactory.getStreamFor(featureFile);
        this.index = IndexFactory.loadIndex(indexFile);
    }

    public AsciiQuerySource(String featureFile) throws IOException {
        String indexFile = Tribble.indexFile(featureFile);
        this.seekableStream = SeekableStreamFactory.getStreamFor(featureFile);
        this.index = IndexFactory.loadIndex(indexFile);
    }

    public AsciiQuerySource(String featureFile, Index indexInstance) throws IOException {
        this.seekableStream = SeekableStreamFactory.getStreamFor(featureFile);
        this.index = indexInstance;
    }

    @Override
    public void close() throws IOException {
        if (this.seekableStream != null) {
            this.seekableStream.close();
        }
    }

    @Override
    public LineReader iterate() throws IOException {
        this.seekableStream.seek(0L);
        return new AsciiLineReader(this.seekableStream);
    }

    @Override
    public void mark() {
        throw new UnsupportedOperationException("Unable to mark/reset position in an AsciiQuerySource");
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public void reset() {
        throw new UnsupportedOperationException("Unable to mark/reset position in an AsciiQuerySource");
    }

    @Override
    public LineReader query(String chr, int start, int end) {
        return new IndexedReader(chr, start, end);
    }

    @Override
    public List<String> getSequenceNames() {
        return new ArrayList<String>(this.index.getSequenceNames());
    }

    public class IndexedReader
    implements LineReader {
        String chr;
        int start;
        int end;
        AsciiLineReader reader;
        List<Block> blocks;

        public IndexedReader() {
            this.reader = new AsciiLineReader(AsciiQuerySource.this.seekableStream);
        }

        public IndexedReader(String chr, int start, int end) {
            this.chr = chr;
            this.start = start;
            this.end = end;
            this.init();
        }

        @Override
        public String readLine() throws IOException {
            return this.reader == null ? null : this.reader.readLine();
        }

        @Override
        public void close() {
            this.reader.close();
        }

        private void init() {
            if (AsciiQuerySource.this.index == null) {
                throw new UnsupportedOperationException("Files must be indexed to support query methods");
            }
            this.blocks = AsciiQuerySource.this.index.getBlocks(this.chr, this.start, this.end);
            if (this.blocks == null || this.blocks.size() == 0) {
                this.reader = null;
            } else {
                Block firstBlock = this.blocks.get(0);
                try {
                    AsciiQuerySource.this.seekableStream.seek(firstBlock.getStartPosition());
                    this.reader = new AsciiLineReader(AsciiQuerySource.this.seekableStream);
                }
                catch (IOException ex) {
                    log.error("Error seeking to position: " + firstBlock.getStartPosition(), ex);
                }
            }
        }
    }
}

