/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.util;

import java.awt.Frame;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.BasicResponseHandler;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.log4j.Logger;
import org.broad.igv.gs.GSLoginDialog;
import org.broad.igv.gs.GSUtils;
import org.broad.igv.ui.IGV;

public class IGVHttpClientUtils {
    private static Logger log = Logger.getLogger(IGVHttpClientUtils.class);
    static DefaultHttpClient client = new DefaultHttpClient();

    public static void setProxy(String proxyHost, int proxyPort, boolean auth, String user, String pw) {
        if (client == null) {
            client = new DefaultHttpClient();
        }
        if (proxyHost != null) {
            HttpHost proxy = new HttpHost(proxyHost, proxyPort);
            client.getParams().setParameter("http.route.default-proxy", proxy);
            log.info("Proxy settings: " + proxyHost + ":" + proxyPort);
        }
        if (auth) {
            client.getCredentialsProvider().setCredentials(new AuthScope(proxyHost, proxyPort), new UsernamePasswordCredentials(user, pw));
        }
    }

    public static void shutdown() {
        client.getConnectionManager().shutdown();
        client = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean downloadFile(String url, File outputFile) throws IOException {
        log.info("Downloading " + url + " to " + outputFile.getAbsolutePath());
        HttpGet httpget = new HttpGet(url);
        HttpResponse response = client.execute(httpget);
        HttpEntity entity = response.getEntity();
        if (entity != null) {
            long contentLength = entity.getContentLength();
            log.info("Content length = " + contentLength);
            InputStream is = null;
            FileOutputStream out = null;
            try {
                is = entity.getContent();
                out = new FileOutputStream(outputFile);
                byte[] buf = new byte[65536];
                int downloaded = 0;
                int bytesRead = 0;
                while ((bytesRead = is.read(buf)) != -1) {
                    ((OutputStream)out).write(buf, 0, bytesRead);
                    downloaded += bytesRead;
                }
                log.info("Download complete.  Total bytes downloaded = " + downloaded);
            }
            finally {
                if (is != null) {
                    is.close();
                }
                if (out != null) {
                    out.flush();
                    ((OutputStream)out).close();
                }
            }
            long fileLength = outputFile.length();
            log.info("File length = " + fileLength);
            return contentLength <= 0L || contentLength == fileLength;
        }
        return false;
    }

    public static InputStream openConnectionStream(URL url) throws IOException {
        HttpResponse response = IGVHttpClientUtils.executeGet(url);
        return response.getEntity().getContent();
    }

    public static String getHeaderField(URL url, String key) throws IOException {
        HttpResponse response = IGVHttpClientUtils.executeGet(url);
        return response.getFirstHeader(key).getValue();
    }

    private static HttpResponse executeGet(URL url) throws IOException {
        if (client == null) {
            client = new DefaultHttpClient();
        }
        HttpRequestBase getMethod = null;
        try {
            if (GSUtils.isGenomeSpace(url)) {
                GSUtils.checkForCookie(client, url);
            }
            getMethod = new HttpGet(url.toExternalForm());
            client.getParams().setParameter("http.protocol.allow-circular-redirects", true);
            HttpResponse response = client.execute(getMethod);
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode == 401) {
                getMethod.abort();
                client.getCredentialsProvider().clear();
                IGVHttpClientUtils.login(url);
                return IGVHttpClientUtils.executeGet(url);
            }
            if (statusCode != 200) {
                getMethod.abort();
                throw new RuntimeException("Error connecting.  Status code = " + statusCode);
            }
            return response;
        }
        catch (RuntimeException e2) {
            if (getMethod != null) {
                getMethod.abort();
            }
            throw e2;
        }
    }

    private static void login(URL url) {
        Frame owner = IGV.hasInstance() ? IGV.getMainFrame() : null;
        String userpass = IGVHttpClientUtils.getGSUserPass(owner);
        if (userpass == null) {
            throw new RuntimeException("Access denied to: " + url.toString());
        }
        UsernamePasswordCredentials GENOME_SPACE_CREDS = new UsernamePasswordCredentials(userpass);
        String host = GSUtils.isGenomeSpace(url) ? "identitytest.genomespace.org" : url.getHost();
        client.getCredentialsProvider().setCredentials(new AuthScope(host, -1, AuthScope.ANY_REALM), GENOME_SPACE_CREDS);
        if (GSUtils.isGenomeSpace(url)) {
            try {
                HttpGet httpget = new HttpGet("https://identitytest.genomespace.org:8443/identityServer/basic");
                BasicResponseHandler responseHandler = new BasicResponseHandler();
                String responseBody = client.execute((HttpUriRequest)httpget, responseHandler);
                if (responseBody != null && responseBody.length() > 0) {
                    String[] tokens = userpass.split(":");
                    String user = tokens[0];
                    GSUtils.saveLoginForSSO(responseBody, user);
                }
            }
            catch (IOException e2) {
                log.error("Error fetching GS token", e2);
            }
        }
    }

    public static String getGSUserPass(Frame owner) {
        GSLoginDialog dlg = new GSLoginDialog(owner);
        dlg.setVisible(true);
        if (dlg.isCanceled()) {
            return null;
        }
        String userString = dlg.getUsername();
        String userPass = new String(dlg.getPassword());
        return userString + ":" + userPass;
    }
}

