/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui.panel;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.event.MouseInputAdapter;
import org.broad.igv.track.AttributeManager;
import org.broad.igv.ui.FontManager;
import org.broad.igv.ui.IGV;

public class AttributeHeaderPanel
extends JPanel {
    static final int MAXIMUM_FONT_SIZE = 10;
    static final int ATTRIBUTE_COLUMN_WIDTH = 10;
    static final int COLUMN_BORDER_WIDTH = 2;
    Map<String, Boolean> sortOrder = new HashMap<String, Boolean>();

    public AttributeHeaderPanel() {
        this.setBorder(BorderFactory.createLineBorder(Color.black));
        this.setCursor(Cursor.getPredefinedCursor(12));
        this.addMouseListener();
    }

    public int getAttributeColumnWidth() {
        return 10;
    }

    private String getAttributeHeading(int x) {
        int idx = x / 12;
        List<String> keys = AttributeManager.getInstance().getVisibleAttributes();
        if (idx < keys.size()) {
            return keys.get(idx);
        }
        return null;
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        List<String> keys = AttributeManager.getInstance().getVisibleAttributes();
        if (keys.size() > 0) {
            Graphics2D graphics2 = (Graphics2D)graphics.create();
            int columnWidth = this.getAttributeColumnWidth();
            int fontSize = (int)(0.9 * (double)columnWidth);
            if (fontSize > 10) {
                fontSize = 10;
            }
            Font font = FontManager.getFont(fontSize);
            AffineTransform transform = AffineTransform.getTranslateInstance(0.0, this.getHeight() - 2);
            graphics2.transform(transform);
            transform = AffineTransform.getRotateInstance(-1.5707963267948966);
            graphics2.transform(transform);
            graphics2.setFont(font);
            FontMetrics fm = graphics2.getFontMetrics();
            int fontAscent = fm.getHeight();
            int i2 = 1;
            for (String key : keys) {
                int columnLeftEdge = 12 * i2++;
                int x = columnLeftEdge + (12 - fontAscent) / 2;
                graphics2.drawString(key, 0, x);
            }
        }
    }

    private void addMouseListener() {
        this.setToolTipText("Click attribute heading to sort");
        MouseInputAdapter listener = new MouseInputAdapter(){

            @Override
            public void mouseClicked(MouseEvent e2) {
                String attKey = AttributeHeaderPanel.this.getAttributeHeading(e2.getX());
                if (attKey != null) {
                    Boolean tmp = AttributeHeaderPanel.this.sortOrder.get(attKey);
                    boolean sortAscending = tmp == null ? true : tmp;
                    AttributeHeaderPanel.this.sortTrackByAttribute(attKey, sortAscending);
                    AttributeHeaderPanel.this.sortOrder.put(attKey, !sortAscending);
                }
            }

            @Override
            public void mouseExited(MouseEvent e2) {
            }

            @Override
            public void mouseReleased(MouseEvent e2) {
            }
        };
        this.addMouseMotionListener(listener);
        this.addMouseListener(listener);
    }

    public final void sortTrackByAttribute(String sortKey, boolean isSortAscending) {
        if (sortKey != null) {
            IGV.getInstance().getTrackManager().sortAllTracksByAttributes(new String[]{sortKey}, new boolean[]{isSortAscending});
            IGV.getMainFrame().repaint();
        }
    }
}

