/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.track;

import com.jidesoft.swing.JidePopupMenu;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import org.apache.log4j.Logger;
import org.broad.igv.PreferenceManager;
import org.broad.igv.feature.IGVFeature;
import org.broad.igv.feature.Locus;
import org.broad.igv.feature.LocusScore;
import org.broad.igv.feature.SpliceJunctionFeature;
import org.broad.igv.feature.Strand;
import org.broad.igv.renderer.DataRange;
import org.broad.igv.renderer.SpliceJunctionRenderer;
import org.broad.igv.sam.Alignment;
import org.broad.igv.sam.AlignmentBlock;
import org.broad.igv.sam.AlignmentDataManager;
import org.broad.igv.sam.AlignmentInterval;
import org.broad.igv.track.FeatureSource;
import org.broad.igv.track.FeatureTrack;
import org.broad.igv.track.PackedFeatures;
import org.broad.igv.track.RegionScoreType;
import org.broad.igv.track.RenderContext;
import org.broad.igv.track.Track;
import org.broad.igv.track.TrackClickEvent;
import org.broad.igv.track.TrackMenuUtils;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.panel.ReferenceFrame;

public class SpliceJunctionFinderTrack
extends FeatureTrack {
    private static Logger log = Logger.getLogger(SpliceJunctionFinderTrack.class);
    AlignmentDataManager dataManager;
    PreferenceManager prefs;
    RenderContext context;
    protected int minReadFlankingWidth = 0;
    protected int minJunctionCoverage = 1;

    public SpliceJunctionFinderTrack(String id, String name, AlignmentDataManager dataManager) {
        super(id, name);
        this.init(new SpliceJunctionFinderFeatureSource());
        super.setDataRange(new DataRange(0.0f, 0.0f, 60.0f));
        this.setRendererClass(SpliceJunctionRenderer.class);
        this.dataManager = dataManager;
        this.prefs = PreferenceManager.getInstance();
    }

    protected boolean shouldShowFeatures() {
        return this.context != null && !this.dataManager.isLoading() && this.dataManager.getLoadedInterval(this.context) != null;
    }

    @Override
    protected void renderFeatures(RenderContext context, Rectangle inputRect) {
        this.context = context;
        if (this.featuresLoading || !this.shouldShowFeatures()) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug("renderFeatures: " + this.getName());
        }
        String chr = context.getChr();
        int start = (int)context.getOrigin();
        int end = (int)context.getEndLocation() + 1;
        PackedFeatures packedFeatures = (PackedFeatures)this.packedFeaturesMap.get(context.getReferenceFrame().getName());
        if (packedFeatures == null || !packedFeatures.containsInterval(chr, start, end)) {
            this.featuresLoading = true;
            this.loadFeatures(chr, start, end, context);
            if (!IGV.getInstance().isExportingSnapshot()) {
                return;
            }
        }
        this.renderFeatureImpl(context, inputRect, packedFeatures);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void renderFeatureImpl(RenderContext context, Rectangle inputRect, PackedFeatures packedFeatures) {
        float maxRange = PreferenceManager.getInstance().getAsFloat("SAM.MAX_VISIBLE_RANGE");
        float minVisibleScale = maxRange * 1000.0f / 700.0f;
        if (context.getScale() > (double)minVisibleScale) {
            return;
        }
        if (this.getDisplayMode() == Track.DisplayMode.EXPANDED) {
            List<PackedFeatures.FeatureRow> rows = packedFeatures.getRows();
            if (rows != null && rows.size() > 0) {
                int nLevels = rows.size();
                List list = this.levelRects;
                synchronized (list) {
                    this.levelRects.clear();
                    double h2 = inputRect.getHeight() / (double)nLevels;
                    Rectangle rect = new Rectangle(inputRect.x, inputRect.y, inputRect.width, (int)h2);
                    int i2 = 0;
                    for (PackedFeatures.FeatureRow row : rows) {
                        this.levelRects.add(new Rectangle(rect));
                        this.getRenderer().render(row.features, context, rect, this);
                        if (this.selectedFeatureRowIndex == i2) {
                            Graphics2D fontGraphics = (Graphics2D)context.getGraphic2DForColor(SELECTED_FEATURE_ROW_COLOR).create();
                            fontGraphics.fillRect(rect.x, rect.y, rect.width, rect.height);
                        }
                        rect.y = (int)((double)rect.y + h2);
                        ++i2;
                    }
                }
            }
        } else {
            List features = packedFeatures.getFeatures();
            if (features != null) {
                this.getRenderer().render(features, context, inputRect, this);
            }
        }
    }

    public JMenuItem addFlankingWidthTresholdItem(JPopupMenu menu) {
        JMenuItem flankingWidthItem = new JMenuItem("Set minimum read flanking width...");
        flankingWidthItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                String value = JOptionPane.showInputDialog("Minimum start and end flanking region width: ", (Object)Float.valueOf(SpliceJunctionFinderTrack.this.minReadFlankingWidth));
                if (value == null) {
                    return;
                }
                try {
                    int tmp;
                    SpliceJunctionFinderTrack.this.minReadFlankingWidth = tmp = Integer.parseInt(value);
                    IGV.getInstance().repaintDataPanels();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        menu.add(flankingWidthItem);
        return flankingWidthItem;
    }

    public JMenuItem addJunctionCoverageTresholdItem(JPopupMenu menu) {
        JMenuItem junctionDepthItem = new JMenuItem("Set minimum junction coverage...");
        junctionDepthItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                String value = JOptionPane.showInputDialog("Minimum coverage depth for displayed junctions: ", (Object)Float.valueOf(SpliceJunctionFinderTrack.this.minJunctionCoverage));
                if (value == null) {
                    return;
                }
                try {
                    int tmp;
                    SpliceJunctionFinderTrack.this.minJunctionCoverage = tmp = Integer.parseInt(value);
                    IGV.getInstance().repaintDataPanels();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        menu.add(junctionDepthItem);
        return junctionDepthItem;
    }

    @Override
    public JPopupMenu getPopupMenu(TrackClickEvent te) {
        JidePopupMenu popupMenu = new JidePopupMenu();
        JLabel popupTitle = new JLabel("  " + this.getName(), 0);
        Font newFont = popupMenu.getFont().deriveFont(1, 12.0f);
        popupTitle.setFont(newFont);
        if (popupTitle != null) {
            popupMenu.add(popupTitle);
        }
        popupMenu.addSeparator();
        ArrayList<Track> tmp = new ArrayList<Track>();
        tmp.add(this);
        TrackMenuUtils.addStandardItems(popupMenu, tmp, te);
        popupMenu.addSeparator();
        this.addFlankingWidthTresholdItem(popupMenu);
        this.addJunctionCoverageTresholdItem(popupMenu);
        return popupMenu;
    }

    @Override
    public void setDataRange(DataRange axisDefinition) {
        super.setDataRange(axisDefinition);
    }

    @Override
    public boolean isLogNormalized() {
        return false;
    }

    @Override
    public float getRegionScore(String chr, int start, int end, int zoom, RegionScoreType type, ReferenceFrame frame) {
        return 0.0f;
    }

    static class LoadedInterval {
        String chr;
        int start;
        int end;
        List<SpliceJunctionFeature> features;

        LoadedInterval(String chr, int start, int end, List<SpliceJunctionFeature> features) {
            this.chr = chr;
            this.start = start;
            this.end = end;
            this.features = features;
        }

        boolean contains(String chr, int start, int end) {
            return start >= this.start && end <= this.end && chr.equals(this.chr);
        }
    }

    protected class SpliceJunctionFinderFeatureSource
    implements FeatureSource {
        LoadedInterval loadedInterval;

        public Iterator getFeatures(String chr, int start, int end) throws IOException {
            ArrayList<SpliceJunctionFeature> spliceJunctionFeatures = new ArrayList<SpliceJunctionFeature>();
            if (!SpliceJunctionFinderTrack.this.shouldShowFeatures()) {
                return null;
            }
            if (this.loadedInterval != null && this.loadedInterval.contains(chr, start, end)) {
                return this.loadedInterval.features.iterator();
            }
            Locus alignmentInterval = null;
            if (SpliceJunctionFinderTrack.this.dataManager != null) {
                alignmentInterval = SpliceJunctionFinderTrack.this.dataManager.getLoadedInterval(SpliceJunctionFinderTrack.this.context);
                if (SpliceJunctionFinderTrack.this.dataManager.isLoading()) {
                    while (SpliceJunctionFinderTrack.this.dataManager.isLoading()) {
                        try {
                            Thread.sleep(50L);
                        }
                        catch (InterruptedException e2) {}
                    }
                    alignmentInterval = SpliceJunctionFinderTrack.this.dataManager.getLoadedInterval(SpliceJunctionFinderTrack.this.context);
                }
            }
            if (alignmentInterval != null && ((AlignmentInterval)alignmentInterval).contains(SpliceJunctionFinderTrack.this.context.getGenomeId(), SpliceJunctionFinderTrack.this.context.getChr(), (int)SpliceJunctionFinderTrack.this.context.getOrigin(), (int)SpliceJunctionFinderTrack.this.context.getEndLocation())) {
                HashMap posStartEndJunctionsMap = new HashMap();
                HashMap negStartEndJunctionsMap = new HashMap();
                List<AlignmentInterval.Row> alignmentRows = ((AlignmentInterval)alignmentInterval).getAlignmentRows();
                for (AlignmentInterval.Row row : alignmentRows) {
                    AlignmentInterval.Row.AlignmentIterator iterator = row.getIterator();
                    while (iterator.hasNext()) {
                        Alignment alignment = iterator.next();
                        AlignmentBlock[] blocks = alignment.getAlignmentBlocks();
                        if (blocks.length < 2) continue;
                        boolean isNegativeStrand = false;
                        Object strandAttr = alignment.getAttribute("XS");
                        if (strandAttr != null) {
                            isNegativeStrand = strandAttr.toString().charAt(0) == '-';
                        }
                        HashMap startEndJunctionsMapThisStrand = isNegativeStrand ? negStartEndJunctionsMap : posStartEndJunctionsMap;
                        int flankingStart = -1;
                        int junctionStart = -1;
                        for (AlignmentBlock block : blocks) {
                            int flankingEnd = block.getEnd();
                            int junctionEnd = block.getStart();
                            if (junctionStart != -1 && (SpliceJunctionFinderTrack.this.minReadFlankingWidth == 0 || junctionStart - flankingStart >= SpliceJunctionFinderTrack.this.minReadFlankingWidth && flankingEnd - junctionEnd >= SpliceJunctionFinderTrack.this.minReadFlankingWidth)) {
                                SpliceJunctionFeature junction;
                                HashMap<Integer, SpliceJunctionFeature> endJunctionsMap = (HashMap<Integer, SpliceJunctionFeature>)startEndJunctionsMapThisStrand.get(junctionStart);
                                if (endJunctionsMap == null) {
                                    endJunctionsMap = new HashMap<Integer, SpliceJunctionFeature>();
                                    startEndJunctionsMapThisStrand.put(junctionStart, endJunctionsMap);
                                }
                                if ((junction = (SpliceJunctionFeature)endJunctionsMap.get(junctionEnd)) == null) {
                                    junction = new SpliceJunctionFeature(chr, junctionStart, junctionEnd, isNegativeStrand ? Strand.NEGATIVE : Strand.POSITIVE);
                                    endJunctionsMap.put(junctionEnd, junction);
                                    spliceJunctionFeatures.add(junction);
                                }
                                junction.addRead(flankingStart, flankingEnd);
                            }
                            flankingStart = junctionEnd;
                            junctionStart = flankingEnd;
                        }
                    }
                }
                if (SpliceJunctionFinderTrack.this.minJunctionCoverage > 1) {
                    ArrayList<SpliceJunctionFeature> coveredFeatures = new ArrayList<SpliceJunctionFeature>(spliceJunctionFeatures.size());
                    for (SpliceJunctionFeature feature : spliceJunctionFeatures) {
                        if (feature.getJunctionDepth() < SpliceJunctionFinderTrack.this.minJunctionCoverage) continue;
                        coveredFeatures.add(feature);
                    }
                    spliceJunctionFeatures = coveredFeatures;
                }
                Collections.sort(spliceJunctionFeatures, new Comparator<IGVFeature>(){

                    @Override
                    public int compare(IGVFeature o1, IGVFeature o2) {
                        return o1.getStart() - o2.getStart();
                    }
                });
            }
            this.loadedInterval = new LoadedInterval(alignmentInterval.getChr(), alignmentInterval.getStart(), alignmentInterval.getEnd(), spliceJunctionFeatures);
            return spliceJunctionFeatures.iterator();
        }

        @Override
        public List<LocusScore> getCoverageScores(String chr, int start, int end, int zoom) {
            return null;
        }

        @Override
        public int getFeatureWindowSize() {
            return 0;
        }

        @Override
        public void setFeatureWindowSize(int size) {
        }

        @Override
        public Class getFeatureClass() {
            return null;
        }
    }
}

