/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.feature.tribble;

import org.broad.igv.feature.BasicFeature;
import org.broad.igv.feature.Exon;
import org.broad.igv.feature.Strand;
import org.broad.igv.feature.tribble.UCSCCodec;
import org.broad.igv.util.ParsingUtils;
import org.broad.tribble.Feature;

public class PSLCodec
extends UCSCCodec {
    public Feature decode(String line) {
        BasicFeature f2 = null;
        try {
            if (line.trim().length() == 0 || line.startsWith("#") || line.startsWith("track") || line.startsWith("browser")) {
                return null;
            }
            int nTokens = ParsingUtils.splitWhitespace(line, this.tokens);
            if (nTokens < 21) {
                return null;
            }
            int tSize = Integer.parseInt(this.tokens[14]);
            String chr = this.tokens[13];
            int start = Integer.parseInt(this.tokens[15]);
            String strandString = this.tokens[8];
            Strand strand = strandString.startsWith("+") ? Strand.POSITIVE : Strand.NEGATIVE;
            boolean gNeg = false;
            if (strandString.length() > 1) {
                gNeg = strandString.charAt(1) == '-';
            }
            f2 = new BasicFeature();
            f2.setName(this.tokens[9]);
            f2.setChr(chr);
            f2.setStart(start);
            f2.setEnd(Integer.parseInt(this.tokens[16]));
            f2.setStrand(strand);
            int exonCount = Integer.parseInt(this.tokens[17]);
            String[] exonSizes = this.tokens[18].split(",");
            String[] startsBuffer = this.tokens[20].split(",");
            if (startsBuffer.length == exonSizes.length && exonCount == startsBuffer.length) {
                for (int i2 = 0; i2 < startsBuffer.length; ++i2) {
                    int exonSize = Integer.parseInt(exonSizes[i2]);
                    int exonStart = Integer.parseInt(startsBuffer[i2]);
                    if (gNeg) {
                        exonStart = tSize - exonStart - exonSize;
                    }
                    int exonEnd = exonStart + exonSize;
                    Exon exon = new Exon(chr, exonStart, exonEnd, strand);
                    f2.addExon(exon);
                }
            }
        }
        catch (NumberFormatException e2) {
            return null;
        }
        return f2;
    }
}

