/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.sam.reader;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.sf.samtools.BAMIndex;
import net.sf.samtools.SAMFileHeader;
import net.sf.samtools.SAMFileReader;
import net.sf.samtools.SAMRecordIterator;
import net.sf.samtools.SAMSequenceRecord;
import net.sf.samtools.util.CloseableIterator;
import org.apache.log4j.Logger;
import org.broad.igv.sam.Alignment;
import org.broad.igv.sam.reader.AlignmentQueryReader;
import org.broad.igv.sam.reader.WrappedIterator;
import org.broad.igv.ui.util.MessageUtils;

public class BAMQueryReader
implements AlignmentQueryReader {
    private static Logger log = Logger.getLogger(BAMQueryReader.class);
    SAMFileReader reader;
    BAMIndex index;
    SAMFileHeader header;

    public BAMQueryReader(File samFile) {
        try {
            this.reader = new SAMFileReader(samFile);
            this.reader.setValidationStringency(SAMFileReader.ValidationStringency.SILENT);
            this.loadHeader();
        }
        catch (Exception e2) {
            MessageUtils.showMessage("Error loading SAM header: " + e2.getMessage());
            e2.printStackTrace();
        }
    }

    @Override
    public SAMFileHeader getHeader() {
        if (this.header == null) {
            this.loadHeader();
        }
        return this.header;
    }

    @Override
    public Set<String> getSequenceNames() {
        SAMFileHeader header = this.getHeader();
        if (header == null) {
            return null;
        }
        HashSet<String> seqNames = new HashSet<String>();
        List<SAMSequenceRecord> records = header.getSequenceDictionary().getSequences();
        if (records.size() > 0) {
            for (SAMSequenceRecord rec : header.getSequenceDictionary().getSequences()) {
                String chr = rec.getSequenceName();
                seqNames.add(chr);
            }
        }
        return seqNames;
    }

    private void loadHeader() {
        this.header = this.reader.getFileHeader();
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }

    @Override
    public boolean hasIndex() {
        return this.reader.hasIndex();
    }

    @Override
    public CloseableIterator<Alignment> query(String sequence, int start, int end, boolean contained) {
        SAMRecordIterator query = null;
        try {
            query = this.reader.query(sequence, start, end, contained);
            return new WrappedIterator(query);
        }
        catch (ArrayIndexOutOfBoundsException e2) {
            log.error("Error querying BAM file ", e2);
            MessageUtils.showMessage("Error reading bam file.  This usually indicates a problem with the index (bai) file.<br>" + e2.toString() + " (" + e2.getMessage() + ")");
            return EmptyIterator.instance;
        }
    }

    @Override
    public CloseableIterator<Alignment> iterator() {
        return new WrappedIterator(this.reader.iterator());
    }

    public static class EmptyIterator
    implements CloseableIterator<Alignment> {
        public static final EmptyIterator instance = new EmptyIterator();

        @Override
        public void close() {
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public Alignment next() {
            return null;
        }

        @Override
        public void remove() {
        }
    }
}

