/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.gs;

import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;
import org.broad.igv.gs.GSFileBrowser;
import org.broad.igv.gs.dm.DMUtils;
import org.broad.igv.session.Session;
import org.broad.igv.session.SessionWriter;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.WaitCursorManager;
import org.broad.igv.ui.action.MenuAction;
import org.broad.igv.ui.action.SaveSessionMenuAction;

public class GSSaveSessionMenuAction
extends MenuAction {
    static Logger log = Logger.getLogger(SaveSessionMenuAction.class);
    IGV mainFrame;

    public GSSaveSessionMenuAction(String label, IGV mainFrame) {
        super(label);
        this.mainFrame = mainFrame;
        this.setToolTipText("Save session to GenomeSpace");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent e2) {
        block11: {
            block10: {
                WaitCursorManager.CursorToken token = null;
                try {
                    File tmpDir;
                    String currentSessionFilePath = this.mainFrame.getSession().getPath();
                    String initFile = currentSessionFilePath == null ? "igv_session.xml" : currentSessionFilePath;
                    String sessionName = new File(initFile).getName();
                    GSFileBrowser gsFileBrowser = new GSFileBrowser(IGV.getMainFrame(), GSFileBrowser.Mode.SAVE);
                    gsFileBrowser.setVisible(true);
                    String gsPath = gsFileBrowser.getPath();
                    if (gsPath == null) {
                        return;
                    }
                    if (!gsPath.endsWith(".xml")) {
                        gsPath = gsPath + ".xml";
                    }
                    if (!(tmpDir = new File(System.getProperty("java.io.tmpdir"), System.getProperty("user.name"))).exists()) {
                        tmpDir.mkdirs();
                    }
                    sessionName = new File(gsPath).getName();
                    File sessionFile = new File(tmpDir, sessionName);
                    this.mainFrame.setStatusBarMessage("Saving session to " + sessionFile.getAbsolutePath());
                    Object out = null;
                    token = WaitCursorManager.showWaitCursor();
                    Session currentSession = this.mainFrame.getSession();
                    currentSession.setPath(sessionFile.getAbsolutePath());
                    new SessionWriter().saveSession(currentSession, sessionFile);
                    DMUtils.uploadFile(sessionFile, gsPath);
                    sessionFile.delete();
                    if (token == null) break block10;
                }
                catch (Exception e22) {
                    GSSaveSessionMenuAction gSSaveSessionMenuAction = this;
                    JOptionPane.showMessageDialog(gSSaveSessionMenuAction.mainFrame.getMainFrame(), "Error saving session file (" + e22.getMessage() + ")");
                    log.error("Failed to save session!", e22);
                    break block11;
                }
                finally {
                    if (token != null) {
                        WaitCursorManager.removeWaitCursor(token);
                    }
                    this.mainFrame.resetStatusMessage();
                }
                WaitCursorManager.removeWaitCursor(token);
            }
            this.mainFrame.resetStatusMessage();
        }
    }
}

