/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.feature;

import org.broad.igv.feature.AbstractFeatureParser;
import org.broad.igv.feature.IGVFeature;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.track.TrackProperties;
import org.broad.igv.util.ParsingUtils;

public abstract class UCSCParser
extends AbstractFeatureParser {
    String[] tokens = new String[25];

    protected UCSCParser(Genome genome) {
        super(genome);
    }

    @Override
    protected IGVFeature parseLine(String nextLine) {
        if (nextLine.startsWith("#")) {
            return null;
        }
        if (nextLine.startsWith("track")) {
            TrackProperties tp = new TrackProperties();
            ParsingUtils.parseTrackLine(nextLine, tp);
            this.setTrackProperties(tp);
        }
        int nTokens = ParsingUtils.splitWhitespace(nextLine.replaceAll("\"", ""), this.tokens);
        return this.parseLine(this.tokens, nTokens);
    }

    protected abstract IGVFeature parseLine(String[] var1, int var2);
}

