/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.util;

import it.unimi.dsi.bits.Fast;
import it.unimi.dsi.fastutil.chars.CharList;
import it.unimi.dsi.lang.MutableString;
import java.io.Serializable;
import java.util.Arrays;

public class TextPattern
implements Serializable,
CharSequence {
    private static final long serialVersionUID = 1L;
    public static final int CASE_INSENSITIVE = 1;
    public static final int UNICODE_CASE = 2;
    private static final int PHI2 = 1640531525;
    protected char[] pattern;
    private transient int[] badCharShift;
    private transient int[] asciiBadCharShift = new int[128];
    private transient int mask;
    private transient int hashShift;
    private boolean caseSensitive;
    private boolean asciiCase;
    private static final int MIN_COUNT = 8;

    public TextPattern(CharSequence pattern) {
        this(pattern, 0);
    }

    public TextPattern(CharSequence pattern, int flags) {
        this.pattern = new char[pattern.length()];
        MutableString.getChars(pattern, 0, this.pattern.length, this.pattern, 0);
        this.caseSensitive = (flags & 1) == 0;
        boolean bl = this.asciiCase = (flags & 2) == 0;
        if (!this.caseSensitive) {
            int i2 = this.pattern.length;
            if (this.asciiCase) {
                while (i2-- != 0) {
                    this.pattern[i2] = TextPattern.asciiToLowerCase(this.pattern[i2]);
                }
            } else {
                while (i2-- != 0) {
                    this.pattern[i2] = TextPattern.unicodeToLowerCase(this.pattern[i2]);
                }
            }
        }
        this.compile();
    }

    public boolean caseInsensitive() {
        return !this.caseSensitive;
    }

    public boolean unicodeCase() {
        return !this.asciiCase;
    }

    private static char asciiToLowerCase(char c2) {
        return c2 >= 'A' && c2 <= 'Z' ? (char)(c2 + 32) : c2;
    }

    private static char unicodeToLowerCase(char c2) {
        if (c2 < '\u0080') {
            return c2 >= 'A' && c2 <= 'Z' ? (char)(c2 + 32) : c2;
        }
        return Character.toLowerCase(Character.toUpperCase(c2));
    }

    private void compile() {
        char c2;
        char[] p2 = this.pattern;
        int n2 = p2.length;
        int[] s = this.asciiBadCharShift;
        int j2 = 0;
        int k2 = 0;
        int[] max = new int[8];
        int i2 = s.length;
        while (i2-- != 0) {
            s[i2] = n2;
        }
        i2 = 8;
        while (i2-- != 0) {
            max[i2] = Integer.MAX_VALUE;
        }
        i2 = n2;
        while (i2-- != 0) {
            if ((c2 = p2[j2++]) < '\u0080') {
                s[c2] = i2;
                continue;
            }
            ++k2;
            int h2 = c2 * 1640531525;
            int l2 = 8;
            while (l2-- != 0 && h2 <= max[l2]) {
            }
            if (++l2 >= 8 || h2 == max[l2]) continue;
            System.arraycopy(max, l2, max, l2 + 1, 8 - l2 - 1);
            max[l2] = h2;
        }
        int log2m = (k2 = Math.min(k2, (int)(0x800000000L / (0x80000000L + (long)max[7])))) == 0 ? 0 : Math.min(Math.max(Fast.mostSignificantBit(k2 * 3) + 1, 7), 16);
        int m2 = (1 << log2m) - 1;
        int hs = 16 - log2m;
        s = new int[m2 + 1];
        i2 = m2 + 1;
        while (i2-- != 0) {
            s[i2] = n2;
        }
        i2 = n2;
        j2 = 0;
        while (i2-- != 0) {
            if ((c2 = p2[j2++]) < '\u0080') continue;
            s[c2 * c2 & m2] = i2;
            s[c2 * 1640531525 >> hs & m2] = i2;
        }
        this.badCharShift = s;
        this.mask = m2;
        this.hashShift = hs;
    }

    @Override
    public int length() {
        return this.pattern.length;
    }

    @Override
    public char charAt(int i2) {
        return this.pattern[i2];
    }

    @Override
    public CharSequence subSequence(int from, int to) {
        return new MutableString(this.pattern, from, to - from + 1);
    }

    private int indexOf(char[] array, int from, int to) {
        int i2;
        char[] a2 = array;
        char c2 = this.pattern[0];
        int n2 = i2 = from < 0 ? -1 : from - 1;
        if (this.caseSensitive) {
            while (++i2 < to) {
                if (a2[i2] != c2) continue;
                return i2;
            }
            return -1;
        }
        if (this.asciiCase) {
            while (++i2 < to) {
                if (TextPattern.asciiToLowerCase(a2[i2]) != c2) continue;
                return i2;
            }
            return -1;
        }
        while (++i2 < to) {
            if (TextPattern.unicodeToLowerCase(a2[i2]) != c2) continue;
            return i2;
        }
        return -1;
    }

    private int indexOf(CharSequence s, int from, int to) {
        int i2;
        char c2 = this.pattern[0];
        int n2 = i2 = from < 0 ? -1 : from - 1;
        if (this.caseSensitive) {
            while (++i2 < to) {
                if (s.charAt(i2) != c2) continue;
                return i2;
            }
            return -1;
        }
        if (this.asciiCase) {
            while (++i2 < to) {
                if (TextPattern.asciiToLowerCase(s.charAt(i2)) != c2) continue;
                return i2;
            }
            return -1;
        }
        while (++i2 < to) {
            if (TextPattern.unicodeToLowerCase(s.charAt(i2)) != c2) continue;
            return i2;
        }
        return -1;
    }

    private int indexOf(byte[] array, int from, int to) {
        int i2;
        byte[] a2 = array;
        char c2 = this.pattern[0];
        int n2 = i2 = from < 0 ? -1 : from - 1;
        if (this.caseSensitive) {
            while (++i2 < to) {
                if ((a2[i2] & 0xFF) != c2) continue;
                return i2;
            }
            return -1;
        }
        while (++i2 < to) {
            if (TextPattern.asciiToLowerCase((char)(a2[i2] & 0xFF)) != c2) continue;
            return i2;
        }
        return -1;
    }

    public int search(char[] array) {
        return this.search(array, 0, array.length);
    }

    public int search(char[] array, int from) {
        return this.search(array, from, array.length);
    }

    public int search(char[] a2, int from, int to) {
        int j2;
        int n2 = this.pattern.length;
        if (n2 == 0) {
            return from > to ? to : (from < 0 ? 0 : from);
        }
        if (n2 == 1) {
            return this.indexOf(a2, from, to);
        }
        char[] p2 = this.pattern;
        char last = p2[n2 - 1];
        int m1 = to - 1;
        int[] shift = this.badCharShift;
        int[] asciiShift = this.asciiBadCharShift;
        int m2 = this.mask;
        int hs = this.hashShift;
        int i2 = (from < 0 ? 0 : from) + n2 - 1;
        if (this.caseSensitive) {
            int j3;
            while (i2 < m1) {
                char c2;
                int k2;
                if (a2[i2] == last) {
                    j3 = n2 - 1;
                    k2 = i2;
                    while (j3-- != 0 && a2[--k2] == p2[j3]) {
                    }
                    if (j3 < 0) {
                        return k2;
                    }
                }
                if ((c2 = a2[++i2]) < '\u0080') {
                    i2 += asciiShift[c2];
                    continue;
                }
                j3 = shift[c2 * c2 & m2];
                k2 = shift[c2 * 1640531525 >> hs & m2];
                i2 += j3 > k2 ? j3 : k2;
            }
            if (i2 == m1) {
                j3 = n2;
                while (j3-- != 0 && a2[i2--] == p2[j3]) {
                }
                if (j3 < 0) {
                    return i2 + 1;
                }
            }
            return -1;
        }
        if (this.asciiCase) {
            int j4;
            while (i2 < m1) {
                char c3;
                int k3;
                if (TextPattern.asciiToLowerCase(a2[i2]) == last) {
                    j4 = n2 - 1;
                    k3 = i2;
                    while (j4-- != 0 && TextPattern.asciiToLowerCase(a2[--k3]) == p2[j4]) {
                    }
                    if (j4 < 0) {
                        return k3;
                    }
                }
                if ((c3 = TextPattern.asciiToLowerCase(a2[++i2])) < '\u0080') {
                    i2 += asciiShift[c3];
                    continue;
                }
                j4 = shift[c3 * c3 & m2];
                k3 = shift[c3 * 1640531525 >> hs & m2];
                i2 += j4 > k3 ? j4 : k3;
            }
            if (i2 == m1) {
                j4 = n2;
                while (j4-- != 0 && TextPattern.asciiToLowerCase(a2[i2--]) == p2[j4]) {
                }
                if (j4 < 0) {
                    return i2 + 1;
                }
            }
            return -1;
        }
        while (i2 < m1) {
            char c4;
            int k4;
            if (TextPattern.unicodeToLowerCase(a2[i2]) == last) {
                j2 = n2 - 1;
                k4 = i2;
                while (j2-- != 0 && TextPattern.unicodeToLowerCase(a2[--k4]) == p2[j2]) {
                }
                if (j2 < 0) {
                    return k4;
                }
            }
            if ((c4 = TextPattern.unicodeToLowerCase(a2[++i2])) < '\u0080') {
                i2 += asciiShift[c4];
                continue;
            }
            j2 = shift[c4 * c4 & m2];
            k4 = shift[c4 * 1640531525 >> hs & m2];
            i2 += j2 > k4 ? j2 : k4;
        }
        if (i2 == m1) {
            j2 = n2;
            while (j2-- != 0 && TextPattern.unicodeToLowerCase(a2[i2--]) == p2[j2]) {
            }
            if (j2 < 0) {
                return i2 + 1;
            }
        }
        return -1;
    }

    public int search(CharSequence s) {
        return this.search(s, 0, s.length());
    }

    public int search(CharSequence s, int from) {
        return this.search(s, from, s.length());
    }

    public int search(CharSequence s, int from, int to) {
        int j2;
        int n2 = this.pattern.length;
        if (n2 == 0) {
            return from > to ? to : (from < 0 ? 0 : from);
        }
        if (n2 == 1) {
            return this.indexOf(s, from, to);
        }
        char[] p2 = this.pattern;
        char last = p2[n2 - 1];
        int m1 = to - 1;
        int[] shift = this.badCharShift;
        int[] asciiShift = this.asciiBadCharShift;
        int m2 = this.mask;
        int hs = this.hashShift;
        int i2 = (from < 0 ? 0 : from) + n2 - 1;
        if (this.caseSensitive) {
            int j3;
            while (i2 < m1) {
                char c2;
                int k2;
                if (s.charAt(i2) == last) {
                    j3 = n2 - 1;
                    k2 = i2;
                    while (j3-- != 0 && s.charAt(--k2) == p2[j3]) {
                    }
                    if (j3 < 0) {
                        return k2;
                    }
                }
                if ((c2 = s.charAt(++i2)) < '\u0080') {
                    i2 += asciiShift[c2];
                    continue;
                }
                j3 = shift[c2 * c2 & m2];
                k2 = shift[c2 * 1640531525 >> hs & m2];
                i2 += j3 > k2 ? j3 : k2;
            }
            if (i2 == m1) {
                j3 = n2;
                while (j3-- != 0 && s.charAt(i2--) == p2[j3]) {
                }
                if (j3 < 0) {
                    return i2 + 1;
                }
            }
            return -1;
        }
        if (this.asciiCase) {
            int j4;
            while (i2 < m1) {
                char c3;
                int k3;
                if (TextPattern.asciiToLowerCase(s.charAt(i2)) == last) {
                    j4 = n2 - 1;
                    k3 = i2;
                    while (j4-- != 0 && TextPattern.asciiToLowerCase(s.charAt(--k3)) == p2[j4]) {
                    }
                    if (j4 < 0) {
                        return k3;
                    }
                }
                if ((c3 = TextPattern.asciiToLowerCase(s.charAt(++i2))) < '\u0080') {
                    i2 += asciiShift[c3];
                    continue;
                }
                j4 = shift[c3 * c3 & m2];
                k3 = shift[c3 * 1640531525 >> hs & m2];
                i2 += j4 > k3 ? j4 : k3;
            }
            if (i2 == m1) {
                j4 = n2;
                while (j4-- != 0 && TextPattern.asciiToLowerCase(s.charAt(i2--)) == p2[j4]) {
                }
                if (j4 < 0) {
                    return i2 + 1;
                }
            }
            return -1;
        }
        while (i2 < m1) {
            char c4;
            int k4;
            if (TextPattern.unicodeToLowerCase(s.charAt(i2)) == last) {
                j2 = n2 - 1;
                k4 = i2;
                while (j2-- != 0 && TextPattern.unicodeToLowerCase(s.charAt(--k4)) == p2[j2]) {
                }
                if (j2 < 0) {
                    return k4;
                }
            }
            if ((c4 = TextPattern.unicodeToLowerCase(s.charAt(++i2))) < '\u0080') {
                i2 += asciiShift[c4];
                continue;
            }
            j2 = shift[c4 * c4 & m2];
            k4 = shift[c4 * 1640531525 >> hs & m2];
            i2 += j2 > k4 ? j2 : k4;
        }
        if (i2 == m1) {
            j2 = n2;
            while (j2-- != 0 && TextPattern.unicodeToLowerCase(s.charAt(i2--)) == p2[j2]) {
            }
            if (j2 < 0) {
                return i2 + 1;
            }
        }
        return -1;
    }

    public int search(byte[] a2) {
        return this.search(a2, 0, a2.length);
    }

    public int search(byte[] a2, int from) {
        return this.search(a2, from, a2.length);
    }

    public int search(byte[] a2, int from, int to) {
        int j2;
        int n2 = this.pattern.length;
        if (n2 == 0) {
            return from > to ? to : (from < 0 ? 0 : from);
        }
        if (n2 == 1) {
            return this.indexOf(a2, from, to);
        }
        char[] p2 = this.pattern;
        char last = p2[n2 - 1];
        int m1 = to - 1;
        int[] shift = this.badCharShift;
        int[] asciiShift = this.asciiBadCharShift;
        int m2 = this.mask;
        int hs = this.hashShift;
        int i2 = (from < 0 ? 0 : from) + n2 - 1;
        if (this.caseSensitive) {
            int j3;
            while (i2 < m1) {
                char c2;
                int k2;
                if ((a2[i2] & 0xFF) == last) {
                    j3 = n2 - 1;
                    k2 = i2;
                    while (j3-- != 0 && (a2[--k2] & 0xFF) == p2[j3]) {
                    }
                    if (j3 < 0) {
                        return k2;
                    }
                }
                if ((c2 = (char)(a2[++i2] & 0xFF)) < '\u0080') {
                    i2 += asciiShift[c2];
                    continue;
                }
                j3 = shift[c2 * c2 & m2];
                k2 = shift[c2 * 1640531525 >> hs & m2];
                i2 += j3 > k2 ? j3 : k2;
            }
            if (i2 == m1) {
                j3 = n2;
                while (j3-- != 0 && (a2[i2--] & 0xFF) == p2[j3]) {
                }
                if (j3 < 0) {
                    return i2 + 1;
                }
            }
            return -1;
        }
        if (this.asciiCase) {
            int j4;
            while (i2 < m1) {
                char c3;
                int k3;
                if (TextPattern.asciiToLowerCase((char)(a2[i2] & 0xFF)) == last) {
                    j4 = n2 - 1;
                    k3 = i2;
                    while (j4-- != 0 && TextPattern.asciiToLowerCase((char)(a2[--k3] & 0xFF)) == p2[j4]) {
                    }
                    if (j4 < 0) {
                        return k3;
                    }
                }
                if ((c3 = TextPattern.asciiToLowerCase((char)(a2[++i2] & 0xFF))) < '\u0080') {
                    i2 += asciiShift[c3];
                    continue;
                }
                j4 = shift[c3 * c3 & m2];
                k3 = shift[c3 * 1640531525 >> hs & m2];
                i2 += j4 > k3 ? j4 : k3;
            }
            if (i2 == m1) {
                j4 = n2;
                while (j4-- != 0 && TextPattern.asciiToLowerCase((char)(a2[i2--] & 0xFF)) == p2[j4]) {
                }
                if (j4 < 0) {
                    return i2 + 1;
                }
            }
            return -1;
        }
        while (i2 < m1) {
            char c4;
            int k4;
            if (TextPattern.unicodeToLowerCase((char)(a2[i2] & 0xFF)) == last) {
                j2 = n2 - 1;
                k4 = i2;
                while (j2-- != 0 && TextPattern.unicodeToLowerCase((char)(a2[--k4] & 0xFF)) == p2[j2]) {
                }
                if (j2 < 0) {
                    return k4;
                }
            }
            if ((c4 = TextPattern.unicodeToLowerCase((char)(a2[++i2] & 0xFF))) < '\u0080') {
                i2 += asciiShift[c4];
                continue;
            }
            j2 = shift[c4 * c4 & m2];
            k4 = shift[c4 * 1640531525 >> hs & m2];
            i2 += j2 > k4 ? j2 : k4;
        }
        if (i2 == m1) {
            j2 = n2;
            while (j2-- != 0 && TextPattern.unicodeToLowerCase((char)(a2[i2--] & 0xFF)) == p2[j2]) {
            }
            if (j2 < 0) {
                return i2 + 1;
            }
        }
        return -1;
    }

    public int search(CharList list) {
        return this.search(list, 0, list.size());
    }

    public int search(CharList list, int from) {
        return this.search(list, from, list.size());
    }

    public int search(CharList list, int from, int to) {
        int j2;
        int n2 = this.pattern.length;
        if (n2 == 0) {
            return from > to ? to : (from < 0 ? 0 : from);
        }
        if (n2 == 1) {
            return list.subList(from, to).indexOf(this.pattern[0]);
        }
        char[] p2 = this.pattern;
        char last = p2[n2 - 1];
        int m1 = to - 1;
        int[] shift = this.badCharShift;
        int[] asciiShift = this.asciiBadCharShift;
        int m2 = this.mask;
        int hs = this.hashShift;
        int i2 = (from < 0 ? 0 : from) + n2 - 1;
        if (this.caseSensitive) {
            int j3;
            while (i2 < m1) {
                char c2;
                int k2;
                if (list.getChar(i2) == last) {
                    j3 = n2 - 1;
                    k2 = i2;
                    while (j3-- != 0 && list.getChar(--k2) == p2[j3]) {
                    }
                    if (j3 < 0) {
                        return k2;
                    }
                }
                if ((c2 = list.getChar(++i2)) < '\u0080') {
                    i2 += asciiShift[c2];
                    continue;
                }
                j3 = shift[c2 * c2 & m2];
                k2 = shift[c2 * 1640531525 >> hs & m2];
                i2 += j3 > k2 ? j3 : k2;
            }
            if (i2 == m1) {
                j3 = n2;
                while (j3-- != 0 && list.getChar(i2--) == p2[j3]) {
                }
                if (j3 < 0) {
                    return i2 + 1;
                }
            }
            return -1;
        }
        if (this.asciiCase) {
            int j4;
            while (i2 < m1) {
                char c3;
                int k3;
                if (TextPattern.asciiToLowerCase(list.getChar(i2)) == last) {
                    j4 = n2 - 1;
                    k3 = i2;
                    while (j4-- != 0 && TextPattern.asciiToLowerCase(list.getChar(--k3)) == p2[j4]) {
                    }
                    if (j4 < 0) {
                        return k3;
                    }
                }
                if ((c3 = TextPattern.asciiToLowerCase(list.getChar(++i2))) < '\u0080') {
                    i2 += asciiShift[c3];
                    continue;
                }
                j4 = shift[c3 * c3 & m2];
                k3 = shift[c3 * 1640531525 >> hs & m2];
                i2 += j4 > k3 ? j4 : k3;
            }
            if (i2 == m1) {
                j4 = n2;
                while (j4-- != 0 && TextPattern.asciiToLowerCase(list.getChar(i2--)) == p2[j4]) {
                }
                if (j4 < 0) {
                    return i2 + 1;
                }
            }
            return -1;
        }
        while (i2 < m1) {
            char c4;
            int k4;
            if (TextPattern.unicodeToLowerCase(list.getChar(i2)) == last) {
                j2 = n2 - 1;
                k4 = i2;
                while (j2-- != 0 && TextPattern.unicodeToLowerCase(list.getChar(--k4)) == p2[j2]) {
                }
                if (j2 < 0) {
                    return k4;
                }
            }
            if ((c4 = TextPattern.unicodeToLowerCase(list.getChar(++i2))) < '\u0080') {
                i2 += asciiShift[c4];
                continue;
            }
            j2 = shift[c4 * c4 & m2];
            k4 = shift[c4 * 1640531525 >> hs & m2];
            i2 += j2 > k4 ? j2 : k4;
        }
        if (i2 == m1) {
            j2 = n2;
            while (j2-- != 0 && TextPattern.unicodeToLowerCase(list.getChar(i2--)) == p2[j2]) {
            }
            if (j2 < 0) {
                return i2 + 1;
            }
        }
        return -1;
    }

    public final boolean equals(Object o2) {
        if (o2 instanceof TextPattern) {
            TextPattern p2 = (TextPattern)o2;
            return this.caseSensitive == p2.caseSensitive && this.asciiCase == p2.asciiCase && Arrays.equals(p2.pattern, this.pattern);
        }
        return false;
    }

    public final int hashCode() {
        char[] a2 = this.pattern;
        int l2 = a2.length;
        int h2 = 0;
        for (int i2 = 0; i2 < l2; ++i2) {
            h2 = 31 * h2 + a2[i2];
        }
        return h2;
    }

    @Override
    public final String toString() {
        return new String(this.pattern);
    }
}

