/*
 * Decompiled with CFR 0.152.
 */
package org.broad.tribble.source.tabix;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.broad.tribble.TribbleException;
import org.broad.tribble.readers.LineReader;
import org.broad.tribble.source.query.QuerySource;
import org.broad.tribble.source.tabix.TabixReader;

public final class TabixLineReader
implements LineReader,
QuerySource {
    private final TabixReader reader;
    private final String source;

    public TabixLineReader(String source) {
        this.source = source;
        try {
            this.reader = new TabixReader(source);
        }
        catch (IOException e2) {
            e2.printStackTrace();
            throw new TribbleException.TabixReaderFailure("Unable to generate TabixReader given the input source ", source, e2);
        }
    }

    @Override
    public String readLine() throws IOException {
        return this.reader.readLine();
    }

    @Override
    public LineReader iterate() throws IOException {
        return this;
    }

    @Override
    public void mark() {
        throw new UnsupportedOperationException("Unable to mark/reset position in a TABIX line reader");
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public void reset() {
        throw new UnsupportedOperationException("Unable to mark/reset position in a TABIX line reader");
    }

    @Override
    public LineReader query(String chr, int start, int end) {
        List<String> mp = this.getSequenceNames();
        if (mp == null) {
            throw new TribbleException.TabixReaderFailure("Unable to find contig named " + chr + " in the tabix index", this.source);
        }
        if (!mp.contains(chr)) {
            return null;
        }
        return new TabixIteratorToLineReader(this.reader.query(this.reader.mChr2tid.get(chr), start - 1, end));
    }

    @Override
    public void close() {
        try {
            this.reader.mFp.close();
        }
        catch (IOException e2) {
            throw new TribbleException("Unable to close file source " + this.source, e2);
        }
    }

    @Override
    public List<String> getSequenceNames() {
        return new ArrayList<String>(this.reader.mChr2tid.keySet());
    }

    public List<String> getContigNames() {
        return new ArrayList<String>(this.reader.mChr2tid.keySet());
    }

    class TabixIteratorToLineReader
    implements LineReader {
        private final TabixReader.Iterator it;

        public TabixIteratorToLineReader(TabixReader.Iterator it) {
            this.it = it;
        }

        @Override
        public String readLine() throws IOException {
            if (this.it == null) {
                return null;
            }
            return this.it.next();
        }

        @Override
        public void close() {
        }
    }
}

