/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.tools;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import net.sf.samtools.util.CloseableIterator;
import org.broad.igv.feature.Chromosome;
import org.broad.igv.feature.Locus;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.sam.Alignment;
import org.broad.igv.sam.AlignmentBlock;
import org.broad.igv.sam.ReadMate;
import org.broad.igv.sam.reader.AlignmentQueryReader;
import org.broad.igv.sam.reader.AlignmentReaderFactory;
import org.broad.igv.sam.reader.MergedAlignmentReader;
import org.broad.igv.tools.PairedEndStats;
import org.broad.igv.tools.parsers.DataConsumer;
import org.broad.igv.ui.filefilters.AlignmentFileFilter;
import org.broad.igv.util.FileUtils;
import org.broad.igv.util.stats.Distribution;

public class CoverageCounter {
    private int countThreshold = 0;
    private int upperExpectedInsertSize = 600;
    private int lowerExpectedInsertSize = 200;
    private Locus interval;
    private String alignmentFile;
    private File tdfFile;
    private DataConsumer consumer;
    private float[] buffer;
    private int windowSize = 1;
    private int minMappingQuality = 0;
    private int strandOption = -1;
    private int extFactor;
    private int totalCount = 0;
    private File wigFile = null;
    private WigWriter wigWriter = null;
    private boolean keepZeroes = false;
    private boolean includeDuplicates = false;
    private Genome genome;
    private String readGroup;
    Map<Event, WigWriter> writers = new HashMap<Event, WigWriter>();
    private boolean computeTDF = true;
    private Distribution coverageHistogram;
    private static final double LOG_1__1 = 0.09531018;

    public CoverageCounter(String alignmentFile, DataConsumer consumer, int windowSize, int extFactor, File tdfFile, File wigFile, Genome genome, String options) {
        this.alignmentFile = alignmentFile;
        this.tdfFile = tdfFile;
        this.consumer = consumer;
        this.windowSize = windowSize;
        this.extFactor = extFactor;
        this.wigFile = wigFile;
        this.genome = genome;
        float[] fArray = this.buffer = this.strandOption < 0 ? new float[1] : new float[2];
        if (options != null) {
            this.parseOptions(options);
        }
    }

    private void parseOptions(String options) {
        try {
            String[] opts;
            for (String opt : opts = options.split(",")) {
                String[] tmp;
                if (opt.startsWith("d")) {
                    this.includeDuplicates = true;
                    continue;
                }
                if (opt.startsWith("m=")) {
                    tmp = opt.split("=");
                    this.minMappingQuality = Integer.parseInt(tmp[1]);
                    System.out.println("Minimum mapping quality = " + this.minMappingQuality);
                    continue;
                }
                if (opt.startsWith("t=")) {
                    tmp = opt.split("=");
                    this.countThreshold = Integer.parseInt(tmp[1]);
                    System.out.println("Count threshold = " + this.countThreshold);
                    continue;
                }
                if (opt.startsWith("l:")) {
                    tmp = opt.split(":");
                    this.readGroup = tmp[1];
                    continue;
                }
                if (opt.startsWith("q")) {
                    tmp = opt.split("@");
                    this.interval = new Locus(tmp[1]);
                    continue;
                }
                if (opt.startsWith("i")) {
                    this.writers.put(Event.largeISize, new WigWriter(new File(this.getFilenameBase() + ".large_isize.wig"), this.windowSize));
                    this.writers.put(Event.smallISize, new WigWriter(new File(this.getFilenameBase() + ".small_isize.wig"), this.windowSize));
                    String[] tokens = opt.split(":");
                    if (tokens.length > 2) {
                        int min = Integer.parseInt(tokens[1]);
                        int max = Integer.parseInt(tokens[2]);
                        this.upperExpectedInsertSize = min;
                        this.lowerExpectedInsertSize = max;
                        continue;
                    }
                    PairedEndStats stats = PairedEndStats.compute(this.alignmentFile);
                    if (stats == null) {
                        System.out.println("Warning: error computing stats.  Using default insert size settings");
                        continue;
                    }
                    this.upperExpectedInsertSize = (int)stats.getMaxPercentileInsertSize();
                    this.lowerExpectedInsertSize = (int)stats.getMinPercentileInsertSize();
                    System.out.println(this.alignmentFile + "  min = " + this.lowerExpectedInsertSize + " max = " + this.upperExpectedInsertSize);
                    continue;
                }
                if (opt.equals("o")) {
                    this.writers.put(Event.inversion, new WigWriter(new File(this.getFilenameBase() + ".inversion.wig"), this.windowSize));
                    this.writers.put(Event.duplication, new WigWriter(new File(this.getFilenameBase() + ".duplication.wig"), this.windowSize));
                    continue;
                }
                if (opt.equals("m")) {
                    this.writers.put(Event.mismatch, new WigWriter(new File(this.getFilenameBase() + ".mismatch.wig"), this.windowSize));
                    continue;
                }
                if (opt.equals("d")) {
                    this.writers.put(Event.indel, new WigWriter(new File(this.getFilenameBase() + ".indel.wig"), this.windowSize));
                    continue;
                }
                if (opt.equals("u")) {
                    this.writers.put(Event.unmappedMate, new WigWriter(new File(this.getFilenameBase() + ".nomate.wig"), this.windowSize));
                    continue;
                }
                if (opt.equals("r")) {
                    this.writers.put(Event.inter, new WigWriter(new File(this.getFilenameBase() + ".inter.wig"), this.windowSize));
                    continue;
                }
                if (opt.equals("h")) {
                    this.coverageHistogram = new Distribution(200);
                    continue;
                }
                if (opt.equals("z")) {
                    this.keepZeroes = true;
                    continue;
                }
                System.out.println("Unknown coverage option: " + opt);
            }
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
    }

    private String getFilenameBase() {
        String tmp = this.tdfFile.getAbsolutePath();
        tmp = tmp.substring(0, tmp.length() - 4);
        if (this.readGroup != null) {
            tmp = tmp + "." + this.readGroup;
        }
        return tmp;
    }

    private boolean passFilter(Alignment alignment) {
        return !(this.readGroup != null && !this.readGroup.equals(alignment.getReadGroup()) || !alignment.isMapped() || !this.includeDuplicates && alignment.isDuplicate() || alignment.getMappingQuality() < this.minMappingQuality || alignment.isVendorFailedRead());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse() throws IOException {
        int tolerance = (int)((double)this.windowSize * (Math.floor(this.extFactor / this.windowSize) + 2.0));
        this.consumer.setSortTolerance(tolerance);
        AlignmentQueryReader reader = null;
        CloseableIterator<Alignment> iter = null;
        String lastChr = "";
        ReadCounter counter = null;
        try {
            if (this.wigFile != null) {
                this.wigWriter = new WigWriter(this.wigFile, this.windowSize);
            }
            if (this.interval == null) {
                reader = this.getReader(this.alignmentFile, false);
                iter = reader.iterator();
            } else {
                reader = this.getReader(this.alignmentFile, true);
                iter = reader.query(this.interval.getChr(), this.interval.getStart(), this.interval.getEnd(), false);
            }
            while (iter != null && iter.hasNext()) {
                AlignmentBlock[] blocks;
                Alignment alignment = (Alignment)iter.next();
                if (!this.passFilter(alignment)) continue;
                ++this.totalCount;
                String alignmentChr = alignment.getChr();
                if (alignmentChr.equals(lastChr)) {
                    if (counter != null) {
                        counter.closeBucketsBefore(alignment.getAlignmentStart() - tolerance);
                    }
                } else {
                    if (counter != null) {
                        counter.closeBucketsBefore(Integer.MAX_VALUE);
                    }
                    counter = new ReadCounter(alignmentChr);
                    lastChr = alignmentChr;
                }
                if (alignment.getMappingQuality() != 0 && alignment.isPaired()) {
                    boolean sameChromosome;
                    int start = alignment.getStart();
                    int end = alignment.getEnd();
                    counter.incrementPairedCount(start, end);
                    ReadMate mate = alignment.getMate();
                    boolean mateMapped = mate != null && mate.isMapped();
                    boolean bl = sameChromosome = mateMapped && mate.getChr().equals(alignment.getChr());
                    if (mateMapped) {
                        if (sameChromosome) {
                            String oStr = alignment.getPairOrientation();
                            if (oStr.equals("R1F2") || oStr.equals("R2F1")) {
                                counter.incrementPairedEvent(start, end, Event.duplication);
                            } else if (oStr.equals("F1F2") || oStr.equals("F2F1") || oStr.equals("R1R2") || oStr.equals("R2R1")) {
                                counter.incrementPairedEvent(start, end, Event.inversion);
                            }
                            int isize = Math.abs(alignment.getInferredInsertSize());
                            if (isize > this.upperExpectedInsertSize) {
                                counter.incrementPairedEvent(start, end, Event.largeISize);
                            }
                            if (isize < this.lowerExpectedInsertSize) {
                                counter.incrementPairedEvent(start, end, Event.smallISize);
                            }
                        } else {
                            counter.incrementPairedEvent(start, end, Event.inter);
                        }
                    } else {
                        counter.incrementPairedEvent(start, end, Event.unmappedMate);
                    }
                }
                if ((blocks = alignment.getAlignmentBlocks()) != null) {
                    int lastBlockEnd = -1;
                    for (AlignmentBlock block : blocks) {
                        if (block.isSoftClipped()) continue;
                        if (lastBlockEnd >= 0) {
                            String c2 = alignment.getCigarString();
                            int s = block.getStart();
                            if (s > lastBlockEnd) {
                                counter.incrementEvent(lastBlockEnd, Event.indel);
                            }
                        }
                        byte[] bases = block.getBases();
                        int blockStart = block.getStart();
                        int adjustedStart = block.getStart();
                        int adjustedEnd = block.getEnd();
                        if (alignment.isNegativeStrand()) {
                            adjustedStart = Math.max(0, adjustedStart - this.extFactor);
                        } else {
                            adjustedEnd += this.extFactor;
                        }
                        if (this.interval != null) {
                            adjustedStart = Math.max(this.interval.getStart() - 1, adjustedStart);
                            adjustedEnd = Math.min(this.interval.getEnd(), adjustedEnd);
                        }
                        for (int pos = adjustedStart; pos < adjustedEnd; ++pos) {
                            int idx;
                            byte base = 0;
                            int baseIdx = pos - blockStart;
                            if (bases != null && baseIdx >= 0 && baseIdx < bases.length) {
                                base = bases[baseIdx];
                            }
                            byte quality = (idx = pos - blockStart) >= 0 && idx < block.qualities.length ? block.qualities[pos - blockStart] : (byte)0;
                            counter.incrementCount(pos, base, quality);
                        }
                        lastBlockEnd = block.getEnd();
                    }
                } else {
                    int adjustedStart = alignment.getAlignmentStart();
                    int adjustedEnd = alignment.getAlignmentEnd();
                    if (alignment.isNegativeStrand()) {
                        adjustedStart = Math.max(0, adjustedStart - this.extFactor);
                    } else {
                        adjustedEnd += this.extFactor;
                    }
                    if (this.interval != null) {
                        adjustedStart = Math.max(this.interval.getStart() - 1, adjustedStart);
                        adjustedEnd = Math.min(this.interval.getEnd(), adjustedEnd);
                    }
                    for (int pos = adjustedStart; pos < adjustedEnd; ++pos) {
                        counter.incrementCount(pos, (byte)0, (byte)0);
                    }
                }
                if (!this.writers.containsKey((Object)Event.indel)) continue;
                for (AlignmentBlock block : alignment.getInsertions()) {
                    if (this.interval != null && (block.getStart() < this.interval.getStart() - 1 || block.getStart() > this.interval.getEnd())) continue;
                    counter.incrementEvent(block.getStart(), Event.indel);
                }
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        finally {
            if (counter != null) {
                counter.closeBucketsBefore(Integer.MAX_VALUE);
            }
            this.consumer.setAttribute("totalCount", String.valueOf(this.totalCount));
            this.consumer.parsingComplete();
            if (iter != null) {
                iter.close();
            }
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e3) {
                    e3.printStackTrace();
                }
            }
            if (this.wigWriter != null) {
                this.wigWriter.close();
            }
            for (WigWriter writer : this.writers.values()) {
                writer.close();
            }
            if (this.coverageHistogram != null) {
                try {
                    PrintWriter pw = new PrintWriter(new FileWriter(this.getFilenameBase() + ".hist.txt"));
                    this.coverageHistogram.print(pw);
                    pw.close();
                }
                catch (IOException e4) {
                    e4.printStackTrace();
                }
            }
        }
    }

    private AlignmentQueryReader getReader(String alignmentFile, boolean b2) throws IOException {
        File f2;
        boolean isList;
        boolean bl = isList = alignmentFile.indexOf(",") > 0;
        if (isList) {
            String[] tokens = alignmentFile.split(",");
            ArrayList<AlignmentQueryReader> readers = new ArrayList<AlignmentQueryReader>(tokens.length);
            for (String f3 : tokens) {
                readers.add(AlignmentReaderFactory.getReader(f3, b2));
            }
            return new MergedAlignmentReader(readers);
        }
        if (!FileUtils.isRemote(alignmentFile) && (f2 = new File(alignmentFile)).isDirectory()) {
            ArrayList<AlignmentQueryReader> readers = new ArrayList<AlignmentQueryReader>();
            for (File file : f2.listFiles(new AlignmentFileFilter())) {
                readers.add(AlignmentReaderFactory.getReader(file.getAbsolutePath(), b2));
            }
            return new MergedAlignmentReader(readers);
        }
        return AlignmentReaderFactory.getReader(alignmentFile, b2);
    }

    class WigWriter {
        Event event = null;
        String lastChr = null;
        int lastPosition = 0;
        int step;
        int span;
        PrintWriter pw;

        WigWriter(File file, int step) throws IOException {
            this.step = step;
            this.span = step;
            this.pw = new PrintWriter(new FileWriter(file));
        }

        WigWriter(File file, int step, Event event) throws IOException {
            this.step = step;
            this.span = step;
            this.pw = new PrintWriter(new FileWriter(file));
            this.event = event;
        }

        public void addData(String chr, int start, int end, float data) {
            if (Float.isNaN(data)) {
                return;
            }
            if (CoverageCounter.this.genome.getChromosome(chr) == null) {
                return;
            }
            if (!CoverageCounter.this.keepZeroes && data == 0.0f || end <= start) {
                return;
            }
            int dataSpan = end - start;
            if (chr == null || !chr.equals(this.lastChr) || dataSpan != this.span) {
                this.span = dataSpan;
                this.outputStepLine(chr, start + 1);
            }
            this.pw.println(start + 1 + "\t" + data);
            this.lastPosition = start;
            this.lastChr = chr;
        }

        private void close() {
            this.pw.close();
        }

        private void outputStepLine(String chr, int start) {
            this.pw.println("variableStep chrom=" + chr + " span=" + this.span);
        }
    }

    class Counter {
        int count = 0;
        int negCount = 0;
        int qualityCount = 0;
        float pairedCount = 0.0f;
        float mismatchCount = 0.0f;
        float indelCount = 0.0f;
        float largeISizeCount = 0.0f;
        float smallISizeCount = 0.0f;
        float inversionCount = 0.0f;
        float duplicationCount = 0.0f;
        float unmappedMate = 0.0f;
        float interChrCount = 0.0f;
        float totalISizeCount = 0.0f;
        String chr;
        int start;
        int end;
        byte[] ref;
        int[] baseCount;

        Counter(String chr, int start, int end) {
            this.chr = chr;
            this.start = start;
            this.end = end;
            this.baseCount = new int[end - start];
        }

        int getCount() {
            return this.count;
        }

        int getNegCount() {
            return this.negCount;
        }

        void incrementNeg() {
            ++this.negCount;
        }

        void incrementPairedCount(float frac) {
            this.pairedCount += frac;
        }

        public int[] getBaseCount() {
            return this.baseCount;
        }

        void increment(int position, byte base, byte quality) {
            byte refBase;
            int offset;
            int n2 = offset = position - this.start;
            this.baseCount[n2] = this.baseCount[n2] + 1;
            if (this.ref != null && this.ref.length > offset && (refBase = this.ref[offset]) != base) {
                this.mismatchCount += (float)quality;
            }
            ++this.count;
            this.qualityCount += quality;
        }

        void incrementEvent(Event evt, float frac) {
            switch (evt) {
                case indel: {
                    this.indelCount += frac;
                    break;
                }
                case largeISize: {
                    this.largeISizeCount += frac;
                    break;
                }
                case smallISize: {
                    this.smallISizeCount += frac;
                    break;
                }
                case inversion: {
                    this.inversionCount += frac;
                    break;
                }
                case duplication: {
                    this.duplicationCount += frac;
                    break;
                }
                case inter: {
                    this.interChrCount += frac;
                    break;
                }
                case unmappedMate: {
                    this.unmappedMate += frac;
                }
            }
        }

        public float getEventScore(Event evt) {
            switch (evt) {
                case mismatch: {
                    return this.qualityCount < 25 ? 0.0f : this.mismatchCount / (float)this.qualityCount;
                }
                case indel: {
                    return this.count < 5 ? 0.0f : this.indelCount / (float)this.count;
                }
                case largeISize: {
                    return this.pairedCount < 5.0f ? 0.0f : this.largeISizeCount / this.pairedCount;
                }
                case smallISize: {
                    return this.pairedCount < 5.0f ? 0.0f : this.smallISizeCount / this.pairedCount;
                }
                case inversion: {
                    return this.pairedCount < 5.0f ? 0.0f : this.inversionCount / this.pairedCount;
                }
                case duplication: {
                    return this.pairedCount < 5.0f ? 0.0f : this.duplicationCount / this.pairedCount;
                }
                case inter: {
                    return this.pairedCount < 5.0f ? 0.0f : this.interChrCount / this.pairedCount;
                }
                case unmappedMate: {
                    return this.pairedCount < 5.0f ? 0.0f : this.unmappedMate / this.pairedCount;
                }
            }
            throw new RuntimeException("Unknown event type: " + (Object)((Object)evt));
        }

        public void incrementISize(int inferredInsertSize) {
            this.totalISizeCount += 1.0f;
            if (inferredInsertSize > 600) {
                this.largeISizeCount += 1.0f;
            } else if (inferredInsertSize < 200) {
                this.smallISizeCount += 1.0f;
            }
        }
    }

    class ReadCounter {
        String chr;
        TreeMap<Integer, Counter> counts = new TreeMap();

        ReadCounter(String chr) {
            this.chr = chr;
        }

        void incrementCount(int position, byte base, byte quality) {
            Counter counter = this.getCounterForPosition(position);
            counter.increment(position, base, quality);
        }

        void incrementEvent(int position, Event type) {
            Counter counter = this.getCounterForPosition(position);
            counter.incrementEvent(type, 1.0f);
        }

        void incrementPairedCount(int start, int end) {
            int startIdx = start / CoverageCounter.this.windowSize;
            int endIdx = end / CoverageCounter.this.windowSize;
            for (int idx = startIdx; idx <= endIdx; ++idx) {
                Counter counter = this.getCounter(idx);
                counter.incrementPairedCount(this.fractionOverlap(counter, start, end));
            }
        }

        void incrementPairedEvent(int start, int end, Event type) {
            int startIdx = start / CoverageCounter.this.windowSize;
            int endIdx = end / CoverageCounter.this.windowSize;
            for (int idx = startIdx; idx <= endIdx; ++idx) {
                Counter counter = this.getCounter(idx);
                counter.incrementEvent(type, this.fractionOverlap(counter, start, end));
            }
        }

        float fractionOverlap(Counter counter, int start, int end) {
            float counterLength = counter.end - counter.start;
            float overlapLength = Math.min(end, counter.end) - Math.max(start, counter.start);
            return overlapLength / counterLength;
        }

        private Counter getCounterForPosition(int position) {
            int idx = position / CoverageCounter.this.windowSize;
            return this.getCounter(idx);
        }

        private Counter getCounter(int idx) {
            if (!this.counts.containsKey(idx)) {
                int counterStartPosition = idx * CoverageCounter.this.windowSize;
                int counterEndPosition = counterStartPosition + CoverageCounter.this.windowSize;
                this.counts.put(idx, new Counter(this.chr, counterStartPosition, counterEndPosition));
            }
            Counter counter = this.counts.get(idx);
            return counter;
        }

        void closeBucketsBefore(int position) {
            ArrayList<Integer> bucketsToClose = new ArrayList<Integer>();
            Integer bucket = position / CoverageCounter.this.windowSize;
            for (Map.Entry<Integer, Counter> entry : this.counts.entrySet()) {
                if (entry.getKey() >= bucket) continue;
                Counter counter = entry.getValue();
                int totalCount = counter.getCount();
                if (totalCount > CoverageCounter.this.countThreshold) {
                    Chromosome chromosome;
                    int bucketStartPosition = entry.getKey() * CoverageCounter.this.windowSize;
                    int bucketEndPosition = bucketStartPosition + CoverageCounter.this.windowSize;
                    if (CoverageCounter.this.genome != null && (chromosome = CoverageCounter.this.genome.getChromosome(this.chr)) != null) {
                        bucketEndPosition = Math.min(bucketEndPosition, chromosome.getLength());
                    }
                    int bucketSize = bucketEndPosition - bucketStartPosition;
                    ((CoverageCounter)CoverageCounter.this).buffer[0] = (float)totalCount / (float)bucketSize;
                    if (CoverageCounter.this.strandOption > 0) {
                        ((CoverageCounter)CoverageCounter.this).buffer[1] = (float)counter.getCount() / (float)bucketSize;
                    }
                    CoverageCounter.this.consumer.addData(this.chr, bucketStartPosition, bucketEndPosition, CoverageCounter.this.buffer, null);
                    for (Map.Entry<Event, WigWriter> entries : CoverageCounter.this.writers.entrySet()) {
                        Event evt = entries.getKey();
                        WigWriter writer = entries.getValue();
                        float score = counter.getEventScore(evt);
                        writer.addData(this.chr, bucketStartPosition, bucketEndPosition, score);
                    }
                    if (CoverageCounter.this.wigWriter != null) {
                        CoverageCounter.this.wigWriter.addData(this.chr, bucketStartPosition, bucketEndPosition, CoverageCounter.this.buffer[0]);
                    }
                }
                bucketsToClose.add(entry.getKey());
            }
            for (Integer key : bucketsToClose) {
                this.counts.remove(key);
            }
        }
    }

    static enum Event {
        mismatch,
        indel,
        largeISize,
        smallISize,
        inversion,
        duplication,
        inter,
        unmappedMate;

    }
}

