/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.gvt;

import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.apache.batik.gvt.ShapePainter;

public class CompositeShapePainter
implements ShapePainter {
    protected Shape shape;
    protected ShapePainter[] painters;
    protected int count;

    public CompositeShapePainter(Shape shape) {
        if (shape == null) {
            throw new IllegalArgumentException();
        }
        this.shape = shape;
    }

    public void addShapePainter(ShapePainter shapePainter) {
        if (shapePainter == null) {
            return;
        }
        if (this.shape != shapePainter.getShape()) {
            shapePainter.setShape(this.shape);
        }
        if (this.painters == null) {
            this.painters = new ShapePainter[2];
        }
        if (this.count == this.painters.length) {
            ShapePainter[] newPainters = new ShapePainter[this.count + this.count / 2 + 1];
            System.arraycopy(this.painters, 0, newPainters, 0, this.count);
            this.painters = newPainters;
        }
        this.painters[this.count++] = shapePainter;
    }

    public ShapePainter getShapePainter(int index) {
        return this.painters[index];
    }

    public int getShapePainterCount() {
        return this.count;
    }

    public void paint(Graphics2D g2d) {
        if (this.painters != null) {
            int i2 = 0;
            while (i2 < this.count) {
                this.painters[i2].paint(g2d);
                ++i2;
            }
        }
    }

    public Shape getPaintedArea() {
        if (this.painters == null) {
            return null;
        }
        Area paintedArea = new Area();
        int i2 = 0;
        while (i2 < this.count) {
            Shape s = this.painters[i2].getPaintedArea();
            if (s != null) {
                paintedArea.add(new Area(s));
            }
            ++i2;
        }
        return paintedArea;
    }

    public Rectangle2D getPaintedBounds2D() {
        if (this.painters == null) {
            return null;
        }
        Rectangle2D bounds = null;
        int i2 = 0;
        while (i2 < this.count) {
            Rectangle2D pb = this.painters[i2].getPaintedBounds2D();
            if (pb != null) {
                if (bounds == null) {
                    bounds = (Rectangle2D)pb.clone();
                } else {
                    bounds.add(pb);
                }
            }
            ++i2;
        }
        return bounds;
    }

    public boolean inPaintedArea(Point2D pt) {
        if (this.painters == null) {
            return false;
        }
        int i2 = 0;
        while (i2 < this.count) {
            if (this.painters[i2].inPaintedArea(pt)) {
                return true;
            }
            ++i2;
        }
        return false;
    }

    public Shape getSensitiveArea() {
        if (this.painters == null) {
            return null;
        }
        Area paintedArea = new Area();
        int i2 = 0;
        while (i2 < this.count) {
            Shape s = this.painters[i2].getSensitiveArea();
            if (s != null) {
                paintedArea.add(new Area(s));
            }
            ++i2;
        }
        return paintedArea;
    }

    public Rectangle2D getSensitiveBounds2D() {
        if (this.painters == null) {
            return null;
        }
        Rectangle2D bounds = null;
        int i2 = 0;
        while (i2 < this.count) {
            Rectangle2D pb = this.painters[i2].getSensitiveBounds2D();
            if (bounds == null) {
                bounds = (Rectangle2D)pb.clone();
            } else {
                bounds.add(pb);
            }
            ++i2;
        }
        return bounds;
    }

    public boolean inSensitiveArea(Point2D pt) {
        if (this.painters == null) {
            return false;
        }
        int i2 = 0;
        while (i2 < this.count) {
            if (this.painters[i2].inSensitiveArea(pt)) {
                return true;
            }
            ++i2;
        }
        return false;
    }

    public void setShape(Shape shape) {
        if (shape == null) {
            throw new IllegalArgumentException();
        }
        if (this.painters != null) {
            int i2 = 0;
            while (i2 < this.count) {
                this.painters[i2].setShape(shape);
                ++i2;
            }
        }
        this.shape = shape;
    }

    public Shape getShape() {
        return this.shape;
    }
}

