/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.gs.dm;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import org.apache.log4j.Logger;
import org.broad.igv.PreferenceManager;
import org.broad.igv.gs.GSUtils;
import org.broad.igv.gs.dm.GSDirectoryListing;
import org.broad.igv.gs.dm.GSFileMetadata;
import org.broad.igv.util.HttpUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;
import sun.misc.BASE64Encoder;

public class DMUtils {
    private static Logger log = Logger.getLogger(DMUtils.class);

    public static GSDirectoryListing listDefaultDirectory() {
        try {
            URL defaultURL = new URL(PreferenceManager.getInstance().get("GENOME_SPACE_DM_SERVER") + "defaultdirectory");
            return DMUtils.getDirectoryListing(defaultURL);
        }
        catch (Exception e2) {
            throw new RuntimeException(e2);
        }
    }

    public static GSDirectoryListing getDirectoryListing(URL directoryURL) throws IOException, JSONException {
        String str = HttpUtils.getInstance().getContentsAsString(directoryURL);
        JSONTokener tk = new JSONTokener(str);
        JSONObject obj = new JSONObject(tk);
        JSONObject directory = (JSONObject)obj.get("directory");
        String dirUrlString = directory.get("url").toString();
        LinkedList<GSFileMetadata> elements = new LinkedList<GSFileMetadata>();
        if (obj.has("contents")) {
            Object c2 = obj.get("contents");
            ArrayList<JSONObject> contents = new ArrayList<JSONObject>();
            if (c2 instanceof JSONObject) {
                contents.add((JSONObject)c2);
            } else {
                JSONArray tmp = (JSONArray)c2;
                int l2 = tmp.length();
                for (int i2 = 0; i2 < l2; ++i2) {
                    contents.add((JSONObject)tmp.get(i2));
                }
            }
            ArrayList<GSFileMetadata> dirElements = new ArrayList<GSFileMetadata>();
            ArrayList<GSFileMetadata> fileElements = new ArrayList<GSFileMetadata>();
            int contentsLength = contents.size();
            for (int i3 = 0; i3 < contentsLength; ++i3) {
                JSONObject o2 = (JSONObject)contents.get(i3);
                GSFileMetadata metaData = new GSFileMetadata(o2);
                if (metaData.isDirectory()) {
                    dirElements.add(metaData);
                    continue;
                }
                fileElements.add(metaData);
            }
            elements.addAll(dirElements);
            elements.addAll(fileElements);
        }
        return new GSDirectoryListing(dirUrlString, elements);
    }

    public static void uploadFile(File localFile, String gsPath) throws IOException, URISyntaxException {
        byte[] md5 = DMUtils.computeMD5(localFile);
        String base64String = new BASE64Encoder().encode(md5);
        String hexString = DMUtils.toHexString(md5);
        long contentLength = localFile.length();
        String contentType = "text";
        String user = GSUtils.getGSUser();
        String tmp = PreferenceManager.getInstance().get("GENOME_SPACE_DM_SERVER") + "uploadurls" + gsPath + "?Content-Length=" + contentLength + "&Content-MD5=" + URLEncoder.encode(base64String, "UTF-8") + "&Content-Type=" + contentType;
        String uploadURL = HttpUtils.getInstance().getContentsAsString(new URL(tmp));
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-MD5", base64String);
        headers.put("x-amz-meta-md5-hash", hexString);
        headers.put("Content-Length", String.valueOf(contentLength));
        headers.put("Content-Type", contentType);
        HttpUtils.getInstance().uploadGenomeSpaceFile(uploadURL, localFile, headers);
    }

    public static GSFileMetadata createDirectory(String putURL) throws IOException, JSONException {
        JSONObject dirMeta = new JSONObject();
        try {
            dirMeta.put("isDirectory", true);
            System.out.println(dirMeta.toString());
        }
        catch (JSONException e2) {
            e2.printStackTrace();
        }
        String body = "{\"isDirectory\":true}";
        String response = HttpUtils.getInstance().createGenomeSpaceDirectory(new URL(putURL), body);
        JSONTokener tk = new JSONTokener(response);
        JSONObject obj = new JSONObject(tk);
        return new GSFileMetadata(obj);
    }

    public static byte[] computeMD5(File file) throws IOException {
        BufferedInputStream in = null;
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            in = new BufferedInputStream(new FileInputStream(file));
            int theByte = 0;
            while ((theByte = in.read()) != -1) {
                md.update((byte)theByte);
            }
            byte[] byArray = md.digest();
            return byArray;
        }
        catch (NoSuchAlgorithmException e2) {
            log.error("Error creating MD5 digest");
            throw new RuntimeException(e2);
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    public static String toHexString(byte[] v) {
        String HEX_DIGITS = "0123456789abcdef";
        StringBuffer sb = new StringBuffer(v.length * 2);
        for (int i2 = 0; i2 < v.length; ++i2) {
            int b2 = v[i2] & 0xFF;
            sb.append("0123456789abcdef".charAt(b2 >>> 4)).append("0123456789abcdef".charAt(b2 & 0xF));
        }
        return sb.toString();
    }

    public static void main(String[] args) throws IOException, URISyntaxException {
        String testFile = "/Users/jrobinso/projects/igv/test/data/bed/Unigene.sample.bed";
        File localFile = new File("/Users/jrobinso/projects/igv/test/data/bed/Unigene.sample.bed");
        DMUtils.uploadFile(localFile, "/users/test/Unigene.sample.bed");
        System.exit(-1);
    }
}

