/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui.panel;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.dnd.DropTarget;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.broad.igv.lists.GeneList;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.panel.DataPanelLayout;
import org.broad.igv.ui.panel.DragAndDropTransferHandler;
import org.broad.igv.ui.panel.FrameManager;
import org.broad.igv.ui.panel.HeaderDropTargetListener;
import org.broad.igv.ui.panel.HeaderPanel;
import org.broad.igv.ui.panel.ReferenceFrame;

public class HeaderPanelContainer
extends JPanel {
    private Collection<ReferenceFrame> frames = new ArrayList<ReferenceFrame>();
    JPanel contentPanel;

    public HeaderPanelContainer() {
        this.setLayout(new BorderLayout());
        this.init();
        this.createHeaderPanels();
    }

    public void init() {
        this.setTransferHandler(new DragAndDropTransferHandler());
        this.setDropTarget(new DropTarget(this, new HeaderDropTargetListener(this)));
    }

    @Override
    public void setBackground(Color color) {
        super.setBackground(color);
        if (this.contentPanel != null) {
            for (Component c2 : this.contentPanel.getComponents()) {
                if (!(c2 instanceof HeaderPanel)) continue;
                c2.setBackground(color);
            }
        }
    }

    public void createHeaderPanels() {
        this.removeAll();
        this.frames = FrameManager.getFrames();
        this.contentPanel = new JPanel();
        this.contentPanel.setLayout(new DataPanelLayout());
        for (ReferenceFrame f2 : this.frames) {
            HeaderPanel dp = new HeaderPanel(f2);
            dp.setBackground(this.getBackground());
            this.contentPanel.add(dp);
        }
        this.add((Component)this.contentPanel, "Center");
        if (FrameManager.isGeneListMode()) {
            GeneList gl = IGV.getInstance().getSession().getCurrentGeneList();
            String name = gl.getDisplayName();
            JLabel label = new JLabel(name, 0);
            Border border = BorderFactory.createLineBorder(Color.lightGray);
            label.setBorder(border);
            this.add((Component)label, "North");
        }
        this.invalidate();
    }
}

