/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.das;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.log4j.Logger;
import org.broad.igv.exceptions.DataLoadException;
import org.broad.igv.feature.BasicFeature;
import org.broad.igv.feature.Exon;
import org.broad.igv.feature.FeatureUtils;
import org.broad.igv.feature.LocusScore;
import org.broad.igv.feature.Strand;
import org.broad.igv.feature.tribble.CachingFeatureReader;
import org.broad.igv.ui.WaitCursorManager;
import org.broad.igv.ui.util.MessageUtils;
import org.broad.igv.util.HttpUtils;
import org.broad.igv.util.ResourceLocator;
import org.broad.tribble.Feature;
import org.broad.tribble.FeatureSource;
import org.broad.tribble.iterators.CloseableTribbleIterator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.traversal.DocumentTraversal;
import org.w3c.dom.traversal.TreeWalker;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DASFeatureSource
implements org.broad.igv.track.FeatureSource {
    private static Logger log = Logger.getLogger(DASFeatureSource.class);
    private static final IteratorWrapper EMPTY__ITERATOR = new IteratorWrapper(new ArrayList().iterator());
    private String path;
    private String serverURL;
    private boolean isValid = true;
    private CachingFeatureReader reader;
    private int featureWindowSize = 250000;
    private String type;
    private String[] parameters;
    Map<String, BasicFeature> groupFeatureCache = new HashMap<String, BasicFeature>(10000);

    public DASFeatureSource(ResourceLocator locator) throws MalformedURLException {
        URL url = new URL(locator.getPath());
        String host = url.getHost();
        String protocol = url.getProtocol();
        this.path = url.getPath();
        this.serverURL = protocol + "://" + host + this.path;
        String paramString = url.getQuery();
        if (paramString != null) {
            for (String param : this.parameters = paramString.split(";")) {
                if (!param.startsWith("type=")) continue;
                this.type = param.substring(5);
            }
        }
        if (locator.getPath().contains("genome.ucsc.edu") && this.type == null) {
            throw new DataLoadException("<html>Feature type is required for UCSC DAS tracks. <br>See http://www.broadinstitute.org/igv/LoadData for more details.", locator.getPath());
        }
        this.reader = new CachingFeatureReader(new DasReader());
        this.reader.setBinSize(this.featureWindowSize);
    }

    public Iterator<Feature> getFeatures(String chr, int start, int end) throws IOException {
        return this.reader.query(chr, start, end);
    }

    @Override
    public List<LocusScore> getCoverageScores(String chr, int i2, int i1, int zoom) {
        return null;
    }

    @Override
    public int getFeatureWindowSize() {
        return this.featureWindowSize;
    }

    @Override
    public void setFeatureWindowSize(int size) {
        this.featureWindowSize = size;
        this.reader.setBinSize(size);
    }

    public Class getFeatureClass() {
        return BasicFeature.class;
    }

    public String getPath() {
        return this.path;
    }

    public String getType() {
        return this.type;
    }

    static class IteratorWrapper<Feature>
    implements CloseableTribbleIterator {
        private Iterator<Feature> iterator;

        IteratorWrapper(Iterator<Feature> iterator) {
            this.iterator = iterator;
        }

        public void close() {
        }

        @Override
        public Iterator<Feature> iterator() {
            return this.iterator;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public Feature next() {
            return this.iterator.next();
        }

        @Override
        public void remove() {
            this.iterator.remove();
        }
    }

    class DasReader
    implements FeatureSource {
        DasReader() {
        }

        public CloseableTribbleIterator query(String chr, int start, int end, boolean contained) throws IOException {
            return this.query(chr, start, end);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public CloseableTribbleIterator query(String chr, int start, int end) throws IOException {
            int dasStart = start + 1;
            int dasEnd = end;
            if (DASFeatureSource.this.isValid && !chr.equals("All")) {
                WaitCursorManager.CursorToken token = WaitCursorManager.showWaitCursor();
                try {
                    DASFeatureSource.this.groupFeatureCache.clear();
                    List<Feature> features = this.gatherFeatures(chr, dasStart, dasEnd);
                    if (features.size() < 1) {
                        IteratorWrapper iteratorWrapper = EMPTY__ITERATOR;
                        return iteratorWrapper;
                    }
                    IteratorWrapper<Feature> iteratorWrapper = new IteratorWrapper<Feature>(features.iterator());
                    return iteratorWrapper;
                }
                finally {
                    DASFeatureSource.this.groupFeatureCache.clear();
                    WaitCursorManager.removeWaitCursor(token);
                }
            }
            return EMPTY__ITERATOR;
        }

        public CloseableTribbleIterator iterator() throws IOException {
            return null;
        }

        private List<Feature> gatherFeatures(String chr, int start, int end) {
            ArrayList<Feature> features = new ArrayList<Feature>();
            try {
                URL dataQuery;
                Document dom;
                String dasChr = chr.startsWith("chr") ? chr.substring(3, chr.length()) : chr;
                String urlString = DASFeatureSource.this.serverURL + "?" + "segment=" + dasChr;
                if (end > 0) {
                    urlString = urlString + ":" + start + "," + end;
                }
                if (DASFeatureSource.this.parameters != null) {
                    for (String param : DASFeatureSource.this.parameters) {
                        if (param.startsWith("segment")) continue;
                        urlString = urlString + ";" + param;
                    }
                }
                if ((dom = this.getDocument(dataQuery = new URL(urlString))) == null) {
                    return Collections.emptyList();
                }
                this.parseDocument(dom, chr, features);
                FeatureUtils.sortFeatureList(features);
                return features;
            }
            catch (IOException ioe) {
                throw new DataLoadException("Failed to reconnect with server", DASFeatureSource.this.serverURL);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Document getDocument(URL query) {
            InputStream is = null;
            try {
                is = HttpUtils.getInstance().openConnectionStream(query);
                Document document = this.createDocument(is);
                return document;
            }
            catch (Exception e2) {
                DASFeatureSource.this.isValid = false;
                log.error(e2);
                MessageUtils.showMessage("<html>The DAS Server: " + DASFeatureSource.this.serverURL + " has returned an error or invalid data." + "<br>" + e2.getMessage());
                Document document = null;
                return document;
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException e3) {
                        e3.printStackTrace();
                    }
                }
            }
        }

        private Document createDocument(InputStream inputStream) throws ParserConfigurationException, IOException, SAXException {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setValidating(false);
            DocumentBuilder documentBuilder = dbf.newDocumentBuilder();
            documentBuilder.setEntityResolver(new EntityResolver(){

                @Override
                public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                    log.debug("Ignoring " + publicId + ", " + systemId);
                    return new InputSource(new StringReader(""));
                }
            });
            Document dom = documentBuilder.parse(inputStream);
            inputStream.close();
            return dom;
        }

        public String getPath() {
            return DASFeatureSource.this.serverURL;
        }

        private void parseDocument(Document dasDoc, String chr, List<Feature> features) {
            try {
                DocumentTraversal traversal = (DocumentTraversal)((Object)dasDoc);
                TreeWalker treewalker = traversal.createTreeWalker(dasDoc.getDocumentElement(), 1, null, true);
                this.parseTree(treewalker, "FEATURE", chr, features);
            }
            catch (Exception ex) {
                log.error(ex);
                throw new DataLoadException("Error loading DAS resource (" + ex.toString() + ")", this.getPath());
            }
        }

        private List<Feature> parseTree(TreeWalker walker, String tag, String chr, List<Feature> features) {
            Node parent = walker.getCurrentNode();
            Element n2 = (Element)walker.firstChild();
            while (n2 != null) {
                if (n2.getTagName().equalsIgnoreCase(tag)) {
                    BasicFeature f2 = this.getFeature(walker, chr);
                    if (f2 != null) {
                        features.add(f2);
                    }
                    n2 = (Element)walker.nextSibling();
                    continue;
                }
                this.parseTree(walker, tag, chr, features);
                n2 = (Element)walker.nextSibling();
            }
            walker.setCurrentNode(parent);
            return features;
        }

        /*
         * Enabled aggressive block sorting
         */
        private BasicFeature getFeature(TreeWalker walker, String chr) {
            String type = "";
            int start = 0;
            int end = 0;
            Strand strand = Strand.NONE;
            String description = null;
            String link = null;
            String group = null;
            String groupLabel = null;
            String groupLink = null;
            Node featureNode = walker.getCurrentNode();
            NamedNodeMap nnm = featureNode.getAttributes();
            Node tmpNode = nnm.getNamedItem("id");
            String id = tmpNode.getTextContent();
            tmpNode = nnm.getNamedItem("label");
            String label = tmpNode == null ? "" : tmpNode.getTextContent();
            Node n2 = walker.firstChild();
            while (n2 != null) {
                block22: {
                    block27: {
                        block26: {
                            block25: {
                                block24: {
                                    block23: {
                                        block21: {
                                            if (!((Element)n2).getTagName().equalsIgnoreCase("TYPE")) break block21;
                                            type = n2.getTextContent();
                                            break block22;
                                        }
                                        if (!((Element)n2).getTagName().equalsIgnoreCase("START")) break block23;
                                        start = Integer.parseInt(n2.getTextContent()) - 1;
                                        break block22;
                                    }
                                    if (!((Element)n2).getTagName().equalsIgnoreCase("END")) break block24;
                                    end = Math.max(start + 1, Integer.parseInt(n2.getTextContent()));
                                    break block22;
                                }
                                if (!((Element)n2).getTagName().equalsIgnoreCase("SCORE")) break block25;
                                String scoreString = n2.getTextContent();
                                if (!scoreString.equals("-")) {
                                    float f2 = Float.parseFloat(scoreString);
                                }
                                break block22;
                            }
                            if (!((Element)n2).getTagName().equalsIgnoreCase("PHASE")) break block26;
                            String phaseString = n2.getTextContent();
                            if (!phaseString.equals("-")) {
                                int n3 = Integer.parseInt(n2.getTextContent());
                            }
                            break block22;
                        }
                        if (!((Element)n2).getTagName().equalsIgnoreCase("ORIENTATION")) break block27;
                        String orientation = n2.getTextContent();
                        if (orientation.equals("-")) {
                            strand = Strand.NEGATIVE;
                            break block22;
                        } else if (orientation.equalsIgnoreCase("+")) {
                            strand = Strand.POSITIVE;
                        }
                        break block22;
                    }
                    if (((Element)n2).getTagName().equalsIgnoreCase("NOTE")) {
                        description = description == null ? "<html>" + n2.getTextContent() : description + "<br>" + n2.getTextContent();
                    } else if (((Element)n2).getTagName().equalsIgnoreCase("GROUP")) {
                        Node ln;
                        Node hrefNode;
                        NodeList linkNodes;
                        nnm = n2.getAttributes();
                        tmpNode = nnm.getNamedItem("id");
                        group = tmpNode.getTextContent();
                        tmpNode = nnm.getNamedItem("label");
                        if (tmpNode != null) {
                            groupLabel = tmpNode.getTextContent();
                        }
                        if ((linkNodes = ((Element)n2).getElementsByTagName("LINK")).getLength() > 0 && (hrefNode = (ln = linkNodes.item(0)).getAttributes().getNamedItem("href")) != null) {
                            groupLink = hrefNode.getTextContent();
                        }
                    } else if (((Element)n2).getTagName().equalsIgnoreCase("LINK")) {
                        NamedNodeMap tmpnnm = n2.getAttributes();
                        Node tmpnode = tmpnnm.getNamedItem("href");
                        link = tmpnode.getTextContent();
                    }
                }
                n2 = walker.nextSibling();
            }
            walker.setCurrentNode(featureNode);
            BasicFeature feature = null;
            if (group != null) {
                Exon exon = new Exon(chr, start, end, strand);
                feature = DASFeatureSource.this.groupFeatureCache.get(group);
                if (feature != null) {
                    feature.addExon(exon);
                    return null;
                }
                feature = new BasicFeature(exon.getChr(), exon.getStart(), exon.getEnd(), exon.getStrand());
                feature.addExon(exon);
                if (groupLink != null) {
                    feature.setURL(groupLink);
                }
                if (groupLabel != null) {
                    feature.setName(groupLabel);
                } else {
                    feature.setName(label);
                }
                DASFeatureSource.this.groupFeatureCache.put(group, feature);
            } else {
                feature = new BasicFeature(chr, start, end);
                if (link != null) {
                    feature.setURL(link);
                }
                feature.setIdentifier(id);
                label = label.replace("?", " ");
                feature.setName(label);
                feature.setType(type);
                feature.setStrand(strand);
            }
            if (description != null) {
                description = description.replace("&nbsp;", "<br>");
                description = description.replace("<br><br><br>", "<br>");
                description = description.replace("<br><br>", "<br>");
                description = description.replace(":", ":&nbsp;");
                description = description.replace("?", " ");
                description = description + "<br>TYPE:&nbsp;" + type;
                feature.setDescription(description);
            }
            return feature;
        }

        @Override
        public void close() throws IOException {
        }

        @Override
        public List<String> getSequenceNames() {
            return null;
        }

        @Override
        public Object getHeader() {
            return null;
        }
    }
}

