/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractCellEditor;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;
import org.broad.igv.track.AttributeManager;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.util.LinkCheckBox;
import org.broad.igv.util.ColorUtilities;
import org.broad.igv.util.ResourceLocator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ResourceTree {
    private StringBuffer buffer = new StringBuffer();
    private static String FAILED_TO_CREATE_RESOURCE_TREE_DIALOG = "Failure while creating the resource tree dialog";
    private static Logger log = Logger.getLogger(ResourceTree.class);
    private static String XML_ROOT = "Global";
    private List<CheckableResource> leafResources = new ArrayList<CheckableResource>();
    private HashMap<String, TreeNode> leafNodeMap = new HashMap();
    private JTree tree;
    private static ResourceTree theInstance;
    private Set<String> selectedLeafNodePaths = new LinkedHashSet<String>();

    private ResourceTree() {
        theInstance = this;
    }

    public static ResourceTree getInstance() {
        theInstance = new ResourceTree();
        return theInstance;
    }

    public LinkedHashSet<ResourceLocator> showResourceTreeDialog(Component parent, Document document, String dialogTitle) {
        JDialog dialog = null;
        final LinkedHashSet<ResourceLocator> locators = new LinkedHashSet<ResourceLocator>();
        try {
            final ResourceTree resourceTree = ResourceTree.getInstance();
            final JTree dialogTree = resourceTree.createTreeFromDOM(document);
            int optionType = 2;
            int messageType = -1;
            final CancelableOptionPane optionPane = new CancelableOptionPane(new JScrollPane(dialogTree), messageType, optionType);
            optionPane.setPreferredSize(new Dimension(650, 500));
            optionPane.setOpaque(true);
            optionPane.setBackground(Color.WHITE);
            optionPane.addPropertyChangeListener("value", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent e2) {
                    Object value = e2.getNewValue();
                    if (value instanceof Integer) {
                        int option = (Integer)value;
                        if (option == 2) {
                            optionPane.setCanceled(true);
                        } else {
                            TreeModel model = dialogTree.getModel();
                            LinkedHashSet allCheckedLeafNodes = resourceTree.findSelectedLeafNodes(model, (TreeNode)model.getRoot(), null);
                            LinkedHashSet<ResourceLocator> selectedLocators = resourceTree.getSelectedResourceLocators();
                            for (ResourceLocator locator : selectedLocators) {
                                locators.add(locator);
                            }
                        }
                    }
                }
            });
            dialog = optionPane.createDialog(parent, dialogTitle == null ? "Resource Tree" : dialogTitle);
            dialog.setBackground(Color.WHITE);
            dialog.getContentPane().setBackground(Color.WHITE);
            Component[] children = optionPane.getComponents();
            if (children != null) {
                for (Component child : children) {
                    child.setBackground(Color.WHITE);
                }
            }
            dialog.setResizable(true);
            dialog.pack();
            dialog.setLocationRelativeTo(IGV.getMainFrame());
            dialog.setVisible(true);
            return optionPane.isCanceled() ? null : locators;
        }
        catch (Exception e2) {
            log.error(FAILED_TO_CREATE_RESOURCE_TREE_DIALOG, e2);
            return null;
        }
    }

    private JTree createTreeFromDOM(Document document) {
        Element rootElement = (Element)document.getElementsByTagName(XML_ROOT).item(0);
        if (rootElement == null) {
            return new JTree(new DefaultMutableTreeNode(""));
        }
        String nodeName = rootElement.getNodeName();
        if (!nodeName.equalsIgnoreCase(XML_ROOT)) {
            throw new RuntimeException(rootElement + " is not the root of the xml document!");
        }
        String rootLabel = this.getAttribute(rootElement, "name");
        DefaultMutableTreeNode rootNode = new DefaultMutableTreeNode(rootLabel);
        this.tree = new JTree(rootNode);
        this.tree.setExpandsSelectedPaths(true);
        this.tree.setCellRenderer(new NodeRenderer());
        this.tree.setCellEditor(new ResourceEditor(this.tree));
        this.tree.setEditable(true);
        Set<ResourceLocator> loadedResources = IGV.getInstance().getTrackManager().getDataResourceLocators();
        loadedResources.addAll(AttributeManager.getInstance().getLoadedResources());
        this.processNode(rootNode, rootElement, ResourceTree.getLoadedResources());
        this.recheckTree();
        this.expandTree(TreeExpansionFlag.EXPAND_SELECTED_ONLY, true);
        this.tree.updateUI();
        return this.tree;
    }

    private void processNode(DefaultMutableTreeNode treeNode, Node xmlNode, Set<ResourceLocator> loadedResources) {
        String colorString;
        String name = this.getAttribute((Element)xmlNode, ResourceLocator.AttributeType.NAME.getText());
        ResourceLocator locator = new ResourceLocator(this.getAttribute((Element)xmlNode, ResourceLocator.AttributeType.SERVER_URL.getText()), this.getAttribute((Element)xmlNode, ResourceLocator.AttributeType.PATH.getText()));
        String resourceType = this.getAttribute((Element)xmlNode, ResourceLocator.AttributeType.RESOURCE_TYPE.getText());
        if (resourceType != null) {
            locator.setType(resourceType);
        }
        locator.setInfolink(this.getAttribute((Element)xmlNode, ResourceLocator.AttributeType.HYPERLINK.getText()));
        String sampleId = this.getAttribute((Element)xmlNode, ResourceLocator.AttributeType.SAMPLE_ID.getText());
        if (sampleId == null) {
            sampleId = this.getAttribute((Element)xmlNode, ResourceLocator.AttributeType.ID.getText());
        }
        locator.setSampleId(sampleId);
        locator.setUrl(this.getAttribute((Element)xmlNode, ResourceLocator.AttributeType.URL.getText()));
        locator.setDescription(this.getAttribute((Element)xmlNode, ResourceLocator.AttributeType.DESCRIPTION.getText()));
        locator.setName(name);
        String coverage = this.getAttribute((Element)xmlNode, "coverage");
        if (coverage != null) {
            locator.setCoverage(coverage);
        }
        locator.setTrackLine(this.getAttribute((Element)xmlNode, ResourceLocator.AttributeType.TRACK_LINE.getText()));
        if (coverage != null) {
            locator.setCoverage(coverage);
        }
        locator.setTrackLine(this.getAttribute((Element)xmlNode, ResourceLocator.AttributeType.TRACK_LINE.getText()));
        if (coverage != null) {
            locator.setCoverage(coverage);
        }
        locator.setTrackLine(this.getAttribute((Element)xmlNode, ResourceLocator.AttributeType.TRACK_LINE.getText()));
        if (coverage != null) {
            locator.setCoverage(coverage);
        }
        if ((colorString = this.getAttribute((Element)xmlNode, "color")) != null) {
            try {
                Color c2 = ColorUtilities.stringToColor(colorString);
                locator.setColor(c2);
            }
            catch (Exception e2) {
                log.error("Error setting color: ", e2);
            }
        }
        CheckableResource resource = new CheckableResource(name, false, locator);
        resource.setEnabled(this.tree.isEnabled());
        treeNode.setUserObject(resource);
        NodeList nodeList = xmlNode.getChildNodes();
        Node xmlChildNode = null;
        for (int i2 = 0; i2 < nodeList.getLength(); ++i2) {
            xmlChildNode = nodeList.item(i2);
            String nodeName = xmlChildNode.getNodeName();
            if (nodeName.equalsIgnoreCase("#text") || !(xmlChildNode instanceof Element)) continue;
            String categoryLabel = this.getAttribute((Element)xmlChildNode, ResourceLocator.AttributeType.NAME.getText());
            DefaultMutableTreeNode treeChildNode = new DefaultMutableTreeNode(categoryLabel);
            treeNode.add(treeChildNode);
            this.processNode(treeChildNode, (Element)xmlChildNode, loadedResources);
        }
        if (treeNode.isLeaf()) {
            this.expandPath(new TreePath(treeNode.getPath()));
            treeNode.setAllowsChildren(false);
            if (loadedResources.contains(locator)) {
                resource.setEnabled(false);
                resource.setSelected(true);
                this.checkParentNode(treeNode, true);
            }
            this.leafResources.add(resource);
        } else {
            treeNode.setAllowsChildren(true);
            boolean hasSelectedChildren = this.hasSelectedChildren(treeNode);
            resource.setSelected(hasSelectedChildren);
            ResourceEditor.checkOrUncheckParentNodesRecursively(treeNode, true);
        }
        if (treeNode.isLeaf()) {
            this.leafNodeMap.put(this.getPath(treeNode), treeNode);
        }
    }

    public TreeNode checkParentNode(TreeNode childNode, boolean isSelected) {
        CheckableResource parentResource;
        TreeNode parentNode = childNode.getParent();
        Object parentsUserObject = ((DefaultMutableTreeNode)parentNode).getUserObject();
        if (parentsUserObject instanceof CheckableResource && (parentResource = (CheckableResource)parentsUserObject).isEnabled()) {
            parentResource.setSelected(isSelected);
        }
        return parentNode;
    }

    public List<CheckableResource> getLeafResources() {
        return this.leafResources;
    }

    public LinkedHashSet<ResourceLocator> getSelectedResourceLocators() {
        LinkedHashSet<ResourceLocator> resourceLocators = new LinkedHashSet<ResourceLocator>();
        for (CheckableResource resource : this.leafResources) {
            if (!resource.isSelected()) continue;
            resourceLocators.add(resource.getResourceLocator());
        }
        return resourceLocators;
    }

    private String getAttribute(Element element, String key) {
        String value = element.getAttribute(key);
        if (value != null && value.trim().equals("")) {
            value = null;
        }
        return value;
    }

    private LinkedHashSet<DefaultMutableTreeNode> findSelectedLeafNodes(TreeModel model, TreeNode parentNode, LinkedHashSet<DefaultMutableTreeNode> allCheckedLeafNodes) {
        if (allCheckedLeafNodes == null) {
            allCheckedLeafNodes = new LinkedHashSet();
        }
        int count = model.getChildCount(parentNode);
        for (int i2 = 0; i2 < count; ++i2) {
            TreeNode childNode = (TreeNode)model.getChild(parentNode, i2);
            if (!childNode.isLeaf()) {
                this.findSelectedLeafNodes(model, childNode, allCheckedLeafNodes);
                continue;
            }
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)childNode;
            CheckableResource resource = (CheckableResource)node.getUserObject();
            if (!resource.isSelected()) continue;
            allCheckedLeafNodes.add(node);
        }
        return allCheckedLeafNodes;
    }

    private void expandTree(TreeExpansionFlag expansionFlag, boolean skipSelectingEnabledNodes) {
        TreeNode root = (TreeNode)this.tree.getModel().getRoot();
        if (expansionFlag == TreeExpansionFlag.EXPAND_SELECTED_ONLY) {
            if (this.selectedLeafNodePaths.isEmpty()) {
                TreePath rootPath = new TreePath(root);
                this.expandPath(rootPath);
            } else {
                boolean[] expansionVetoed = new boolean[]{true};
                this.expandSelectedDescendants(new TreePath(root), true, expansionVetoed, skipSelectingEnabledNodes);
            }
        } else if (expansionFlag == TreeExpansionFlag.EXPAND_ALL) {
            this.expandAllDescendants(new TreePath(root), true, skipSelectingEnabledNodes);
        } else if (expansionFlag == TreeExpansionFlag.EXPAND_ROOT_ONLY) {
            TreePath rootPath = new TreePath(root);
            this.expandPath(rootPath);
            this.checkAllSelectedLeafNodes(rootPath, skipSelectingEnabledNodes);
        }
    }

    private void expandAllDescendants(TreePath parentPath, boolean isExpanding, boolean skipSelectingEnabledNodes) {
        String path;
        TreeNode node = (TreeNode)parentPath.getLastPathComponent();
        Enumeration<? extends TreeNode> e2 = node.children();
        while (e2.hasMoreElements()) {
            TreeNode n2 = e2.nextElement();
            TreePath childPath = parentPath.pathByAddingChild(n2);
            this.expandAllDescendants(childPath, isExpanding, skipSelectingEnabledNodes);
        }
        if (isExpanding) {
            this.expandPath(parentPath);
        } else {
            this.collapsePath(parentPath);
        }
        if (node.isLeaf() && this.selectedLeafNodePaths.contains(path = this.getPath((DefaultMutableTreeNode)node))) {
            this.manuallySelectNode((DefaultMutableTreeNode)node, skipSelectingEnabledNodes);
        }
    }

    private void expandSelectedDescendants(TreePath parentPath, boolean isExpanding, boolean[] expansionVetoed, boolean skipSelectingEnabledNodes) {
        boolean[] expansionIsVetoed = new boolean[]{true};
        TreeNode node = (TreeNode)parentPath.getLastPathComponent();
        Enumeration<? extends TreeNode> e2 = node.children();
        while (e2.hasMoreElements()) {
            String path;
            DefaultMutableTreeNode childNode = (DefaultMutableTreeNode)e2.nextElement();
            if (childNode.isLeaf() && this.selectedLeafNodePaths.contains(path = this.getPath(childNode))) {
                this.manuallySelectNode(childNode, skipSelectingEnabledNodes);
                expansionIsVetoed[0] = false;
            }
            TreePath childPath = parentPath.pathByAddingChild(childNode);
            this.expandSelectedDescendants(childPath, isExpanding, expansionVetoed, skipSelectingEnabledNodes);
        }
        if (expansionIsVetoed[0]) {
            return;
        }
        if (isExpanding) {
            this.expandPath(parentPath);
        } else {
            this.collapsePath(parentPath);
        }
    }

    private String getPath(DefaultMutableTreeNode treeNode) {
        TreeNode[] nodesInPath;
        this.buffer.delete(0, this.buffer.length());
        for (TreeNode element : nodesInPath = treeNode.getPath()) {
            CheckableResource resource;
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)element;
            Object userObject = node.getUserObject();
            if (userObject instanceof CheckableResource) {
                resource = (CheckableResource)userObject;
                this.buffer.append(resource.getText());
                if (node.isLeaf()) continue;
                this.buffer.append("/");
                continue;
            }
            if (userObject instanceof CheckableResource) {
                resource = (CheckableResource)userObject;
                this.buffer.append(resource.getText());
                if (node.isLeaf()) continue;
                this.buffer.append("/");
                continue;
            }
            this.buffer.append(userObject.toString());
            if (node.isLeaf()) continue;
            this.buffer.append("/");
        }
        return this.buffer.toString();
    }

    private void manuallySelectNode(DefaultMutableTreeNode childNode, boolean skipSelectingEnabledNodes) {
        Object userObject = childNode.getUserObject();
        if (userObject instanceof CheckableResource) {
            TreeNode parentNode;
            Object parentsUserObject;
            CheckableResource resource = (CheckableResource)userObject;
            if (skipSelectingEnabledNodes && resource.isEnabled()) {
                return;
            }
            if (resource.isSelected()) {
                return;
            }
            resource.setSelected(true);
            if (childNode.isLeaf() && (parentsUserObject = ((DefaultMutableTreeNode)(parentNode = childNode.getParent())).getUserObject()) instanceof CheckableResource) {
                CheckableResource parentResource = (CheckableResource)parentsUserObject;
                if (!parentResource.isSelected()) {
                    parentResource.setSelected(true);
                }
                this.tree.treeDidChange();
            }
        }
    }

    private void checkAllSelectedLeafNodes(TreePath parentPath, boolean skipSelectingEnabledNodes) {
        String path;
        TreeNode node = (TreeNode)parentPath.getLastPathComponent();
        Enumeration<? extends TreeNode> e2 = node.children();
        while (e2.hasMoreElements()) {
            TreeNode n2 = e2.nextElement();
            TreePath childPath = parentPath.pathByAddingChild(n2);
            this.checkAllSelectedLeafNodes(childPath, skipSelectingEnabledNodes);
        }
        if (node.isLeaf() && this.selectedLeafNodePaths.contains(path = this.getPath((DefaultMutableTreeNode)node))) {
            this.manuallySelectNode((DefaultMutableTreeNode)node, skipSelectingEnabledNodes);
        }
    }

    private void collapsePath(TreePath treePath) {
        if (!this.tree.isCollapsed(treePath)) {
            this.tree.collapsePath(treePath);
        }
    }

    private void expandPath(TreePath treePath) {
        if (!this.tree.isExpanded(treePath)) {
            this.tree.expandPath(treePath);
        }
    }

    public boolean hasSelectedChildren(TreeNode treeNode) {
        Enumeration<? extends TreeNode> children = treeNode.children();
        while (children.hasMoreElements()) {
            TreeNode childNode = children.nextElement();
            Object childsUserObject = ((DefaultMutableTreeNode)childNode).getUserObject();
            if (!(childsUserObject instanceof CheckableResource)) continue;
            CheckableResource childResource = (CheckableResource)childsUserObject;
            if (childResource.isSelected()) {
                return true;
            }
            this.tree.treeDidChange();
        }
        return false;
    }

    private static Set<ResourceLocator> getLoadedResources() {
        Set<ResourceLocator> loadedResources = IGV.getInstance().getTrackManager().getDataResourceLocators();
        loadedResources.addAll(AttributeManager.getInstance().getLoadedResources());
        return loadedResources;
    }

    private void recheckTree() {
        if (this.leafNodeMap != null && !this.leafNodeMap.isEmpty()) {
            Collection<TreeNode> leaves = this.leafNodeMap.values();
            for (TreeNode leafNode : leaves) {
                TreeNode parent = leafNode.getParent();
                if (parent == null) continue;
                Object userObject = ((DefaultMutableTreeNode)leafNode).getUserObject();
                CheckableResource checkableLeafResource = (CheckableResource)userObject;
                if (userObject == null || !checkableLeafResource.isSelected()) continue;
                this.checkNode(parent, true);
                while ((parent = parent.getParent()) != null) {
                    this.checkNode(parent, true);
                }
            }
        }
    }

    protected void checkNode(TreeNode node, boolean checked) {
        if (!checked) {
            return;
        }
        Object userObject = ((DefaultMutableTreeNode)node).getUserObject();
        CheckableResource nodeResource = null;
        if (userObject instanceof CheckableResource) {
            nodeResource = (CheckableResource)userObject;
            nodeResource.setSelected(checked);
        }
    }

    static interface DataResource {
        public ResourceLocator getResourceLocator();

        public void setText(String var1);

        public String getText();

        public void setEnabled(boolean var1);

        public boolean isEnabled();
    }

    static interface SelectableResource
    extends DataResource {
        public boolean isSelected();

        public void setSelected(boolean var1);
    }

    public static class CheckableResource
    implements SelectableResource {
        protected static final Color partialSelectionColor = new Color(255, 128, 128);
        protected boolean isParentOfPartiallySelectedChildren = false;
        protected String text;
        protected boolean selected;
        protected ResourceLocator dataResourceLocator;
        protected boolean isEnabled = true;

        public CheckableResource() {
        }

        public CheckableResource(String text, boolean selected, ResourceLocator dataResourceLocator) {
            this.text = text;
            this.selected = selected;
            this.dataResourceLocator = dataResourceLocator;
        }

        @Override
        public boolean isSelected() {
            return this.selected;
        }

        @Override
        public void setSelected(boolean newValue) {
            this.selected = newValue;
        }

        @Override
        public boolean isEnabled() {
            return this.isEnabled;
        }

        @Override
        public void setEnabled(boolean value) {
            this.isEnabled = value;
        }

        @Override
        public String getText() {
            return this.text;
        }

        @Override
        public void setText(String newValue) {
            this.text = newValue;
        }

        @Override
        public ResourceLocator getResourceLocator() {
            return this.dataResourceLocator;
        }

        public void setResourceLocator(ResourceLocator dataResourceLocator) {
            this.dataResourceLocator = dataResourceLocator;
        }

        public boolean isParentOfPartiallySelectedChildren() {
            return this.isParentOfPartiallySelectedChildren;
        }

        public void setIsParentOfPartiallySelectedChildren(boolean value) {
            this.isParentOfPartiallySelectedChildren = value;
        }

        public Color getBackground() {
            if (this.isParentOfPartiallySelectedChildren()) {
                return partialSelectionColor;
            }
            return Color.WHITE;
        }

        public String toString() {
            return this.text + ":" + this.selected;
        }
    }

    static class ResourceEditor
    extends AbstractCellEditor
    implements TreeCellEditor {
        NodeRenderer renderer = new NodeRenderer();
        JTree tree;

        public ResourceEditor(JTree tree) {
            this.tree = tree;
        }

        @Override
        public Object getCellEditorValue() {
            CheckableResource resource = null;
            TreePath treePath = this.tree.getEditingPath();
            if (treePath != null) {
                Object node = treePath.getLastPathComponent();
                if (node != null && node instanceof DefaultMutableTreeNode) {
                    LinkCheckBox checkbox = this.renderer.getRendereringComponent();
                    DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)node;
                    Object userObject = treeNode.getUserObject();
                    resource = (CheckableResource)userObject;
                    if (!resource.isEnabled()) {
                        return resource;
                    }
                    boolean isChecked = checkbox.isSelected();
                    if (isChecked) {
                        resource.setSelected(true);
                    } else {
                        this.uncheckCurrentNodeIfAllowed(resource, treeNode);
                    }
                    boolean checkRelatives = isChecked;
                    if (this.hasSelectedAndLockedDescendants(treeNode)) {
                        checkRelatives = false;
                    } else if (this.hasLockedDescendants(treeNode)) {
                        checkRelatives = true;
                    }
                    if (!treeNode.isLeaf()) {
                        this.checkOrUncheckChildNodesRecursively(treeNode, checkRelatives);
                        ResourceEditor.checkOrUncheckParentNodesRecursively(treeNode, resource.isSelected());
                    } else {
                        ResourceEditor.checkOrUncheckParentNodesRecursively(treeNode, checkRelatives);
                    }
                }
                this.tree.treeDidChange();
            }
            return resource;
        }

        private void uncheckCurrentNodeIfAllowed(CheckableResource resource, TreeNode treeNode) {
            if (!ResourceEditor.hasSelectedChildren(treeNode)) {
                resource.setSelected(false);
            } else if (this.hasLockedDescendants(treeNode)) {
                resource.setSelected(true);
            } else {
                resource.setSelected(false);
            }
        }

        public static void checkOrUncheckParentNodesRecursively(TreeNode node, boolean checkParentNode) {
            if (node == null) {
                return;
            }
            TreeNode parentNode = node.getParent();
            if (parentNode == null) {
                return;
            }
            Object parentUserObject = ((DefaultMutableTreeNode)parentNode).getUserObject();
            CheckableResource parentNodeResource = null;
            if (parentUserObject instanceof CheckableResource) {
                parentNodeResource = (CheckableResource)parentUserObject;
            }
            if (parentNodeResource != null) {
                if (parentNodeResource.isSelected() == checkParentNode) {
                    return;
                }
                if (checkParentNode) {
                    parentNodeResource.setSelected(true);
                } else if (!ResourceEditor.hasSelectedChildren(parentNode)) {
                    parentNodeResource.setSelected(false);
                }
            }
            ResourceEditor.checkOrUncheckParentNodesRecursively(parentNode, checkParentNode);
        }

        private void checkOrUncheckChildNodesRecursively(TreeNode currentNode, boolean isCheckingNeeded) {
            Object parentUserObject = ((DefaultMutableTreeNode)currentNode).getUserObject();
            CheckableResource currentTreeNodeResource = null;
            if (parentUserObject instanceof CheckableResource) {
                currentTreeNodeResource = (CheckableResource)parentUserObject;
            }
            if (currentTreeNodeResource != null) {
                Enumeration<? extends TreeNode> children = currentNode.children();
                while (children.hasMoreElements()) {
                    CheckableResource childResource;
                    TreeNode childNode = children.nextElement();
                    Object childsUserObject = ((DefaultMutableTreeNode)childNode).getUserObject();
                    if (childsUserObject instanceof CheckableResource && (childResource = (CheckableResource)childsUserObject).isEnabled()) {
                        if (this.hasLockedDescendants(childNode)) {
                            childResource.setSelected(true);
                        } else {
                            childResource.setSelected(isCheckingNeeded);
                        }
                    }
                    this.checkOrUncheckChildNodesRecursively(childNode, isCheckingNeeded);
                }
            }
        }

        public boolean hasLockedDescendants(TreeNode treeNode) {
            Enumeration<? extends TreeNode> children = treeNode.children();
            while (children.hasMoreElements()) {
                CheckableResource childResource;
                TreeNode childNode = children.nextElement();
                Object childsUserObject = ((DefaultMutableTreeNode)childNode).getUserObject();
                if (childsUserObject instanceof CheckableResource && !(childResource = (CheckableResource)childsUserObject).isEnabled()) {
                    return true;
                }
                if (!this.hasLockedDescendants(childNode)) continue;
                return true;
            }
            return false;
        }

        public static boolean hasSelectedDescendants(TreeNode treeNode) {
            Enumeration<? extends TreeNode> children = treeNode.children();
            while (children.hasMoreElements()) {
                CheckableResource childResource;
                TreeNode childNode = children.nextElement();
                Object childsUserObject = ((DefaultMutableTreeNode)childNode).getUserObject();
                if (childsUserObject instanceof CheckableResource && (childResource = (CheckableResource)childsUserObject).isSelected()) {
                    return true;
                }
                if (!ResourceEditor.hasSelectedDescendants(childNode)) continue;
                return true;
            }
            return false;
        }

        public static boolean hasSelectedChildren(TreeNode treeNode) {
            Enumeration<? extends TreeNode> children = treeNode.children();
            while (children.hasMoreElements()) {
                CheckableResource childResource;
                TreeNode childNode = children.nextElement();
                Object childsUserObject = ((DefaultMutableTreeNode)childNode).getUserObject();
                if (!(childsUserObject instanceof CheckableResource) || !(childResource = (CheckableResource)childsUserObject).isSelected()) continue;
                return true;
            }
            return false;
        }

        public boolean hasLockedChildren(TreeNode treeNode) {
            boolean hasSelectedAndDisabled = false;
            Enumeration<? extends TreeNode> children = treeNode.children();
            while (children.hasMoreElements()) {
                TreeNode childNode = children.nextElement();
                Object childsUserObject = ((DefaultMutableTreeNode)childNode).getUserObject();
                if (!(childsUserObject instanceof CheckableResource)) continue;
                CheckableResource childResource = (CheckableResource)childsUserObject;
                if (!childResource.isEnabled() && childResource.isSelected()) {
                    hasSelectedAndDisabled = true;
                }
                if (!hasSelectedAndDisabled) continue;
                break;
            }
            return hasSelectedAndDisabled;
        }

        public boolean hasSelectedAndLockedChildren(TreeNode treeNode) {
            boolean hasSelected = false;
            boolean hasSelectedAndDisabled = false;
            Enumeration<? extends TreeNode> children = treeNode.children();
            while (children.hasMoreElements()) {
                TreeNode childNode = children.nextElement();
                Object childsUserObject = ((DefaultMutableTreeNode)childNode).getUserObject();
                if (!(childsUserObject instanceof CheckableResource)) continue;
                CheckableResource childResource = (CheckableResource)childsUserObject;
                if (childResource.isSelected() && childResource.isEnabled()) {
                    hasSelected = true;
                }
                if (!childResource.isEnabled() && childResource.isSelected()) {
                    hasSelectedAndDisabled = true;
                }
                if (!(hasSelected & hasSelectedAndDisabled)) continue;
                break;
            }
            return hasSelected & hasSelectedAndDisabled;
        }

        public boolean hasSelectedAndLockedDescendants(TreeNode treeNode) {
            boolean hasSelected = false;
            boolean hasSelectedAndDisabled = false;
            Enumeration<? extends TreeNode> children = treeNode.children();
            while (children.hasMoreElements()) {
                TreeNode childNode = children.nextElement();
                Object childsUserObject = ((DefaultMutableTreeNode)childNode).getUserObject();
                if (childsUserObject instanceof CheckableResource) {
                    CheckableResource childResource = (CheckableResource)childsUserObject;
                    if (childResource.isSelected() && childResource.isEnabled()) {
                        hasSelected = true;
                    }
                    if (!childResource.isEnabled() && childResource.isSelected()) {
                        hasSelectedAndDisabled = true;
                    }
                    if (hasSelected & hasSelectedAndDisabled) break;
                }
                if (!this.hasSelectedAndLockedDescendants(childNode)) continue;
                return true;
            }
            return hasSelected & hasSelectedAndDisabled;
        }

        @Override
        public boolean isCellEditable(EventObject event) {
            Object node;
            MouseEvent mouseEvent;
            TreePath treePath;
            boolean returnValue = false;
            if (event instanceof MouseEvent && (treePath = this.tree.getPathForLocation((mouseEvent = (MouseEvent)event).getX(), mouseEvent.getY())) != null && (node = treePath.getLastPathComponent()) != null && node instanceof DefaultMutableTreeNode) {
                DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)node;
                Object userObject = treeNode.getUserObject();
                if (userObject instanceof CheckableResource) {
                    returnValue = true;
                } else if (userObject instanceof CheckableResource) {
                    returnValue = true;
                }
            }
            return returnValue;
        }

        @Override
        public Component getTreeCellEditorComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row) {
            Component rendererComponent = this.renderer.getTreeCellRendererComponent(tree, value, true, expanded, leaf, row, true);
            ItemListener itemListener = new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    if (ResourceEditor.this.stopCellEditing()) {
                        ResourceEditor.this.fireEditingStopped();
                    }
                }
            };
            if (rendererComponent instanceof LinkCheckBox) {
                ((LinkCheckBox)rendererComponent).addItemListener(itemListener);
            }
            return rendererComponent;
        }
    }

    static class NodeRenderer
    implements TreeCellRenderer {
        private LinkCheckBox renderer = new LinkCheckBox();
        private Color selectionForeground;
        private Color selectionBackground;
        private Color textForeground;
        private Color textBackground;

        public NodeRenderer() {
            Boolean booleanValue;
            Font fontValue = UIManager.getFont("Tree.font");
            if (fontValue != null) {
                this.renderer.setFont(fontValue);
            }
            this.renderer.setFocusPainted((booleanValue = (Boolean)UIManager.get("Tree.drawsFocusBorderAroundIcon")) != null && booleanValue != false);
            this.selectionForeground = UIManager.getColor("Tree.selectionForeground");
            this.selectionBackground = UIManager.getColor("Tree.selectionBackground");
            this.textForeground = UIManager.getColor("Tree.textForeground");
            this.textBackground = UIManager.getColor("Tree.textBackground");
            this.renderer.setSelected(false);
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean isNodeSelected, boolean isNodeExpanded, boolean isLeaf, int row, boolean hasFocus) {
            DefaultMutableTreeNode node;
            Object userObject;
            String toStringValue;
            String stringValue = "";
            if (value != null && (toStringValue = value.toString()) != null) {
                stringValue = toStringValue;
            }
            this.renderer.setSelected(false);
            this.renderer.setText(stringValue);
            this.renderer.setEnabled(tree.isEnabled());
            if (isNodeSelected) {
                this.renderer.setForeground(this.selectionForeground);
                this.renderer.setBackground(this.selectionBackground);
            } else {
                this.renderer.setForeground(this.textForeground);
                this.renderer.setBackground(this.textBackground);
            }
            if (value != null && value instanceof DefaultMutableTreeNode && (userObject = (node = (DefaultMutableTreeNode)value).getUserObject()) instanceof CheckableResource) {
                CheckableResource resource = (CheckableResource)userObject;
                this.renderer.setText(resource.getText());
                this.renderer.setSelected(resource.isSelected());
                this.renderer.setEnabled(resource.isEnabled());
                String hyperLink = resource.getResourceLocator().getInfolink();
                if (hyperLink == null) {
                    this.renderer.showHyperLink(false);
                } else {
                    this.renderer.setHyperLink(hyperLink);
                    this.renderer.showHyperLink(true);
                }
            }
            return this.renderer;
        }

        protected LinkCheckBox getRendereringComponent() {
            return this.renderer;
        }
    }

    static class CancelableOptionPane
    extends JOptionPane {
        private boolean canceled = false;

        CancelableOptionPane(Object o2, int i2, int i1) {
            super(o2, i2, i1);
        }

        public boolean isCanceled() {
            return this.canceled;
        }

        public void setCanceled(boolean canceled) {
            this.canceled = canceled;
        }
    }

    private static enum TreeExpansionFlag {
        EXPAND_ALL,
        EXPAND_ROOT_ONLY,
        EXPAND_SELECTED_ONLY;

    }
}

