/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.feature.genome;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Collection;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import org.apache.log4j.Logger;
import org.broad.igv.PreferenceManager;
import org.broad.igv.feature.genome.GenomeImporter;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.util.FileDialogUtils;

public class GenomeBuilderPane
extends JPanel {
    private static Logger logger = Logger.getLogger(GenomeBuilderPane.class);
    private String genomeArchiveLocation;
    private String genomeFilename;
    GenomeImporter importer;
    IGV igv;
    private JPanel jPanel1;
    private JTextField cytobandFileTextField;
    private JButton cytobandFileButton;
    private JLabel refFlatFileLabel;
    private JButton refFlatFileButton;
    private JTextField genomeDisplayNameTextField;
    private JLabel fastaFileLabel;
    private JButton fastaFileButton;
    private JLabel cytobandFileLabel;
    private JTextField fastaFileTextField;
    private JTextField refFlatFileTextField;
    private JLabel genomeDisplayNameLabel;
    private JLabel refFlatFileLabel2;
    private JTextField chrAliasField;
    private JButton chrAliasButton;
    private JTextField idField;
    private JLabel genomeDisplayNameLabel2;
    private JLabel label1;
    private JCheckBox sequenceDirectoryCB;
    private JLabel label2;
    private JLabel label3;
    private JTextField sequenceURLField;
    private JLabel jLabel1;

    public GenomeBuilderPane(IGV igv) {
        this.igv = igv;
        this.initComponents();
        this.importer = new GenomeImporter();
    }

    public String getCytobandFileName() {
        String cytobandFile = this.cytobandFileTextField.getText();
        if (cytobandFile != null && cytobandFile.trim().equals("")) {
            cytobandFile = null;
        }
        return cytobandFile;
    }

    public String getRefFlatFileName() {
        String refFlatFile = this.refFlatFileTextField.getText();
        if (refFlatFile != null && refFlatFile.trim().equals("")) {
            refFlatFile = null;
        }
        return refFlatFile;
    }

    public String getFastaFileName() {
        String fastaFile = this.fastaFileTextField.getText();
        if (fastaFile != null && fastaFile.trim().equals("")) {
            fastaFile = null;
        }
        return fastaFile;
    }

    public String getChrAliasFileName() {
        String chrAliasFile = this.chrAliasField.getText();
        if (chrAliasFile != null && chrAliasFile.trim().equals("")) {
            chrAliasFile = null;
        }
        return chrAliasFile;
    }

    public String getGenomeId() {
        return this.idField.getText();
    }

    public String getSequenceURL() {
        return this.sequenceURLField.getText();
    }

    public String getGenomeDisplayName() {
        String name = this.genomeDisplayNameTextField.getText();
        name = name != null && name.trim().equals("") ? null : name.trim();
        return name;
    }

    public String getGenomeArchiveLocation() {
        if (this.genomeArchiveLocation != null && this.genomeArchiveLocation.trim().equals("")) {
            this.genomeArchiveLocation = null;
        }
        return this.genomeArchiveLocation;
    }

    public String getArchiveFileName() {
        if (this.genomeFilename == null) {
            this.genomeFilename = this.getGenomeId() + ".genome";
        }
        return this.genomeFilename;
    }

    protected File showGenomeArchiveDirectoryChooser() {
        File archiveName;
        File directory = PreferenceManager.getInstance().getLastGenomeImportDirectory();
        File file = FileDialogUtils.chooseFile("Save Genome File", directory, archiveName = new File(this.getGenomeId() + ".genome"), FileDialogUtils.SAVE);
        if (file != null) {
            this.genomeFilename = file.getName();
            if (this.genomeFilename != null) {
                if (!this.genomeFilename.endsWith(".genome")) {
                    this.genomeFilename = this.genomeFilename + ".genome";
                    file = new File(file.getParentFile(), this.genomeFilename);
                }
                this.genomeArchiveLocation = file.getParentFile().getAbsolutePath();
            }
        }
        return file;
    }

    public boolean validateSelection() {
        try {
            if (!this.isIdValid().booleanValue()) {
                return false;
            }
            if (!this.isGenomeDisplayNameValid()) {
                this.genomeDisplayNameTextField.setText(null);
                return false;
            }
            if (!this.isFASTAFileValid()) {
                JOptionPane.showMessageDialog(this, "A fasta file is required!");
                return false;
            }
        }
        catch (Exception e2) {
            logger.error("Error during Genome Builder validation!", e2);
            return false;
        }
        return true;
    }

    private boolean isFASTAFileValid() {
        String file = this.fastaFileTextField.getText();
        return file != null && file.trim().length() > 0;
    }

    private Boolean isIdValid() {
        String id = this.getGenomeId();
        if (id == null || id.trim().length() == 0) {
            JOptionPane.showMessageDialog(this, "Genome ID is required");
            return false;
        }
        Collection<String> inUseIds = this.igv.getGenomeIds();
        if (inUseIds.contains(id)) {
            JOptionPane.showMessageDialog(this, "The genome ID '" + id + "' is already in use - please select another!");
            return false;
        }
        return true;
    }

    private boolean isGenomeDisplayNameValid() {
        String displayName = this.getGenomeDisplayName();
        if (displayName == null || displayName.trim().length() == 0) {
            JOptionPane.showMessageDialog(this, "Genome name is required");
            return false;
        }
        Collection<String> inUseDisplayNames = this.igv.getGenomeDisplayNames();
        if (inUseDisplayNames.contains(displayName)) {
            JOptionPane.showMessageDialog(this, "The genome name '" + displayName + "' is already in use - please select another!");
            return false;
        }
        return true;
    }

    private void initComponents() {
        Rectangle bounds;
        this.jPanel1 = new JPanel();
        this.cytobandFileTextField = new JTextField();
        this.cytobandFileButton = new JButton();
        this.refFlatFileLabel = new JLabel();
        this.refFlatFileButton = new JButton();
        this.genomeDisplayNameTextField = new JTextField();
        this.fastaFileLabel = new JLabel();
        this.fastaFileButton = new JButton();
        this.cytobandFileLabel = new JLabel();
        this.fastaFileTextField = new JTextField();
        this.refFlatFileTextField = new JTextField();
        this.genomeDisplayNameLabel = new JLabel();
        this.refFlatFileLabel2 = new JLabel();
        this.chrAliasField = new JTextField();
        this.chrAliasButton = new JButton();
        this.idField = new JTextField();
        this.genomeDisplayNameLabel2 = new JLabel();
        this.label1 = new JLabel();
        this.sequenceDirectoryCB = new JCheckBox();
        this.label2 = new JLabel();
        this.label3 = new JLabel();
        this.sequenceURLField = new JTextField();
        this.jLabel1 = new JLabel();
        this.setFont(new Font("Tahoma", 2, 12));
        this.setMaximumSize(new Dimension(900, 500));
        this.setMinimumSize(new Dimension(400, 300));
        this.setPreferredSize(new Dimension(700, 400));
        this.setLayout(null);
        this.jPanel1.setBorder(null);
        this.jPanel1.setLayout(null);
        this.cytobandFileTextField.setToolTipText("A cytoband data file");
        this.cytobandFileTextField.setPreferredSize(new Dimension(400, 28));
        this.cytobandFileTextField.setMinimumSize(new Dimension(25, 28));
        this.jPanel1.add(this.cytobandFileTextField);
        this.cytobandFileTextField.setBounds(105, 135, 608, 29);
        this.cytobandFileButton.setLabel("...");
        this.cytobandFileButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                GenomeBuilderPane.this.cytobandFileButtonActionPerformed(e2);
            }
        });
        this.jPanel1.add(this.cytobandFileButton);
        this.cytobandFileButton.setBounds(725, 130, 50, this.cytobandFileButton.getPreferredSize().height);
        this.refFlatFileLabel.setText("Gene file");
        this.jPanel1.add(this.refFlatFileLabel);
        this.refFlatFileLabel.setBounds(15, 170, 87, 29);
        this.refFlatFileButton.setLabel("...");
        this.refFlatFileButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                GenomeBuilderPane.this.refFlatFileButtonActionPerformed(e2);
            }
        });
        this.jPanel1.add(this.refFlatFileButton);
        this.refFlatFileButton.setBounds(725, 165, 50, this.refFlatFileButton.getPreferredSize().height);
        this.genomeDisplayNameTextField.setToolTipText("The user-readable name of the genome");
        this.genomeDisplayNameTextField.setPreferredSize(new Dimension(400, 28));
        this.genomeDisplayNameTextField.setMinimumSize(new Dimension(25, 28));
        this.jPanel1.add(this.genomeDisplayNameTextField);
        this.genomeDisplayNameTextField.setBounds(105, 40, 288, this.genomeDisplayNameTextField.getPreferredSize().height);
        this.fastaFileLabel.setText("Fasta file *");
        this.jPanel1.add(this.fastaFileLabel);
        this.fastaFileLabel.setBounds(15, 100, 87, 29);
        this.fastaFileButton.setLabel("...");
        this.fastaFileButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                GenomeBuilderPane.this.fastaFileButtonActionPerformed(e2);
            }
        });
        this.jPanel1.add(this.fastaFileButton);
        this.fastaFileButton.setBounds(725, 95, 50, this.fastaFileButton.getPreferredSize().height);
        this.cytobandFileLabel.setText("Cytoband file");
        this.jPanel1.add(this.cytobandFileLabel);
        this.cytobandFileLabel.setBounds(15, 135, 87, 29);
        this.fastaFileTextField.setToolTipText("A FASTA data file");
        this.fastaFileTextField.setPreferredSize(new Dimension(400, 28));
        this.fastaFileTextField.setMinimumSize(new Dimension(25, 28));
        this.jPanel1.add(this.fastaFileTextField);
        this.fastaFileTextField.setBounds(105, 100, 608, 29);
        this.refFlatFileTextField.setToolTipText("An annotation file");
        this.refFlatFileTextField.setPreferredSize(new Dimension(400, 28));
        this.refFlatFileTextField.setMinimumSize(new Dimension(25, 28));
        this.jPanel1.add(this.refFlatFileTextField);
        this.refFlatFileTextField.setBounds(105, 170, 608, 29);
        this.genomeDisplayNameLabel.setText("Name *");
        this.jPanel1.add(this.genomeDisplayNameLabel);
        this.genomeDisplayNameLabel.setBounds(15, 40, 87, 28);
        this.refFlatFileLabel2.setText("Alias file");
        this.jPanel1.add(this.refFlatFileLabel2);
        this.refFlatFileLabel2.setBounds(15, 220, 87, 29);
        this.chrAliasField.setPreferredSize(new Dimension(400, 28));
        this.chrAliasField.setMinimumSize(new Dimension(25, 28));
        this.jPanel1.add(this.chrAliasField);
        this.chrAliasField.setBounds(105, 220, 608, 29);
        this.chrAliasButton.setLabel("...");
        this.chrAliasButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                GenomeBuilderPane.this.chrAliasButtonActionPerformed(e2);
            }
        });
        this.jPanel1.add(this.chrAliasButton);
        this.chrAliasButton.setBounds(725, 220, 50, this.chrAliasButton.getPreferredSize().height);
        this.idField.setToolTipText("A uniqe identifier for the genome");
        this.jPanel1.add(this.idField);
        this.idField.setBounds(105, 5, 148, this.idField.getPreferredSize().height);
        this.genomeDisplayNameLabel2.setText("ID *");
        this.jPanel1.add(this.genomeDisplayNameLabel2);
        this.genomeDisplayNameLabel2.setBounds(15, 5, 87, 28);
        this.label1.setText("(unique id, e.g. hg18)");
        this.jPanel1.add(this.label1);
        this.label1.setBounds(270, 5, 166, 28);
        this.sequenceDirectoryCB.setText("Fasta file is a directory");
        this.sequenceDirectoryCB.setFont(new Font("Lucida Grande", 2, 13));
        this.jPanel1.add(this.sequenceDirectoryCB);
        this.sequenceDirectoryCB.setBounds(105, 75, 546, this.sequenceDirectoryCB.getPreferredSize().height);
        this.label2.setText("Supply a sequence URL if defining a web-hosted genome (optional, not common).  See user guide for more details. ");
        this.label2.setFont(new Font("Lucida Grande", 2, 13));
        this.jPanel1.add(this.label2);
        this.label2.setBounds(new Rectangle(new Point(15, 275), this.label2.getPreferredSize()));
        this.label3.setText("Sequence URL");
        this.jPanel1.add(this.label3);
        this.label3.setBounds(15, 295, this.label3.getPreferredSize().width, 28);
        this.sequenceURLField.setToolTipText("A refFlat gene file");
        this.sequenceURLField.setPreferredSize(new Dimension(400, 28));
        this.sequenceURLField.setMinimumSize(new Dimension(25, 28));
        this.jPanel1.add(this.sequenceURLField);
        this.sequenceURLField.setBounds(110, 295, 608, this.sequenceURLField.getPreferredSize().height);
        Dimension preferredSize = new Dimension();
        for (int i2 = 0; i2 < this.jPanel1.getComponentCount(); ++i2) {
            bounds = this.jPanel1.getComponent(i2).getBounds();
            preferredSize.width = Math.max(bounds.x + bounds.width, preferredSize.width);
            preferredSize.height = Math.max(bounds.y + bounds.height, preferredSize.height);
        }
        Insets insets = this.jPanel1.getInsets();
        preferredSize.width += insets.right;
        preferredSize.height += insets.bottom;
        this.jPanel1.setMinimumSize(preferredSize);
        this.jPanel1.setPreferredSize(preferredSize);
        this.add(this.jPanel1);
        this.jPanel1.setBounds(10, 0, 810, this.jPanel1.getPreferredSize().height);
        this.jLabel1.setFont(new Font("Lucida Sans Unicode", 2, 12));
        this.jLabel1.setText("<html>* required.  <br>The sequence file (required) can be a FASTA file, a directory of FASTA files, or a zip of FASTA files. Optionally, specify a cytoband file to display the chromosome ideogram and an annotation file to display the gene track. See the documentation for descriptions of supported annotation formats.");
        this.jLabel1.setVerticalAlignment(1);
        this.jLabel1.setBorder(new EmptyBorder(5, 25, 25, 5));
        this.add(this.jLabel1);
        this.jLabel1.setBounds(5, 340, 785, 150);
        preferredSize = new Dimension();
        for (int i3 = 0; i3 < this.getComponentCount(); ++i3) {
            bounds = this.getComponent(i3).getBounds();
            preferredSize.width = Math.max(bounds.x + bounds.width, preferredSize.width);
            preferredSize.height = Math.max(bounds.y + bounds.height, preferredSize.height);
        }
        insets = this.getInsets();
        preferredSize.width += insets.right;
        preferredSize.height += insets.bottom;
        this.setMinimumSize(preferredSize);
        this.setPreferredSize(preferredSize);
    }

    private void chrAliasButtonActionPerformed(ActionEvent e2) {
        File directory = PreferenceManager.getInstance().getDefineGenomeInputDirectory();
        File file = FileDialogUtils.chooseFile("Select Chromosome Alias File", directory, FileDialogUtils.LOAD);
        if (file != null) {
            this.chrAliasField.setText(file.getAbsolutePath());
            PreferenceManager.getInstance().setDefineGenomeInputDirectory(file.getParentFile());
        }
    }

    private void cytobandFileButtonActionPerformed(ActionEvent evt) {
        File directory = PreferenceManager.getInstance().getDefineGenomeInputDirectory();
        File file = FileDialogUtils.chooseFile("Select Cytoband File", directory, FileDialogUtils.LOAD);
        if (file != null) {
            this.cytobandFileTextField.setText(file.getAbsolutePath());
            PreferenceManager.getInstance().setDefineGenomeInputDirectory(file.getParentFile());
        }
    }

    private void refFlatFileButtonActionPerformed(ActionEvent evt) {
        File directory = PreferenceManager.getInstance().getDefineGenomeInputDirectory();
        File file = FileDialogUtils.chooseFile("Select Annotation File", directory, FileDialogUtils.LOAD);
        if (file != null) {
            this.refFlatFileTextField.setText(file.getAbsolutePath());
            PreferenceManager.getInstance().setDefineGenomeInputDirectory(file.getParentFile());
        }
    }

    private void fastaFileButtonActionPerformed(ActionEvent evt) {
        File file;
        boolean chooseDir = this.sequenceDirectoryCB.isSelected();
        File directory = PreferenceManager.getInstance().getDefineGenomeInputDirectory();
        File file2 = file = chooseDir ? FileDialogUtils.chooseDirectory("Select Fasta Directory", directory) : FileDialogUtils.chooseFile("Select Fasta File", directory, FileDialogUtils.LOAD);
        if (file != null) {
            this.fastaFileTextField.setText(file.getAbsolutePath());
            PreferenceManager.getInstance().setDefineGenomeInputDirectory(file.getParentFile());
        }
    }
}

