/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.batch;

import java.io.File;
import java.io.IOException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.broad.igv.feature.Locus;
import org.broad.igv.feature.RegionOfInterest;
import org.broad.igv.sam.AlignmentTrack;
import org.broad.igv.track.RegionScoreType;
import org.broad.igv.track.TrackManager;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.panel.FrameManager;
import org.broad.igv.ui.util.SnapshotUtilities;
import org.broad.igv.util.LRUCache;
import org.broad.igv.util.ResourceLocator;
import org.broad.igv.util.RuntimeUtils;
import org.broad.igv.util.StringUtils;

public class CommandExecutor {
    private static Logger log = Logger.getLogger(CommandExecutor.class);
    private File snapshotDirectory;

    private List<String> getArgs(String[] tokens) {
        ArrayList<String> args = new ArrayList<String>(tokens.length);
        for (String s : tokens) {
            if (s.trim().length() <= 0) continue;
            args.add(s.trim());
        }
        return args;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String execute(String command) {
        List<String> args = this.getArgs(StringUtils.breakQuotedString(command, ' ').toArray(new String[0]));
        String result = "OK";
        IGV mainFrame = IGV.getFirstInstance();
        System.out.println();
        log.debug("Executing: " + command);
        try {
            String param3;
            if (args.size() <= 0) return "Empty command string";
            String cmd = args.get(0).toLowerCase();
            String param1 = args.size() > 1 ? args.get(1) : null;
            String param2 = args.size() > 2 ? args.get(2) : null;
            String string = param3 = args.size() > 3 ? args.get(3) : null;
            if (cmd.equals("echo")) {
                result = cmd;
            } else if (cmd.equals("goto")) {
                result = this.goto1(args);
            } else if (cmd.equals("snapshotdirectory")) {
                result = this.setSnapshotDirectory(param1);
            } else if (cmd.equals("snapshot")) {
                String filename = param1;
                this.createSnapshot(filename);
            } else if ((cmd.equals("loadfile") || cmd.equals("load")) && param1 != null) {
                result = this.load(param1);
            } else if (cmd.equals("hget") && args.size() > 3) {
                result = this.hget(param1, param2, param3);
            } else if (cmd.equals("genome") && args.size() > 1) {
                result = this.genome(param1);
            } else if (cmd.equals("new") || cmd.equals("reset") || cmd.equals("clear")) {
                mainFrame.createNewSession(null);
            } else if (cmd.equals("region")) {
                this.defineRegion(param1, param2, param3);
            } else if (cmd.equals("sort")) {
                this.sort(param1, param2, param3);
            } else if (cmd.equals("collapse")) {
                String trackName = param1 == null ? null : param1.replace("\"", "").replace("'", "");
                this.collapse(trackName);
            } else if (cmd.equals("expand")) {
                String trackName = param1 == null ? null : param1.replace("\"", "").replace("'", "");
                this.expand(trackName);
            } else if (cmd.equals("tweakdivider")) {
                IGV.getFirstInstance().tweakPanelDivider();
            } else {
                if (cmd.equals("maxpanelheight") && param1 != null) {
                    return this.setMaxPanelHeight(param1);
                }
                if (cmd.equals("exit")) {
                    System.exit(0);
                } else {
                    log.error("UNKOWN COMMAND: " + command);
                    return "UNKOWN COMMAND: " + command;
                }
            }
            IGV.getFirstInstance().doRefresh();
            if (RuntimeUtils.getAvailableMemoryFraction() < 0.5) {
                log.debug("Clearing caches");
                LRUCache.clearCaches();
            }
            log.debug("Finished execution: " + command + "  sleeping ....");
            Thread.sleep(2000L);
            log.debug("Finished sleeping");
        }
        catch (Exception e2) {
            log.error("Could not Parse Command", e2);
            return "ERROR Could not Parse Command: " + e2.toString();
        }
        log.info(result);
        return result;
    }

    private String setMaxPanelHeight(String param1) {
        try {
            Integer h2 = Integer.parseInt(param1.trim());
            SnapshotUtilities.MAX_PANEL_HEIGHT = h2;
            return "OK";
        }
        catch (NumberFormatException e2) {
            return "ERROR - max panel height value ('" + param1 + ".) must be a number";
        }
    }

    private String genome(String param1) {
        if (param1 == null) {
            return "ERROR missing genome parameter";
        }
        String genomeID = param1;
        IGV.getFirstInstance().selectGenomeFromList(genomeID);
        String result = "OK";
        return result;
    }

    private String hget(String param1, String param2, String param3) throws IOException {
        String fileString = param1;
        String locusString = URLDecoder.decode(param2);
        String mergeValue = param3;
        boolean merge = mergeValue != null && mergeValue.equalsIgnoreCase("true");
        String result = this.loadFiles(fileString, locusString, merge);
        return result;
    }

    private String load(String param1) throws IOException {
        if (param1 == null) {
            return "ERROR: missing path parameter";
        }
        String fileString = param1.replace("\"", "").replace("'", "");
        return this.loadFiles(fileString, null, true);
    }

    private String setSnapshotDirectory(String param1) {
        String result;
        if (param1 == null) {
            return "ERROR: missing directory parameter";
        }
        File parentDir = new File(param1);
        if (parentDir.exists()) {
            this.snapshotDirectory = parentDir;
            result = "OK";
        } else {
            parentDir.mkdir();
            if (parentDir.exists()) {
                this.snapshotDirectory = parentDir;
                result = "OK";
            } else {
                result = "ERROR: directory: " + param1 + " does not exist";
            }
        }
        return result;
    }

    private String goto1(List<String> args) {
        if (args == null || args.size() < 2) {
            return "ERROR: missing locus parameter";
        }
        String locus = args.get(1);
        for (int i2 = 2; i2 < args.size(); ++i2) {
            locus = locus + " " + args.get(i2);
        }
        IGV.getFirstInstance().goToLocus(locus);
        return "OK";
    }

    private void collapse(String trackName) {
        if (trackName == null) {
            IGV.getFirstInstance().getTrackManager().collapseTracks();
        } else {
            IGV.getFirstInstance().getTrackManager().collapseTrack(trackName);
        }
        IGV.getFirstInstance().repaintDataPanels();
    }

    private void expand(String trackName) {
        if (trackName == null) {
            IGV.getFirstInstance().getTrackManager().expandTracks();
        } else {
            IGV.getFirstInstance().getTrackManager().expandTrack(trackName);
        }
        IGV.getFirstInstance().repaintDataPanels();
    }

    private void defineRegion(String param1, String param2, String param3) {
        Locus locus;
        RegionOfInterest roi = null;
        if (param1 != null && param2 != null && param3 != null) {
            int start = Math.max(0, Integer.parseInt(param2) - 1);
            int end = Integer.parseInt(param3);
            roi = new RegionOfInterest(param1, start, end, "");
        }
        if (param1 != null && (locus = new Locus(param1)).isValid()) {
            int start = Math.max(0, locus.getStart() - 1);
            roi = new RegionOfInterest(locus.getChr(), start, locus.getEnd(), "");
        }
        if (roi != null) {
            IGV.getFirstInstance().addRegionOfInterest(roi);
        }
    }

    private void sort(String sortArg, String locusString, String param3) {
        TrackManager tm = IGV.getFirstInstance().getTrackManager();
        RegionScoreType regionSortOption = CommandExecutor.getRegionSortOption(sortArg);
        if (regionSortOption != null) {
            Locus locus;
            RegionOfInterest roi = null;
            if (locusString != null && (locus = new Locus(locusString)).isValid()) {
                int start = Math.max(0, locus.getStart() - 1);
                roi = new RegionOfInterest(locus.getChr(), start, locus.getEnd(), "");
            }
            tm.sortByRegionScore(roi, regionSortOption, FrameManager.getDefaultFrame());
        } else {
            Double location = null;
            if (param3 != null) {
                try {
                    location = new Double(param3.replace(",", ""));
                }
                catch (NumberFormatException e2) {
                    log.info("Unexpected sort location argument (expected number): " + param3);
                }
            } else {
                try {
                    location = new Double(locusString.replace(",", ""));
                }
                catch (NumberFormatException e3) {
                    log.info("Unexpected sort location argument (expected number): " + param3);
                }
            }
            if (location == null) {
                tm.sortAlignmentTracks(CommandExecutor.getAlignmentSortOption(sortArg));
            } else {
                tm.sortAlignmentTracks(CommandExecutor.getAlignmentSortOption(sortArg), location);
            }
        }
        IGV.getFirstInstance().repaintDataPanels();
    }

    private String loadFiles(String fileString, String locus, boolean merge) throws IOException {
        log.debug("Run load files");
        String[] files = fileString.split(",");
        ArrayList<ResourceLocator> fileLocators = new ArrayList<ResourceLocator>();
        ArrayList<String> sessionPaths = new ArrayList<String>();
        if (!merge) {
            IGV.getFirstInstance().createNewSession(null);
        }
        for (String f2 : files) {
            if (f2.endsWith(".xml")) {
                sessionPaths.add(f2);
                continue;
            }
            ResourceLocator rl = new ResourceLocator(f2);
            fileLocators.add(rl);
        }
        for (String sessionPath : sessionPaths) {
            IGV.getFirstInstance().doRestoreSession(sessionPath, locus, merge);
        }
        IGV.getFirstInstance().loadTracks(fileLocators);
        if (locus != null && !locus.equals("null")) {
            IGV.getFirstInstance().goToLocus(locus);
        }
        return "OK";
    }

    private void createSnapshot(String filename) {
        IGV mainFrame = IGV.getFirstInstance();
        if (filename == null) {
            String locus = FrameManager.getDefaultFrame().getFormattedLocusString();
            filename = locus.replaceAll(":", "_").replace("-", "_") + ".png";
        }
        File file = this.snapshotDirectory == null ? new File(filename) : new File(this.snapshotDirectory, filename);
        System.out.println("Snapshot: " + file.getAbsolutePath());
        SnapshotUtilities.doSnapshotOffscreen(mainFrame.getMainPanel(), file);
    }

    private static RegionScoreType getRegionSortOption(String str) {
        if (str == null) {
            return null;
        }
        String option = str.toUpperCase();
        try {
            return RegionScoreType.valueOf(option);
        }
        catch (Exception e2) {
            return null;
        }
    }

    private static AlignmentTrack.SortOption getAlignmentSortOption(String str) {
        String option = str.toLowerCase();
        if (str == null || option.equals("base")) {
            return AlignmentTrack.SortOption.NUCELOTIDE;
        }
        if (option.equals("strand")) {
            return AlignmentTrack.SortOption.STRAND;
        }
        if (option.equals("start") || option.equals("position")) {
            return AlignmentTrack.SortOption.START;
        }
        if (option.equals("quality")) {
            return AlignmentTrack.SortOption.QUALITY;
        }
        if (option.equals("sample")) {
            return AlignmentTrack.SortOption.SAMPLE;
        }
        if (option.equals("readGroup") || option.equals("read_group")) {
            return AlignmentTrack.SortOption.READ_GROUP;
        }
        if (option.equals("insertSize") || option.equals("insert_size")) {
            return AlignmentTrack.SortOption.INSERT_SIZE;
        }
        return AlignmentTrack.SortOption.NUCELOTIDE;
    }
}

