/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.swing.JideButton;
import com.jidesoft.utils.SystemInfo;
import java.awt.AWTEvent;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.InputEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleState;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.DefaultButtonModel;
import javax.swing.Icon;

public class JideToggleButton
extends JideButton
implements Accessible {
    private ItemListener _itemListener;

    public JideToggleButton() {
        this(null, null, false);
    }

    public JideToggleButton(Icon icon) {
        this(null, icon, false);
    }

    public JideToggleButton(Icon icon, boolean bl) {
        this(null, icon, bl);
    }

    public JideToggleButton(String string) {
        this(string, null, false);
    }

    public JideToggleButton(String string, boolean bl) {
        this(string, null, bl);
    }

    public JideToggleButton(Action action) {
        this();
        this.setAction(action);
    }

    public JideToggleButton(String string, Icon icon) {
        this(string, icon, false);
    }

    public JideToggleButton(String string, Icon icon, boolean bl) {
        this.setModel(new ToggleButtonModel());
        this.model.setSelected(bl);
        this.init(string, icon);
    }

    static boolean hasSelectedKey(Action action) {
        return SystemInfo.isJdk6Above() && action != null && action.getValue("SwingSelectedKey") != null;
    }

    static boolean isSelected(Action action) {
        return SystemInfo.isJdk6Above() && Boolean.TRUE.equals(action.getValue("SwingSelectedKey"));
    }

    private void setSelectedFromAction(Action action) {
        boolean bl = false;
        if (action != null) {
            bl = JideToggleButton.isSelected(action);
        }
        if (bl != this.isSelected()) {
            ButtonGroup buttonGroup;
            this.setSelected(bl);
            if (!bl && this.isSelected() && this.getModel() instanceof DefaultButtonModel && (buttonGroup = ((DefaultButtonModel)this.getModel()).getGroup()) != null && SystemInfo.isJdk6Above()) {
                buttonGroup.clearSelection();
            }
        }
    }

    protected void actionPropertyChanged(Action action, String string) {
        if (SystemInfo.isJdk6Above()) {
            super.actionPropertyChanged(action, string);
            if ("SwingSelectedKey".equals(string) && JideToggleButton.hasSelectedKey(action)) {
                this.setSelectedFromAction(action);
            }
        }
    }

    protected void configurePropertiesFromAction(Action action) {
        super.configurePropertiesFromAction(action);
        if (JideToggleButton.hasSelectedKey(action)) {
            this.setSelectedFromAction(action);
        }
    }

    protected ItemListener createItemListener() {
        if (this._itemListener == null) {
            this._itemListener = new ItemListener(){

                public void itemStateChanged(ItemEvent itemEvent) {
                    JideToggleButton.this.fireItemStateChanged(itemEvent);
                    Action action = JideToggleButton.this.getAction();
                    if (action != null && JideToggleButton.hasSelectedKey(action)) {
                        boolean bl = JideToggleButton.this.isSelected();
                        boolean bl2 = JideToggleButton.isSelected(action);
                        if (bl2 != bl) {
                            action.putValue("SwingSelectedKey", bl);
                        }
                    }
                }
            };
        }
        return this._itemListener;
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJToggleButton();
        }
        return this.accessibleContext;
    }

    protected class AccessibleJToggleButton
    extends AbstractButton.AccessibleAbstractButton
    implements ItemListener {
        public AccessibleJToggleButton() {
            super(JideToggleButton.this);
            JideToggleButton.this.addItemListener(this);
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            JideToggleButton jideToggleButton = (JideToggleButton)itemEvent.getSource();
            if (JideToggleButton.this.accessibleContext != null) {
                if (jideToggleButton.isSelected()) {
                    JideToggleButton.this.accessibleContext.firePropertyChange("AccessibleState", null, AccessibleState.CHECKED);
                } else {
                    JideToggleButton.this.accessibleContext.firePropertyChange("AccessibleState", AccessibleState.CHECKED, null);
                }
            }
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.TOGGLE_BUTTON;
        }
    }

    public static class ToggleButtonModel
    extends DefaultButtonModel {
        public boolean isSelected() {
            return (this.stateMask & 2) != 0;
        }

        public void setSelected(boolean bl) {
            ButtonGroup buttonGroup = this.getGroup();
            if (buttonGroup != null) {
                buttonGroup.setSelected(this, bl);
                bl = buttonGroup.isSelected(this);
            }
            if (this.isSelected() == bl) {
                return;
            }
            this.stateMask = bl ? (this.stateMask |= 2) : (this.stateMask &= 0xFFFFFFFD);
            this.fireStateChanged();
            this.fireItemStateChanged(new ItemEvent(this, 701, this, this.isSelected() ? 1 : 2));
        }

        public void setPressed(boolean bl) {
            if (this.isPressed() == bl || !this.isEnabled()) {
                return;
            }
            if (!bl && this.isArmed()) {
                this.setSelected(!this.isSelected());
            }
            this.stateMask = bl ? (this.stateMask |= 4) : (this.stateMask &= 0xFFFFFFFB);
            this.fireStateChanged();
            if (!this.isPressed() && this.isArmed()) {
                int n2 = 0;
                AWTEvent aWTEvent = EventQueue.getCurrentEvent();
                if (aWTEvent instanceof InputEvent) {
                    n2 = ((InputEvent)aWTEvent).getModifiers();
                } else if (aWTEvent instanceof ActionEvent) {
                    n2 = ((ActionEvent)aWTEvent).getModifiers();
                }
                this.fireActionPerformed(new ActionEvent(this, 1001, this.getActionCommand(), EventQueue.getMostRecentEventTime(), n2));
            }
        }
    }
}

