/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui.panel;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.util.ArrayList;
import java.util.List;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.panel.FrameManager;
import org.broad.igv.ui.panel.HeaderPanel;
import org.broad.igv.ui.panel.HeaderPanelContainer;
import org.broad.igv.ui.panel.ReferenceFrame;

class HeaderDropTargetListener
implements DropTargetListener {
    private final HeaderPanelContainer rootPanel;

    public HeaderDropTargetListener(HeaderPanelContainer sheet) {
        this.rootPanel = sheet;
    }

    @Override
    public void dragEnter(DropTargetDragEvent dtde) {
    }

    @Override
    public void dragOver(DropTargetDragEvent dtde) {
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dtde) {
    }

    @Override
    public void dragExit(DropTargetEvent dte) {
    }

    @Override
    public void drop(DropTargetDropEvent dtde) {
        DataFlavor dragAndDropPanelFlavor = null;
        Object transferableObj = null;
        try {
            dragAndDropPanelFlavor = HeaderPanel.getDragAndDropPanelDataFlavor();
            Transferable transferable = dtde.getTransferable();
            if (transferable.isDataFlavorSupported(dragAndDropPanelFlavor)) {
                transferableObj = dtde.getTransferable().getTransferData(dragAndDropPanelFlavor);
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (transferableObj == null) {
            return;
        }
        HeaderPanel droppedPanel = (HeaderPanel)transferableObj;
        ReferenceFrame droppedFrame = droppedPanel.frame;
        int dropXLoc = dtde.getLocation().x;
        List<ReferenceFrame> panels = FrameManager.getFrames();
        ArrayList<ReferenceFrame> orderedPanels = new ArrayList<ReferenceFrame>(panels.size());
        panels.remove(droppedFrame);
        boolean dropAdded = false;
        for (ReferenceFrame frame : panels) {
            if (frame.getMidpoint() > dropXLoc && !dropAdded) {
                orderedPanels.add(droppedFrame);
                dropAdded = true;
            }
            orderedPanels.add(frame);
        }
        if (!dropAdded) {
            orderedPanels.add(droppedFrame);
        }
        FrameManager.setFrames(orderedPanels);
        IGV.getInstance().resetFrames();
    }
}

