/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui.panel;

import java.util.ArrayList;
import java.util.List;
import org.broad.igv.PreferenceManager;
import org.broad.igv.feature.FeatureDB;
import org.broad.igv.feature.Locus;
import org.broad.igv.feature.NamedFeature;
import org.broad.igv.lists.GeneList;
import org.broad.igv.ui.panel.ReferenceFrame;
import org.broad.igv.ui.util.MessageUtils;

public class FrameManager {
    private static List<ReferenceFrame> frames = new ArrayList<ReferenceFrame>();
    private static ReferenceFrame defaultFrame = new ReferenceFrame("genome");

    public static ReferenceFrame getDefaultFrame() {
        return defaultFrame;
    }

    public static List<ReferenceFrame> getFrames() {
        return frames;
    }

    public static void setFrames(List<ReferenceFrame> f2) {
        frames = f2;
    }

    public static boolean isGeneListMode() {
        return frames.size() > 1;
    }

    public static void setToDefaultFrame(String searchString) {
        Locus locus;
        frames.clear();
        if (searchString != null && (locus = FrameManager.getLocus(searchString, 0)) != null) {
            defaultFrame.setInterval(locus);
        }
        frames.add(defaultFrame);
        defaultFrame.recordHistory();
    }

    public static void resetFrames(GeneList gl) {
        frames.clear();
        if (gl == null) {
            frames.add(defaultFrame);
        } else {
            int flankingRegion = PreferenceManager.getInstance().getAsInt("FLAKING_REGIONS");
            ArrayList<String> lociNotFound = new ArrayList<String>();
            for (String searchString : gl.getLoci()) {
                Locus locus = FrameManager.getLocus(searchString, flankingRegion);
                if (locus == null) {
                    lociNotFound.add(searchString);
                    continue;
                }
                ReferenceFrame referenceFrame = new ReferenceFrame(searchString);
                referenceFrame.setInterval(locus);
                frames.add(referenceFrame);
            }
            if (lociNotFound.size() > 1) {
                StringBuffer message = new StringBuffer();
                message.append("<html>The following loci could not be found in the currently loaded annotation sets: <br>");
                for (String s : lociNotFound) {
                    message.append(s + " ");
                }
                MessageUtils.showMessage(message.toString());
            }
        }
    }

    public static double getMinimumScale() {
        double minScale = Double.MAX_VALUE;
        for (ReferenceFrame frame : frames) {
            minScale = Math.min(minScale, frame.getScale());
        }
        return minScale;
    }

    public static Locus getLocus(String name) {
        int flankingRegion = PreferenceManager.getInstance().getAsInt("FLAKING_REGIONS");
        return FrameManager.getLocus(name, flankingRegion);
    }

    public static Locus getLocus(String searchString, int flankingRegion) {
        NamedFeature feature = FeatureDB.getFeature(searchString.toUpperCase().trim());
        if (feature != null) {
            return new Locus(feature.getChr(), feature.getStart() - flankingRegion, feature.getEnd() + flankingRegion);
        }
        Locus locus = new Locus(searchString);
        String chr = locus.getChr();
        if (chr != null) {
            return locus;
        }
        return null;
    }

    public static void removeFrame(ReferenceFrame frame) {
        frames.remove(frame);
    }

    public static void reset(String chr) {
        FrameManager.setToDefaultFrame(null);
        FrameManager.getDefaultFrame().setChrName(chr);
        FrameManager.getDefaultFrame().computeMaxZoom();
        FrameManager.getDefaultFrame().invalidateLocationScale();
    }

    static {
        frames.add(defaultFrame);
    }
}

