/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.track;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.broad.igv.data.CoverageDataSource;
import org.broad.igv.data.DataSource;
import org.broad.igv.feature.LocusScore;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.renderer.DataRange;
import org.broad.igv.track.DataTrack;
import org.broad.igv.track.WindowFunction;
import org.broad.igv.util.ResourceLocator;

public class DataSourceTrack
extends DataTrack {
    private static Logger log = Logger.getLogger(DataSourceTrack.class);
    private DataSource dataSource;
    public static double log2 = Math.log(2.0);
    boolean normalize = false;

    public DataSourceTrack(ResourceLocator locator, String id, String name, DataSource dataSource, Genome genome) {
        super(locator, id, name);
        this.dataSource = dataSource;
        this.setTrackType(dataSource.getTrackType());
        float min = (float)dataSource.getDataMin();
        float max = (float)dataSource.getDataMax();
        float baseline = 0.0f;
        if (min > 0.0f) {
            min = 0.0f;
        }
        this.setDataRange(new DataRange(min, baseline, max));
    }

    @Override
    public List<LocusScore> getSummaryScores(String chr, int startLocation, int endLocation, int zoom) {
        ArrayList tmp = this.dataSource.getSummaryScoresForRange(chr, startLocation, endLocation, zoom);
        return tmp == null ? new ArrayList() : tmp;
    }

    @Override
    public void setWindowFunction(WindowFunction statType) {
        this.clearCaches();
        this.dataSource.setWindowFunction(statType);
    }

    @Override
    public boolean isLogNormalized() {
        return this.dataSource.isLogNormalized();
    }

    @Override
    public void refreshData(long timestamp) {
        this.dataSource.refreshData(timestamp);
    }

    @Override
    public WindowFunction getWindowFunction() {
        return this.dataSource.getWindowFunction();
    }

    @Override
    public Collection<WindowFunction> getAvailableWindowFunctions() {
        return this.dataSource.getAvailableWindowFunctions();
    }

    @Override
    public Map<String, String> getPersistentState() {
        Map<String, String> properties = super.getPersistentState();
        if (this.normalize) {
            properties.put("normalize", String.valueOf(this.normalize));
        }
        return properties;
    }

    @Override
    public void restorePersistentState(Map<String, String> attributes) {
        super.restorePersistentState(attributes);
        String as = attributes.get("normalize");
        if (as != null) {
            try {
                this.normalize = Boolean.parseBoolean(as);
                if (this.dataSource != null && this.dataSource instanceof CoverageDataSource) {
                    ((CoverageDataSource)this.dataSource).setNormalize(this.normalize);
                }
            }
            catch (Exception e2) {
                log.error("Error restoring session.  Invalid normalization value: " + this.normalize);
            }
        }
    }
}

