/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.special;

import java.io.Serializable;
import org.apache.commons.math.ConvergenceException;
import org.apache.commons.math.MathException;
import org.apache.commons.math.util.ContinuedFraction;

public class Gamma
implements Serializable {
    private static final double DEFAULT_EPSILON = 1.0E-8;
    private static double[] lanczos = new double[]{0.9999999999999971, 57.15623566586292, -59.59796035547549, 14.136097974741746, -0.4919138160976202, 3.399464998481189E-5, 4.652362892704858E-5, -9.837447530487956E-5, 1.580887032249125E-4, -2.1026444172410488E-4, 2.1743961811521265E-4, -1.643181065367639E-4, 8.441822398385275E-5, -2.6190838401581408E-5, 3.6899182659531625E-6};
    private static final double HALF_LOG_2_PI = 0.5 * Math.log(Math.PI * 2);

    private Gamma() {
    }

    public static double logGamma(double x) {
        double ret;
        if (Double.isNaN(x) || x <= 0.0) {
            ret = Double.NaN;
        } else {
            double g2 = 4.7421875;
            double sum = 0.0;
            int i2 = lanczos.length - 1;
            while (i2 > 0) {
                sum += lanczos[i2] / (x + (double)i2);
                --i2;
            }
            double tmp = x + g2 + 0.5;
            ret = (x + 0.5) * Math.log(tmp) - tmp + HALF_LOG_2_PI + Math.log((sum += lanczos[0]) / x);
        }
        return ret;
    }

    public static double regularizedGammaP(double a2, double x) throws MathException {
        return Gamma.regularizedGammaP(a2, x, 1.0E-8, Integer.MAX_VALUE);
    }

    public static double regularizedGammaP(double a2, double x, double epsilon, int maxIterations) throws MathException {
        double ret;
        if (Double.isNaN(a2) || Double.isNaN(x) || a2 <= 0.0 || x < 0.0) {
            ret = Double.NaN;
        } else if (x == 0.0) {
            ret = 0.0;
        } else if (a2 >= 1.0 && x > a2) {
            ret = 1.0 - Gamma.regularizedGammaQ(a2, x, epsilon, maxIterations);
        } else {
            double an;
            double n2 = 0.0;
            double sum = an = 1.0 / a2;
            while (Math.abs(an) > epsilon && n2 < (double)maxIterations) {
                sum += (an *= x / (a2 + (n2 += 1.0)));
            }
            if (n2 >= (double)maxIterations) {
                throw new ConvergenceException("maximum number of iterations reached");
            }
            ret = Math.exp(-x + a2 * Math.log(x) - Gamma.logGamma(a2)) * sum;
        }
        return ret;
    }

    public static double regularizedGammaQ(double a2, double x) throws MathException {
        return Gamma.regularizedGammaQ(a2, x, 1.0E-8, Integer.MAX_VALUE);
    }

    public static double regularizedGammaQ(final double a2, double x, double epsilon, int maxIterations) throws MathException {
        double ret;
        if (Double.isNaN(a2) || Double.isNaN(x) || a2 <= 0.0 || x < 0.0) {
            ret = Double.NaN;
        } else if (x == 0.0) {
            ret = 1.0;
        } else if (x < a2 || a2 < 1.0) {
            ret = 1.0 - Gamma.regularizedGammaP(a2, x, epsilon, maxIterations);
        } else {
            ContinuedFraction cf = new ContinuedFraction(){

                protected double getA(int n2, double x) {
                    return 2.0 * (double)n2 + 1.0 - a2 + x;
                }

                protected double getB(int n2, double x) {
                    return (double)n2 * (a2 - (double)n2);
                }
            };
            ret = 1.0 / cf.evaluate(x, epsilon, maxIterations);
            ret = Math.exp(-x + a2 * Math.log(x) - Gamma.logGamma(a2)) * ret;
        }
        return ret;
    }
}

