/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.svggen;

import java.awt.Shape;
import java.awt.geom.PathIterator;
import org.apache.batik.svggen.SVGGeneratorContext;
import org.apache.batik.svggen.SVGGraphicObjectConverter;
import org.w3c.dom.Element;

public class SVGPath
extends SVGGraphicObjectConverter {
    public SVGPath(SVGGeneratorContext generatorContext) {
        super(generatorContext);
    }

    public Element toSVG(Shape path) {
        String dAttr = SVGPath.toSVGPathData(path, this.generatorContext);
        if (dAttr == null || dAttr.length() == 0) {
            return null;
        }
        Element svgPath = this.generatorContext.domFactory.createElementNS("http://www.w3.org/2000/svg", "path");
        svgPath.setAttributeNS(null, "d", dAttr);
        if (path.getPathIterator(null).getWindingRule() == 0) {
            svgPath.setAttributeNS(null, "fill-rule", "evenodd");
        }
        return svgPath;
    }

    public static String toSVGPathData(Shape path, SVGGeneratorContext gc) {
        StringBuffer d2 = new StringBuffer(40);
        PathIterator pi = path.getPathIterator(null);
        float[] seg = new float[6];
        int segType = 0;
        while (!pi.isDone()) {
            segType = pi.currentSegment(seg);
            switch (segType) {
                case 0: {
                    d2.append("M");
                    SVGPath.appendPoint(d2, seg[0], seg[1], gc);
                    break;
                }
                case 1: {
                    d2.append("L");
                    SVGPath.appendPoint(d2, seg[0], seg[1], gc);
                    break;
                }
                case 4: {
                    d2.append("Z");
                    break;
                }
                case 2: {
                    d2.append("Q");
                    SVGPath.appendPoint(d2, seg[0], seg[1], gc);
                    SVGPath.appendPoint(d2, seg[2], seg[3], gc);
                    break;
                }
                case 3: {
                    d2.append("C");
                    SVGPath.appendPoint(d2, seg[0], seg[1], gc);
                    SVGPath.appendPoint(d2, seg[2], seg[3], gc);
                    SVGPath.appendPoint(d2, seg[4], seg[5], gc);
                    break;
                }
                default: {
                    throw new Error("invalid segmentType:" + segType);
                }
            }
            pi.next();
        }
        if (d2.length() > 0) {
            return d2.toString().trim();
        }
        return "";
    }

    private static void appendPoint(StringBuffer d2, float x, float y, SVGGeneratorContext gc) {
        d2.append(gc.doubleString(x));
        d2.append(" ");
        d2.append(gc.doubleString(y));
        d2.append(" ");
    }
}

