/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.plaf.LookAndFeelFactory;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.swing.Contour;
import com.jidesoft.swing.HeavyweightWrapper;
import com.jidesoft.swing.JideBoxLayout;
import com.jidesoft.swing.JideSplitPaneDivider;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.Serializable;
import java.util.Arrays;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;

public class JideSplitPane
extends JPanel
implements ContainerListener,
ComponentListener,
Accessible {
    protected static final String NON_CONTINUOUS_DIVIDER = "nonContinuousDivider";
    public static final int VERTICAL_SPLIT = 0;
    public static final int HORIZONTAL_SPLIT = 1;
    public static final String ORIENTATION_PROPERTY = "orientation";
    public static final String DIVIDER_SIZE_PROPERTY = "dividerSize";
    public static final String PROPERTY_DIVIDER_LOCATION = "dividerLocation";
    public static final String CONTINUOUS_LAYOUT_PROPERTY = "continuousLayout";
    public static final String GRIPPER_PROPERTY = "gripper";
    public static final String PROPORTIONAL_LAYOUT_PROPERTY = "proportionalLayout";
    public static final String PROPORTIONS_PROPERTY = "proportions";
    public static final String PROPERTY_HEAVYWEIGHT_COMPONENT_ENABLED = "heavyweightComponentEnabled";
    private int _orientation;
    private int _dividerSize = UIDefaultsLookup.getInt("JideSplitPane.dividerSize");
    private HeavyweightWrapper _nonContinuousLayoutDividerWrapper;
    private boolean _continuousLayout = false;
    private Container _layeredPane;
    private boolean _showGripper = false;
    private boolean _proportionalLayout = false;
    private double[] _proportions;
    private boolean _initiallyEven = true;
    private boolean _heavyweightComponentEnabled = false;
    public WindowAdapter _windowDeactivatedListener;
    public static final String ONE_TOUCH_EXPANDABLE_PROPERTY = "oneTouchExpandable";
    private boolean _oneTouchExpandable = false;
    private int oneTouchExpandableDividerSize = 8;
    private ImageIcon _leftOneTouchButtonImageIcon = null;
    private ImageIcon _rightOneTouchButtonImageIcon = null;

    public JideSplitPane() {
        this(1);
    }

    public JideSplitPane(int n2) {
        this._orientation = n2;
        if (this._orientation != 1 && this._orientation != 0) {
            throw new IllegalArgumentException("cannot create JideSplitPane, orientation must be one of JideSplitPane.HORIZONTAL_SPLIT or JideSplitPane.VERTICAL_SPLIT");
        }
        JideSplitPaneLayout jideSplitPaneLayout = this._orientation == 1 ? new JideSplitPaneLayout(this, 0) : new JideSplitPaneLayout(this, 1);
        super.setLayout(jideSplitPaneLayout);
        this.setOpaque(false);
        this.installListeners();
    }

    public void updateUI() {
        if (UIDefaultsLookup.get("JideSplitPane.dividerSize") == null) {
            LookAndFeelFactory.installJideExtension();
        }
        super.updateUI();
    }

    private void installListeners() {
        this.addContainerListener(this);
    }

    public void setDividerSize(int n2) {
        int n3 = this._dividerSize;
        if (n3 != n2) {
            this._dividerSize = n2;
            this.firePropertyChange(DIVIDER_SIZE_PROPERTY, n3, n2);
            this.invalidate();
        }
    }

    public int getDividerSize() {
        return this._dividerSize;
    }

    public Component insertPane(Component component, int n2) {
        return this.insertPane(component, null, n2);
    }

    public Component insertPane(Component component, Object object, int n2) {
        if (n2 <= 0) {
            this.addImpl(component, object, 0);
        } else if (n2 >= this.getPaneCount()) {
            this.addImpl(component, object, -1);
        } else {
            this.addImpl(component, object, (n2 << 1) - 1);
        }
        return component;
    }

    public Component addPane(Component component) {
        if (component == null) {
            return null;
        }
        return super.add(component);
    }

    public void removePane(Component component) {
        this.removePane(this.indexOfPane(component));
    }

    public void setPaneAt(Component component, int n2) {
        this.setPaneAt(component, null, n2);
    }

    public void setPaneAt(Component component, Object object, int n2) {
        double[] dArray = this._proportions;
        this._proportions = null;
        this.removePane(n2);
        this.insertPane(component, object, n2);
        this._proportions = dArray;
    }

    public void removePane(int n2) {
        if (n2 == 0) {
            super.remove(0);
        } else {
            super.remove(n2 << 1);
        }
    }

    public void setOrientation(int n2) {
        if (n2 != 0 && n2 != 1) {
            throw new IllegalArgumentException("JideSplitPane: orientation must be one of JideSplitPane.VERTICAL_SPLIT or JideSplitPane.HORIZONTAL_SPLIT");
        }
        if (this._orientation == n2) {
            return;
        }
        int n3 = this._orientation;
        this._orientation = n2;
        JideSplitPaneLayout jideSplitPaneLayout = this._orientation == 1 ? new JideSplitPaneLayout(this, 0) : new JideSplitPaneLayout(this, 1);
        super.setLayout(jideSplitPaneLayout);
        this.doLayout();
        this.firePropertyChange(ORIENTATION_PROPERTY, n3, n2);
    }

    public int getOrientation() {
        return this._orientation;
    }

    public void resetToPreferredSizes() {
        this.doLayout();
    }

    public void setProportionalLayout(boolean bl) {
        if (bl == this._proportionalLayout) {
            return;
        }
        this._proportionalLayout = bl;
        this.revalidate();
        this.firePropertyChange(PROPORTIONAL_LAYOUT_PROPERTY, !bl, bl);
        if (!bl) {
            this.setProportions(null);
        }
    }

    public boolean isProportionalLayout() {
        return this._proportionalLayout;
    }

    public void setProportions(double[] dArray) {
        int n2;
        if (!this._proportionalLayout && dArray != null) {
            throw new IllegalStateException("Can't set proportions on a non-proportional split pane");
        }
        if (Arrays.equals(dArray, this._proportions)) {
            return;
        }
        if (dArray != null && dArray.length != this.getPaneCount() - 1) {
            throw new IllegalArgumentException("Must provide one fewer proportions than there are panes: got " + dArray.length + ", expected " + (this.getPaneCount() - 1));
        }
        if (dArray != null) {
            double d2 = 0.0;
            for (n2 = 0; n2 < dArray.length; ++n2) {
                if (dArray[n2] < 0.0) {
                    dArray[n2] = 0.0;
                }
                if (dArray[n2] > 1.0) {
                    dArray[n2] = 1.0;
                }
                d2 += dArray[n2];
            }
            if (d2 > 1.0) {
                throw new IllegalArgumentException("Sum of proportions must be no more than 1, got " + d2);
            }
        }
        double[] dArray2 = this._proportions;
        this._proportions = dArray == null ? null : (double[])dArray.clone();
        LayoutManager layoutManager = this.getLayout();
        n2 = 0;
        if (layoutManager instanceof JideBoxLayout) {
            n2 = ((JideBoxLayout)layoutManager).isResetWhenInvalidate() ? 1 : 0;
            ((JideBoxLayout)layoutManager).setResetWhenInvalidate(true);
        }
        this.revalidate();
        if (n2 != 0) {
            ((JideBoxLayout)layoutManager).setResetWhenInvalidate(n2 != 0);
        }
        this.firePropertyChange(PROPORTIONS_PROPERTY, dArray2, dArray);
    }

    public double[] getProportions() {
        double[] dArray = this._proportions;
        if (dArray != null) {
            dArray = (double[])dArray.clone();
        }
        return dArray;
    }

    public void setInitiallyEven(boolean bl) {
        this._initiallyEven = bl;
    }

    public boolean isInitiallyEven() {
        return this._initiallyEven;
    }

    public boolean isValidateRoot() {
        return true;
    }

    protected void startDragging(JideSplitPaneDivider jideSplitPaneDivider) {
        if (!this.isContinuousLayout()) {
            Container container = this.getTopLevelAncestor();
            if (this._windowDeactivatedListener == null) {
                this._windowDeactivatedListener = new WindowAdapter(){

                    public void windowDeactivated(WindowEvent windowEvent) {
                        JideSplitPane.this.stopDragging();
                        if (windowEvent.getWindow() != null) {
                            windowEvent.getWindow().removeWindowListener(JideSplitPane.this._windowDeactivatedListener);
                        }
                    }
                };
            }
            if (container instanceof Window) {
                ((Window)container).addWindowListener(this._windowDeactivatedListener);
            }
            if (container instanceof RootPaneContainer) {
                Serializable serializable;
                this._layeredPane = ((RootPaneContainer)((Object)container)).getLayeredPane();
                if (this._nonContinuousLayoutDividerWrapper == null) {
                    serializable = new Contour();
                    this._nonContinuousLayoutDividerWrapper = new HeavyweightWrapper((Component)serializable);
                    this._nonContinuousLayoutDividerWrapper.setHeavyweight(this.isHeavyweightComponentEnabled());
                }
                this._nonContinuousLayoutDividerWrapper.delegateSetCursor(this._orientation == 1 ? JideSplitPaneDivider.HORIZONTAL_CURSOR : JideSplitPaneDivider.VERTICAL_CURSOR);
                this._nonContinuousLayoutDividerWrapper.delegateSetVisible(false);
                this._nonContinuousLayoutDividerWrapper.delegateAdd(this._layeredPane, JLayeredPane.DRAG_LAYER);
                serializable = this.getVisibleRect();
                Rectangle rectangle = SwingUtilities.convertRectangle(this, (Rectangle)serializable, this._layeredPane);
                int n2 = Math.min(4, this.getDividerSize());
                if (this.getOrientation() == 1) {
                    this._nonContinuousLayoutDividerWrapper.delegateSetBounds(rectangle.x, rectangle.y, n2, rectangle.height);
                } else {
                    this._nonContinuousLayoutDividerWrapper.delegateSetBounds(rectangle.x, rectangle.y, rectangle.width, n2);
                }
            }
        }
    }

    private void stopDragging() {
        if (!this.isContinuousLayout() && this._layeredPane != null && this._nonContinuousLayoutDividerWrapper != null) {
            this._nonContinuousLayoutDividerWrapper.delegateSetVisible(false);
            this._nonContinuousLayoutDividerWrapper.delegateRemove(this._layeredPane);
            this._nonContinuousLayoutDividerWrapper.delegateSetNull();
            this._nonContinuousLayoutDividerWrapper = null;
        }
    }

    protected void dragDividerTo(JideSplitPaneDivider jideSplitPaneDivider, int n2) {
        if (this._layeredPane == null || this.isContinuousLayout()) {
            this.setDividerLocation(jideSplitPaneDivider, n2);
        } else if (this._nonContinuousLayoutDividerWrapper != null) {
            Point point = this.getOrientation() == 1 ? SwingUtilities.convertPoint(this, n2, 0, this._layeredPane) : SwingUtilities.convertPoint(this, 0, n2, this._layeredPane);
            int n3 = Math.min(4, this.getDividerSize());
            if (this.getOrientation() == 1) {
                point.x += this.getDividerSize() - n3 >> 1;
            } else {
                point.y += this.getDividerSize() - n3 >> 1;
            }
            this._nonContinuousLayoutDividerWrapper.delegateSetLocation(point);
            this._nonContinuousLayoutDividerWrapper.delegateSetVisible(true);
        }
    }

    protected void finishDraggingTo(JideSplitPaneDivider jideSplitPaneDivider, int n2) {
        if (this.isContinuousLayout() || this._nonContinuousLayoutDividerWrapper != null) {
            this.stopDragging();
            this.setDividerLocation(jideSplitPaneDivider, n2);
        }
    }

    public int indexOfDivider(JideSplitPaneDivider jideSplitPaneDivider) {
        int n2 = this.indexOf(jideSplitPaneDivider);
        if (n2 == -1) {
            return n2;
        }
        if (n2 % 2 == 0) {
            System.err.println("Warning: divider's index is even. (index = " + n2 + ")");
        }
        return (n2 - 1) / 2;
    }

    public int indexOfPane(Component component) {
        int n2 = this.indexOf(component);
        if (n2 == -1) {
            return -1;
        }
        if (n2 % 2 != 0) {
            System.err.println("Warning: pane's index is odd. (index = " + n2 + ")");
        }
        return n2 >> 1;
    }

    public int indexOf(Component component) {
        for (int i2 = 0; i2 < this.getComponentCount(); ++i2) {
            if (!this.getComponent(i2).equals(component)) continue;
            return i2;
        }
        return -1;
    }

    public JideSplitPaneDivider getDividerAt(int n2) {
        if (n2 < 0 || n2 * 2 + 1 >= this.getComponentCount()) {
            return null;
        }
        return (JideSplitPaneDivider)this.getComponent(n2 * 2 + 1);
    }

    public Component getPaneAt(int n2) {
        if (n2 < 0 || n2 << 1 >= this.getComponentCount()) {
            return null;
        }
        return this.getComponent(n2 << 1);
    }

    public int getPaneCount() {
        return this.getComponentCount() + 1 >> 1;
    }

    public void setDividerLocation(JideSplitPaneDivider jideSplitPaneDivider, int n2) {
        this.setDividerLocation(this.indexOfDivider(jideSplitPaneDivider), n2);
    }

    public void setDividerLocation(int n2, int n3) {
        int n4 = ((JideSplitPaneLayout)this.getLayout()).getDividerLocation(n2);
        ((JideSplitPaneLayout)this.getLayout()).setDividerLocation(n2, n3);
        this.firePropertyChange(PROPERTY_DIVIDER_LOCATION, n4, n3);
        this.revalidate();
    }

    public int getDividerLocation(int n2) {
        return ((JideSplitPaneLayout)this.getLayout()).getDividerLocation(n2);
    }

    public void componentAdded(ContainerEvent containerEvent) {
        containerEvent.getChild().addComponentListener(this);
        if (!(containerEvent.getChild() instanceof JideSplitPaneDivider)) {
            this.addExtraDividers();
        }
        this.setDividersVisible();
        this.resetToPreferredSizes();
    }

    public void componentRemoved(ContainerEvent containerEvent) {
        containerEvent.getChild().removeComponentListener(this);
        if (!(containerEvent.getChild() instanceof JideSplitPaneDivider)) {
            this.removeExtraDividers();
        }
        this.setDividersVisible();
        this.resetToPreferredSizes();
    }

    public void componentResized(ComponentEvent componentEvent) {
    }

    public void componentMoved(ComponentEvent componentEvent) {
    }

    public void componentShown(ComponentEvent componentEvent) {
        if (componentEvent.getComponent() instanceof JideSplitPaneDivider) {
            return;
        }
        this.setDividersVisible();
        this.resetToPreferredSizes();
    }

    public void componentHidden(ComponentEvent componentEvent) {
        if (componentEvent.getComponent() instanceof JideSplitPaneDivider) {
            return;
        }
        this.setDividersVisible();
        this.resetToPreferredSizes();
    }

    protected boolean removeExtraDividers() {
        int n2 = 0;
        if (this.getComponentCount() == 0) {
            if (this._proportions != null) {
                this.setProportions(null);
            }
            return false;
        }
        boolean bl = false;
        if (this.getComponent(0) instanceof JideSplitPaneDivider) {
            this.remove(0);
            this.removeProportion(0);
            bl = true;
        }
        for (int i2 = 0; i2 < this.getComponentCount(); ++i2) {
            Component component = this.getComponent(i2);
            if (component instanceof JideSplitPaneDivider) {
                if (++n2 != 2) continue;
                this.remove(component);
                if (this._proportions != null && this.getPaneCount() == this._proportions.length) {
                    this.removeProportion(i2 / 2);
                }
                bl = true;
                --n2;
                --i2;
                continue;
            }
            n2 = 0;
        }
        if (n2 == 1) {
            this.remove(this.getComponentCount() - 1);
            this.removeProportion((this.getComponentCount() + 1) / 2);
            bl = true;
        }
        return bl;
    }

    protected void removeProportion(int n2) {
        int n3;
        double d2;
        double[] dArray = this._proportions;
        if (dArray == null) {
            return;
        }
        if (dArray.length <= 1) {
            this.setProportions(null);
            return;
        }
        double[] dArray2 = new double[dArray.length - 1];
        if (n2 < dArray.length) {
            d2 = dArray[n2];
        } else {
            d2 = 1.0;
            double[] dArray3 = dArray;
            int n4 = dArray3.length;
            for (n3 = 0; n3 < n4; ++n3) {
                double d3 = dArray3[n3];
                d2 -= d3;
            }
        }
        double d4 = 1.0 - d2;
        for (n3 = 0; n3 < dArray2.length; ++n3) {
            int n5 = n3 < n2 ? n3 : n3 + 1;
            dArray2[n3] = dArray[n5] / d4;
        }
        this.setProportions(dArray2);
    }

    protected void addExtraDividers() {
        int n2 = 0;
        for (int i2 = 0; i2 < this.getComponentCount(); ++i2) {
            Component component = this.getComponent(i2);
            if (!(component instanceof JideSplitPaneDivider)) {
                if (++n2 != 2) continue;
                this.add(this.createSplitPaneDivider(), "fix", i2);
                if (this._proportions != null && this.getPaneCount() == this._proportions.length + 2) {
                    this.addProportion((i2 + 1) / 2);
                }
                n2 = 0;
                continue;
            }
            n2 = 0;
        }
    }

    protected void addProportion(int n2) {
        double[] dArray = this._proportions;
        if (dArray == null) {
            return;
        }
        double[] dArray2 = new double[dArray.length + 1];
        double d2 = 1.0 / (double)(dArray2.length + 1);
        double d3 = 1.0 - d2;
        for (int i2 = 0; i2 < dArray2.length; ++i2) {
            if (i2 == n2) {
                dArray2[i2] = d2;
                continue;
            }
            int n3 = i2 < n2 ? i2 : i2 - 1;
            dArray2[i2] = n3 < dArray.length ? dArray[n3] * d3 : d2;
        }
        this.setProportions(dArray2);
    }

    protected void setDividersVisible() {
        if (this.getComponentCount() == 1) {
            this.setVisible(this.getComponent(0).isVisible());
        } else if (this.getComponentCount() > 1) {
            boolean bl = false;
            boolean bl2 = false;
            for (int i2 = 0; i2 < this.getComponentCount(); ++i2) {
                Component component = this.getComponent(i2);
                if (!(component instanceof JideSplitPaneDivider)) {
                    if (!component.isVisible() || bl) continue;
                    bl = true;
                    continue;
                }
                boolean bl3 = this.getComponent(i2 - 1).isVisible();
                boolean bl4 = this.getComponent(i2 + 1).isVisible();
                if (bl3 && bl4) {
                    component.setVisible(true);
                    continue;
                }
                if (!bl3 && !bl4) {
                    component.setVisible(false);
                    continue;
                }
                if (bl3 && !bl4) {
                    component.setVisible(false);
                    bl2 = true;
                    continue;
                }
                if (bl2) {
                    component.setVisible(true);
                    bl2 = false;
                    continue;
                }
                component.setVisible(false);
            }
            this.setVisible(bl);
        }
    }

    protected JideSplitPaneDivider createSplitPaneDivider() {
        return new JideSplitPaneDivider(this);
    }

    protected int getPreviousDividerLocation(JideSplitPaneDivider jideSplitPaneDivider, boolean bl, boolean bl2) {
        int n2 = this.indexOfDivider(jideSplitPaneDivider);
        int n3 = -1;
        if (bl2) {
            if ((n2 + 1) * 2 + 1 <= this.getComponentCount()) {
                int n4 = n2 + 1;
                while (n4 * 2 + 1 < this.getComponentCount()) {
                    if (bl || this.getDividerAt(n4).isVisible()) {
                        n3 = this._orientation == 1 ? this.getDividerAt((int)n4).getBounds().x : this.getDividerAt((int)n4).getBounds().y;
                        break;
                    }
                    ++n4;
                }
            }
        } else if (n2 > 0) {
            for (int i2 = n2 - 1; i2 >= 0; --i2) {
                if (!bl && !this.getDividerAt(i2).isVisible()) continue;
                n3 = this._orientation == 1 ? this.getDividerAt((int)i2).getBounds().x : this.getDividerAt((int)i2).getBounds().y;
                break;
            }
        }
        if (n3 != -1) {
            return n3 + this.getDividerSize();
        }
        return 0;
    }

    public int getNextDividerLocation(JideSplitPaneDivider jideSplitPaneDivider, boolean bl, boolean bl2) {
        int n2 = this.indexOfDivider(jideSplitPaneDivider);
        int n3 = -1;
        if (!bl2) {
            if ((n2 + 1) * 2 + 1 <= this.getComponentCount()) {
                int n4 = n2 + 1;
                while (n4 * 2 + 1 < this.getComponentCount()) {
                    if (bl || this.getDividerAt(n4).isVisible()) {
                        n3 = this._orientation == 1 ? this.getDividerAt((int)n4).getBounds().x : this.getDividerAt((int)n4).getBounds().y;
                        break;
                    }
                    ++n4;
                }
            }
        } else if (n2 > 0) {
            for (int i2 = n2 - 1; i2 >= 0; --i2) {
                if (!bl && !this.getDividerAt(i2).isVisible()) continue;
                n3 = this._orientation == 1 ? this.getDividerAt((int)i2).getBounds().x : this.getDividerAt((int)i2).getBounds().y;
                break;
            }
        }
        if (n3 != -1) {
            return n3 - this.getDividerSize();
        }
        return this.getOrientation() == 1 ? this.getWidth() - this.getDividerSize() : this.getHeight() - this.getDividerSize();
    }

    public boolean isShowGripper() {
        return this._showGripper;
    }

    public void setShowGripper(boolean bl) {
        boolean bl2 = this._showGripper;
        if (bl2 != bl) {
            this._showGripper = bl;
            this.firePropertyChange(GRIPPER_PROPERTY, bl2, this._showGripper);
        }
    }

    public void doLayout() {
        if (this.removeExtraDividers()) {
            ((JideSplitPaneLayout)this.getLayout()).invalidateLayout(this);
        }
        super.doLayout();
    }

    public boolean isContinuousLayout() {
        return this._continuousLayout;
    }

    public void setContinuousLayout(boolean bl) {
        boolean bl2 = this._continuousLayout;
        this._continuousLayout = bl;
        this.firePropertyChange(CONTINUOUS_LAYOUT_PROPERTY, bl2, bl);
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJideSplitPane();
        }
        return this.accessibleContext;
    }

    public boolean isHeavyweightComponentEnabled() {
        return this._heavyweightComponentEnabled;
    }

    public void setHeavyweightComponentEnabled(boolean bl) {
        boolean bl2 = this._heavyweightComponentEnabled;
        if (this._heavyweightComponentEnabled != bl) {
            this._heavyweightComponentEnabled = bl;
            this.firePropertyChange(PROPERTY_HEAVYWEIGHT_COMPONENT_ENABLED, bl2, this._heavyweightComponentEnabled);
        }
    }

    public void setOneTouchExpandable(boolean bl) {
        boolean bl2 = this._oneTouchExpandable;
        if (bl2 != bl) {
            this._oneTouchExpandable = bl;
            LayoutManager layoutManager = this.getLayout();
            if (layoutManager instanceof JideBoxLayout) {
                ((JideBoxLayout)layoutManager).setResetWhenInvalidate(true);
            }
            if (bl) {
                this.setDividerSize(this.oneTouchExpandableDividerSize);
            } else {
                this.setDividerSize(UIDefaultsLookup.getInt("JideSplitPane.dividerSize"));
            }
            this.firePropertyChange(ONE_TOUCH_EXPANDABLE_PROPERTY, bl2, this._oneTouchExpandable);
            this.revalidate();
            this.repaint();
            if (layoutManager instanceof JideBoxLayout) {
                ((JideBoxLayout)layoutManager).setResetWhenInvalidate(false);
            }
        }
    }

    public boolean isOneTouchExpandable() {
        return this._oneTouchExpandable;
    }

    public void setLeftOneTouchButtonImageIcon(ImageIcon imageIcon) {
        this._leftOneTouchButtonImageIcon = imageIcon;
    }

    public ImageIcon getLeftOneTouchButtonImageIcon() {
        return this._leftOneTouchButtonImageIcon;
    }

    public void setRightOneTouchButtonImageIcon(ImageIcon imageIcon) {
        this._rightOneTouchButtonImageIcon = imageIcon;
    }

    public ImageIcon getRightOneTouchButtonImageIcon() {
        return this._rightOneTouchButtonImageIcon;
    }

    public void setDividerLocations(int[] nArray) {
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            int n2 = nArray[i2];
            this.setDividerLocation(i2, n2);
        }
    }

    public int[] getDividerLocations() {
        int n2 = this.getPaneCount();
        if (this.getPaneCount() == 0) {
            return new int[0];
        }
        int[] nArray = new int[n2 - 1];
        for (int i2 = 0; i2 < n2 - 1; ++i2) {
            nArray[i2] = this.getDividerLocation(i2);
        }
        return nArray;
    }

    static /* synthetic */ double[] access$002(JideSplitPane jideSplitPane, double[] dArray) {
        jideSplitPane._proportions = dArray;
        return dArray;
    }

    protected class AccessibleJideSplitPane
    extends JComponent.AccessibleJComponent {
        protected AccessibleJideSplitPane() {
            super(JideSplitPane.this);
        }

        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet accessibleStateSet = super.getAccessibleStateSet();
            if (JideSplitPane.this.getOrientation() == 0) {
                accessibleStateSet.add(AccessibleState.VERTICAL);
            } else {
                accessibleStateSet.add(AccessibleState.HORIZONTAL);
            }
            return accessibleStateSet;
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.SPLIT_PANE;
        }
    }

    private class JideSplitPaneLayout
    extends JideBoxLayout {
        public JideSplitPaneLayout(Container container) {
            super(container);
            this.setResetWhenInvalidate(false);
        }

        public JideSplitPaneLayout(Container container, int n2) {
            super(container, n2);
            this.setResetWhenInvalidate(false);
        }

        public JideSplitPaneLayout(Container container, int n2, int n3) {
            super(container, n2, n3);
            this.setResetWhenInvalidate(false);
        }

        int getDividerLocation(int n2) {
            Insets insets;
            int n3;
            if (this._componentSizes == null) {
                return -1;
            }
            if (n2 < 0 || n2 + 1 << 1 >= this._componentSizes.length) {
                return -1;
            }
            boolean bl = JideSplitPane.this.getComponentOrientation().isLeftToRight();
            boolean bl2 = !bl && JideSplitPane.this.getOrientation() == 1;
            int n4 = 0;
            if (bl2) {
                for (n3 = this._componentSizes.length - 1; n3 >= n2 * 2 + 1; --n3) {
                    n4 += this._componentSizes[n3];
                }
            } else {
                for (n3 = 0; n3 < n2 * 2 + 1; ++n3) {
                    n4 += this._componentSizes[n3];
                }
            }
            if ((insets = JideSplitPane.this.getInsets()) != null) {
                n4 = JideSplitPane.this.getOrientation() == 1 ? (n4 += bl2 ? insets.right : insets.left) : (n4 += insets.top);
            }
            return n4;
        }

        void setDividerLocation(int n2, int n3) {
            int n4;
            int n5;
            int n6;
            boolean bl;
            int n7 = this.getDividerLocation(n2);
            if (n7 == -1 || n7 == n3) {
                return;
            }
            boolean bl2 = JideSplitPane.this.getComponentOrientation().isLeftToRight();
            boolean bl3 = bl = !bl2 && JideSplitPane.this.getOrientation() == 1;
            if (bl) {
                n6 = 2 * n2 + 2;
                for (n5 = n4 = 2 * n2; !(n5 < 0 || this._target.getComponent(n5).isVisible() && this.getConstraintMap().get(this._target.getComponent(n5)) != "fix"); --n5) {
                    --n4;
                }
                for (n5 = n6; !(n5 >= this._target.getComponentCount() || this._target.getComponent(n5).isVisible() && this.getConstraintMap().get(this._target.getComponent(n5)) != "fix"); ++n5) {
                    ++n6;
                }
                if (n4 < 0 || n6 >= this._componentSizes.length) {
                    return;
                }
            } else {
                n6 = 2 * n2;
                n4 = 2 * n2 + 2;
                for (n5 = n6; !(n5 < 0 || this._target.getComponent(n5).isVisible() && this.getConstraintMap().get(this._target.getComponent(n5)) != "fix"); --n5) {
                    --n6;
                }
                for (n5 = n4; !(n5 >= this._target.getComponentCount() || this._target.getComponent(n5).isVisible() && this.getConstraintMap().get(this._target.getComponent(n5)) != "fix"); ++n5) {
                    ++n4;
                }
                if (n6 < 0 || n4 >= this._componentSizes.length) {
                    return;
                }
            }
            int n8 = n6;
            this._componentSizes[n8] = this._componentSizes[n8] + (n3 - n7);
            int n9 = n4;
            this._componentSizes[n9] = this._componentSizes[n9] - (n3 - n7);
            Component component = this._target.getComponent(n6);
            Component component2 = this._target.getComponent(n4);
            if (JideSplitPane.this.isProportionalLayout()) {
                this.replaceProportions();
                return;
            }
            ComponentOrientation componentOrientation = this._target.getComponentOrientation();
            if (JideSplitPaneLayout.resolveAxis(this._axis, componentOrientation) == 0) {
                if (component instanceof JComponent) {
                    ((JComponent)component).setPreferredSize(new Dimension(this._componentSizes[n6], component.getPreferredSize().height));
                }
                if (component2 instanceof JComponent) {
                    ((JComponent)component2).setPreferredSize(new Dimension(this._componentSizes[n4], component2.getPreferredSize().height));
                }
            } else {
                if (component instanceof JComponent) {
                    ((JComponent)component).setPreferredSize(new Dimension(component.getPreferredSize().width, this._componentSizes[n6]));
                }
                if (component2 instanceof JComponent) {
                    ((JComponent)component2).setPreferredSize(new Dimension(component2.getPreferredSize().width, this._componentSizes[n4]));
                }
            }
        }

        private void replaceProportions() {
            JideSplitPane.this.setProportions(this.deduceProportions());
        }

        private double[] deduceProportions() {
            double[] dArray;
            double d2 = 0.0;
            for (int i2 = 0; i2 < this._componentSizes.length; i2 += 2) {
                d2 += (double)this._componentSizes[i2];
            }
            if (d2 == 0.0) {
                dArray = null;
            } else {
                dArray = new double[(this._componentSizes.length - 1) / 2];
                for (int i3 = 0; i3 < dArray.length; ++i3) {
                    dArray[i3] = (double)this._componentSizes[i3 * 2] / d2;
                }
            }
            return dArray;
        }

        protected boolean calculateComponentSizes(int n2, int n3, int n4) {
            int n5;
            int n6;
            if (!JideSplitPane.this.isProportionalLayout() || JideSplitPane.this.getComponentCount() <= 1) {
                return super.calculateComponentSizes(n2, n3, n4);
            }
            if (JideSplitPane.this._proportions == null) {
                if (!JideSplitPane.this.isInitiallyEven()) {
                    return super.calculateComponentSizes(n2, n3, n4);
                }
                n6 = JideSplitPane.this.getPaneCount();
                double[] dArray = new double[n6 - 1];
                for (n5 = 0; n5 < dArray.length; ++n5) {
                    dArray[n5] = 1.0 / (double)n6;
                }
                JideSplitPane.access$002(JideSplitPane.this, dArray);
            }
            for (n6 = 1; n6 < JideSplitPane.this.getComponentCount(); n6 += 2) {
                if (JideSplitPane.this.getComponent(n6).isVisible()) {
                    this._componentSizes[n6] = JideSplitPane.this.getDividerSize();
                }
                n2 -= this._componentSizes[n6];
            }
            if (n2 < 0) {
                return false;
            }
            double[] dArray = JideSplitPane.this._proportions;
            int n7 = n2;
            for (n5 = 0; n5 < dArray.length; ++n5) {
                double d2;
                int n8 = n5 * 2;
                if (JideSplitPane.this.getComponent(n8).isVisible() && (d2 = dArray[n5]) <= 1.0) {
                    this._componentSizes[n8] = (int)(0.5 + (double)n7 * d2);
                }
                n2 -= this._componentSizes[n8];
            }
            if (n2 < 0) {
                return false;
            }
            this._componentSizes[this._componentSizes.length - 1] = n2;
            return true;
        }
    }
}

