/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

public class StringUtils {
    public static List<String> breakQuotedString(String string, char splitToken) {
        ArrayList<String> strings = new ArrayList<String>();
        if (string.length() == 0) {
            return strings;
        }
        char[] characters = string.toCharArray();
        boolean isQuoted = false;
        StringBuffer buff = new StringBuffer(100);
        for (int i2 = 0; i2 < characters.length; ++i2) {
            char c2 = characters[i2];
            if (isQuoted) {
                if (c2 == '\"') {
                    isQuoted = false;
                }
                buff.append(c2);
                continue;
            }
            if (c2 == '\"') {
                isQuoted = true;
                buff.append(c2);
                continue;
            }
            if (c2 == splitToken) {
                strings.add(buff.toString().trim());
                buff.setLength(0);
                continue;
            }
            buff.append(c2);
        }
        if (buff.length() > 0) {
            strings.add(buff.toString().trim());
        }
        return strings;
    }

    public static String checkLength(String string, int maxLength) {
        if (string.length() <= maxLength) {
            return string;
        }
        int nDots = maxLength > 10 ? 3 : (maxLength > 5 ? 2 : 1);
        int m2 = Math.max(1, (maxLength - nDots) / 2);
        StringBuffer newString = new StringBuffer(maxLength);
        newString.append(string.substring(0, m2));
        for (int i2 = 0; i2 < nDots; ++i2) {
            newString.append('.');
        }
        newString.append(string.substring(string.length() - m2));
        return newString.toString();
    }

    public static short genoToShort(String genotype) {
        byte[] bytes = genotype.getBytes();
        return (short)((bytes[0] & 0xFF) << 8 | bytes[1] & 0xFF);
    }

    public static String readString(ByteBuffer byteBuffer) throws IOException {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        int b2 = -1;
        while (true) {
            byte by = byteBuffer.get();
            b2 = by;
            if (by == 0) break;
            bytes.write(b2);
        }
        return new String(bytes.toByteArray());
    }
}

