/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.util;

import java.awt.Frame;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.Authenticator;
import java.net.CookieHandler;
import java.net.CookieManager;
import java.net.HttpCookie;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.log4j.Logger;
import org.broad.igv.PreferenceManager;
import org.broad.igv.gs.GSUtils;
import org.broad.igv.ui.IGV;
import org.broad.igv.util.LoginDialog;
import org.broad.igv.util.UserPasswordInputImpl;
import org.broad.igv.util.Utilities;
import org.broad.igv.util.stream.IGVUrlHelper;
import org.broad.tribble.util.SeekableHTTPStream;
import org.broad.tribble.util.ftp.FTPClient;
import org.broad.tribble.util.ftp.FTPStream;
import org.broad.tribble.util.ftp.FTPUtils;
import sun.misc.BASE64Encoder;

public class HttpUtils {
    private static Logger log = Logger.getLogger(HttpUtils.class);
    public static boolean byteRangeTested = false;
    public static boolean useByteRange = true;
    private static HttpUtils instance;
    private ProxySettings proxySettings = null;
    private final int MAX_REDIRECTS = 5;

    public static HttpUtils getInstance() {
        return instance;
    }

    private HttpUtils() {
        Authenticator.setDefault(new IGVAuthenticator());
    }

    public static boolean isURL(String string) {
        String lcString = string.toLowerCase();
        return lcString.startsWith("http://") || lcString.startsWith("https://") || lcString.startsWith("ftp://") || lcString.startsWith("file://");
    }

    public static boolean testByteRange() {
        try {
            String testURL = "http://www.broadinstitute.org/igvdata/byteRangeTest.txt";
            byte[] expectedBytes = new byte[]{107, 108, 109, 110, 111};
            SeekableHTTPStream str = new SeekableHTTPStream(new IGVUrlHelper(new URL(testURL)));
            str.seek(10L);
            byte[] buffer = new byte[5];
            str.read(buffer, 0, 5);
            for (int i2 = 0; i2 < buffer.length; ++i2) {
                if (buffer[i2] == expectedBytes[i2]) continue;
                return false;
            }
            return true;
        }
        catch (IOException e2) {
            log.error("Error while testing byte range ", e2);
            return true;
        }
    }

    public static boolean useByteRange() {
        useByteRange = PreferenceManager.getInstance().getAsBoolean("UseHttpByteRange");
        if (useByteRange && !byteRangeTested) {
            useByteRange = HttpUtils.testByteRange();
            byteRangeTested = true;
        }
        return useByteRange;
    }

    public void shutdown() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getContentsAsString(URL url) throws IOException {
        InputStream is = null;
        HttpURLConnection conn = this.openConnection(url, null);
        try {
            is = conn.getInputStream();
            String string = this.readContents(is);
            return string;
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
    }

    public InputStream openConnectionStream(URL url) throws IOException {
        if (url.getProtocol().toLowerCase().equals("ftp")) {
            String userInfo = url.getUserInfo();
            String host = url.getHost();
            String file = url.getPath();
            FTPClient ftp = FTPUtils.connect(host, userInfo, new UserPasswordInputImpl());
            ftp.pasv();
            ftp.retr(file);
            return new FTPStream(ftp);
        }
        return this.openConnection(url, null).getInputStream();
    }

    public InputStream openConnectionStream(URL url, Map<String, String> requestProperties) throws IOException {
        HttpURLConnection conn = this.openConnection(url, requestProperties);
        return conn.getInputStream();
    }

    public boolean resourceAvailable(URL url) {
        if (url.getProtocol().toLowerCase().equals("ftp")) {
            return FTPUtils.resourceAvailable(url);
        }
        try {
            HttpURLConnection conn = this.openConnection(url, null, "HEAD");
            int code = conn.getResponseCode();
            return code == 200;
        }
        catch (IOException e2) {
            return false;
        }
    }

    public String getHeaderField(URL url, String key) throws IOException {
        HttpURLConnection conn = this.openConnection(url, null, "HEAD");
        return conn.getHeaderField(key);
    }

    public long getContentLength(URL url) throws IOException {
        String contentLengthString = "";
        contentLengthString = this.getHeaderField(url, "Content-Length");
        if (contentLengthString == null) {
            return -1L;
        }
        return Long.parseLong(contentLengthString);
    }

    public void updateProxySettings() {
        int proxyPort = -1;
        boolean auth = false;
        String user = null;
        String pw = null;
        PreferenceManager prefMgr = PreferenceManager.getInstance();
        boolean useProxy = prefMgr.getAsBoolean("PROXY.USE");
        String proxyHost = prefMgr.get("PROXY.HOST", null);
        try {
            proxyPort = Integer.parseInt(prefMgr.get("PROXY.PORT", "-1"));
        }
        catch (NumberFormatException e2) {
            proxyPort = -1;
        }
        auth = prefMgr.getAsBoolean("PROXY.AUTHENTICATE");
        user = prefMgr.get("PROXY.USERNAME", null);
        String pwString = prefMgr.get("PROXY.PW", null);
        if (pwString != null) {
            pw = Utilities.base64Decode(pwString);
        }
        this.proxySettings = new ProxySettings(useProxy, user, pw, auth, proxyHost, proxyPort);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean downloadFile(String url, File outputFile) throws IOException {
        log.info("Downloading " + url + " to " + outputFile.getAbsolutePath());
        HttpURLConnection conn = this.openConnection(new URL(url), null);
        long contentLength = -1L;
        String contentLengthString = conn.getHeaderField("Content-Length");
        if (contentLengthString != null) {
            contentLength = Long.parseLong(contentLengthString);
        }
        log.info("Content length = " + contentLength);
        InputStream is = null;
        FileOutputStream out = null;
        try {
            is = conn.getInputStream();
            out = new FileOutputStream(outputFile);
            byte[] buf = new byte[65536];
            int downloaded = 0;
            int bytesRead = 0;
            while ((bytesRead = is.read(buf)) != -1) {
                ((OutputStream)out).write(buf, 0, bytesRead);
                downloaded += bytesRead;
            }
            log.info("Download complete.  Total bytes downloaded = " + downloaded);
        }
        finally {
            if (is != null) {
                is.close();
            }
            if (out != null) {
                out.flush();
                ((OutputStream)out).close();
            }
        }
        long fileLength = outputFile.length();
        return contentLength <= 0L || contentLength == fileLength;
    }

    public void uploadGenomeSpaceFile(String uri, File file, Map<String, String> headers) throws IOException {
        int i2;
        HttpURLConnection urlconnection = null;
        BufferedOutputStream bos = null;
        URL url = new URL(uri);
        urlconnection = this.openConnection(url, headers, "PUT");
        urlconnection.setDoOutput(true);
        urlconnection.setDoInput(true);
        bos = new BufferedOutputStream(urlconnection.getOutputStream());
        BufferedInputStream bis = new BufferedInputStream(new FileInputStream(file));
        while ((i2 = bis.read()) > 0) {
            ((OutputStream)bos).write(i2);
        }
        ((OutputStream)bos).close();
        int responseCode = urlconnection.getResponseCode();
        if (responseCode >= 400) {
            String message = this.readErrorStream(urlconnection);
            throw new IOException("Error uploading " + file.getName() + " : " + message);
        }
    }

    public String createGenomeSpaceDirectory(URL url, String body) throws IOException {
        String nextLine;
        HttpURLConnection urlconnection = null;
        BufferedOutputStream bos = null;
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/json");
        headers.put("Content-Length", String.valueOf(body.getBytes().length));
        urlconnection = this.openConnection(url, headers, "PUT");
        urlconnection.setDoOutput(true);
        urlconnection.setDoInput(true);
        bos = new BufferedOutputStream(urlconnection.getOutputStream());
        ((OutputStream)bos).write(body.getBytes());
        ((OutputStream)bos).close();
        int responseCode = urlconnection.getResponseCode();
        StringBuffer buf = new StringBuffer();
        InputStream inputStream = null;
        inputStream = responseCode >= 200 && responseCode < 300 ? urlconnection.getInputStream() : urlconnection.getErrorStream();
        BufferedReader br = new BufferedReader(new InputStreamReader(inputStream));
        while ((nextLine = br.readLine()) != null) {
            buf.append(nextLine);
            buf.append('\n');
        }
        inputStream.close();
        if (responseCode >= 200 && responseCode < 300) {
            return buf.toString();
        }
        throw new IOException("Error creating GS directory: " + buf.toString());
    }

    private void disableCertificateValidation() {
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }
        }};
        try {
            SSLContext sc = SSLContext.getInstance("TLS");
            sc.init(null, trustAllCerts, new SecureRandom());
            HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String readContents(InputStream is) throws IOException {
        int b2;
        BufferedInputStream bis = new BufferedInputStream(is);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        while ((b2 = bis.read()) >= 0) {
            bos.write(b2);
        }
        return new String(bos.toByteArray());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readErrorStream(HttpURLConnection connection) throws IOException {
        InputStream inputStream = null;
        try {
            inputStream = connection.getErrorStream();
            String string = this.readContents(inputStream);
            return string;
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
    }

    private HttpURLConnection openConnection(URL url, Map<String, String> requestProperties) throws IOException {
        return this.openConnection(url, requestProperties, "GET");
    }

    private HttpURLConnection openConnection(URL url, Map<String, String> requestProperties, String method) throws IOException {
        return this.openConnection(url, requestProperties, method, 0);
    }

    private HttpURLConnection openConnection(URL url, Map<String, String> requestProperties, String method, int redirectCount) throws IOException {
        HttpURLConnection conn;
        boolean useProxy;
        boolean bl = useProxy = this.proxySettings != null && this.proxySettings.useProxy && this.proxySettings.proxyHost != null && this.proxySettings.proxyPort > 0;
        if (useProxy) {
            Proxy proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(this.proxySettings.proxyHost, this.proxySettings.proxyPort));
            conn = (HttpURLConnection)url.openConnection(proxy);
            if (this.proxySettings.auth && this.proxySettings.user != null && this.proxySettings.pw != null) {
                byte[] bytes = (this.proxySettings.user + ":" + this.proxySettings.pw).getBytes();
                String encodedUserPwd = new BASE64Encoder().encode(bytes);
                conn.setRequestProperty("Proxy-Authorization", "Basic " + encodedUserPwd);
            }
        } else {
            conn = (HttpURLConnection)url.openConnection();
        }
        if (GSUtils.isGenomeSpace(url)) {
            String token = GSUtils.getGSToken();
            if (token != null) {
                conn.setRequestProperty("Cookie", "gs-token=" + token);
            }
            if (!url.toString().contains("datamanager/uploadurls")) {
                conn.setRequestProperty("Accept", "application/json,application/text");
            }
        }
        conn.setConnectTimeout(10000);
        conn.setReadTimeout(300000);
        conn.setRequestMethod(method);
        conn.setRequestProperty("Connection", "close");
        if (requestProperties != null) {
            for (Map.Entry<String, String> prop : requestProperties.entrySet()) {
                conn.setRequestProperty(prop.getKey(), prop.getValue());
            }
        }
        if (method.equals("PUT")) {
            return conn;
        }
        int code = conn.getResponseCode();
        if (code >= 200 && code < 300 && GSUtils.isGenomeSpace(url)) {
            try {
                List<HttpCookie> cookies = ((CookieManager)CookieManager.getDefault()).getCookieStore().get(url.toURI());
                if (cookies != null) {
                    for (HttpCookie cookie : cookies) {
                        if (cookie.getName().equals("gs-token")) {
                            GSUtils.setGSToken(cookie.getValue());
                            continue;
                        }
                        if (!cookie.getName().equals("gs-username")) continue;
                        GSUtils.setGSUser(cookie.getValue());
                    }
                }
            }
            catch (URISyntaxException e2) {
                e2.printStackTrace();
            }
        }
        if (code >= 300 && code < 400) {
            if (redirectCount > 5) {
                throw new IOException("Too many redirects");
            }
            String newLocation = conn.getHeaderField("Location");
            log.debug("Redirecting to " + newLocation);
            return this.openConnection(new URL(newLocation), requestProperties, method, redirectCount++);
        }
        if (code >= 400) {
            String message;
            if (code == 404) {
                message = "File not found: " + url.toString();
                throw new FileNotFoundException(message);
            }
            message = conn.getResponseMessage();
            String details = this.readErrorStream(conn);
            throw new IOException("Server returned error code: " + code + " (" + message + ")");
        }
        return conn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        Class<HttpUtils> clazz = HttpUtils.class;
        synchronized (HttpUtils.class) {
            instance = new HttpUtils();
            CookieHandler.setDefault(new CookieManager());
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public class IGVAuthenticator
    extends Authenticator {
        @Override
        protected PasswordAuthentication getPasswordAuthentication() {
            boolean isProxyChallenge;
            Authenticator.RequestorType type = this.getRequestorType();
            URL url = this.getRequestingURL();
            boolean bl = isProxyChallenge = type == Authenticator.RequestorType.PROXY;
            if (isProxyChallenge && ((HttpUtils)HttpUtils.this).proxySettings.auth && ((HttpUtils)HttpUtils.this).proxySettings.user != null && ((HttpUtils)HttpUtils.this).proxySettings.pw != null) {
                return new PasswordAuthentication(((HttpUtils)HttpUtils.this).proxySettings.user, ((HttpUtils)HttpUtils.this).proxySettings.pw.toCharArray());
            }
            Frame owner = IGV.hasInstance() ? IGV.getMainFrame() : null;
            boolean isGenomeSpace = GSUtils.isGenomeSpace(url);
            LoginDialog dlg = new LoginDialog(owner, isGenomeSpace, url.toString(), isProxyChallenge);
            dlg.setVisible(true);
            if (dlg.isCanceled()) {
                return null;
            }
            String userString = dlg.getUsername();
            char[] userPass = dlg.getPassword();
            if (isProxyChallenge) {
                ((HttpUtils)HttpUtils.this).proxySettings.user = userString;
                ((HttpUtils)HttpUtils.this).proxySettings.pw = new String(userPass);
            }
            return new PasswordAuthentication(userString, userPass);
        }
    }

    public static class ProxySettings {
        boolean auth = false;
        String user;
        String pw;
        boolean useProxy;
        String proxyHost;
        int proxyPort = -1;

        public ProxySettings(boolean useProxy, String user, String pw, boolean auth, String proxyHost, int proxyPort) {
            this.auth = auth;
            this.proxyHost = proxyHost;
            this.proxyPort = proxyPort;
            this.pw = pw;
            this.useProxy = useProxy;
            this.user = user;
        }
    }
}

